/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.Trace;

public abstract class DatabaseRowInput
extends DataInputStream {
    public int pos = -1;
    public int nextPos = -1;
    public int size;
    public boolean makeSystemId = false;

    public DatabaseRowInput(InputStream inputStream) {
        super(inputStream);
    }

    public DatabaseRowInput(byte[] byArray, int n2) throws IOException {
        this(new ByteArrayInputStream(byArray));
        this.pos = n2;
        this.size = byArray.length;
    }

    public int getPos() throws IOException {
        if (this.pos == -1) {
            throw new IOException("No position specified");
        }
        return this.pos;
    }

    public int getNextPos() throws IOException {
        if (this.nextPos == -1) {
            throw new IOException("No next position specified");
        }
        return this.nextPos;
    }

    public int getSize() {
        return this.size;
    }

    public abstract int readIntData() throws IOException;

    public abstract int readType() throws IOException;

    public abstract String readString() throws IOException;

    public abstract boolean checkNull() throws IOException;

    public abstract String readChar(int var1) throws IOException, SQLException;

    public abstract Integer readSmallint() throws IOException, SQLException;

    public abstract Integer readInteger() throws IOException, SQLException;

    public abstract Long readBigint() throws IOException, SQLException;

    public abstract Double readReal(int var1) throws IOException, SQLException;

    public abstract BigDecimal readDecimal() throws IOException, SQLException;

    public abstract Boolean readBit() throws IOException, SQLException;

    public abstract Time readTime() throws IOException, SQLException;

    public abstract Date readDate() throws IOException, SQLException;

    public abstract Timestamp readTimestamp() throws IOException, SQLException;

    public abstract Object readOther() throws IOException, SQLException;

    public abstract byte[] readBinary(int var1) throws IOException, SQLException;

    public Object[] readData(int[] nArray) throws IOException, SQLException {
        int n2 = nArray.length;
        Object[] objectArray = new Object[n2];
        if (this.makeSystemId) {
            --n2;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (!this.checkNull()) {
                Object object = null;
                int n4 = nArray[n3];
                switch (n4) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 100: {
                        object = this.readChar(n4);
                        break;
                    }
                    case -6: 
                    case 5: {
                        object = this.readSmallint();
                        break;
                    }
                    case 4: {
                        object = this.readInteger();
                        break;
                    }
                    case -5: {
                        object = this.readBigint();
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        object = this.readReal(n4);
                        break;
                    }
                    case 2: 
                    case 3: {
                        object = this.readDecimal();
                        break;
                    }
                    case 91: {
                        object = this.readDate();
                        break;
                    }
                    case 92: {
                        object = this.readTime();
                        break;
                    }
                    case 93: {
                        object = this.readTimestamp();
                        break;
                    }
                    case -7: {
                        object = this.readBit();
                        break;
                    }
                    case 1111: {
                        object = this.readOther();
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        object = this.readBinary(n4);
                        break;
                    }
                    default: {
                        throw Trace.error(20, n4);
                    }
                }
                objectArray[n3] = object;
            }
            ++n3;
        }
        if (this.makeSystemId) {
            objectArray[n2] = new Integer(this.getPos());
        }
        return objectArray;
    }
}

