/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.DatabaseRowOutputInterface;
import org.hsqldb.Table;
import org.hsqldb.Trace;

public abstract class DatabaseRowOutput
extends DataOutputStream
implements DatabaseRowOutputInterface {
    public boolean skipSystemId = false;

    public DatabaseRowOutput(OutputStream outputStream) throws IOException {
        super(outputStream);
    }

    public abstract void writePos(int var1) throws IOException;

    public abstract void writeSize(int var1) throws IOException;

    public abstract void writeType(int var1) throws IOException;

    public abstract void writeIntData(int var1) throws IOException;

    public abstract void writeString(String var1) throws IOException;

    public abstract void writeFieldType(int var1) throws IOException;

    public abstract void writeNull(int var1) throws IOException;

    public abstract void writeChar(String var1, int var2) throws IOException;

    public abstract void writeSmallint(Number var1) throws IOException, SQLException;

    public abstract void writeInteger(Number var1) throws IOException, SQLException;

    public abstract void writeBigint(Number var1) throws IOException, SQLException;

    public abstract void writeReal(Double var1, int var2) throws IOException, SQLException;

    public abstract void writeDecimal(BigDecimal var1) throws IOException, SQLException;

    public abstract void writeBit(Boolean var1) throws IOException, SQLException;

    public abstract void writeDate(Date var1) throws IOException, SQLException;

    public abstract void writeTime(Time var1) throws IOException, SQLException;

    public abstract void writeTimestamp(Timestamp var1) throws IOException, SQLException;

    public abstract void writeOther(Object var1) throws IOException, SQLException;

    public abstract void writeBinary(byte[] var1, int var2) throws IOException, SQLException;

    public void writeData(Object[] objectArray, Table table) throws IOException, SQLException {
        int[] nArray = table.t();
        int n2 = nArray.length;
        if (this.skipSystemId) {
            --n2;
        }
        this.writeData(n2, nArray, objectArray);
    }

    public void writeData(int n2, int[] nArray, Object[] objectArray) throws IOException, SQLException {
        int n3 = 0;
        while (n3 < n2) {
            Object object = objectArray[n3];
            int n4 = nArray[n3];
            if (object == null) {
                this.writeNull(n4);
            } else {
                this.writeFieldType(n4);
                switch (n4) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 100: {
                        this.writeChar((String)object, n4);
                        break;
                    }
                    case -6: 
                    case 5: {
                        this.writeSmallint((Number)object);
                        break;
                    }
                    case 4: {
                        this.writeInteger((Number)object);
                        break;
                    }
                    case -5: {
                        this.writeBigint((Number)object);
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        this.writeReal((Double)object, n4);
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.writeDecimal((BigDecimal)object);
                        break;
                    }
                    case -7: {
                        this.writeBit((Boolean)object);
                        break;
                    }
                    case 91: {
                        this.writeDate((Date)object);
                        break;
                    }
                    case 92: {
                        this.writeTime((Time)object);
                        break;
                    }
                    case 93: {
                        this.writeTimestamp((Timestamp)object);
                        break;
                    }
                    case 1111: {
                        this.writeOther(object);
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        this.writeBinary((byte[])object, n4);
                        break;
                    }
                    default: {
                        throw Trace.error(20, n4);
                    }
                }
            }
            ++n3;
        }
    }

    public abstract byte[] toByteArray() throws IOException;
}

