/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class HsqlProperties {
    public String fileName;
    public Properties stringProps;

    public HsqlProperties() {
        this.stringProps = new Properties();
        this.fileName = null;
    }

    public HsqlProperties(String string) {
        this.stringProps = new Properties();
        this.fileName = string;
    }

    public HsqlProperties(Properties properties) {
        this.stringProps = properties;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String setProperty(String string, int n2) {
        return ((Hashtable)this.stringProps).put(string, Integer.toString(n2));
    }

    public String setProperty(String string, boolean bl2) {
        return ((Hashtable)this.stringProps).put(string, String.valueOf(bl2));
    }

    public String setProperty(String string, String string2) {
        return ((Hashtable)this.stringProps).put(string, string2);
    }

    public String setPropertyIfNotExists(String string, String string2) {
        string2 = this.stringProps.getProperty(string, string2);
        return ((Hashtable)this.stringProps).put(string, string2);
    }

    public String getProperty(String string) {
        return this.stringProps.getProperty(string);
    }

    public String getProperty(String string, String string2) {
        return this.stringProps.getProperty(string, string2);
    }

    public int getIntegerProperty(String string, int n2) {
        String string2 = this.getProperty(string);
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n2;
    }

    public boolean isPropertyTrue(String string) {
        return this.isPropertyTrue(string, false);
    }

    public boolean isPropertyTrue(String string, boolean bl2) {
        String string2 = this.stringProps.getProperty(string, bl2 ? "true" : "false");
        return Boolean.valueOf(string2);
    }

    public void removeProperty(String string) {
        ((Hashtable)this.stringProps).remove(string);
    }

    public static HsqlProperties argArrayToProps(String[] stringArray, String string) {
        HsqlProperties hsqlProperties = new HsqlProperties();
        int n2 = 0;
        while (n2 < stringArray.length - 1) {
            String string2 = stringArray[n2];
            if (string2.charAt(0) == '-' && !string2.startsWith("-?")) {
                hsqlProperties.setProperty(string + "." + string2.substring(1), stringArray[n2 + 1]);
                ++n2;
            }
            ++n2;
        }
        return hsqlProperties;
    }

    public void addProperties(HsqlProperties hsqlProperties) {
        Enumeration<?> enumeration = hsqlProperties.stringProps.propertyNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            ((Hashtable)this.stringProps).put(obj, ((Hashtable)hsqlProperties.stringProps).get(obj));
        }
    }

    public boolean checkFileExists() {
        if (this.fileName == null || this.fileName.length() == 0) {
            return false;
        }
        return new File(this.fileName + ".properties").exists();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void load() throws Exception {
        if (this.fileName == null || this.fileName.length() == 0) {
            throw new FileNotFoundException("properties name is null or empty");
        }
        FileInputStream fileInputStream = null;
        try {
            File file = new File(this.fileName + ".properties");
            fileInputStream = new FileInputStream(file);
            this.stringProps.load(fileInputStream);
            fileInputStream.close();
            Object var4_3 = null;
            if (fileInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (fileInputStream == null) throw throwable;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
    }

    public void save() throws Exception {
        if (this.fileName == null || this.fileName.length() == 0) {
            throw new FileNotFoundException("properties name is null or empty");
        }
        File file = new File(this.fileName + ".properties");
        File file2 = file.getParentFile();
        if (file2 != null) {
            file2.mkdirs();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.stringProps.store(fileOutputStream, "HSQL database");
        fileOutputStream.close();
    }
}

