/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.SQLException;
import java.util.Date;
import java.util.Vector;
import org.hsqldb.Database;
import org.hsqldb.HsqlProperties;
import org.hsqldb.ServerConnection;
import org.hsqldb.Trace;
import org.hsqldb.jdbcSystem;

public class Server {
    public Vector d = new Vector(16);
    public Database c;
    public HsqlProperties b;
    public ServerSocket socket;
    public Thread thread;
    public boolean traceMessages;
    private boolean restartOnShutdown;
    private boolean noSystemExit;

    public static void main(String[] stringArray) {
        Object object;
        if (stringArray.length > 0 && (object = stringArray[0]) != null && ((String)object).startsWith("-?")) {
            Server.b();
            return;
        }
        object = HsqlProperties.argArrayToProps(stringArray, "server");
        Server server = new Server();
        server.a((HsqlProperties)object);
        server.run();
    }

    public void a(HsqlProperties hsqlProperties) {
        this.b = new HsqlProperties("server");
        try {
            this.b.load();
        }
        catch (Exception exception) {
            Trace.c("server.properties not found, using command line or default properties");
        }
        this.b.addProperties(hsqlProperties);
        this.b.setPropertyIfNotExists("server.database", "test");
        this.b.setPropertyIfNotExists("server.port", String.valueOf(9001));
        if (this.b.isPropertyTrue("server.trace")) {
            jdbcSystem.a(true);
        }
        this.traceMessages = !this.b.isPropertyTrue("server.silent", true);
        this.noSystemExit = this.b.isPropertyTrue("server.no_system_exit");
        this.restartOnShutdown = this.b.isPropertyTrue("server.restart_on_shutdown");
    }

    public void a() throws SQLException {
        String string = this.b.getProperty("server.database");
        this.c = new Database(string);
    }

    private void run() {
        Object object;
        try {
            int n2 = this.b.getIntegerProperty("server.port", 9001);
            object = this.b.getProperty("server.database");
            Trace.c("Opening database: " + (String)object);
            this.c();
            this.a();
            this.socket = new ServerSocket(n2);
            Trace.c(new Date(System.currentTimeMillis()) + " Listening for connections ...");
        }
        catch (Exception exception) {
            this.a("Server.run/init: " + exception);
            exception.printStackTrace();
            return;
        }
        try {
            while (true) {
                Socket socket = this.socket.accept();
                object = new ServerConnection(socket, this);
                this.thread = new Thread((Runnable)object);
                this.thread.start();
            }
        }
        catch (IOException iOException) {
            if (this.c != null) {
                this.a("Server.run/loop: " + iOException.getMessage());
                iOException.printStackTrace();
            } else {
                this.b("");
            }
            return;
        }
    }

    public static void b() {
        Trace.c("Usage: java Server [-options]\nwhere options include:\n    -port <nr>            port where the server is listening\n    -database <name>      name of the database\n    -silent <true/false>  false means display all queries\n    -trace <true/false>   display JDBC trace messages\n    -no_system_exit <true/false>  do not issue System.exit()\nThe command line arguments override the values in the server.properties file.");
    }

    public void c() {
        this.b("server.port    =" + this.b.getProperty("server.port"));
        this.b("server.database=" + this.b.getProperty("server.database"));
        this.b("server.silent  =" + this.b.getProperty("server.silent"));
        Trace.c("HSQLDB server 1.7.1 is running");
        Trace.c("Use SHUTDOWN to close normally. Use [Ctrl]+[C] to abort abruptly");
    }

    public void b(String string) {
        if (this.traceMessages) {
            Trace.c(string);
        }
    }

    public void a(String string) {
        Trace.c(string);
    }

    public void d() {
        int n2 = this.d.size() - 1;
        while (n2 >= 0) {
            ServerConnection serverConnection = (ServerConnection)this.d.elementAt(n2);
            serverConnection.a();
            --n2;
        }
        this.d.removeAllElements();
    }

    public void a(int n2) {
        if (this.c == null) {
            return;
        }
        if (!this.c.f()) {
            return;
        }
        this.c = null;
        this.d();
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            this.a("Exception when closing the main socket");
        }
        this.b = null;
        this.socket = null;
        this.thread = null;
        if (!this.noSystemExit) {
            Trace.c(new Date(System.currentTimeMillis()) + " SHUTDOWN : System.exit() is called next");
            System.exit(0);
        }
        Trace.c(new Date(System.currentTimeMillis()) + " SHUTDOWN : System.exit() was not called");
    }
}

