/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.sql.SQLException;
import org.hsqldb.Trace;

public class StringConverter {
    private static final char[] HEXCHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String HEXINDEX = "0123456789abcdef0123456789ABCDEF";

    public static byte[] b(String string) throws SQLException {
        int n2 = string.length() / 2;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            char c2;
            int n5;
            if ((n5 = HEXINDEX.indexOf(c2 = string.charAt(n3++))) == -1) {
                throw Trace.error(7, "hexadecimal string contains non hex character");
            }
            int n6 = (n5 & 0xF) << 4;
            c2 = string.charAt(n3++);
            n5 = HEXINDEX.indexOf(c2);
            byArray[n4] = (byte)(n6 += n5 & 0xF);
            ++n4;
        }
        return byArray;
    }

    public static String a(byte[] byArray) {
        int n2 = byArray.length;
        StringBuffer stringBuffer = new StringBuffer(n2 * 2);
        int n3 = 0;
        while (n3 < n2) {
            int n4 = byArray[n3] & 0xFF;
            stringBuffer.append(HEXCHAR[n4 >> 4 & 0xF]);
            stringBuffer.append(HEXCHAR[n4 & 0xF]);
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static String a(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeUTF(string);
            dataOutputStream.close();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            return null;
        }
        return StringConverter.a(byteArrayOutputStream.toByteArray());
    }

    public static String hexStringToUnicode(String string) throws SQLException {
        byte[] byArray = StringConverter.b(string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            return dataInputStream.readUTF();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static StringBuffer unicodeToAscii(String string) {
        if (string == null || string.length() == 0) {
            return new StringBuffer();
        }
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2 + 16);
        int n3 = 0;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            if (c2 == '\\') {
                if (n3 < n2 - 1 && string.charAt(n3 + 1) == 'u') {
                    stringBuffer.append(c2);
                    stringBuffer.append("u005c");
                } else {
                    stringBuffer.append(c2);
                }
            } else if (c2 >= ' ' && c2 <= '\u007f') {
                stringBuffer.append(c2);
            } else {
                stringBuffer.append("\\u");
                stringBuffer.append(HEXCHAR[c2 >> 12 & 0xF]);
                stringBuffer.append(HEXCHAR[c2 >> 8 & 0xF]);
                stringBuffer.append(HEXCHAR[c2 >> 4 & 0xF]);
                stringBuffer.append(HEXCHAR[c2 & 0xF]);
            }
            ++n3;
        }
        return stringBuffer;
    }

    public static String asciiToUnicode(String string) {
        if (string == null || string.indexOf("\\u") == -1) {
            return string;
        }
        int n2 = string.length();
        char[] cArray = new char[n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            char c2 = string.charAt(n4);
            if (c2 == '\\' && n4 < n2 - 5) {
                char c3 = string.charAt(n4 + 1);
                if (c3 == 'u') {
                    ++n4;
                    int n5 = HEXINDEX.indexOf(string.charAt(++n4)) << 12;
                    n5 += HEXINDEX.indexOf(string.charAt(++n4)) << 8;
                    n5 += HEXINDEX.indexOf(string.charAt(++n4)) << 4;
                    cArray[n3++] = (char)(n5 += HEXINDEX.indexOf(string.charAt(++n4)));
                } else {
                    cArray[n3++] = c2;
                }
            } else {
                cArray[n3++] = c2;
            }
            ++n4;
        }
        return new String(cArray, 0, n3);
    }

    public static String inputStreamToString(InputStream inputStream) throws SQLException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        StringWriter stringWriter = new StringWriter();
        int n2 = 8192;
        char[] cArray = new char[n2];
        try {
            int n3;
            while ((n3 = inputStreamReader.read(cArray, 0, n2)) != -1) {
                stringWriter.write(cArray, 0, n3);
            }
            stringWriter.close();
            inputStream.close();
        }
        catch (IOException iOException) {
            throw Trace.error(34, iOException.getMessage());
        }
        return stringWriter.toString();
    }

    public static String a(String string, char c2, boolean bl2) {
        if (string == null) {
            return "NULL";
        }
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2 + 16).append(c2);
        int n3 = 0;
        while (n3 < n2) {
            char c3 = string.charAt(n3);
            if (bl2 && c3 == c2) {
                stringBuffer.append(c3);
            }
            stringBuffer.append(c3);
            ++n3;
        }
        return stringBuffer.append(c2).toString();
    }
}

