/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.ByteArray;
import org.hsqldb.DatabaseRowInput;
import org.hsqldb.DatabaseRowInputInterface;

public class TextDatabaseRowInput
extends DatabaseRowInput
implements DatabaseRowInputInterface {
    private String fieldSep;
    private String varSep;
    private String longvarSep;
    private int fieldSepLen;
    private int varSepLen;
    private int longvarSepLen;
    private boolean fieldSepEnd;
    private boolean varSepEnd;
    private boolean longvarSepEnd;
    private int textLen;
    public String text;
    public int line;
    public int field;
    public int next = 0;
    public boolean emptyIsNull;

    public TextDatabaseRowInput(String string, String string2, String string3, boolean bl2) throws IOException {
        super(new ByteArrayInputStream(new byte[0]));
        this.makeSystemId = true;
        if (string.endsWith("\n")) {
            this.fieldSepEnd = true;
            string = string.substring(0, string.length() - 1);
        }
        if (string2.endsWith("\n")) {
            this.varSepEnd = true;
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string3.endsWith("\n")) {
            this.longvarSepEnd = true;
            string3 = string3.substring(0, string3.length() - 1);
        }
        this.emptyIsNull = bl2;
        this.fieldSep = string;
        this.varSep = string2;
        this.longvarSep = string3;
        this.fieldSepLen = string.length();
        this.varSepLen = string2.length();
        this.longvarSepLen = string3.length();
    }

    public void setSource(String string, int n2) {
        this.text = string.substring(0, string.indexOf(10));
        this.textLen = this.text.length();
        this.pos = n2;
        this.size = string.length();
        this.nextPos = n2 + this.size;
        this.next = 0;
        ++this.line;
        this.field = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getField(String string, int n2, boolean bl2) throws IOException {
        String string2 = this.emptyIsNull ? null : "";
        try {
            int n3 = this.next;
            ++this.field;
            if (bl2) {
                if (this.next >= this.textLen && n2 > 0) {
                    throw new Exception("No end sep.");
                }
                if (!this.text.endsWith(string)) throw new Exception("No end sep.");
                this.next = this.textLen - n2;
            } else {
                this.next = this.text.indexOf(string, n3);
                if (this.next == -1) {
                    this.next = this.textLen;
                }
            }
            string2 = this.text.substring(n3, this.next);
            this.next += n2;
            if (!this.emptyIsNull) return string2;
            if (!string2.equals("")) return string2;
            return null;
        }
        catch (Exception exception) {
            throw new IOException("line " + this.line + ", field " + this.field + " (" + exception.getMessage() + ")");
        }
    }

    public String readString() throws IOException {
        return this.getField(this.fieldSep, this.fieldSepLen, this.fieldSepEnd);
    }

    private String readVarString() throws IOException {
        return this.getField(this.varSep, this.varSepLen, this.varSepEnd);
    }

    private String readLongVarString() throws IOException {
        return this.getField(this.longvarSep, this.longvarSepLen, this.longvarSepEnd);
    }

    private byte[] readByteArray(String string) throws IOException, SQLException {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < cArray.length) {
            String string2 = Integer.toHexString(cArray[n2]);
            if (string2.length() == 1) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string2);
            ++n2;
        }
        return ByteArray.a(stringBuffer.toString());
    }

    public int readIntData() throws IOException {
        String string = this.readString();
        if (string == null) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    public int readType() throws IOException {
        return 0;
    }

    public boolean checkNull() {
        return false;
    }

    public String readChar(int n2) throws IOException {
        switch (n2) {
            case 1: {
                return this.readString();
            }
            case 12: 
            case 100: {
                return this.readVarString();
            }
        }
        return this.readLongVarString();
    }

    public Integer readSmallint() throws IOException, SQLException {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        return Integer.valueOf(string);
    }

    public Integer readInteger() throws IOException, SQLException {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        return Integer.valueOf(string);
    }

    public Long readBigint() throws IOException, SQLException {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        return Long.valueOf(string);
    }

    public Double readReal(int n2) throws IOException, SQLException {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        return Double.valueOf(string);
    }

    public BigDecimal readDecimal() throws IOException, SQLException {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        return new BigDecimal(string);
    }

    public Time readTime() throws IOException, SQLException {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        return Time.valueOf(string);
    }

    public Date readDate() throws IOException, SQLException {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        return Date.valueOf(string);
    }

    public Timestamp readTimestamp() throws IOException, SQLException {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        return Timestamp.valueOf(string);
    }

    public Boolean readBit() throws IOException, SQLException {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        return Boolean.valueOf(string);
    }

    public Object readOther() throws IOException, SQLException {
        String string = this.readLongVarString();
        if (string == null) {
            return null;
        }
        byte[] byArray = this.readByteArray(string);
        return ByteArray.a(byArray);
    }

    public byte[] readBinary(int n2) throws IOException, SQLException {
        switch (n2) {
            case -2: {
                String string = this.readString();
                if (string == null) {
                    return null;
                }
                return this.readByteArray(string);
            }
            case -3: {
                String string = this.readVarString();
                if (string == null) {
                    return null;
                }
                return this.readByteArray(string);
            }
        }
        String string = this.readLongVarString();
        if (string == null) {
            return null;
        }
        return this.readByteArray(string);
    }

    public void setNextPos(int n2) {
        this.nextPos = n2;
    }

    public void skippedLine() {
        ++this.line;
    }

    public void reset() {
        this.text = "";
        this.textLen = 0;
        this.pos = 0;
        this.size = 0;
        this.nextPos = 0;
        this.next = 0;
        this.field = 0;
        this.line = 0;
    }
}

