/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;
import org.hsqldb.ByteArray;
import org.hsqldb.Column;
import org.hsqldb.StringConverter;
import org.hsqldb.Trace;
import org.hsqldb.jdbcConnection;
import org.hsqldb.jdbcStatement;
import org.hsqldb.lib.HsqlDateTime;

public class jdbcPreparedStatement
extends jdbcStatement
implements PreparedStatement,
CallableStatement {
    private String sSql;
    private Vector vParameter;

    public void setEscapeProcessing(boolean bl2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        this.a();
    }

    public ResultSet executeQuery() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        return super.executeQuery(this.build());
    }

    public int executeUpdate() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        return super.executeUpdate(this.build());
    }

    public void setNull(int n2, int n3) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        this.setNull(n2);
    }

    public void setBoolean(int n2, boolean bl2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        this.setParameter(n2, bl2 ? "TRUE" : "FALSE");
    }

    public void setByte(int n2, byte by2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        this.setParameter(n2, String.valueOf(by2));
    }

    public void setShort(int n2, short s2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        this.setParameter(n2, String.valueOf(s2));
    }

    public void setInt(int n2, int n3) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        this.setParameter(n2, String.valueOf(n3));
    }

    public void setLong(int n2, long l2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        this.setParameter(n2, String.valueOf(l2));
    }

    public void setFloat(int n2, float f2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        this.setParameter(n2, Column.a(f2));
    }

    public void setDouble(int n2, double d2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        this.setParameter(n2, Column.a(d2));
    }

    public void setBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        this.setParameter(n2, Column.c(bigDecimal, 3));
    }

    public void setString(int n2, String string) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        this.setParameter(n2, Column.b(string));
    }

    public void setBytes(int n2, byte[] byArray) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        if (byArray == null) {
            this.setNull(n2);
        } else {
            this.setParameter(n2, Column.b(StringConverter.a(byArray)));
        }
    }

    public void setDate(int n2, Date date) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        this.setParameter(n2, Column.c(date, 91));
    }

    public void setTime(int n2, Time time) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        this.setParameter(n2, Column.c(time, 92));
    }

    public void setTimestamp(int n2, Timestamp timestamp) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        this.setParameter(n2, Column.c(timestamp, 93));
    }

    public void setAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        if (inputStream == null) {
            this.setNull(n2);
        } else {
            this.setString(n2, StringConverter.inputStreamToString(inputStream));
        }
    }

    public void setUnicodeStream(int n2, InputStream inputStream, int n3) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        StringBuffer stringBuffer = new StringBuffer(n3 / 2);
        try {
            int n4 = 0;
            while (n4 < stringBuffer.length()) {
                int n5;
                int n6 = inputStream.read();
                if (n6 != -1 && (n5 = inputStream.read()) != -1) {
                    int n7 = n6 << 8 | n5;
                    stringBuffer.append(n7);
                    ++n4;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            throw Trace.error(19);
        }
        this.setParameter(n2, stringBuffer.toString());
    }

    public void setBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        byte[] byArray = new byte[n3];
        try {
            inputStream.read(byArray, 0, n3);
            inputStream.close();
        }
        catch (IOException iOException) {
            throw Trace.error(34, iOException.getMessage());
        }
        this.setBytes(n2, byArray);
    }

    public void clearParameters() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        this.vParameter.removeAllElements();
    }

    public void setObject(int n2, Object object, int n3, int n4) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        this.setObject(n2, object, n3);
    }

    public void setObject(int n2, Object object, int n3) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        if (object == null) {
            this.setNull(n2);
            return;
        }
        if (n3 != 1111) {
            object = Column.a(object, n3);
        }
        this.setObjectInType(n2, object, n3);
    }

    public void setObject(int n2, Object object) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        if (object == null) {
            this.setNull(n2);
            return;
        }
        int n3 = 1111;
        if (object instanceof String) {
            n3 = 12;
        } else if (object instanceof BigDecimal) {
            n3 = 2;
        } else if (object instanceof Integer) {
            n3 = 4;
        } else if (object instanceof Long) {
            n3 = -5;
        } else if (object instanceof Float) {
            n3 = 7;
        } else if (object instanceof Double) {
            n3 = 8;
        } else if (object instanceof byte[]) {
            n3 = -2;
        } else if (object instanceof Date) {
            n3 = 91;
        } else if (object instanceof Time) {
            n3 = 92;
        } else if (object instanceof Timestamp) {
            n3 = 93;
        } else if (object instanceof Boolean) {
            n3 = -7;
        } else if (object instanceof Byte) {
            n3 = -6;
        } else if (object instanceof Short) {
            n3 = 5;
        }
        this.setObjectInType(n2, object, n3);
    }

    public boolean execute() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        return super.execute(this.build());
    }

    public void addBatch() throws SQLException {
        throw this.getNotSupported();
    }

    public void setCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        char[] cArray = new char[n3];
        try {
            int n4 = reader.read(cArray);
            if (n4 == -1) {
                throw new IOException();
            }
        }
        catch (IOException iOException) {
            throw Trace.error(19);
        }
        this.setString(n2, new String(cArray));
    }

    public void setRef(int n2, Ref ref) throws SQLException {
        throw this.getNotSupported();
    }

    public void setBlob(int n2, Blob blob) throws SQLException {
        throw this.getNotSupported();
    }

    public void setClob(int n2, Clob clob) throws SQLException {
        throw this.getNotSupported();
    }

    public void setArray(int n2, Array array) throws SQLException {
        throw this.getNotSupported();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        throw this.getNotSupported();
    }

    public void setDate(int n2, Date date, Calendar calendar) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        if (date == null) {
            this.setNull(n2);
        } else {
            String string = HsqlDateTime.getDateString(date, calendar);
            this.setParameter(n2, Column.b(string));
        }
    }

    public void setTime(int n2, Time time, Calendar calendar) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        if (time == null) {
            this.setNull(n2);
        } else {
            String string = HsqlDateTime.getTimeString(time, calendar);
            this.setParameter(n2, Column.b(string));
        }
    }

    public void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        if (timestamp == null) {
            this.setNull(n2);
        } else {
            String string = HsqlDateTime.getTimestampString(timestamp, calendar);
            this.setParameter(n2, Column.b(string));
        }
    }

    public void setNull(int n2, int n3, String string) throws SQLException {
        this.setNull(n2, n3);
    }

    public void registerOutParameter(int n2, int n3) throws SQLException {
        throw this.getNotSupported();
    }

    public void registerOutParameter(int n2, int n3, int n4) throws SQLException {
        throw this.getNotSupported();
    }

    public boolean wasNull() throws SQLException {
        throw this.getNotSupported();
    }

    public String getString(int n2) throws SQLException {
        throw this.getNotSupported();
    }

    public boolean getBoolean(int n2) throws SQLException {
        throw this.getNotSupported();
    }

    public byte getByte(int n2) throws SQLException {
        throw this.getNotSupported();
    }

    public short getShort(int n2) throws SQLException {
        throw this.getNotSupported();
    }

    public int getInt(int n2) throws SQLException {
        throw this.getNotSupported();
    }

    public long getLong(int n2) throws SQLException {
        throw this.getNotSupported();
    }

    public float getFloat(int n2) throws SQLException {
        throw this.getNotSupported();
    }

    public double getDouble(int n2) throws SQLException {
        throw this.getNotSupported();
    }

    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        throw this.getNotSupported();
    }

    public byte[] getBytes(int n2) throws SQLException {
        throw this.getNotSupported();
    }

    public Date getDate(int n2) throws SQLException {
        throw this.getNotSupported();
    }

    public Time getTime(int n2) throws SQLException {
        throw this.getNotSupported();
    }

    public Timestamp getTimestamp(int n2) throws SQLException {
        throw this.getNotSupported();
    }

    public Object getObject(int n2) throws SQLException {
        throw this.getNotSupported();
    }

    public BigDecimal getBigDecimal(int n2) throws SQLException {
        throw this.getNotSupported();
    }

    public Object getObject(int n2, Map map) throws SQLException {
        throw this.getNotSupported();
    }

    public Ref getRef(int n2) throws SQLException {
        throw this.getNotSupported();
    }

    public Blob getBlob(int n2) throws SQLException {
        throw this.getNotSupported();
    }

    public Clob getClob(int n2) throws SQLException {
        throw this.getNotSupported();
    }

    public Array getArray(int n2) throws SQLException {
        throw this.getNotSupported();
    }

    public Date getDate(int n2, Calendar calendar) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        String string = this.getParameter(n2);
        string = string.substring(1, string.length() - 1);
        return HsqlDateTime.getDate(string, calendar);
    }

    public Time getTime(int n2, Calendar calendar) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        String string = this.getParameter(n2);
        string = string.substring(1, string.length() - 1);
        return HsqlDateTime.getTime(string, calendar);
    }

    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        String string = this.getParameter(n2);
        string = string.substring(1, string.length() - 1);
        return HsqlDateTime.getTimestamp(string, calendar);
    }

    public void registerOutParameter(int n2, int n3, String string) throws SQLException {
        throw this.getNotSupported();
    }

    public jdbcPreparedStatement(jdbcConnection jdbcConnection2, String string) {
        super(jdbcConnection2);
        this.sSql = string;
        this.vParameter = new Vector();
    }

    public jdbcPreparedStatement(jdbcConnection jdbcConnection2, String string, int n2) {
        super(jdbcConnection2, n2);
        this.sSql = string;
        this.vParameter = new Vector();
    }

    private String build() {
        if (this.vParameter.isEmpty()) {
            return this.sSql;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = this.sSql.length();
        boolean bl2 = false;
        boolean bl3 = false;
        int n4 = 0;
        while (n4 < n3) {
            char c2 = this.sSql.charAt(n4);
            if (c2 == '?' && !bl2 && !bl3) {
                stringBuffer.append(this.getParameter(n2++));
            } else {
                if (c2 == '\'' && !bl3) {
                    bl2 = !bl2;
                } else if (c2 == '\"' && !bl2) {
                    bl3 = !bl3;
                }
                stringBuffer.append(c2);
            }
            ++n4;
        }
        return stringBuffer.toString();
    }

    private SQLException getNotSupported() {
        return Trace.error(20);
    }

    private String getParameter(int n2) {
        if (n2 >= this.vParameter.size()) {
            return null;
        }
        return (String)this.vParameter.elementAt(n2);
    }

    private SQLException invalidValue() {
        return Trace.error(11);
    }

    private void setNull(int n2) {
        this.setParameter(n2, "NULL");
    }

    private void setObjectInType(int n2, Object object, int n3) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        if (object == null) {
            this.setNull(n2);
            return;
        }
        switch (n3) {
            case -7: {
                this.setBoolean(n2, (boolean)((Boolean)object));
                break;
            }
            case -6: {
                this.setByte(n2, ((Number)object).byteValue());
                break;
            }
            case 5: {
                this.setShort(n2, ((Number)object).shortValue());
                break;
            }
            case 4: {
                this.setInt(n2, ((Number)object).intValue());
                break;
            }
            case -5: {
                this.setLong(n2, ((Number)object).longValue());
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                this.setDouble(n2, ((Number)object).doubleValue());
                break;
            }
            case 2: {
                this.setBigDecimal(n2, (BigDecimal)object);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                this.setString(n2, (String)object);
                break;
            }
            case 91: {
                this.setDate(n2, (Date)object);
                break;
            }
            case 92: {
                this.setTime(n2, (Time)object);
                break;
            }
            case 93: {
                this.setTimestamp(n2, (Timestamp)object);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.setBytes(n2, (byte[])object);
                break;
            }
            case 1111: {
                this.setParameter(n2, Column.b(ByteArray.b(object)));
                break;
            }
            default: {
                this.setParameter(n2, object.toString());
            }
        }
    }

    private void setParameter(int n2, String string) {
        if (Trace.TRACE) {
            Trace.b();
        }
        if (this.vParameter.size() < n2) {
            this.vParameter.setSize(n2);
        }
        this.vParameter.setElementAt(string, --n2);
    }
}

