/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.hsqldb.Column;
import org.hsqldb.HsqlProperties;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Trace;
import org.hsqldb.lib.AsciiStringInputStream;
import org.hsqldb.lib.StringInputStream;

public class jdbcResultSet
implements ResultSet,
ResultSetMetaData {
    private Result rResult;
    private Record nCurrent;
    private int iCurrentRow;
    private int iUpdateCount;
    private boolean bInit;
    private int iColumnCount;
    private boolean bWasNull;
    private boolean getColumnName = true;
    private boolean strictMetaData = false;
    private HsqlProperties connProperties;
    public Statement a;
    public int b = 1003;

    public boolean next() throws SQLException {
        this.bWasNull = false;
        if (this.rResult == null) {
            return false;
        }
        if (this.rResult.l == null) {
            return false;
        }
        if (!this.bInit) {
            this.nCurrent = this.rResult.l;
            this.bInit = true;
            this.iCurrentRow = 1;
        } else {
            if (this.nCurrent == null) {
                return false;
            }
            this.nCurrent = this.nCurrent.next;
            ++this.iCurrentRow;
        }
        if (this.nCurrent == null) {
            this.iCurrentRow = 0;
            return false;
        }
        return true;
    }

    public void close() throws SQLException {
        this.iUpdateCount = -1;
        this.rResult = null;
    }

    public boolean wasNull() throws SQLException {
        return this.bWasNull;
    }

    public String getString(int n2) throws SQLException {
        Object object;
        this.checkAvailable();
        try {
            object = this.nCurrent.data[--n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw Trace.error(28, ++n2);
        }
        this.checkNull(object);
        return object == null ? null : object.toString();
    }

    public boolean getBoolean(int n2) throws SQLException {
        Object object = this.getColumnInType(n2, -7);
        return object == null ? false : (Boolean)object;
    }

    public byte getByte(int n2) throws SQLException {
        Object object = this.getColumnInType(n2, 5);
        return object == null ? (byte)0 : ((Number)object).byteValue();
    }

    public short getShort(int n2) throws SQLException {
        Object object = this.getColumnInType(n2, 5);
        return object == null ? (short)0 : ((Number)object).shortValue();
    }

    public int getInt(int n2) throws SQLException {
        Object object = this.getColumnInType(n2, 4);
        return object == null ? 0 : ((Number)object).intValue();
    }

    public long getLong(int n2) throws SQLException {
        Object object = this.getColumnInType(n2, -5);
        return object == null ? 0L : ((Number)object).longValue();
    }

    public float getFloat(int n2) throws SQLException {
        Object object = this.getColumnInType(n2, 7);
        return object == null ? 0.0f : ((Number)object).floatValue();
    }

    public double getDouble(int n2) throws SQLException {
        Object object = this.getColumnInType(n2, 8);
        return object == null ? 0.0 : ((Number)object).doubleValue();
    }

    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        BigDecimal bigDecimal = (BigDecimal)this.getColumnInType(n2, 3);
        if (n3 < 0) {
            throw Trace.error(62);
        }
        if (bigDecimal != null) {
            bigDecimal.setScale(n3, 5);
        }
        return bigDecimal;
    }

    public byte[] getBytes(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof String) {
            return ((String)object).getBytes();
        }
        object = this.getColumnInType(--n2, -2);
        return (byte[])object;
    }

    public Date getDate(int n2) throws SQLException {
        return (Date)this.getColumnInType(n2, 91);
    }

    public Time getTime(int n2) throws SQLException {
        return (Time)this.getColumnInType(n2, 92);
    }

    public Timestamp getTimestamp(int n2) throws SQLException {
        return (Timestamp)this.getColumnInType(n2, 93);
    }

    public InputStream getAsciiStream(int n2) throws SQLException {
        String string = this.getString(n2);
        if (string == null) {
            return null;
        }
        return new AsciiStringInputStream(string);
    }

    public InputStream getUnicodeStream(int n2) throws SQLException {
        String string = this.getString(n2);
        if (string == null) {
            return null;
        }
        return new StringInputStream(string);
    }

    public InputStream getBinaryStream(int n2) throws SQLException {
        byte[] byArray = this.getBytes(n2);
        return this.wasNull() ? null : new ByteArrayInputStream(byArray);
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n2) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n2);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        return null;
    }

    public void clearWarnings() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
    }

    public String getCursorName() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        throw this.getNotSupported();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this;
    }

    public Object getObject(int n2) throws SQLException {
        Object object;
        this.checkAvailable();
        try {
            object = this.nCurrent.data[--n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw Trace.error(28, ++n2);
        }
        this.checkNull(object);
        return object;
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public int findColumn(String string) throws SQLException {
        if (Trace.TRACE) {
            Trace.b(string);
        }
        int n2 = 0;
        while (n2 < this.iColumnCount) {
            if (string.equalsIgnoreCase(this.rResult.i[n2])) {
                return n2 + 1;
            }
            ++n2;
        }
        throw Trace.error(28);
    }

    public Reader getCharacterStream(int n2) throws SQLException {
        String string = this.getString(n2);
        if (string == null) {
            return null;
        }
        return new StringReader(string);
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n2) throws SQLException {
        return (BigDecimal)this.getColumnInType(n2, 3);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public boolean isBeforeFirst() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        return !this.bInit;
    }

    public boolean isAfterLast() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        if (!this.bInit) {
            return false;
        }
        return this.nCurrent == null;
    }

    public boolean isFirst() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        return this.iCurrentRow == 1;
    }

    public boolean isLast() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        if (!this.bInit || this.nCurrent == null) {
            return false;
        }
        return this.nCurrent.next == null;
    }

    public void beforeFirst() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        if (this.getType() == 1003) {
            throw Trace.error(51);
        }
        this.bInit = false;
        this.nCurrent = null;
        this.iCurrentRow = 0;
    }

    public void afterLast() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        if (this.getType() == 1003) {
            throw Trace.error(51);
        }
        if (this.rResult != null && this.rResult.l != null) {
            this.bInit = true;
            this.iCurrentRow = 0;
            this.nCurrent = null;
        }
    }

    public boolean first() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        if (this.getType() == 1003) {
            throw Trace.error(51);
        }
        if (this.rResult == null) {
            return false;
        }
        this.bInit = false;
        if (this.rResult.l != null) {
            this.bInit = true;
            this.nCurrent = this.rResult.l;
            this.iCurrentRow = 1;
        }
        return this.bInit;
    }

    public boolean last() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        if (this.getType() == 1003) {
            throw Trace.error(51);
        }
        if (this.rResult == null) {
            return false;
        }
        if (this.rResult.l == null) {
            return false;
        }
        if (!this.bInit | this.nCurrent == null) {
            this.first();
        }
        while (this.nCurrent.next != null) {
            ++this.iCurrentRow;
            this.nCurrent = this.nCurrent.next;
        }
        return true;
    }

    public int getRow() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        return this.iCurrentRow;
    }

    public boolean absolute(int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        if (this.getType() == 1003) {
            throw Trace.error(51);
        }
        if (this.rResult == null) {
            return false;
        }
        if (this.rResult.l == null || n2 == 0) {
            return false;
        }
        switch (n2) {
            case 1: {
                return this.first();
            }
            case -1: {
                return this.last();
            }
        }
        if (n2 < 0) {
            this.last();
            n2 = this.iCurrentRow + n2 + 1;
            if (n2 <= 0) {
                this.beforeFirst();
                return false;
            }
        }
        if (n2 < this.iCurrentRow || this.iCurrentRow == 0) {
            this.beforeFirst();
        }
        while (n2 > this.iCurrentRow) {
            this.next();
            if (this.nCurrent == null) break;
        }
        return this.nCurrent != null;
    }

    /*
     * Unable to fully structure code
     */
    public boolean relative(int var1_1) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        if (this.getType() == 1003) {
            throw Trace.error(51);
        }
        if (this.rResult == null) {
            return false;
        }
        if (this.rResult.l == null || this.bInit && this.iCurrentRow == 0) {
            return false;
        }
        if (var1_1 >= 0) ** GOTO lbl17
        var1_1 = this.iCurrentRow + var1_1;
        this.beforeFirst();
        if (var1_1 > 0) ** GOTO lbl17
        return false;
lbl-1000:
        // 1 sources

        {
            this.next();
            if (this.nCurrent == null) break;
lbl17:
            // 3 sources

            ** while (var1_1-- > 0)
        }
lbl18:
        // 2 sources

        return this.nCurrent != null;
    }

    public boolean previous() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        if (this.getType() == 1003) {
            throw Trace.error(51);
        }
        if (this.rResult == null) {
            return false;
        }
        if (this.rResult.l == null || this.iCurrentRow == 0) {
            return false;
        }
        if (this.bInit && this.nCurrent == null) {
            return this.last();
        }
        int n2 = this.iCurrentRow - 1;
        if (n2 == 0) {
            this.beforeFirst();
            return false;
        }
        this.first();
        while (n2 != this.iCurrentRow) {
            this.nCurrent = this.nCurrent.next;
            ++this.iCurrentRow;
        }
        return this.nCurrent != null;
    }

    public void setFetchDirection(int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.a(n2);
        }
        if (this.b == 1003 && n2 != 1000) {
            throw this.getNotSupported();
        }
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public void setFetchSize(int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.a(n2);
        }
    }

    public int getFetchSize() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        return 1;
    }

    public int getType() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        return this.b;
    }

    public int getConcurrency() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        return 1007;
    }

    public boolean rowUpdated() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        return false;
    }

    public boolean rowInserted() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        return false;
    }

    public void updateNull(int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.a(n2);
        }
        throw this.getNotSupported();
    }

    public void updateBoolean(int n2, boolean bl2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        throw this.getNotSupported();
    }

    public void updateByte(int n2, byte by2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        throw this.getNotSupported();
    }

    public void updateShort(int n2, short s2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        throw this.getNotSupported();
    }

    public void updateInt(int n2, int n3) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        throw this.getNotSupported();
    }

    public void updateLong(int n2, long l2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        throw this.getNotSupported();
    }

    public void updateFloat(int n2, float f2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        throw this.getNotSupported();
    }

    public void updateDouble(int n2, double d2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        throw this.getNotSupported();
    }

    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        throw this.getNotSupported();
    }

    public void updateString(int n2, String string) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        throw this.getNotSupported();
    }

    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        throw this.getNotSupported();
    }

    public void updateDate(int n2, Date date) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        throw this.getNotSupported();
    }

    public void updateTime(int n2, Time time) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        throw this.getNotSupported();
    }

    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        throw this.getNotSupported();
    }

    public void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        throw this.getNotSupported();
    }

    public void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        throw this.getNotSupported();
    }

    public void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        throw this.getNotSupported();
    }

    public void updateObject(int n2, Object object, int n3) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        throw this.getNotSupported();
    }

    public void updateObject(int n2, Object object) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        throw this.getNotSupported();
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateBoolean(String string, boolean bl2) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl2);
    }

    public void updateByte(String string, byte by2) throws SQLException {
        this.updateByte(this.findColumn(string), by2);
    }

    public void updateShort(String string, short s2) throws SQLException {
        this.updateShort(this.findColumn(string), s2);
    }

    public void updateInt(String string, int n2) throws SQLException {
        this.updateInt(this.findColumn(string), n2);
    }

    public void updateLong(String string, long l2) throws SQLException {
        this.updateLong(this.findColumn(string), l2);
    }

    public void updateFloat(String string, float f2) throws SQLException {
        this.updateFloat(this.findColumn(string), f2);
    }

    public void updateDouble(String string, double d2) throws SQLException {
        this.updateDouble(this.findColumn(string), d2);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n2);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n2);
    }

    public void updateCharacterStream(String string, Reader reader, int n2) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n2);
    }

    public void updateObject(String string, Object object, int n2) throws SQLException {
        this.updateObject(this.findColumn(string), object, n2);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void insertRow() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        throw this.getNotSupported();
    }

    public void updateRow() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        throw this.getNotSupported();
    }

    public void deleteRow() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        throw this.getNotSupported();
    }

    public void refreshRow() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        throw this.getNotSupported();
    }

    public void cancelRowUpdates() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        throw this.getNotSupported();
    }

    public void moveToInsertRow() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        throw this.getNotSupported();
    }

    public void moveToCurrentRow() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
    }

    public Statement getStatement() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        return this.a;
    }

    public Object getObject(int n2, Map map) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        throw this.getNotSupported();
    }

    public Ref getRef(int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        throw this.getNotSupported();
    }

    public Blob getBlob(int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        throw this.getNotSupported();
    }

    public Clob getClob(int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        throw this.getNotSupported();
    }

    public Array getArray(int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        throw this.getNotSupported();
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    public Date getDate(int n2, Calendar calendar) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        throw this.getNotSupported();
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public Time getTime(int n2, Calendar calendar) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        throw this.getNotSupported();
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        throw this.getNotSupported();
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public int getColumnCount() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        return this.iColumnCount;
    }

    public boolean isAutoIncrement(int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        if (this.strictMetaData) {
            throw this.getNotSupported();
        }
        return false;
    }

    public boolean isCaseSensitive(int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        if (this.strictMetaData) {
            throw this.getNotSupported();
        }
        return true;
    }

    public boolean isSearchable(int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        if (this.strictMetaData) {
            throw this.getNotSupported();
        }
        return true;
    }

    public boolean isCurrency(int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        this.checkColumn(n2);
        return false;
    }

    public int isNullable(int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        if (this.strictMetaData) {
            return 2;
        }
        return 1;
    }

    public boolean isSigned(int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        this.checkColumn(n2);
        int n3 = this.rResult.g[n2 - 1];
        int n4 = 0;
        while (n4 < Column.a.length) {
            if (n3 == Column.a[n4]) {
                return true;
            }
            ++n4;
        }
        return false;
    }

    public int getColumnDisplaySize(int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        this.checkColumn(n2);
        return 0;
    }

    public String getColumnLabel(int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        this.checkColumn(n2);
        return this.rResult.i[--n2];
    }

    public String getColumnName(int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        this.checkColumn(n2);
        if (this.getColumnName) {
            return this.rResult.c[--n2];
        }
        return this.rResult.i[--n2];
    }

    public String getSchemaName(int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        this.checkColumn(n2);
        return "";
    }

    public int getPrecision(int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        this.checkColumn(n2);
        return 0;
    }

    public int getScale(int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        this.checkColumn(n2);
        return 0;
    }

    public String getTableName(int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        this.checkColumn(n2);
        return this.rResult.h[--n2];
    }

    public String getCatalogName(int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        this.checkColumn(n2);
        return "";
    }

    public int getColumnType(int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        this.checkColumn(n2);
        return this.rResult.g[--n2];
    }

    public String getColumnTypeName(int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        this.checkColumn(n2);
        return Column.a(this.rResult.g[--n2]);
    }

    public boolean isReadOnly(int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        if (this.strictMetaData) {
            throw this.getNotSupported();
        }
        return false;
    }

    public boolean isWritable(int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        if (this.strictMetaData) {
            throw this.getNotSupported();
        }
        return true;
    }

    public boolean isDefinitelyWritable(int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        if (this.strictMetaData) {
            throw this.getNotSupported();
        }
        return true;
    }

    public String getColumnClassName(int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        throw this.getNotSupported();
    }

    private SQLException getNotSupported() {
        return Trace.error(20);
    }

    private SQLException getNotSupportedJDBC3() {
        return Trace.error(20, "JDBC3");
    }

    private void checkAvailable() throws SQLException {
        if (this.rResult == null || !this.bInit || this.nCurrent == null) {
            throw Trace.error(35);
        }
    }

    private void checkColumn(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.iColumnCount) {
            throw Trace.error(28, n2);
        }
    }

    private void checkNull(Object object) {
        this.bWasNull = object == null;
    }

    private Object getColumnInType(int n2, int n3) throws SQLException {
        Object object;
        int n4;
        this.checkAvailable();
        try {
            n4 = this.rResult.g[--n2];
            object = this.nCurrent.data[n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw Trace.error(28, ++n2);
        }
        this.checkNull(object);
        if (n3 == n4) {
            return object;
        }
        try {
            return Column.a(object, n3);
        }
        catch (Exception exception) {
            String string = "type: " + Column.a(n4) + " (" + n4 + ") expected: " + Column.a(n3) + " value: " + object.toString();
            throw Trace.error(16, string);
        }
    }

    public jdbcResultSet(Result result, HsqlProperties hsqlProperties) throws SQLException {
        this.connProperties = hsqlProperties;
        if (hsqlProperties != null) {
            this.getColumnName = hsqlProperties.isPropertyTrue("jdbc.get_column_name", true);
            this.strictMetaData = hsqlProperties.isPropertyTrue("jdbc.strict_md", false);
        }
        if (result.f == 0) {
            this.iUpdateCount = result.k;
        } else {
            if (result.f == 1) {
                throw Trace.a(result.e, result.b);
            }
            this.iUpdateCount = -1;
            this.rResult = result;
            this.iColumnCount = result.d();
        }
        this.bWasNull = false;
    }

    public int a() {
        return this.iUpdateCount;
    }

    public boolean b() {
        return this.rResult != null;
    }
}

