/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.hsqldb.Trace;

public class HsqlDateTime {
    private static final String sdftPattern = "HH:mm:ss";
    private static final String sdfdPattern = "yyyy-MM-dd";
    private static final String sdftsPattern = "yyyy-MM-dd HH:mm:ss.";
    private static SimpleDateFormat sdfts;

    public static Timestamp timestampValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null string");
        }
        if (string.toUpperCase().equals("NOW") || string.toUpperCase().equals("CURRENT_TIMESTAMP")) {
            return new Timestamp(System.currentTimeMillis());
        }
        string = string + "1970-01-01 00:00:00.000000000".substring(string.length());
        return Timestamp.valueOf(string);
    }

    public static Timestamp timestampValue(long l2, int n2) {
        Timestamp timestamp = new Timestamp(l2);
        timestamp.setNanos(n2);
        return timestamp;
    }

    public static java.sql.Date dateValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null string");
        }
        if ((string = string.toUpperCase()).equals("TODAY") || string.equals("NOW") || string.equals("CURRENT_DATE") || string.equals("SYSDATE")) {
            return new java.sql.Date(System.currentTimeMillis());
        }
        return java.sql.Date.valueOf(string.substring(0, sdfdPattern.length()));
    }

    public static Time timeValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null string");
        }
        if (string.toUpperCase().equals("NOW") || string.toUpperCase().equals("CURRENT_TIME")) {
            return new Time(System.currentTimeMillis());
        }
        return Time.valueOf(string);
    }

    public static java.sql.Date getDate(String string, Calendar calendar) throws SQLException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(sdfdPattern);
        simpleDateFormat.setCalendar(calendar);
        try {
            Date date = simpleDateFormat.parse(string);
            return new java.sql.Date(date.getTime());
        }
        catch (ParseException parseException) {
            throw HsqlDateTime.invalidValue();
        }
    }

    public static Time getTime(String string, Calendar calendar) throws SQLException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(sdftPattern);
        simpleDateFormat.setCalendar(calendar);
        try {
            Date date = simpleDateFormat.parse(string);
            return new Time(date.getTime());
        }
        catch (ParseException parseException) {
            throw HsqlDateTime.invalidValue();
        }
    }

    public static Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(sdftsPattern);
        simpleDateFormat.setCalendar(calendar);
        try {
            Date date = simpleDateFormat.parse(string.substring(0, sdftsPattern.length()));
            String string2 = string.substring(sdftsPattern.length(), string.length());
            Timestamp timestamp = new Timestamp(date.getTime());
            timestamp.setNanos(Integer.parseInt(string2));
            return timestamp;
        }
        catch (ParseException parseException) {
            throw HsqlDateTime.invalidValue();
        }
    }

    public static String getTimestampString(Timestamp timestamp, Calendar calendar) throws SQLException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(sdftsPattern);
        simpleDateFormat.setCalendar(calendar);
        return simpleDateFormat.format(new Date(((Date)timestamp).getTime() + (long)(timestamp.getNanos() / 1000000)));
    }

    public static String getTimeString(Time time, Calendar calendar) throws SQLException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(sdftPattern);
        simpleDateFormat.setCalendar(calendar);
        return simpleDateFormat.format(new Date(time.getTime()));
    }

    public static String getDateString(java.sql.Date date, Calendar calendar) throws SQLException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(sdfdPattern);
        simpleDateFormat.setCalendar(calendar);
        return simpleDateFormat.format(new Date(date.getTime()));
    }

    private static SQLException invalidValue() {
        return Trace.error(11);
    }
}

