/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;

public class DatabaseManagerCommon {
    private static Random rRandom = new Random(100L);
    public static String[] k = new String[]{"SELECT * FROM ", "SELECT [LIMIT n m] [DISTINCT] \n{ selectExpression | table.* | * } [, ... ] \n[INTO [CACHED|TEMP|TEXT] newTable] \nFROM tableList \n[WHERE Expression] \n[ORDER BY selectExpression [{ASC | DESC}] [, ...] ] \n[GROUP BY Expression [, ...] ] \n[UNION [ALL] selectStatement]"};
    public static String[] b = new String[]{"INSERT INTO ", "INSERT INTO table [ (column [,...] ) ] \n{ VALUES(Expression [,...]) | SelectStatement }"};
    public static String[] d = new String[]{"UPDATE ", "UPDATE table SET column = Expression [, ...] \n[WHERE Expression]"};
    public static String[] e = new String[]{"DELETE FROM ", "DELETE FROM table [WHERE Expression]"};
    public static String[] h = new String[]{"CREATE TABLE ", "CREATE [TEMP] [CACHED|MEMORY|TEXT] TABLE name \n( columnDefinition [, ...] ) \n\ncolumnDefinition: \ncolumn DataType [ [NOT] NULL] [PRIMARY KEY] \nDataType: \n{ INTEGER | DOUBLE | VARCHAR | DATE | TIME |... }"};
    public static String[] i = new String[]{"DROP TABLE ", "DROP TABLE table"};
    public static String[] m = new String[]{"CREATE INDEX ", "CREATE [UNIQUE] INDEX index ON \ntable (column [, ...])"};
    public static String[] g = new String[]{"DROP INDEX ", "DROP INDEX table.index"};
    public static String[] c = new String[]{"CHECKPOINT", "(HSQLDB SQL only)"};
    public static String[] f = new String[]{"SCRIPT", "SCRIPT ['file']\n\n(HSQLDB SQL only)"};
    public static String[] l = new String[]{"SHUTDOWN", "SHUTDOWN [COMPACT|IMMEDIATELY]\n\n(HSQLDB SQL only)"};
    public static String[] n = new String[]{"SET ", "AUTOCOMMIT { TRUE | FALSE }\nIGNORECASE { TRUE | FALSE }\nLOGSIZE size\nMAXROWS maxrows\nPASSWORD password\nREADONLY { TRUE | FALSE }\nREFERENTIAL_INTEGRITY { TRUE | FALSE }\nTABLE table READONLY { TRUE | FALSE }\nTABLE table SOURCE \"file\" [DESC]\nWRITE_DELAY { TRUE | FALSE }\n\n(HSQLDB SQL only)"};
    public static String[] j = new String[]{"-->>>TEST<<<-- ;\n--#1000;\nDROP TABLE Test ;\nCREATE TABLE Test(\n  Id INTEGER PRIMARY KEY,\n  FirstName VARCHAR(20),\n  Name VARCHAR(50),\n  ZIP INTEGER) ;\nINSERT INTO Test \n  VALUES(#,'Julia','Peterson-Clancy',#) ;\nUPDATE Test SET Name='Hans' WHERE Id=# ;\nSELECT * FROM Test WHERE Id=# ;\nDELETE FROM Test WHERE Id=# ;\nDROP TABLE Test", "This test script is parsed by the DatabaseManager\nIt may be changed manually. Rules:\n- it must start with -->>>TEST<<<--.\n- each line must end with ';' (no spaces after)\n- lines starting with -- are comments\n- lines starting with --#<count> means set new count\n"};
    public static String[] a = new String[]{"SELECT * FROM Product", "SELECT * FROM Invoice", "SELECT * FROM Item", "SELECT * FROM Customer a INNER JOIN Invoice i ON a.ID=i.CustomerID", "SELECT * FROM Customer a LEFT OUTER JOIN Invoice i ON a.ID=i.CustomerID", "SELECT * FROM Invoice d INNER JOIN Item i ON d.ID=i.InvoiceID", "SELECT * FROM Customer WHERE Street LIKE '1%' ORDER BY Lastname"};

    public static String a(String[] stringArray) {
        return stringArray[DatabaseManagerCommon.a(stringArray.length)];
    }

    public static int a(int n2) {
        n2 = rRandom.nextInt() % n2;
        return n2 < 0 ? -n2 : n2;
    }

    public static void b(Statement statement) {
        String[] stringArray = new String[]{"DROP TABLE Item IF EXISTS;", "DROP TABLE Invoice IF EXISTS;", "DROP TABLE Product IF EXISTS;", "DROP TABLE Customer IF EXISTS;", "CREATE TABLE Customer(ID INTEGER PRIMARY KEY,FirstName VARCHAR,LastName VARCHAR,Street VARCHAR,City VARCHAR);", "CREATE TABLE Product(ID INTEGER PRIMARY KEY,Name VARCHAR,Price DECIMAL);", "CREATE TABLE Invoice(ID INTEGER PRIMARY KEY,CustomerID INTEGER,Total DECIMAL, FOREIGN KEY (CustomerId) REFERENCES Customer(ID) ON DELETE CASCADE);", "CREATE TABLE Item(InvoiceID INTEGER,Item INTEGER,ProductID INTEGER,Quantity INTEGER,Cost DECIMAL,PRIMARY KEY(InvoiceID,Item), FOREIGN KEY (InvoiceId) REFERENCES Invoice (ID) ON DELETE CASCADE, FOREIGN KEY (ProductId) REFERENCES Product(ID) ON DELETE CASCADE);"};
        int n2 = 0;
        while (n2 < stringArray.length) {
            try {
                statement.execute(stringArray[n2]);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ++n2;
        }
    }

    public static String a(Statement statement) throws SQLException {
        String[] stringArray = new String[]{"White", "Karsen", "Smith", "Ringer", "May", "King", "Fuller", "Miller", "Ott", "Sommer", "Schneider", "Steel", "Peterson", "Heiniger", "Clancy"};
        String[] stringArray2 = new String[]{"Mary", "James", "Anne", "George", "Sylvia", "Robert", "Janet", "Michael", "Andrew", "Bill", "Susanne", "Laura", "Bob", "Julia", "John"};
        String[] stringArray3 = new String[]{"Upland Pl.", "College Av.", "- 20th Ave.", "Seventh Av."};
        String[] stringArray4 = new String[]{"New York", "Dallas", "Boston", "Chicago", "Seattle", "San Francisco", "Berne", "Oslo", "Paris", "Lyon", "Palo Alto", "Olten"};
        String[] stringArray5 = new String[]{"Iron", "Ice Tea", "Clock", "Chair", "Telephone", "Shoe"};
        int n2 = 50;
        statement.execute("SET REFERENTIAL_INTEGRITY FALSE");
        int n3 = 0;
        while (n3 < n2) {
            statement.execute("INSERT INTO Customer VALUES(" + n3 + ",'" + DatabaseManagerCommon.a(stringArray2) + "','" + DatabaseManagerCommon.a(stringArray) + "','" + DatabaseManagerCommon.a(554) + " " + DatabaseManagerCommon.a(stringArray3) + "','" + DatabaseManagerCommon.a(stringArray4) + "')");
            statement.execute("INSERT INTO Product VALUES(" + n3 + ",'" + DatabaseManagerCommon.a(stringArray5) + " " + DatabaseManagerCommon.a(stringArray5) + "'," + (20 + 2 * DatabaseManagerCommon.a(120)) + ")");
            statement.execute("INSERT INTO Invoice VALUES(" + n3 + "," + DatabaseManagerCommon.a(n2) + ",0.0)");
            int n4 = DatabaseManagerCommon.a(20) + 2;
            while (n4 >= 0) {
                statement.execute("INSERT INTO Item VALUES(" + n3 + "," + n4 + "," + DatabaseManagerCommon.a(n2) + "," + (1 + DatabaseManagerCommon.a(24)) + ",1.5)");
                --n4;
            }
            ++n3;
        }
        statement.execute("SET REFERENTIAL_INTEGRITY TRUE");
        statement.execute("UPDATE Product SET Price=ROUND(Price*.1,2)");
        statement.execute("UPDATE Item SET Cost=Cost*SELECT Price FROM Product prod WHERE ProductID=prod.ID");
        statement.execute("UPDATE Invoice SET Total=SELECT SUM(Cost*Quantity) FROM Item WHERE InvoiceID=Invoice.ID");
        return "SELECT * FROM Customer";
    }

    public static String a(String string) {
        try {
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = null;
            int n2 = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                ++n2;
                stringBuffer.append(string2);
                stringBuffer.append('\n');
            }
            bufferedReader.close();
            fileReader.close();
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            return iOException.getMessage();
        }
    }

    public static void a(String string, String string2) {
        try {
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write(string2.toCharArray());
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static long a(Statement statement, String string, int n2) throws SQLException {
        long l2 = System.currentTimeMillis();
        if (string.indexOf(35) == -1) {
            n2 = 1;
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            String string2 = string;
            while ((n4 = string2.indexOf("#r#")) != -1) {
                string2 = string2.substring(0, n4) + (int)(Math.random() * (double)n3) + string2.substring(n4 + 3);
            }
            while ((n4 = string2.indexOf(35)) != -1) {
                string2 = string2.substring(0, n4) + n3 + string2.substring(n4 + 1);
            }
            statement.execute(string2);
            ++n3;
        }
        return System.currentTimeMillis() - l2;
    }

    private DatabaseManagerCommon() {
    }
}

