/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.hsqldb.util.DataAccessPoint;
import org.hsqldb.util.DataAccessPointException;
import org.hsqldb.util.HelperFactory;
import org.hsqldb.util.Traceable;
import org.hsqldb.util.TransferResultSet;
import org.hsqldb.util.TransferTable;

public class TransferDb
extends DataAccessPoint {
    public Connection c;
    public DatabaseMetaData d;
    public Statement srcStatement = null;

    public TransferDb(Connection connection, Traceable traceable) throws DataAccessPointException {
        super(traceable);
        this.c = connection;
        if (connection != null) {
            try {
                this.d = connection.getMetaData();
                this.e = connection.getCatalog();
                String string = this.d.getDatabaseProductName();
                string = string == null ? "" : string.toLowerCase();
                this.a = HelperFactory.a(string);
                this.a.a(this, traceable, this.d.getIdentifierQuoteString());
            }
            catch (SQLException sQLException) {
                throw new DataAccessPointException(sQLException.getMessage());
            }
        }
    }

    public boolean i() {
        return this.c != null;
    }

    public boolean g() throws DataAccessPointException {
        boolean bl2 = false;
        try {
            bl2 = this.c.getAutoCommit();
        }
        catch (SQLException sQLException) {
            throw new DataAccessPointException(sQLException.getMessage());
        }
        return bl2;
    }

    public void h() throws DataAccessPointException {
        if (this.srcStatement != null) {
            try {
                this.srcStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.srcStatement = null;
        }
        try {
            this.c.commit();
        }
        catch (SQLException sQLException) {
            throw new DataAccessPointException(sQLException.getMessage());
        }
    }

    public void f() throws DataAccessPointException {
        if (this.srcStatement != null) {
            try {
                this.srcStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.srcStatement = null;
        }
        try {
            this.c.rollback();
        }
        catch (SQLException sQLException) {
            throw new DataAccessPointException(sQLException.getMessage());
        }
    }

    public void a(boolean bl2) throws DataAccessPointException {
        try {
            this.c.setAutoCommit(bl2);
        }
        catch (SQLException sQLException) {
            throw new DataAccessPointException(sQLException.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean b(String string) throws DataAccessPointException {
        boolean bl2 = false;
        Statement statement = null;
        try {
            try {
                statement = this.c.createStatement();
                bl2 = statement.execute(string);
            }
            catch (SQLException sQLException) {
                throw new DataAccessPointException(sQLException.getMessage());
            }
            Object var6_4 = null;
            if (statement == null) return bl2;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {}
        statement.close();
        return bl2;
    }

    public TransferResultSet c(String string) throws DataAccessPointException {
        ResultSet resultSet = null;
        try {
            if (this.srcStatement != null) {
                this.srcStatement.close();
            }
            this.srcStatement = this.c.createStatement();
            resultSet = this.srcStatement.executeQuery(string);
        }
        catch (SQLException sQLException) {
            try {
                this.srcStatement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.srcStatement = null;
            resultSet = null;
            throw new DataAccessPointException(sQLException.getMessage());
        }
        return new TransferResultSet(resultSet);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void a(String string, TransferResultSet transferResultSet, int n2) throws DataAccessPointException {
        if (string == null) return;
        if (string.equals("")) return;
        if (transferResultSet == null) {
            return;
        }
        PreparedStatement preparedStatement = null;
        try {
            try {
                preparedStatement = this.c.prepareStatement(string);
                int n3 = 0;
                while (transferResultSet.a()) {
                    this.transferRow(transferResultSet, preparedStatement);
                    if (n2 == 0 || n3 != n2) {
                        if (n2 == 0 && ++n3 % 100 != 0) continue;
                        this.b.trace("Transfered " + n3 + " rows");
                        continue;
                    }
                    break;
                }
            }
            catch (SQLException sQLException) {
                throw new DataAccessPointException(sQLException.getMessage());
            }
            Object var7_7 = null;
            if (preparedStatement == null) return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (preparedStatement == null) throw throwable;
            try {
                preparedStatement.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {}
        preparedStatement.close();
        return;
    }

    private void transferRow(TransferResultSet transferResultSet, PreparedStatement preparedStatement) throws DataAccessPointException, SQLException {
        String string = "";
        if (preparedStatement != null) {
            preparedStatement.clearParameters();
        }
        int n2 = transferResultSet.b();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = transferResultSet.b(n3 + 1);
            string = "column=" + transferResultSet.c(n3 + 1) + " datatype=" + (String)this.a.a().get(new Integer(n4));
            Object object = transferResultSet.a(n3 + 1);
            if (object == null) {
                if (preparedStatement != null) {
                    preparedStatement.setNull(n3 + 1, n4);
                }
                string = string + " value=<null>";
            } else {
                object = this.a.a(object, n3 + 1, n4);
                preparedStatement.setObject(n3 + 1, object);
                string = string + " value='" + object.toString() + "'";
            }
            ++n3;
        }
        if (preparedStatement != null) {
            preparedStatement.execute();
        }
        string = "";
    }

    public Vector d() throws DataAccessPointException {
        Vector<String> vector = new Vector<String>();
        ResultSet resultSet = null;
        try {
            resultSet = this.d.getSchemas();
        }
        catch (SQLException sQLException) {
            resultSet = null;
        }
        try {
            if (resultSet != null) {
                while (resultSet.next()) {
                    vector.addElement(resultSet.getString(1));
                }
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            throw new DataAccessPointException(sQLException.getMessage());
        }
        return vector;
    }

    public Vector b() throws DataAccessPointException {
        Vector<String> vector = new Vector<String>();
        ResultSet resultSet = null;
        if (this.e != null && this.e.length() > 0) {
            vector.addElement(this.e);
            return vector;
        }
        try {
            resultSet = this.d.getCatalogs();
        }
        catch (SQLException sQLException) {
            resultSet = null;
        }
        try {
            if (resultSet != null) {
                while (resultSet.next()) {
                    vector.addElement(resultSet.getString(1));
                }
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            throw new DataAccessPointException(sQLException.getMessage());
        }
        return vector;
    }

    public void a(String string) throws DataAccessPointException {
        if (string != null && string.length() > 0) {
            try {
                this.c.setCatalog(string);
            }
            catch (SQLException sQLException) {
                throw new DataAccessPointException(sQLException.getMessage());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector a(String string, String[] stringArray) throws DataAccessPointException {
        Vector<TransferTable> vector = new Vector<TransferTable>();
        ResultSet resultSet = null;
        this.b.trace("Reading source tables");
        int n2 = 1;
        if (stringArray != null) {
            n2 = stringArray.length;
        }
        try {
            try {
                int n3 = 0;
                block9: while (n3 < n2) {
                    if (stringArray != null && stringArray[n3] != null) {
                        resultSet = this.d.getTables(string, stringArray[n3], null, null);
                    } else {
                        try {
                            resultSet = this.d.getTables(string, "", null, null);
                        }
                        catch (SQLException sQLException) {
                            resultSet = this.d.getTables(string, null, null, null);
                        }
                    }
                    while (true) {
                        if (!resultSet.next()) {
                            ++n3;
                            continue block9;
                        }
                        String string2 = resultSet.getString(3);
                        String string3 = resultSet.getString(4);
                        String string4 = "";
                        if (stringArray != null && stringArray[n3] != null) {
                            string4 = stringArray[n3];
                        }
                        if (string3.compareTo("TABLE") == 0 || string3.compareTo("VIEW") == 0) {
                            TransferTable transferTable = new TransferTable(this, string2, string4, string3, this.b);
                            vector.addElement(transferTable);
                            continue;
                        }
                        this.b.trace("Found table of type :" + string3 + " - this type is ignored");
                    }
                }
            }
            catch (SQLException sQLException) {
                throw new DataAccessPointException(sQLException.getMessage());
            }
            Object var12_13 = null;
            if (resultSet == null) return vector;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (resultSet == null) throw throwable;
            try {
                resultSet.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {}
        resultSet.close();
        return vector;
    }

    public void a(TransferTable transferTable, DataAccessPoint dataAccessPoint) throws DataAccessPointException {
        ResultSetMetaData resultSetMetaData;
        ResultSet resultSet;
        Statement statement;
        int n2;
        ResultSet resultSet2;
        Object object;
        String string;
        String string2;
        boolean bl2;
        String string3;
        boolean bl3;
        String string4;
        boolean bl4;
        String string5;
        String string6;
        block64: {
            block63: {
                string6 = "CREATE " + transferTable.b.q + " " + dataAccessPoint.a.a(transferTable.b.a);
                string5 = "";
                ResultSet resultSet3 = null;
                bl4 = false;
                string4 = new String("");
                String string7 = new String("");
                String string8 = new String("");
                String string9 = new String("");
                String string10 = new String("");
                String string11 = new String("");
                transferTable.b.h = "DROP " + transferTable.b.q + " " + dataAccessPoint.a.a(transferTable.b.a) + ";";
                if (transferTable.b.q.compareTo("TABLE") == 0) {
                    transferTable.b.r = "DELETE FROM " + dataAccessPoint.a.a(transferTable.b.a) + ";";
                    string6 = string6 + "(";
                } else if (transferTable.b.q.compareTo("VIEW") == 0) {
                    transferTable.b.t = false;
                    transferTable.b.r = "";
                    string6 = string6 + " AS SELECT ";
                }
                if (transferTable.b.q.compareTo("TABLE") == 0) {
                    string5 = "INSERT INTO " + dataAccessPoint.a.a(transferTable.b.a) + " VALUES(";
                } else if (transferTable.b.q.compareTo("VIEW") == 0) {
                    transferTable.b.l = false;
                    string5 = "";
                }
                if (transferTable.b.q.compareTo("VIEW") == 0) {
                    transferTable.b.e = false;
                    transferTable.b.k = true;
                    transferTable.b.t = false;
                    transferTable.b.j = true;
                    transferTable.b.c = false;
                    transferTable.b.o = false;
                    transferTable.b.l = false;
                    transferTable.b.m = false;
                    return;
                }
                resultSet3 = null;
                try {
                    resultSet3 = this.d.getImportedKeys(transferTable.b.g, transferTable.b.p, transferTable.b.n);
                }
                catch (SQLException sQLException) {
                    resultSet3 = null;
                }
                try {
                    if (resultSet3 != null) {
                        while (resultSet3.next()) {
                            bl4 = true;
                            if (!resultSet3.getString(12).equals(string8)) {
                                if (!string8.equals("")) {
                                    string4 = string4 + dataAccessPoint.a.b(string11.substring(0, string11.length() - 1)) + ") REFERENCES " + dataAccessPoint.a.a(string9);
                                    if (string10.length() > 0) {
                                        string4 = string4 + " (" + dataAccessPoint.a.b(string10.substring(0, string10.length() - 1)) + ")";
                                    }
                                    string4 = string4 + ";";
                                    string7 = string7.substring(0, string7.length() - 1) + ";";
                                    string10 = "";
                                    string11 = "";
                                }
                                string9 = resultSet3.getString(3);
                                string8 = resultSet3.getString(12);
                                string4 = string4 + "ALTER TABLE " + dataAccessPoint.a.a(transferTable.b.a) + " ADD CONSTRAINT ";
                                string4 = transferTable.b.d && !string8.startsWith("FK_") ? string4 + dataAccessPoint.a.b("FK_" + string8) + " " : string4 + dataAccessPoint.a.b(string8) + " ";
                                string4 = string4 + "FOREIGN KEY (";
                                string7 = string7 + "ALTER TABLE " + dataAccessPoint.a.a(transferTable.b.a) + " DROP CONSTRAINT ";
                                string7 = transferTable.b.d && !string8.startsWith("FK_") ? string7 + dataAccessPoint.a.b("FK_" + string8) + " " : string7 + dataAccessPoint.a.b(string8) + " ";
                            }
                            string11 = string11 + resultSet3.getString(8) + ",";
                            string10 = string10 + resultSet3.getString(4) + ",";
                        }
                        resultSet3.close();
                    }
                    if (bl4) {
                        string4 = string4 + string11.substring(0, string11.length() - 1) + ") REFERENCES " + dataAccessPoint.a.a(string9);
                        if (string10.length() > 0) {
                            string4 = string4 + " (" + dataAccessPoint.a.b(string10.substring(0, string10.length() - 1)) + ")";
                        }
                        string4 = string4 + ";";
                        string7 = string7.substring(0, string7.length() - 1) + ";";
                        transferTable.b.h = string7 + transferTable.b.h;
                    }
                }
                catch (SQLException sQLException) {
                    throw new DataAccessPointException(sQLException.getMessage());
                }
                bl3 = false;
                string3 = new String();
                string3 = "";
                ResultSet resultSet4 = null;
                try {
                    resultSet4 = this.d.getPrimaryKeys(transferTable.b.g, transferTable.b.p, transferTable.b.n);
                }
                catch (SQLException sQLException) {
                    resultSet4 = null;
                }
                try {
                    if (resultSet4 != null) {
                        while (resultSet4.next()) {
                            if (bl3) {
                                string3 = string3 + ", ";
                            } else {
                                if (resultSet4.getString(6) != null) {
                                    string3 = " CONSTRAINT " + dataAccessPoint.a.b(resultSet4.getString(6));
                                }
                                string3 = string3 + " PRIMARY KEY (";
                            }
                            string3 = string3 + dataAccessPoint.a.b(resultSet4.getString(4));
                            bl3 = true;
                        }
                        resultSet4.close();
                        if (bl3) {
                            string3 = string3 + ") ";
                        }
                    }
                }
                catch (SQLException sQLException) {
                    throw new DataAccessPointException(sQLException.getMessage());
                }
                bl2 = false;
                ResultSet resultSet5 = null;
                Object object2 = new String("");
                string2 = new String("");
                string = new String("");
                try {
                    resultSet5 = this.d.getIndexInfo(transferTable.b.g, transferTable.b.p, transferTable.b.n, false, false);
                }
                catch (SQLException sQLException) {
                    resultSet5 = null;
                }
                try {
                    if (resultSet5 == null) break block63;
                    while (resultSet5.next()) {
                        object = null;
                        try {
                            object = resultSet5.getString(6);
                        }
                        catch (SQLException sQLException) {
                            object = null;
                        }
                        if (object == null) continue;
                        if (!((String)object).equals(object2)) {
                            if (!((String)object2).equals("")) {
                                string2 = string2.substring(0, string2.length() - 1) + ");";
                                string = string + ";";
                            }
                            object2 = object;
                            string = string + "DROP INDEX ";
                            string = transferTable.b.b && !((String)object2).startsWith("Idx_") ? string + dataAccessPoint.a.b("Idx_" + (String)object2) : string + dataAccessPoint.a.b((String)object2);
                            string2 = string2 + "CREATE ";
                            if (!resultSet5.getBoolean(4)) {
                                string2 = string2 + "UNIQUE ";
                            }
                            string2 = string2 + "INDEX ";
                            string2 = transferTable.b.b && !((String)object2).startsWith("Idx_") ? string2 + dataAccessPoint.a.b("Idx_" + (String)object2) : string2 + dataAccessPoint.a.b((String)object2);
                            string2 = string2 + " ON " + dataAccessPoint.a.a(transferTable.b.a) + "(";
                        }
                        string2 = string2 + dataAccessPoint.a.b(resultSet5.getString(9)) + ",";
                        bl2 = true;
                    }
                    resultSet5.close();
                    if (bl2) {
                        string2 = string2.substring(0, string2.length() - 1) + ");";
                        string = string + ";";
                    }
                }
                catch (SQLException sQLException) {
                    throw new DataAccessPointException(sQLException.getMessage());
                }
            }
            object = new Vector();
            this.b.trace("Reading source columns for table " + transferTable.b.n);
            resultSet2 = null;
            n2 = 1;
            statement = null;
            resultSet = null;
            resultSetMetaData = null;
            try {
                statement = this.c.createStatement();
                resultSet = statement.executeQuery(transferTable.b.v);
                resultSetMetaData = resultSet.getMetaData();
                resultSet2 = this.d.getColumns(transferTable.b.g, transferTable.b.p, transferTable.b.n, null);
            }
            catch (SQLException sQLException) {
                if (!transferTable.b.p.equals("")) break block64;
                try {
                    resultSet2 = this.d.getColumns(transferTable.b.g, null, transferTable.b.n, null);
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
            }
        }
        try {
            while (resultSet2.next()) {
                String string12 = dataAccessPoint.a.b(resultSet2.getString(4));
                int n3 = resultSet2.getShort(5);
                String string13 = resultSet2.getString(6);
                short s2 = resultSet2.getShort(7);
                String string14 = resultSet2.getString(13);
                boolean bl5 = resultSetMetaData.isNullable(n2) == 0;
                boolean bl6 = false;
                try {
                    bl6 = resultSetMetaData.isAutoIncrement(n2);
                }
                catch (SQLException sQLException) {
                    bl6 = false;
                }
                int n4 = resultSetMetaData.getPrecision(n2);
                int n5 = resultSetMetaData.getScale(n2);
                n3 = this.a.b(n3);
                n3 = dataAccessPoint.a.a(n3);
                Integer n6 = new Integer(n3);
                String string15 = (String)transferTable.a.get(n6);
                if (string15 == null) {
                    string15 = string13;
                    this.b.trace("No mapping for type: " + string12 + " type: " + n3 + " source: " + string13);
                }
                if (n3 == 2) {
                    string15 = string15 + "(" + Integer.toString(n4);
                    if (n5 > 0) {
                        string15 = string15 + "," + Integer.toString(n5);
                    }
                    string15 = string15 + ")";
                } else if (n3 == 1) {
                    string15 = string15 + "(" + Integer.toString(s2) + ")";
                } else if (bl6) {
                    string15 = "SERIAL";
                }
                if (string14 != null) {
                    if (n3 == 1 || n3 == -1) {
                        string14 = "'" + string14 + "'";
                    }
                    string15 = string15 + " Default " + string14;
                }
                if (bl5) {
                    string15 = string15 + " NOT NULL ";
                }
                ((Vector)object).addElement(n6);
                string15 = this.a.a(transferTable, resultSetMetaData, string15, resultSet2, n2);
                string15 = dataAccessPoint.a.b(transferTable, resultSetMetaData, string15, resultSet2, n2);
                string6 = string6 + string12 + " " + string15 + ",";
                string5 = string5 + "?,";
                ++n2;
            }
            resultSet.close();
            statement.close();
            resultSet2.close();
        }
        catch (SQLException sQLException) {
            throw new DataAccessPointException(sQLException.getMessage());
        }
        if (bl3) {
            string6 = string6 + string3 + ",";
        }
        transferTable.b.f = string6.substring(0, string6.length() - 1) + ")";
        transferTable.b.u = string5.substring(0, string5.length() - 1) + ")";
        if (bl4) {
            transferTable.b.m = true;
            transferTable.b.i = string4;
        } else {
            transferTable.b.m = false;
        }
        if (bl2) {
            transferTable.b.c = true;
            transferTable.b.o = true;
            transferTable.b.s = string2;
            transferTable.b.w = string;
        } else {
            transferTable.b.c = false;
            transferTable.b.o = false;
        }
    }

    public void c() throws DataAccessPointException {
        if (this.srcStatement != null) {
            try {
                this.srcStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.srcStatement = null;
        }
        if (this.c != null) {
            try {
                this.c.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.c = null;
        }
    }
}

