/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.layout;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;

public class Baseline {
    private static final Rectangle viewRect = new Rectangle();
    private static final Rectangle textRect = new Rectangle();
    private static final Rectangle iconRect = new Rectangle();
    private static final int EDGE_SPACING = 2;
    private static final int TEXT_SPACING = 2;
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private static JLabel TABLE_LABEL;
    private static JLabel LIST_LABEL;
    private static JLabel TREE_LABEL;
    private static Class CLASSIC_WINDOWS;
    private static boolean checkedForClassic;
    private static final Map BASELINE_MAP;
    private static Method COMPONENT_BASELINE_METHOD;
    public static Class a;
    public static Class b;

    public static int getBaseline(JComponent jComponent) {
        Dimension dimension = jComponent.getPreferredSize();
        return Baseline.getBaseline(jComponent, dimension.width, dimension.height);
    }

    private static Method getBaselineMethod(JComponent jComponent) {
        Class<?> clazz;
        if (COMPONENT_BASELINE_METHOD != null) {
            return COMPONENT_BASELINE_METHOD;
        }
        for (clazz = jComponent.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            if (!BASELINE_MAP.containsKey(clazz)) continue;
            Method method = (Method)BASELINE_MAP.get(clazz);
            return method;
        }
        clazz = jComponent.getClass();
        Method[] methodArray = clazz.getMethods();
        for (int i2 = methodArray.length - 1; i2 >= 0; --i2) {
            Class<?>[] classArray;
            Method method = methodArray[i2];
            if (!"getBaseline".equals(method.getName()) || (classArray = method.getParameterTypes()).length != 2 || classArray[0] != Integer.TYPE || classArray[1] != Integer.TYPE) continue;
            BASELINE_MAP.put(clazz, method);
            return method;
        }
        BASELINE_MAP.put(clazz, null);
        return null;
    }

    private static int invokeBaseline(Method method, JComponent jComponent, int n2, int n3) {
        int n4 = -1;
        try {
            n4 = (Integer)method.invoke((Object)jComponent, new Integer(n2), new Integer(n3));
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return n4;
    }

    public static int getBaseline(JComponent jComponent, int n2, int n3) {
        Method method = Baseline.getBaselineMethod(jComponent);
        if (method != null) {
            return Baseline.invokeBaseline(method, jComponent, n2, n3);
        }
        Object object = UIManager.get("Baseline.instance");
        if (object != null && object instanceof Baseline) {
            return ((Baseline)object).getComponentBaseline(jComponent, n2, n3);
        }
        String string = UIManager.getLookAndFeel().getID();
        if (string != "Windows" && string != "Metal" && string != "GTK" && string != "Aqua") {
            return -1;
        }
        String string2 = jComponent.getUIClassID();
        int n4 = -1;
        if (string2 == "ButtonUI" || string2 == "CheckBoxUI" || string2 == "RadioButtonUI" || string2 == "ToggleButtonUI") {
            n4 = Baseline.getButtonBaseline((AbstractButton)jComponent, n3);
        } else {
            if (string2 == "ComboBoxUI") {
                return Baseline.getComboBoxBaseline((JComboBox)jComponent, n3);
            }
            if (string2 == "TextAreaUI") {
                return Baseline.getTextAreaBaseline((JTextArea)jComponent, n3);
            }
            if (string2 == "FormattedTextFieldUI" || string2 == "PasswordFieldUI" || string2 == "TextFieldUI") {
                n4 = Baseline.getSingleLineTextBaseline((JTextComponent)jComponent, n3);
            } else if (string2 == "LabelUI") {
                n4 = Baseline.getLabelBaseline((JLabel)jComponent, n3);
            } else if (string2 == "ListUI") {
                n4 = Baseline.getListBaseline((JList)jComponent, n3);
            } else if (string2 == "PanelUI") {
                n4 = Baseline.getPanelBaseline((JPanel)jComponent, n3);
            } else if (string2 == "ProgressBarUI") {
                n4 = Baseline.getProgressBarBaseline((JProgressBar)jComponent, n3);
            } else if (string2 == "SliderUI") {
                n4 = Baseline.getSliderBaseline((JSlider)jComponent, n3);
            } else if (string2 == "SpinnerUI") {
                n4 = Baseline.getSpinnerBaseline((JSpinner)jComponent, n3);
            } else if (string2 == "ScrollPaneUI") {
                n4 = Baseline.getScrollPaneBaseline((JScrollPane)jComponent, n3);
            } else if (string2 == "TabbedPaneUI") {
                n4 = Baseline.getTabbedPaneBaseline((JTabbedPane)jComponent, n3);
            } else if (string2 == "TableUI") {
                n4 = Baseline.getTableBaseline((JTable)jComponent, n3);
            } else if (string2 == "TreeUI") {
                n4 = Baseline.getTreeBaseline((JTree)jComponent, n3);
            }
        }
        return Math.max(n4, -1);
    }

    private static Insets rotateInsets(Insets insets, int n2) {
        switch (n2) {
            case 2: {
                return new Insets(insets.left, insets.top, insets.right, insets.bottom);
            }
            case 3: {
                return new Insets(insets.bottom, insets.left, insets.top, insets.right);
            }
            case 4: {
                return new Insets(insets.left, insets.bottom, insets.right, insets.top);
            }
        }
        return new Insets(insets.top, insets.left, insets.bottom, insets.right);
    }

    private static int getMaxTabHeight(JTabbedPane jTabbedPane) {
        int n2;
        int n3 = n2 = jTabbedPane.getFontMetrics(jTabbedPane.getFont()).getHeight();
        boolean bl2 = false;
        for (int i2 = jTabbedPane.getTabCount() - 1; i2 >= 0; --i2) {
            Icon icon = jTabbedPane.getIconAt(i2);
            if (icon == null) continue;
            int n4 = icon.getIconHeight();
            n3 = Math.max(n3, n4);
            if (n4 <= n2) continue;
            bl2 = true;
        }
        Insets insets = UIManager.getInsets("TabbedPane.tabInsets");
        n3 += 2;
        if (!Baseline.isMetal() || !bl2) {
            n3 += insets.top + insets.bottom;
        }
        return n3;
    }

    private static int getTabbedPaneBaseline(JTabbedPane jTabbedPane, int n2) {
        if (jTabbedPane.getTabCount() > 0) {
            if (Baseline.isAqua()) {
                return Baseline.getAquaTabbedPaneBaseline(jTabbedPane, n2);
            }
            Insets insets = jTabbedPane.getInsets();
            Insets insets2 = UIManager.getInsets("TabbedPane.contentBorderInsets");
            Insets insets3 = Baseline.rotateInsets(UIManager.getInsets("TabbedPane.tabAreaInsets"), jTabbedPane.getTabPlacement());
            FontMetrics fontMetrics = jTabbedPane.getFontMetrics(jTabbedPane.getFont());
            int n3 = Baseline.getMaxTabHeight(jTabbedPane);
            iconRect.setBounds(0, 0, 0, 0);
            textRect.setBounds(0, 0, 0, 0);
            viewRect.setBounds(0, 0, Short.MAX_VALUE, n3);
            SwingUtilities.layoutCompoundLabel(jTabbedPane, fontMetrics, "A", null, 0, 0, 0, 11, viewRect, iconRect, textRect, 0);
            int n4 = Baseline.textRect.y + fontMetrics.getAscent();
            switch (jTabbedPane.getTabPlacement()) {
                case 1: {
                    n4 += insets.top + insets3.top;
                    if (Baseline.isWindows()) {
                        n4 = jTabbedPane.getTabCount() > 1 ? ++n4 : --n4;
                    }
                    return n4;
                }
                case 3: {
                    n4 = jTabbedPane.getHeight() - insets.bottom - insets3.bottom - n3 + n4;
                    if (Baseline.isWindows()) {
                        n4 = jTabbedPane.getTabCount() > 1 ? --n4 : ++n4;
                    }
                    return n4;
                }
                case 2: 
                case 4: {
                    if (Baseline.isAqua()) {
                        return -1;
                    }
                    n4 += insets.top + insets3.top;
                    if (Baseline.isWindows()) {
                        n4 += n3 % 2;
                    }
                    return n4;
                }
            }
        }
        return -1;
    }

    private static int getAquaTabbedPaneBaseline(JTabbedPane jTabbedPane, int n2) {
        Font font = jTabbedPane.getFont();
        FontMetrics fontMetrics = jTabbedPane.getFontMetrics(font);
        int n3 = fontMetrics.getAscent();
        switch (jTabbedPane.getTabPlacement()) {
            case 1: {
                int n4 = 5;
                if (jTabbedPane.getFont().getSize() > 12) {
                    n4 = 6;
                }
                int n5 = 20 - fontMetrics.getHeight();
                return n4 + (n5 /= 2) + n3 - 1;
            }
            case 3: {
                int n6 = jTabbedPane.getFont().getSize() > 12 ? 6 : 4;
                return n2 - (20 - ((20 - fontMetrics.getHeight()) / 2 + n3)) - n6;
            }
            case 2: 
            case 4: {
                return -1;
            }
        }
        return -1;
    }

    private static int getSliderBaseline(JSlider jSlider, int n2) {
        if (Baseline.isAqua()) {
            return -1;
        }
        if (jSlider.getPaintLabels() && !Baseline.isGTK()) {
            Integer n3;
            FontMetrics fontMetrics = jSlider.getFontMetrics(jSlider.getFont());
            Insets insets = jSlider.getInsets();
            Insets insets2 = (Insets)UIManager.get("Slider.focusInsets");
            if (jSlider.getOrientation() == 0) {
                int n4 = 8;
                int n5 = n2 - insets.top - insets.bottom - insets2.top - insets2.bottom;
                int n6 = 20;
                if (Baseline.isMetal()) {
                    n4 = (Integer)UIManager.get("Slider.majorTickLength") + 5;
                    n6 = UIManager.getIcon("Slider.horizontalThumbIcon").getIconHeight();
                } else if (Baseline.isWindows() && Baseline.isXP()) {
                    ++n6;
                }
                int n7 = n6;
                if (jSlider.getPaintTicks()) {
                    n7 += n4;
                }
                int n8 = insets.top + insets2.top + (n5 - (n7 += fontMetrics.getAscent() + fontMetrics.getDescent()) - 1) / 2;
                int n9 = n6;
                int n10 = n8 + n9;
                int n11 = n4;
                if (!jSlider.getPaintTicks()) {
                    n11 = 0;
                }
                int n12 = n10 + n11;
                if (!jSlider.getPaintTicks() && Baseline.isAqua()) {
                    n12 += 4;
                }
                return n12 + fontMetrics.getAscent();
            }
            boolean bl2 = jSlider.getInverted();
            Integer n13 = n3 = bl2 ? Baseline.getMinSliderValue(jSlider) : Baseline.getMaxSliderValue(jSlider);
            if (n3 != null) {
                int n14;
                int n15 = 11;
                if (Baseline.isMetal()) {
                    n15 = UIManager.getIcon("Slider.verticalThumbIcon").getIconHeight();
                }
                int n16 = Math.max(fontMetrics.getHeight() / 2, n15 / 2);
                int n17 = insets2.top + insets.top;
                int n18 = n17 + n16;
                int n19 = n2 - insets2.top - insets2.bottom - insets.top - insets.bottom - n16 - n16;
                int n20 = Baseline.getMaxSliderValue(jSlider);
                int n21 = jSlider.getMinimum();
                int n22 = jSlider.getMaximum();
                double d2 = (double)n22 - (double)n21;
                double d3 = (double)n19 / d2;
                int n23 = n18 + (n19 - 1);
                if (!bl2) {
                    n14 = n18;
                    n14 = (int)((long)n14 + Math.round(d3 * ((double)n22 - (double)n3.intValue())));
                } else {
                    n14 = n18;
                    n14 = (int)((long)n14 + Math.round(d3 * ((double)n3.intValue() - (double)n21)));
                }
                n14 = Math.max(n18, n14);
                n14 = Math.min(n23, n14);
                return n14 - fontMetrics.getHeight() / 2 + fontMetrics.getAscent();
            }
        }
        return -1;
    }

    private static Integer getMaxSliderValue(JSlider jSlider) {
        Dictionary dictionary = jSlider.getLabelTable();
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            int n2 = jSlider.getMinimum() - 1;
            while (enumeration.hasMoreElements()) {
                n2 = Math.max(n2, (Integer)enumeration.nextElement());
            }
            if (n2 == jSlider.getMinimum() - 1) {
                return null;
            }
            return new Integer(n2);
        }
        return null;
    }

    private static Integer getMinSliderValue(JSlider jSlider) {
        Dictionary dictionary = jSlider.getLabelTable();
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            int n2 = jSlider.getMaximum() + 1;
            while (enumeration.hasMoreElements()) {
                n2 = Math.min(n2, (Integer)enumeration.nextElement());
            }
            if (n2 == jSlider.getMaximum() + 1) {
                return null;
            }
            return new Integer(n2);
        }
        return null;
    }

    private static int getProgressBarBaseline(JProgressBar jProgressBar, int n2) {
        if (jProgressBar.isStringPainted() && jProgressBar.getOrientation() == 0) {
            FontMetrics fontMetrics = jProgressBar.getFontMetrics(jProgressBar.getFont());
            Insets insets = jProgressBar.getInsets();
            int n3 = insets.top;
            if (Baseline.isWindows() && Baseline.isXP()) {
                if (jProgressBar.isIndeterminate()) {
                    n3 = -1;
                    --n2;
                } else {
                    n3 = 0;
                    n2 -= 3;
                }
            } else {
                if (Baseline.isGTK()) {
                    return (n2 - fontMetrics.getAscent() - fontMetrics.getDescent()) / 2 + fontMetrics.getAscent();
                }
                if (Baseline.isAqua()) {
                    if (jProgressBar.isIndeterminate()) {
                        return -1;
                    }
                    --n3;
                    n2 -= insets.top + insets.bottom;
                } else {
                    n2 -= insets.top + insets.bottom;
                }
            }
            return n3 + (n2 + fontMetrics.getAscent() - fontMetrics.getLeading() - fontMetrics.getDescent()) / 2;
        }
        return -1;
    }

    private static int getTreeBaseline(JTree jTree, int n2) {
        int n3 = jTree.getRowHeight();
        if (TREE_LABEL == null) {
            TREE_LABEL = new JLabel("X");
            TREE_LABEL.setIcon(UIManager.getIcon("Tree.closedIcon"));
        }
        JLabel jLabel = TREE_LABEL;
        jLabel.setFont(jTree.getFont());
        if (n3 <= 0) {
            n3 = jLabel.getPreferredSize().height;
        }
        return Baseline.getLabelBaseline(jLabel, n3) + jTree.getInsets().top;
    }

    private static int getTableBaseline(JTable jTable, int n2) {
        if (TABLE_LABEL == null) {
            TABLE_LABEL = new JLabel("");
            TABLE_LABEL.setBorder(new EmptyBorder(1, 1, 1, 1));
        }
        JLabel jLabel = TABLE_LABEL;
        jLabel.setFont(jTable.getFont());
        int n3 = jTable.getRowMargin();
        int n4 = Baseline.getLabelBaseline(jLabel, jTable.getRowHeight() - n3);
        return n4 += n3 / 2;
    }

    private static int getTextAreaBaseline(JTextArea jTextArea, int n2) {
        Insets insets = jTextArea.getInsets();
        FontMetrics fontMetrics = jTextArea.getFontMetrics(jTextArea.getFont());
        return insets.top + fontMetrics.getAscent();
    }

    private static int getListBaseline(JList jList, int n2) {
        int n3 = jList.getFixedCellHeight();
        if (LIST_LABEL == null) {
            LIST_LABEL = new JLabel("X");
            LIST_LABEL.setBorder(new EmptyBorder(1, 1, 1, 1));
        }
        JLabel jLabel = LIST_LABEL;
        jLabel.setFont(jList.getFont());
        if (n3 == -1) {
            n3 = jLabel.getPreferredSize().height;
        }
        return Baseline.getLabelBaseline(jLabel, n3) + jList.getInsets().top;
    }

    private static int getScrollPaneBaseline(JScrollPane jScrollPane, int n2) {
        int n3;
        Component component = jScrollPane.getViewport().getView();
        if (component instanceof JComponent && (n3 = Baseline.getBaseline((JComponent)component)) > 0) {
            return n3 + jScrollPane.getViewport().getY();
        }
        return -1;
    }

    private static int getPanelBaseline(JPanel jPanel, int n2) {
        TitledBorder titledBorder;
        Border border = jPanel.getBorder();
        if (border instanceof TitledBorder && (titledBorder = (TitledBorder)border).getTitle() != null && !"".equals(titledBorder.getTitle())) {
            Border border2;
            Font font = titledBorder.getTitleFont();
            if (font == null && (font = jPanel.getFont()) == null) {
                font = new Font("Dialog", 0, 12);
            }
            Insets insets = (border2 = titledBorder.getBorder()) != null ? border2.getBorderInsets(jPanel) : EMPTY_INSETS;
            FontMetrics fontMetrics = jPanel.getFontMetrics(font);
            int n3 = fontMetrics.getHeight();
            int n4 = fontMetrics.getDescent();
            int n5 = fontMetrics.getAscent();
            int n6 = 2;
            int n7 = n2 - 4;
            switch (((TitledBorder)border).getTitlePosition()) {
                case 1: {
                    int n8 = n5 + n4 + (Math.max(2, 4) - 2);
                    return n6 + n8 - (n4 + 2);
                }
                case 0: 
                case 2: {
                    int n9 = Math.max(0, n5 / 2 + 2 - 2);
                    return n6 + n9 - n4 + (insets.top + n5 + n4) / 2;
                }
                case 3: {
                    return n6 + insets.top + n5 + 2;
                }
                case 4: {
                    return n6 + n7 - (insets.bottom + n4 + 2);
                }
                case 5: {
                    return n6 + (n7 -= n3 / 2) - n4 + (n5 + n4 - insets.bottom) / 2;
                }
                case 6: {
                    return n6 + (n7 -= n3) + n5 + 2;
                }
            }
        }
        return -1;
    }

    private static int getSpinnerBaseline(JSpinner jSpinner, int n2) {
        JComponent jComponent = jSpinner.getEditor();
        if (jComponent instanceof JSpinner.DefaultEditor) {
            JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)jComponent;
            JFormattedTextField jFormattedTextField = defaultEditor.getTextField();
            Insets insets = jSpinner.getInsets();
            Insets insets2 = defaultEditor.getInsets();
            int n3 = insets.top + insets2.top;
            if ((n2 -= n3 + insets.bottom + insets2.bottom) <= 0) {
                return -1;
            }
            return n3 + Baseline.getSingleLineTextBaseline(jFormattedTextField, n2);
        }
        Insets insets = jSpinner.getInsets();
        FontMetrics fontMetrics = jSpinner.getFontMetrics(jSpinner.getFont());
        return insets.top + fontMetrics.getAscent();
    }

    private static int getLabelBaseline(JLabel jLabel, int n2) {
        Icon icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        FontMetrics fontMetrics = jLabel.getFontMetrics(jLabel.getFont());
        Baseline.resetRects(jLabel, n2);
        SwingUtilities.layoutCompoundLabel(jLabel, fontMetrics, "a", icon, jLabel.getVerticalAlignment(), jLabel.getHorizontalAlignment(), jLabel.getVerticalTextPosition(), jLabel.getHorizontalTextPosition(), viewRect, iconRect, textRect, jLabel.getIconTextGap());
        return Baseline.textRect.y + fontMetrics.getAscent();
    }

    private static int getComboBoxBaseline(JComboBox jComboBox, int n2) {
        Serializable serializable;
        Object object;
        Insets insets = jComboBox.getInsets();
        int n3 = insets.top;
        n2 -= insets.top + insets.bottom;
        if (jComboBox.isEditable() && (object = jComboBox.getEditor()) != null && object.getEditorComponent() instanceof JTextField) {
            JTextField jTextField = (JTextField)object.getEditorComponent();
            return n3 + Baseline.getSingleLineTextBaseline(jTextField, n2);
        }
        if (Baseline.isMetal()) {
            if (Baseline.isOceanTheme()) {
                n3 += 2;
                n2 -= 4;
            }
        } else if (Baseline.isWindows() && (object = System.getProperty("os.version")) != null && (double)((Float)(serializable = Float.valueOf((String)object))).floatValue() > 4.0) {
            n3 += 2;
            n2 -= 4;
        }
        if ((object = jComboBox.getRenderer()) instanceof JLabel) {
            int n4 = n3 + Baseline.getLabelBaseline((JLabel)object, n2);
            if (Baseline.isAqua()) {
                return n4 - 1;
            }
            return n4;
        }
        serializable = jComboBox.getFontMetrics(jComboBox.getFont());
        return n3 + ((FontMetrics)serializable).getAscent();
    }

    private static int getSingleLineTextBaseline(JTextComponent jTextComponent, int n2) {
        View view = jTextComponent.getUI().getRootView(jTextComponent);
        if (view.getViewCount() > 0) {
            Insets insets = jTextComponent.getInsets();
            int n3 = n2 - insets.top - insets.bottom;
            int n4 = insets.top;
            View view2 = view.getView(0);
            int n5 = (int)view2.getPreferredSpan(1);
            if (n3 != n5) {
                int n6 = n3 - n5;
                n4 += n6 / 2;
            }
            FontMetrics fontMetrics = jTextComponent.getFontMetrics(jTextComponent.getFont());
            return n4 += fontMetrics.getAscent();
        }
        return -1;
    }

    private static int getButtonBaseline(AbstractButton abstractButton, int n2) {
        FontMetrics fontMetrics = abstractButton.getFontMetrics(abstractButton.getFont());
        Baseline.resetRects(abstractButton, n2);
        String string = abstractButton.getText();
        if (string != null && string.startsWith("<html>")) {
            return -1;
        }
        SwingUtilities.layoutCompoundLabel(abstractButton, fontMetrics, "a", abstractButton.getIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), viewRect, iconRect, textRect, string == null ? 0 : abstractButton.getIconTextGap());
        if (Baseline.isAqua()) {
            return Baseline.textRect.y + fontMetrics.getAscent() + 1;
        }
        return Baseline.textRect.y + fontMetrics.getAscent();
    }

    private static void resetRects(JComponent jComponent, int n2) {
        Insets insets = jComponent.getInsets();
        Baseline.viewRect.x = insets.left;
        Baseline.viewRect.y = insets.top;
        Baseline.viewRect.width = jComponent.getWidth() - (insets.right + Baseline.viewRect.x);
        Baseline.viewRect.height = n2 - (insets.bottom + Baseline.viewRect.y);
        Baseline.textRect.height = 0;
        Baseline.textRect.width = 0;
        Baseline.textRect.y = 0;
        Baseline.textRect.x = 0;
        Baseline.iconRect.height = 0;
        Baseline.iconRect.width = 0;
        Baseline.iconRect.y = 0;
        Baseline.iconRect.x = 0;
    }

    private static boolean isOceanTheme() {
        try {
            Field field = (b == null ? (b = Baseline.a("javax.swing.plaf.metal.MetalLookAndFeel")) : b).getDeclaredField("currentTheme");
            field.setAccessible(true);
            Object object = field.get(null);
            return "javax.swing.plaf.metal.OceanTheme".equals(object.getClass().getName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private static boolean isWindows() {
        return UIManager.getLookAndFeel().getID() == "Windows";
    }

    private static boolean isMetal() {
        return UIManager.getLookAndFeel().getID() == "Metal";
    }

    private static boolean isGTK() {
        return UIManager.getLookAndFeel().getID() == "GTK";
    }

    private static boolean isAqua() {
        return UIManager.getLookAndFeel().getID() == "Aqua";
    }

    private static boolean isXP() {
        if (!checkedForClassic) {
            try {
                CLASSIC_WINDOWS = Class.forName("com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            checkedForClassic = true;
        }
        if (CLASSIC_WINDOWS != null && CLASSIC_WINDOWS.isInstance(UIManager.getLookAndFeel())) {
            return false;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Boolean bl2 = (Boolean)toolkit.getDesktopProperty("win.xpstyle.themeActive");
        if (bl2 == null) {
            bl2 = Boolean.FALSE;
        }
        return bl2;
    }

    public int getComponentBaseline(JComponent jComponent, int n2, int n3) {
        return -1;
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        BASELINE_MAP = Collections.synchronizedMap(new HashMap());
        COMPONENT_BASELINE_METHOD = null;
        try {
            COMPONENT_BASELINE_METHOD = (a == null ? (a = Baseline.a("java.awt.Component")) : a).getMethod("getBaseline", Integer.TYPE, Integer.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

