/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.IllegalAddException;
import org.jdom.Namespace;
import org.jdom.Verifier;

public class AttributeList
extends AbstractList
implements List,
Serializable {
    private static final String CVS_ID = "@(#) $RCSfile: AttributeList.java,v $ $Revision: 1.21 $ $Date: 2004/02/06 09:28:30 $ $Name: jdom_1_0_b10 $";
    private static final int INITIAL_ARRAY_SIZE = 5;
    private Attribute[] elementData;
    private int size;
    private Element parent;

    private AttributeList() {
    }

    public AttributeList(Element element) {
        this.parent = element;
    }

    public boolean add(Object object) {
        if (object instanceof Attribute) {
            Attribute attribute = (Attribute)object;
            int n2 = this.indexOfDuplicate(attribute);
            if (n2 < 0) {
                this.a(this.size(), attribute);
            } else {
                this.b(n2, attribute);
            }
        } else {
            if (object == null) {
                throw new IllegalAddException("Cannot add null attribute");
            }
            throw new IllegalAddException("Class " + object.getClass().getName() + " is not an attribute");
        }
        return true;
    }

    public void add(int n2, Object object) {
        Attribute attribute;
        if (object instanceof Attribute) {
            attribute = (Attribute)object;
            int n3 = this.indexOfDuplicate(attribute);
            if (n3 >= 0) {
                throw new IllegalAddException("Cannot add duplicate attribute");
            }
        } else {
            if (object == null) {
                throw new IllegalAddException("Cannot add null attribute");
            }
            throw new IllegalAddException("Class " + object.getClass().getName() + " is not an attribute");
        }
        this.a(n2, attribute);
        ++this.modCount;
    }

    public void a(int n2, Attribute attribute) {
        if (attribute.getParent() != null) {
            throw new IllegalAddException("The attribute already has an existing parent \"" + attribute.getParent().getQualifiedName() + "\"");
        }
        String string = Verifier.checkNamespaceCollision(attribute, this.parent);
        if (string != null) {
            throw new IllegalAddException(this.parent, attribute, string);
        }
        if (n2 < 0 || n2 > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n2 + " Size: " + this.size());
        }
        attribute.setParent(this.parent);
        this.ensureCapacity(this.size + 1);
        if (n2 == this.size) {
            this.elementData[this.size++] = attribute;
        } else {
            System.arraycopy(this.elementData, n2, this.elementData, n2 + 1, this.size - n2);
            this.elementData[n2] = attribute;
            ++this.size;
        }
        ++this.modCount;
    }

    public boolean addAll(Collection collection) {
        return this.addAll(this.size(), collection);
    }

    /*
     * Unable to fully structure code
     */
    public boolean addAll(int var1_1, Collection var2_2) {
        block6: {
            if (var1_1 < 0 || var1_1 > this.size) {
                throw new IndexOutOfBoundsException("Index: " + var1_1 + " Size: " + this.size());
            }
            if (var2_2 == null || var2_2.size() == 0) {
                return false;
            }
            this.ensureCapacity(this.size() + var2_2.size());
            var3_3 = 0;
            try {
                var4_4 = var2_2.iterator();
                while (var4_4.hasNext()) {
                    var5_6 = var4_4.next();
                    this.add(var1_1 + var3_3, (Object)var5_6);
                    ++var3_3;
                }
                break block6;
            }
            catch (RuntimeException var4_5) {
                var5_7 = 0;
                ** while (var5_7 < var3_3)
            }
lbl-1000:
            // 1 sources

            {
                this.remove(var1_1);
                ++var5_7;
                continue;
            }
lbl22:
            // 1 sources

            throw var4_5;
        }
        return true;
    }

    public void clear() {
        if (this.elementData != null) {
            int n2 = 0;
            while (n2 < this.size) {
                Attribute attribute = this.elementData[n2];
                attribute.setParent(null);
                ++n2;
            }
            this.elementData = null;
            this.size = 0;
        }
        ++this.modCount;
    }

    public void a(Collection collection) {
        Attribute[] attributeArray = this.elementData;
        int n2 = this.size;
        this.elementData = null;
        this.size = 0;
        if (collection != null && collection.size() != 0) {
            this.ensureCapacity(collection.size());
            try {
                this.addAll(0, collection);
            }
            catch (RuntimeException runtimeException) {
                this.elementData = attributeArray;
                this.size = n2;
                throw runtimeException;
            }
        }
        if (attributeArray != null) {
            int n3 = 0;
            while (n3 < n2) {
                Attribute attribute = attributeArray[n3];
                attribute.setParent(null);
                ++n3;
            }
        }
        ++this.modCount;
    }

    private void ensureCapacity(int n2) {
        if (this.elementData == null) {
            this.elementData = new Attribute[Math.max(n2, 5)];
        } else {
            int n3 = this.elementData.length;
            if (n2 > n3) {
                Attribute[] attributeArray = this.elementData;
                int n4 = n3 * 3 / 2 + 1;
                if (n4 < n2) {
                    n4 = n2;
                }
                this.elementData = new Attribute[n4];
                System.arraycopy(attributeArray, 0, this.elementData, 0, this.size);
            }
        }
    }

    public Object get(int n2) {
        if (n2 < 0 || n2 >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n2 + " Size: " + this.size());
        }
        return this.elementData[n2];
    }

    public Object b(String string, Namespace namespace) {
        int n2 = this.a(string, namespace);
        if (n2 < 0) {
            return null;
        }
        return this.elementData[n2];
    }

    public int a(String string, Namespace namespace) {
        String string2 = namespace.getURI();
        if (this.elementData != null) {
            int n2 = 0;
            while (n2 < this.size) {
                Attribute attribute = this.elementData[n2];
                String string3 = attribute.getNamespaceURI();
                String string4 = attribute.getName();
                if (string3.equals(string2) && string4.equals(string)) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    public Object remove(int n2) {
        if (n2 < 0 || n2 >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n2 + " Size: " + this.size());
        }
        Attribute attribute = this.elementData[n2];
        attribute.setParent(null);
        int n3 = this.size - n2 - 1;
        if (n3 > 0) {
            System.arraycopy(this.elementData, n2 + 1, this.elementData, n2, n3);
        }
        this.elementData[--this.size] = null;
        ++this.modCount;
        return attribute;
    }

    public boolean c(String string, Namespace namespace) {
        int n2 = this.a(string, namespace);
        if (n2 < 0) {
            return false;
        }
        this.remove(n2);
        return true;
    }

    public Object set(int n2, Object object) {
        if (object instanceof Attribute) {
            Attribute attribute = (Attribute)object;
            int n3 = this.indexOfDuplicate(attribute);
            if (n3 >= 0 && n3 != n2) {
                throw new IllegalAddException("Cannot set duplicate attribute");
            }
            return this.b(n2, attribute);
        }
        if (object == null) {
            throw new IllegalAddException("Cannot add null attribute");
        }
        throw new IllegalAddException("Class " + object.getClass().getName() + " is not an attribute");
    }

    public Object b(int n2, Attribute attribute) {
        if (n2 < 0 || n2 >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n2 + " Size: " + this.size());
        }
        if (attribute.getParent() != null) {
            throw new IllegalAddException("The attribute already has an existing parent \"" + attribute.getParent().getQualifiedName() + "\"");
        }
        String string = Verifier.checkNamespaceCollision(attribute, this.parent);
        if (string != null) {
            throw new IllegalAddException(this.parent, attribute, string);
        }
        Attribute attribute2 = this.elementData[n2];
        attribute2.setParent(null);
        this.elementData[n2] = attribute;
        attribute.setParent(this.parent);
        return attribute2;
    }

    private int indexOfDuplicate(Attribute attribute) {
        int n2 = -1;
        String string = attribute.getName();
        Namespace namespace = attribute.getNamespace();
        n2 = this.a(string, namespace);
        return n2;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        return super.toString();
    }
}

