/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.input;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import org.jdom.DefaultJDOMFactory;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.JDOMFactory;
import org.jdom.input.BuilderErrorHandler;
import org.jdom.input.JDOMParseException;
import org.jdom.input.SAXHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXBuilder {
    private static final String CVS_ID = "@(#) $RCSfile: SAXBuilder.java,v $ $Revision: 1.84 $ $Date: 2004/02/06 09:28:31 $ $Name: jdom_1_0_b10 $";
    private static final String DEFAULT_SAX_DRIVER = "org.apache.xerces.parsers.SAXParser";
    private boolean validate;
    private boolean expand = true;
    private String saxDriverClass;
    private ErrorHandler saxErrorHandler = null;
    private EntityResolver saxEntityResolver = null;
    private DTDHandler saxDTDHandler = null;
    private XMLFilter saxXMLFilter = null;
    private JDOMFactory factory = new DefaultJDOMFactory();
    private boolean ignoringWhite = false;
    private HashMap features = new HashMap(5);
    private HashMap properties = new HashMap(5);
    private boolean reuseParser = true;
    private XMLReader saxParser = null;
    public static Class a;

    public SAXBuilder() {
        this(false);
    }

    public SAXBuilder(boolean bl2) {
        this.validate = bl2;
    }

    public SAXBuilder(String string) {
        this(string, false);
    }

    public SAXBuilder(String string, boolean bl2) {
        this.saxDriverClass = string;
        this.validate = bl2;
    }

    public String getDriverClass() {
        return this.saxDriverClass;
    }

    public JDOMFactory getFactory() {
        return this.factory;
    }

    public void setFactory(JDOMFactory jDOMFactory) {
        this.factory = jDOMFactory;
    }

    public boolean getValidation() {
        return this.validate;
    }

    public void setValidation(boolean bl2) {
        this.validate = bl2;
    }

    public ErrorHandler getErrorHandler() {
        return this.saxErrorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.saxErrorHandler = errorHandler;
    }

    public EntityResolver getEntityResolver() {
        return this.saxEntityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.saxEntityResolver = entityResolver;
    }

    public DTDHandler getDTDHandler() {
        return this.saxDTDHandler;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.saxDTDHandler = dTDHandler;
    }

    public XMLFilter getXMLFilter() {
        return this.saxXMLFilter;
    }

    public void setXMLFilter(XMLFilter xMLFilter) {
        this.saxXMLFilter = xMLFilter;
    }

    public boolean getIgnoringElementContentWhitespace() {
        return this.ignoringWhite;
    }

    public void setIgnoringElementContentWhitespace(boolean bl2) {
        this.ignoringWhite = bl2;
    }

    public boolean getReuseParser() {
        return this.reuseParser;
    }

    public void setReuseParser(boolean bl2) {
        this.reuseParser = bl2;
        this.saxParser = null;
    }

    public void setFeature(String string, boolean bl2) {
        this.features.put(string, new Boolean(bl2));
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Document build(InputSource inputSource) throws JDOMException, IOException {
        SAXHandler sAXHandler = null;
        try {
            try {
                Object object;
                sAXHandler = this.createContentHandler();
                this.configureContentHandler(sAXHandler);
                XMLReader xMLReader = this.saxParser;
                if (xMLReader == null) {
                    xMLReader = this.createParser();
                    if (this.saxXMLFilter != null) {
                        object = this.saxXMLFilter;
                        while (object.getParent() instanceof XMLFilter) {
                            object = (XMLFilter)object.getParent();
                        }
                        object.setParent(xMLReader);
                        xMLReader = this.saxXMLFilter;
                    }
                    this.configureParser(xMLReader, sAXHandler);
                    if (this.reuseParser) {
                        this.saxParser = xMLReader;
                    }
                } else {
                    this.configureParser(xMLReader, sAXHandler);
                }
                xMLReader.parse(inputSource);
                object = sAXHandler.getDocument();
                Object var6_8 = null;
                sAXHandler = null;
                return object;
            }
            catch (SAXParseException sAXParseException) {
                String string = sAXParseException.getSystemId();
                if (string != null) {
                    throw new JDOMParseException("Error on line " + sAXParseException.getLineNumber() + " of document " + string, sAXParseException, sAXHandler.getDocument());
                }
                throw new JDOMParseException("Error on line " + sAXParseException.getLineNumber(), sAXParseException, sAXHandler.getDocument());
            }
            catch (SAXException sAXException) {
                throw new JDOMParseException("Error in building: " + sAXException.getMessage(), sAXException, sAXHandler.getDocument());
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            sAXHandler = null;
            throw throwable;
        }
    }

    public SAXHandler createContentHandler() {
        SAXHandler sAXHandler = new SAXHandler(this.factory);
        return sAXHandler;
    }

    public void configureContentHandler(SAXHandler sAXHandler) {
        sAXHandler.setExpandEntities(this.expand);
        sAXHandler.setIgnoringElementContentWhitespace(this.ignoringWhite);
    }

    public XMLReader createParser() throws JDOMException {
        XMLReader xMLReader = null;
        if (this.saxDriverClass != null) {
            try {
                xMLReader = XMLReaderFactory.createXMLReader(this.saxDriverClass);
                this.setFeaturesAndProperties(xMLReader, true);
            }
            catch (SAXException sAXException) {
                throw new JDOMException("Could not load " + this.saxDriverClass, sAXException);
            }
        }
        try {
            Class<?> clazz = Class.forName("org.jdom.input.JAXPParserFactory");
            Method method = clazz.getMethod("createParser", Boolean.TYPE, a == null ? (a = SAXBuilder.a("java.util.Map")) : a, a == null ? (a = SAXBuilder.a("java.util.Map")) : a);
            xMLReader = (XMLReader)method.invoke(null, new Boolean(this.validate), this.features, this.properties);
            this.setFeaturesAndProperties(xMLReader, false);
        }
        catch (JDOMException jDOMException) {
            throw jDOMException;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (xMLReader == null) {
            try {
                xMLReader = XMLReaderFactory.createXMLReader(DEFAULT_SAX_DRIVER);
                this.saxDriverClass = xMLReader.getClass().getName();
                this.setFeaturesAndProperties(xMLReader, true);
            }
            catch (SAXException sAXException) {
                throw new JDOMException("Could not load default SAX parser: org.apache.xerces.parsers.SAXParser", sAXException);
            }
        }
        return xMLReader;
    }

    public void configureParser(XMLReader xMLReader, SAXHandler sAXHandler) throws JDOMException {
        block15: {
            xMLReader.setContentHandler(sAXHandler);
            if (this.saxEntityResolver != null) {
                xMLReader.setEntityResolver(this.saxEntityResolver);
            }
            if (this.saxDTDHandler != null) {
                xMLReader.setDTDHandler(this.saxDTDHandler);
            } else {
                xMLReader.setDTDHandler(sAXHandler);
            }
            if (this.saxErrorHandler != null) {
                xMLReader.setErrorHandler(this.saxErrorHandler);
            } else {
                xMLReader.setErrorHandler(new BuilderErrorHandler());
            }
            boolean bl2 = false;
            try {
                xMLReader.setProperty("http://xml.org/sax/handlers/LexicalHandler", sAXHandler);
                bl2 = true;
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                // empty catch block
            }
            if (!bl2) {
                try {
                    xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", sAXHandler);
                    bl2 = true;
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    // empty catch block
                }
            }
            if (this.expand) break block15;
            try {
                xMLReader.setProperty("http://xml.org/sax/properties/declaration-handler", sAXHandler);
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {}
        }
    }

    private void setFeaturesAndProperties(XMLReader xMLReader, boolean bl2) throws JDOMException {
        String string;
        Iterator iterator = this.features.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            Boolean bl3 = (Boolean)this.features.get(string);
            this.internalSetFeature(xMLReader, string, bl3, string);
        }
        iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            this.internalSetProperty(xMLReader, string, this.properties.get(string), string);
        }
        if (bl2) {
            block9: {
                try {
                    this.internalSetFeature(xMLReader, "http://xml.org/sax/features/validation", this.validate, "Validation");
                }
                catch (JDOMException jDOMException) {
                    if (!this.validate) break block9;
                    throw jDOMException;
                }
            }
            this.internalSetFeature(xMLReader, "http://xml.org/sax/features/namespaces", true, "Namespaces");
            this.internalSetFeature(xMLReader, "http://xml.org/sax/features/namespace-prefixes", true, "Namespace prefixes");
        }
        try {
            if (xMLReader.getFeature("http://xml.org/sax/features/external-general-entities") != this.expand) {
                xMLReader.setFeature("http://xml.org/sax/features/external-general-entities", this.expand);
            }
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {}
    }

    private void internalSetFeature(XMLReader xMLReader, String string, boolean bl2, String string2) throws JDOMException {
        try {
            xMLReader.setFeature(string, bl2);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new JDOMException(string2 + " feature not supported for SAX driver " + xMLReader.getClass().getName());
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new JDOMException(string2 + " feature not recognized for SAX driver " + xMLReader.getClass().getName());
        }
    }

    private void internalSetProperty(XMLReader xMLReader, String string, Object object, String string2) throws JDOMException {
        try {
            xMLReader.setProperty(string, object);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new JDOMException(string2 + " property not supported for SAX driver " + xMLReader.getClass().getName());
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new JDOMException(string2 + " property not recognized for SAX driver " + xMLReader.getClass().getName());
        }
    }

    public Document build(InputStream inputStream) throws JDOMException, IOException {
        return this.build(new InputSource(inputStream));
    }

    public Document build(File file) throws JDOMException, IOException {
        try {
            URL uRL = this.fileToURL(file);
            return this.build(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            throw new JDOMException("Error in building", malformedURLException);
        }
    }

    public Document build(URL uRL) throws JDOMException, IOException {
        String string = uRL.toExternalForm();
        return this.build(new InputSource(string));
    }

    public Document build(InputStream inputStream, String string) throws JDOMException, IOException {
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string);
        return this.build(inputSource);
    }

    public Document build(Reader reader) throws JDOMException, IOException {
        return this.build(new InputSource(reader));
    }

    public Document build(Reader reader, String string) throws JDOMException, IOException {
        InputSource inputSource = new InputSource(reader);
        inputSource.setSystemId(string);
        return this.build(inputSource);
    }

    public Document build(String string) throws JDOMException, IOException {
        return this.build(new InputSource(string));
    }

    public URL fileToURL(File file) throws MalformedURLException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
        }
        if (!string.startsWith("/")) {
            stringBuffer.append('/');
        }
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            if (c2 == ' ') {
                stringBuffer.append("%20");
            } else if (c2 == '#') {
                stringBuffer.append("%23");
            } else if (c2 == '%') {
                stringBuffer.append("%25");
            } else if (c2 == '&') {
                stringBuffer.append("%26");
            } else if (c2 == ';') {
                stringBuffer.append("%3B");
            } else if (c2 == '<') {
                stringBuffer.append("%3C");
            } else if (c2 == '=') {
                stringBuffer.append("%3D");
            } else if (c2 == '>') {
                stringBuffer.append("%3E");
            } else if (c2 == '?') {
                stringBuffer.append("%3F");
            } else if (c2 == '~') {
                stringBuffer.append("%7E");
            } else {
                stringBuffer.append(c2);
            }
            ++n3;
        }
        if (!string.endsWith("/") && file.isDirectory()) {
            stringBuffer.append('/');
        }
        return new URL("file", "", stringBuffer.toString());
    }

    public boolean getExpandEntities() {
        return this.expand;
    }

    public void setExpandEntities(boolean bl2) {
        this.expand = bl2;
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

