/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.xbeans;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import serpro.ppgd.gui.xbeans.JEditPopupCombo;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.util.UtilitariosString;

class FiltroTeclado
extends KeyAdapter {
    private Informacao informacao;
    private JDialog popup;
    private JTable tabelaPopup;
    private JScrollPane scroll;
    private long ultimaVez = 0L;
    private String filtro = "";
    private int colunaFiltro;

    public FiltroTeclado(int aColunaFiltro, Informacao aInfo, JDialog aPopup, JTable aTabela, JScrollPane aScroll) {
        this.colunaFiltro = aColunaFiltro;
        this.popup = aPopup;
        this.tabelaPopup = aTabela;
        this.scroll = aScroll;
        this.informacao = aInfo;
    }

    public void keyPressed(KeyEvent e) {
        if (Character.isDigit(e.getKeyChar()) || Character.isLetter(e.getKeyChar())) {
            int selecao = this.selectionForKey(e.getKeyChar());
            this.tabelaPopup.getSelectionModel().setSelectionInterval(selecao, selecao);
            if (selecao != -1) {
                if (selecao == 0) {
                    this.scroll.getVerticalScrollBar().setValue(this.scroll.getVerticalScrollBar().getMinimum());
                } else if (selecao == this.tabelaPopup.getRowCount() - 1) {
                    this.scroll.getVerticalScrollBar().setValue(this.scroll.getVerticalScrollBar().getMaximum());
                } else {
                    int max = this.scroll.getVerticalScrollBar().getMaximum();
                    int pos = max / (this.tabelaPopup.getRowCount() - 1) * selecao;
                    this.scroll.getVerticalScrollBar().setValue(pos);
                }
            }
        } else if (e.getKeyCode() == 10 && this.tabelaPopup.getSelectedRow() != -1) {
            this.popup.setVisible(false);
            String cod = (String)this.tabelaPopup.getModel().getValueAt(this.tabelaPopup.getSelectedRow(), 0);
            ((Codigo)this.informacao).setConteudo(cod);
        }
    }

    public int selectionForKey(char aKey) {
        int itemSelecionado = -1;
        int delayMaxFiltroTeclado = 1000;
        if (this.colunaFiltro >= 0) {
            long atual = System.currentTimeMillis();
            long diferenca = atual - this.ultimaVez;
            if (diferenca < (long)delayMaxFiltroTeclado) {
                this.filtro = String.valueOf(this.filtro) + aKey;
                itemSelecionado = this.tentaSelecionar();
            } else {
                this.filtro = "";
                this.filtro = String.valueOf(this.filtro) + aKey;
                itemSelecionado = this.tentaSelecionar();
            }
            this.ultimaVez = atual;
            if (this.filtro.length() > 100) {
                this.filtro = "";
            }
        }
        return itemSelecionado;
    }

    private synchronized int tentaSelecionar() {
        int total = ((Codigo)this.informacao).getColecaoElementoTabela().size();
        int itemSelecionado = -1;
        String upperFiltro = this.filtro.toUpperCase();
        int i = 0;
        while (i < total) {
            ElementoTabela elem = (ElementoTabela)((Codigo)this.informacao).getColecaoElementoTabela().get(i);
            String item = UtilitariosString.removeAcentos((String)elem.getConteudo(this.colunaFiltro));
            if (item.toUpperCase().startsWith(upperFiltro)) {
                itemSelecionado = i;
                break;
            }
            ++i;
        }
        return itemSelecionado;
    }

    public static void main(String[] args) {
        new JEditPopupCombo();
    }
}

