/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.xbeans;

import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import serpro.ppgd.gui.ConstantesGlobaisGUI;
import serpro.ppgd.gui.FabricaGUI;
import serpro.ppgd.gui.PainelDicasModal;
import serpro.ppgd.gui.UtilitariosGUI;
import serpro.ppgd.gui.pendencia.MapeamentoInformacaoEditCampo;
import serpro.ppgd.gui.xbeans.JButtonMensagem;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.PPGDFacade;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.RetornosValidacoes;
import serpro.ppgd.negocio.ValidadorImpeditivoDefault;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;

public abstract class JEditCampo
extends JComponent
implements PropertyChangeListener,
Accessible {
    protected Informacao campo = null;
    private String informacaoAssociada;
    private boolean associaComFacade = true;
    protected JLabel simbolo = new JLabel("");
    private boolean observadorAtivo = true;
    private JLabel labelCampo;
    private JButtonMensagem buttonMensagem = new JButtonMensagem();
    private boolean validar = true;
    private String idAjuda;
    private String identificacaoPainelAssociado = "";
    private MostrarDicas mostraDicas = null;
    private static boolean validandoImpeditivo;
    protected boolean isPerdeFocoComEnter;
    private ActionListener preActionOkSomente;
    private ActionListener preActionOk;
    private ActionListener preActionCancel;
    private static int CONST_CALC_TAMX_PAINELDICAS;
    private boolean focusLostAtivo = true;
    private Color corComponenteReadOnly = null;
    private Color corBackgroundComponenteReadOnly = null;
    private Color corComponenteNormal = null;
    private Color corBackgroundComponenteNormal = null;
    private boolean disableButtonMensagem = false;
    private boolean validandoInputSemGui = false;
    private boolean readOnlyFocusAble = true;
    protected int incrementoTamanhoFonte = 0;
    protected float tamanhoOriginal = -1.0f;

    static {
        CONST_CALC_TAMX_PAINELDICAS = 7;
    }

    public JEditCampo() {
        this.instanciaComponentes();
        String str = FabricaUtilitarios.getProperties().getProperty("aplicacao.guibeans.associaComFacade", "true");
        this.setAssociaComFacade(Boolean.valueOf(str));
        this.buildComponente();
        this.setOpaque(false);
        this.setPerdeFocoComEnter(Boolean.valueOf(FabricaUtilitarios.getProperties().getProperty("editCampo.transfereFocoEnter", "false")));
        this.transfereFoco();
    }

    protected void instanciaComponentes() {
    }

    public JEditCampo(Informacao campo) {
        this(campo, null);
    }

    public JEditCampo(Informacao campo, String idAjuda) {
        this.instanciaComponentes();
        this.init(idAjuda);
        this.buildComponente();
        this.setInformacao(campo);
        this.setPerdeFocoComEnter(Boolean.valueOf(FabricaUtilitarios.getProperties().getProperty("editCampo.transfereFocoEnter", "false")));
        this.transfereFoco();
    }

    protected void desfazModificacao() {
        this.getInformacao().disparaObservadores();
        this.getComponenteFoco().grabFocus();
    }

    protected boolean continuaValidacaoImpeditiva(Object proxConteudo) {
        return proxConteudo == null || !proxConteudo.equals(this.getInformacao().getConteudoFormatado());
    }

    protected boolean verificaValidacoesImpeditivas(Object proxConteudo) {
        if (!this.continuaValidacaoImpeditiva(proxConteudo)) {
            return true;
        }
        this.setObservadorAtivo(false);
        this.getInformacao().ordenaListaValidadoreImpeditivos();
        for (ValidadorImpeditivoDefault validador : this.getInformacao().getListaValidadoresImpeditivos()) {
            validador.setProximoConteudo(proxConteudo);
            RetornoValidacao retornoValidacao = validador.validarImplementado();
            if (retornoValidacao == null) continue;
            if (validador.getTipoExibicao() == 0) {
                Object[] options;
                String stringOkCustom = validador.getStringOkCustomizada();
                String stringCancelCustom = validador.getStringCancelarCustomizada();
                if (stringOkCustom == null) {
                    stringOkCustom = "Ok";
                }
                if (stringCancelCustom == null) {
                    stringCancelCustom = "Cancelar";
                }
                if (validador.getSeveridade() == 5) {
                    options = new Object[]{stringOkCustom};
                    JOptionPane.showOptionDialog(UtilitariosGUI.tentaObterJanelaPrincipal(), retornoValidacao.getMensagemValidacaoExtendida(), validador.getTituloPopup(), 0, 1, null, options, options[0]);
                    validador.acaoCancelar();
                    this.setObservadorAtivo(true);
                    if (validador.isDesfazModificacaoAoCancelar()) {
                        this.desfazModificacao();
                    }
                    return false;
                }
                options = new Object[]{stringOkCustom, stringCancelCustom};
                int opt = JOptionPane.showOptionDialog(UtilitariosGUI.tentaObterJanelaPrincipal(), retornoValidacao.getMensagemValidacaoExtendida(), validador.getTituloPopup(), 2, 3, null, options, options[0]);
                if (opt == 0) {
                    validador.acaoOk();
                    this.setObservadorAtivo(true);
                    continue;
                }
                validador.acaoCancelar();
                this.setObservadorAtivo(true);
                if (validador.isDesfazModificacaoAoCancelar()) {
                    this.desfazModificacao();
                }
                return false;
            }
            if (validador.getTipoExibicao() != 1) continue;
            this.setValidandoImpeditivo(true);
            Window parent = SwingUtilities.getWindowAncestor(this.getButtonMensagem());
            if (validador.getSeveridade() == 5) {
                this.getButtonMensagem().setIcon(ConstantesGlobaisGUI.ICO_ERRO);
            } else {
                this.getButtonMensagem().setIcon(ConstantesGlobaisGUI.ICO_AVISO);
            }
            this.getButtonMensagem().setVisible(true);
            this.mostraDicas = new MostrarDicas(parent, validador.getSeveridade(), this.campo.getNomeCampoCurto(), retornoValidacao.getMensagemValidacaoExtendida());
            this.mostraDicas.disparaValidacaoImpeditiva();
            if (PainelDicasModal.getOpcaoSelecionada() == 1 && validador.getSeveridade() == 4) {
                validador.acaoOk();
                this.setObservadorAtivo(true);
                continue;
            }
            validador.acaoCancelar();
            this.setObservadorAtivo(true);
            if (validador.isDesfazModificacaoAoCancelar()) {
                this.desfazModificacao();
            }
            return false;
        }
        this.setObservadorAtivo(true);
        return true;
    }

    private void init(String idAjuda) {
        this.setIdAjuda(idAjuda);
        this.setPreActionOkSomente(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Informacao info = JEditCampo.this.getInformacao();
                info.setConteudo(info.getUltimoConteudoValido());
                JEditCampo.this.getComponenteEditor().grabFocus();
            }
        });
        this.setPreActionOk(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Informacao info = JEditCampo.this.getInformacao();
                info.setUltimoConteudoValido(info.asString());
            }
        });
        this.setPreActionCancel(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Informacao info = JEditCampo.this.getInformacao();
                String conteudoAtual = info.asString();
                info.setConteudo(info.getUltimoConteudoValido());
                JEditCampo.this.getComponenteEditor().grabFocus();
            }
        });
    }

    protected abstract void buildComponente();

    private final void setAssociaInformacao(Informacao novoCampo) {
        if (this.campo != null) {
            this.campo.getObservadores().removePropertyChangeListener(this);
        }
        this.campo = novoCampo;
        if (novoCampo != null) {
            novoCampo.getObservadores().addPropertyChangeListener(this);
        }
        MapeamentoInformacaoEditCampo.associaInformacao(this, novoCampo);
        this.configuraComportamentoReadOnly(novoCampo);
        this.habilitadoPropertyChange(novoCampo.isHabilitado());
        if (novoCampo.isReadOnly() || !novoCampo.isHabilitado()) {
            this.setDisableButtonMensagem(true);
        } else {
            this.setDisableButtonMensagem(false);
        }
    }

    public void setInformacao(Informacao campo) {
        if (campo == null) {
            LogPPGD.erro((String)"Tentando setar null em uma informa\u00e7\u00e3o? Edits podem n\u00e3o funcionar bem com uma informa\u00e7\u00e3o nula.");
        }
        this.setAssociaInformacao(campo);
        this.informacaoModificada();
        if (this.getButtonMensagem() != null) {
            this.getButtonMensagem().setVisible(false);
        }
    }

    protected abstract void informacaoModificada();

    public Informacao getInformacao() {
        return this.campo;
    }

    public JLabel getRotulo() {
        return this.labelCampo;
    }

    public void setRotulo(JLabel jlabel) {
        if (this.getRotulo() != null) {
            jlabel.setEnabled(this.getRotulo().isEnabled());
        }
        this.labelCampo = jlabel;
    }

    public JButtonMensagem getButtonMensagem() {
        return this.buttonMensagem;
    }

    public void setButtonMensagem(JButtonMensagem aBtn) {
        this.buttonMensagem = aBtn;
        this.buildComponente();
    }

    public String getIdAjuda() {
        return this.idAjuda;
    }

    public void setIdAjuda(String string) {
        this.idAjuda = string;
    }

    public boolean isValidar() {
        return this.validar;
    }

    public void setValidar(boolean b) {
        this.validar = b;
    }

    public synchronized boolean chamaValidacao() {
        if (this.isValidandoImpeditivo()) {
            return false;
        }
        if (!this.validar || this.getButtonMensagem() == null) {
            return true;
        }
        Informacao campo = this.getInformacao();
        RetornosValidacoes retornosValidacoes = campo.validar();
        RetornoValidacao ret = retornosValidacoes.getPrimeiroRetornoValidacaoMaisSevero();
        if (ret.getSeveridade() > 0) {
            Window parent;
            String mensagem = ret.getMensagemValidacaoExtendida();
            if (this.mostraDicas != null) {
                this.getButtonMensagem().removeActionListener(this.mostraDicas);
            }
            if (!ret.isExibePopup() && ret.getSeveridade() == 1) {
                this.getButtonMensagem().setIcon(ConstantesGlobaisGUI.ICO_ATENCAO);
                this.mostraDicas = new MostrarDicas(ret.getSeveridade(), campo.getNomeCampoCurto(), mensagem);
                this.getButtonMensagem().addActionListener(this.mostraDicas);
            } else if (!ret.isExibePopup() && ret.getSeveridade() == 3) {
                this.getButtonMensagem().setIcon(ConstantesGlobaisGUI.ICO_ERRO);
                this.mostraDicas = new MostrarDicas(ret.getSeveridade(), campo.getNomeCampoCurto(), mensagem);
                this.getButtonMensagem().addActionListener(this.mostraDicas);
            } else if (ret.getSeveridade() == 5) {
                this.setValidandoImpeditivo(true);
                parent = SwingUtilities.getWindowAncestor(this.getButtonMensagem());
                this.getButtonMensagem().setIcon(ConstantesGlobaisGUI.ICO_ERRO);
                this.mostraDicas = new MostrarDicas(parent, ret.getSeveridade(), campo.getNomeCampoCurto(), mensagem);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JEditCampo.this.mostraDicas.dispara();
                    }
                });
            } else if (ret.getSeveridade() == 4) {
                this.setValidandoImpeditivo(true);
                parent = SwingUtilities.getWindowAncestor(this.getButtonMensagem());
                LogPPGD.debug((String)"colocando icone atencao");
                this.getButtonMensagem().setIcon(ConstantesGlobaisGUI.ICO_ATENCAO);
                this.mostraDicas = new MostrarDicas(parent, ret.getSeveridade(), campo.getNomeCampoCurto(), mensagem);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JEditCampo.this.mostraDicas.dispara();
                    }
                });
            } else {
                this.getButtonMensagem().setIcon(ConstantesGlobaisGUI.ICO_AVISO);
                this.mostraDicas = new MostrarDicas(ret.getSeveridade(), campo.getNomeCampoCurto(), mensagem);
                this.getButtonMensagem().addActionListener(this.mostraDicas);
            }
            if (!ret.isExibePopup()) {
                this.getButtonMensagem().setVisible(!this.isDisableButtonMensagem());
            } else if (!this.isValidandoInputSemGui()) {
                parent = SwingUtilities.getWindowAncestor(this.getButtonMensagem());
                JOptionPane.showMessageDialog(parent, ret.getMensagemValidacao(), campo.getNomeCampoCurto(), 1);
            }
            if (SwingUtilities.getRoot(this.getButtonMensagem()) instanceof Window) {
                this.getButtonMensagem().getParent().repaint();
                this.repaint();
                ((Window)SwingUtilities.getRoot(this.getButtonMensagem())).repaint();
            }
            return false;
        }
        this.getButtonMensagem().setVisible(false);
        if (SwingUtilities.getRoot(this.getButtonMensagem()) instanceof Window) {
            this.getButtonMensagem().getParent().repaint();
            this.repaint();
            ((Window)SwingUtilities.getRoot(this.getButtonMensagem())).repaint();
        }
        FabricaGUI.esconderPainelDicas();
        return true;
    }

    public final void propertyChange(PropertyChangeEvent evt) {
        if (this.isObservadorAtivo()) {
            LogPPGD.debug((String)("Disparando observador EditCampo de " + this.getInformacao().getNomeCampo() + "."));
            if (evt.getPropertyName() != null) {
                if (evt.getPropertyName().equals("ReadOnly")) {
                    this.configuraComportamentoReadOnly(this.getInformacao());
                } else if (evt.getPropertyName().equals("habilitado")) {
                    if (this.getInformacao().isHabilitado()) {
                        this.setDisableButtonMensagem(false);
                    } else {
                        this.setDisableButtonMensagem(true);
                    }
                    this.habilitadoPropertyChange(this.getInformacao().isHabilitado());
                } else if (evt.getPropertyName().equals("Val-Property")) {
                    this.getButtonMensagem().setVisible(false);
                    FabricaGUI.esconderPainelDicas();
                    return;
                }
            }
            this.implementacaoPropertyChange(evt);
            this.setValidandoInputSemGui(true);
            this.chamaValidacao();
            this.setValidandoInputSemGui(false);
        }
    }

    private void configuraComportamentoReadOnly(Informacao novoCampo) {
        this.getComponenteFoco().setEnabled(true);
        if (!this.isReadOnlyFocusAble()) {
            if (novoCampo.isReadOnly()) {
                this.getComponenteFoco().setFocusable(false);
            } else {
                this.getComponenteFoco().setFocusable(true);
            }
        } else {
            this.getComponenteFoco().setFocusable(true);
        }
        if (novoCampo.isReadOnly()) {
            this.setDisableButtonMensagem(true);
            this.getComponenteFoco().setForeground(this.getCorComponenteReadOnly());
            this.getComponenteFoco().setBackground(this.getCorBackgroundComponenteReadOnly());
        } else {
            this.setDisableButtonMensagem(false);
            this.getComponenteFoco().setForeground(this.getCorComponenteNormal());
            this.getComponenteFoco().setBackground(this.getCorBackgroundComponenteNormal());
        }
        if (novoCampo.isTransportado()) {
            this.getSimbolo().setText(">>");
        } else {
            this.getSimbolo().setText("=");
        }
        this.getSimbolo().setVisible(novoCampo.isReadOnly());
        this.readOnlyPropertyChange(novoCampo.isReadOnly());
    }

    protected abstract void readOnlyPropertyChange(boolean var1);

    protected abstract void habilitadoPropertyChange(boolean var1);

    public boolean isObservadorAtivo() {
        return this.observadorAtivo;
    }

    public void setObservadorAtivo(boolean b) {
        this.observadorAtivo = b;
    }

    public abstract void implementacaoPropertyChange(PropertyChangeEvent var1);

    public abstract JComponent getComponenteEditor();

    public abstract JComponent getComponenteFoco();

    public void setPerdeFocoComEnter(boolean aPerdeFocoComEnter) {
        boolean focoEnterAntes = this.isPerdeFocoComEnter;
        this.isPerdeFocoComEnter = aPerdeFocoComEnter;
        if (this.isPerdeFocoComEnter) {
            this.aplicaTransfereFocoEnter();
        } else if (focoEnterAntes) {
            this.removeTransfereFocoEnter();
        }
    }

    public boolean isPerdeFocoComEnter() {
        return this.isPerdeFocoComEnter;
    }

    protected void aplicaTransfereFocoEnter() {
        this.getComponenteFoco().getInputMap().put(KeyStroke.getKeyStroke(10, 0, true), "Focus.nextComponent");
        this.getComponenteFoco().getActionMap().put("Focus.nextComponent", FabricaGUI.criaActionTransfereFoco());
    }

    protected void removeTransfereFocoEnter() {
        this.getComponenteFoco().getInputMap().put(KeyStroke.getKeyStroke(10, 0, true), "Focus.nextComponent");
        this.getComponenteFoco().getActionMap().put("Focus.nextComponent", null);
    }

    public void setIdentificacaoFoco(boolean status) {
    }

    public void setaFoco(boolean status) {
        this.getComponenteFoco().requestFocusInWindow();
    }

    public void aplicaFocoPendencia() {
        this.getComponenteFoco().requestFocusInWindow();
    }

    public void setaVisivel(boolean pOpt) {
        this.getComponenteEditor().setVisible(pOpt);
        if (this.getRotulo() != null) {
            this.getRotulo().setVisible(pOpt);
        }
    }

    public String getIdentificacaoPainelAssociado() {
        return this.identificacaoPainelAssociado;
    }

    public void setIdentificacaoPainelAssociado(String aIdentificacao) {
        this.identificacaoPainelAssociado = aIdentificacao;
    }

    public JLabel getSimbolo() {
        return this.simbolo;
    }

    public void setSimbolo(JLabel simbolo) {
        this.simbolo = simbolo;
    }

    public void setPreActionOkSomente(ActionListener preActionOkSomente) {
        this.preActionOkSomente = preActionOkSomente;
    }

    public ActionListener getPreActionOkSomente() {
        return this.preActionOkSomente;
    }

    public void setPreActionOk(ActionListener preActionOk) {
        this.preActionOk = preActionOk;
    }

    public ActionListener getPreActionOk() {
        return this.preActionOk;
    }

    public void setPreActionCancel(ActionListener preActionCancel) {
        this.preActionCancel = preActionCancel;
    }

    public ActionListener getPreActionCancel() {
        return this.preActionCancel;
    }

    protected synchronized void setValidandoImpeditivo(boolean pValidandoImpeditivo) {
        validandoImpeditivo = pValidandoImpeditivo;
    }

    protected boolean isValidandoImpeditivo() {
        return validandoImpeditivo;
    }

    public void disparaPainelDicasModal() {
        this.getButtonMensagem().setVisible(true);
        RetornosValidacoes validacoes = this.getInformacao().validar();
        RetornoValidacao ret = validacoes.getPrimeiroRetornoValidacaoMaisSevero();
        Window parent = SwingUtilities.getWindowAncestor(this.getButtonMensagem());
        this.getButtonMensagem().setIcon(ConstantesGlobaisGUI.ICO_ERRO);
        this.mostraDicas = new MostrarDicas(parent, ret.getSeveridade(), this.campo.getNomeCampoCurto(), ret.getMensagemValidacaoExtendida());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JEditCampo.this.mostraDicas.dispara();
            }
        });
    }

    public boolean isFocusLostAtivo() {
        return this.focusLostAtivo;
    }

    public void setFocusLostAtivo(boolean focusListenersAtivos) {
        this.focusLostAtivo = focusListenersAtivos;
    }

    public Color getCorComponenteReadOnly() {
        if (this.corComponenteReadOnly == null) {
            this.corComponenteReadOnly = this.getComponenteFoco().getForeground();
        }
        return this.corComponenteReadOnly;
    }

    public void setCorComponenteReadOnly(Color corComponenteReadOnly) {
        this.corComponenteReadOnly = corComponenteReadOnly;
    }

    public Color getCorComponenteNormal() {
        if (this.corComponenteNormal == null) {
            this.corComponenteNormal = this.getComponenteFoco().getForeground();
        }
        return this.corComponenteNormal;
    }

    public void setCorComponenteNormal(Color corComponenteNormal) {
        this.corComponenteNormal = corComponenteNormal;
    }

    public Color getCorBackgroundComponenteNormal() {
        if (this.corBackgroundComponenteNormal == null) {
            this.corBackgroundComponenteNormal = this.getComponenteFoco().getBackground();
        }
        return this.corBackgroundComponenteNormal;
    }

    public void setCorBackgroundComponenteNormal(Color corBackgroundComponenteNormal) {
        this.corBackgroundComponenteNormal = corBackgroundComponenteNormal;
    }

    public Color getCorBackgroundComponenteReadOnly() {
        if (this.corBackgroundComponenteReadOnly == null) {
            this.corBackgroundComponenteReadOnly = this.getComponenteFoco().getBackground();
        }
        return UIManager.getColor("Panel.background");
    }

    public void setCorBackgroundComponenteReadOnly(Color corBackgroundComponenteReadOnly) {
        this.corBackgroundComponenteReadOnly = corBackgroundComponenteReadOnly;
    }

    public boolean isReadOnlyFocusAble() {
        return this.readOnlyFocusAble;
    }

    public void setReadOnlyFocusAble(boolean isReadOnlyFocusAble) {
        this.readOnlyFocusAble = isReadOnlyFocusAble;
    }

    public boolean isDisableButtonMensagem() {
        return this.disableButtonMensagem;
    }

    public void setDisableButtonMensagem(boolean disableButtonMensagem) {
        this.disableButtonMensagem = disableButtonMensagem;
    }

    public void setInformacaoAssociada(String informacaoAssociada) {
        this.informacaoAssociada = informacaoAssociada;
        if (this.isAssociaComFacade() && !PlataformaPPGD.isEmDesign()) {
            this.associaInformacao(informacaoAssociada);
        }
    }

    protected void associaInformacao(Object objPai, String aInfo) {
        Object objInfo = objPai;
        try {
            StringTokenizer tokens = new StringTokenizer(aInfo, ".");
            while (tokens.hasMoreTokens()) {
                Class<?> clazz = objInfo.getClass();
                String nomeMetodo = tokens.nextToken();
                Method mtd = clazz.getMethod("get" + (nomeMetodo = String.valueOf(nomeMetodo.substring(0, 1).toUpperCase()) + nomeMetodo.substring(1, nomeMetodo.length())), new Class[0]);
                objInfo = mtd.invoke(objInfo, new Object[0]);
                if (objInfo == null) break;
            }
            if (objInfo != null) {
                this.setInformacao((Informacao)objInfo);
            } else {
                this.getInformacao().setHabilitado(false);
            }
        }
        catch (Exception e) {
            LogPPGD.erro((String)("N\u00e3o foi poss\u00edvel encontrar '" + aInfo + "'. Este atributo existe mesmo?"));
            e.printStackTrace();
        }
    }

    protected void associaInformacao(String aInfo) {
        try {
            PPGDFacade facade;
            String classeFacade = FabricaUtilitarios.getProperties().getProperty("aplicacao.classes.facade", "serpro.ppgd.repositorio.FacadeDefault");
            Class<?> classe = Class.forName(classeFacade);
            Method methGetInstancia = classe.getMethod("getInstancia", new Class[0]);
            PPGDFacade objInfo = facade = (PPGDFacade)methGetInstancia.invoke(null, new Object[0]);
            this.associaInformacao(objInfo, aInfo);
        }
        catch (Exception e) {
            LogPPGD.erro((String)("N\u00e3o foi poss\u00edvel encontrar '" + aInfo + "'. Este atributo existe mesmo?"));
            e.printStackTrace();
        }
    }

    public String getInformacaoAssociada() {
        return this.informacaoAssociada;
    }

    public void setAssociaComFacade(boolean associadoAutomaticamente) {
        this.associaComFacade = associadoAutomaticamente;
    }

    public boolean isAssociaComFacade() {
        return this.associaComFacade;
    }

    public abstract void setEstiloFonte(int var1);

    public abstract void setIncrementoTamanhoFonte(int var1);

    public abstract int getIncrementoTamanhoFonte();

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJEditCampo(this);
        }
        return this.accessibleContext;
    }

    public void setToolTipText(String text) {
        this.getComponenteEditor().setToolTipText(text);
    }

    private void transfereFoco() {
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                JEditCampo.this.getComponenteEditor().requestFocusInWindow();
            }
        });
    }

    protected void setValidandoInputSemGui(boolean validandoInputSemGui) {
        this.validandoInputSemGui = validandoInputSemGui;
    }

    protected boolean isValidandoInputSemGui() {
        return this.validandoInputSemGui;
    }

    protected class AccessibleJEditCampo
    extends JComponent.AccessibleJComponent {
        private JEditCampo edit;

        public AccessibleJEditCampo(JEditCampo aEdit) {
            super(JEditCampo.this);
            this.edit = aEdit;
        }

        public void setAccessibleName(String s) {
            this.edit.getComponenteEditor().getAccessibleContext().setAccessibleName(s);
        }

        public void setAccessibleDescription(String s) {
            this.edit.getComponenteEditor().getAccessibleContext().setAccessibleDescription(s);
        }
    }

    class MostrarDicas
    implements ActionListener {
        private String msg;
        private String titulo;
        private int tipo;
        private Window parent = null;

        public MostrarDicas(int tipo, String titulo, String msg) {
            this.msg = msg;
            this.titulo = titulo;
            this.tipo = tipo;
        }

        public MostrarDicas(Window parent, byte severidade, String nomeCampoCurto, String mensagem) {
            this(severidade, nomeCampoCurto, mensagem);
            this.parent = parent;
        }

        public void disparaValidacaoImpeditiva() {
            int tamMax = JEditCampo.this.getInformacao().getNomeCampoCurto().length() * CONST_CALC_TAMX_PAINELDICAS;
            int n = tamMax = tamMax > 90 ? tamMax : 90;
            if (this.tipo == 5) {
                FabricaGUI.exibirPainelDicasModal((Window)this.parent, (int)this.tipo, (String)this.titulo, (String)this.msg, (Component)JEditCampo.this.getComponenteEditor(), (int)tamMax);
                JEditCampo.this.setValidandoImpeditivo(false);
                JEditCampo.this.getButtonMensagem().setVisible(false);
            } else if (this.tipo == 4) {
                FabricaGUI.exibirPainelDicasModal((Window)this.parent, (int)this.tipo, (String)this.titulo, (String)this.msg, (Component)JEditCampo.this.getComponenteEditor(), (int)tamMax);
                JEditCampo.this.setValidandoImpeditivo(false);
                JEditCampo.this.getButtonMensagem().setVisible(false);
            }
        }

        public void dispara() {
            int tamMax = JEditCampo.this.getInformacao().getNomeCampoCurto().length() * CONST_CALC_TAMX_PAINELDICAS;
            int n = tamMax = tamMax > 90 ? tamMax : 90;
            if (this.tipo == 5) {
                FabricaGUI.exibirPainelDicasModal((Window)this.parent, (int)this.tipo, (String)this.titulo, (String)this.msg, (JComponent)JEditCampo.this.getComponenteEditor(), (int)tamMax, (ActionListener)JEditCampo.this.getPreActionOkSomente());
                JEditCampo.this.setValidandoImpeditivo(false);
                JEditCampo.this.getButtonMensagem().setVisible(false);
            } else if (this.tipo == 4) {
                FabricaGUI.exibirPainelDicasModal((Window)this.parent, (int)this.tipo, (String)this.titulo, (String)this.msg, (Component)JEditCampo.this.getComponenteEditor(), (int)tamMax, (ActionListener)JEditCampo.this.getPreActionOk(), (ActionListener)JEditCampo.this.getPreActionCancel());
                JEditCampo.this.setValidandoImpeditivo(false);
                JEditCampo.this.getButtonMensagem().setVisible(false);
            } else if (SwingUtilities.getRoot(JEditCampo.this.getButtonMensagem()) instanceof JDialog) {
                FabricaGUI.exibirPainelDicas((Window)((Window)SwingUtilities.getRoot(JEditCampo.this.getButtonMensagem())), (int)this.tipo, (String)this.titulo, (String)this.msg, (Component)JEditCampo.this.getButtonMensagem(), (int)tamMax);
            } else {
                FabricaGUI.exibirPainelDicas((int)this.tipo, (String)this.titulo, (String)this.msg, (Component)JEditCampo.this.getButtonMensagem(), (int)tamMax);
            }
        }

        public void actionPerformed(ActionEvent e) {
            this.dispara();
        }
    }

    class Run
    implements Runnable {
        private boolean foco;

        public Run(boolean mudarIdentificacaoFoco) {
            this.foco = mudarIdentificacaoFoco;
        }

        public void run() {
            JEditCampo.this.getComponenteFoco().requestFocusInWindow();
            JEditCampo.this.getComponenteFoco().setBorder(BorderFactory.createLineBorder(Color.RED));
        }
    }
}

