/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.xbeans;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import serpro.ppgd.gui.xbeans.CustomComboBoxObjNegocio;
import serpro.ppgd.gui.xbeans.JButtonMensagem;
import serpro.ppgd.gui.xbeans.JEditCampo;
import serpro.ppgd.gui.xbeans.JEditObjetoNegocioItemIf;
import serpro.ppgd.gui.xbeans.KeySelectionCustomizadoObjNegocio;
import serpro.ppgd.gui.xbeans.MyCustomRendererObjNegocio;
import serpro.ppgd.gui.xbeans.PainelBotao;
import serpro.ppgd.gui.xbeans.editors.PPGDComboBox;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JEditObjetoNegocio
extends JEditCampo
implements ActionListener {
    JComboBox combo;
    protected Colecao colecao;
    Dimension[] tamCols;
    boolean[] colsVisiveisExpandidas;
    boolean[] colsVisiveis;
    private Border bordaColunas = BorderFactory.createMatteBorder(0, 0, 1, 1, Color.GRAY);
    private Border bordaVazia = BorderFactory.createEmptyBorder();

    public JEditObjetoNegocio() {
        super((Informacao)new Alfa("C\u00f3digo"));
        this.aplicaItens(this.colecao.recuperarLista());
        this.inicio();
    }

    public JEditObjetoNegocio(Informacao aCampo) {
        super(aCampo);
        this.inicio();
    }

    public JEditObjetoNegocio(Informacao aCampo, String idAjuda) {
        super(aCampo, idAjuda);
        this.inicio();
    }

    @Override
    protected boolean continuaValidacaoImpeditiva(Object proxConteudo) {
        return proxConteudo == null || !proxConteudo.equals(this.getItemSelecionado());
    }

    protected int getIndiceSelecionado() {
        Iterator it = this.colecao.recuperarLista().iterator();
        int indice = 0;
        while (it.hasNext()) {
            JEditObjetoNegocioItemIf item = (JEditObjetoNegocioItemIf)it.next();
            if (item.getConteudo(0).equals(this.getInformacao().asString())) {
                return indice;
            }
            ++indice;
        }
        return -1;
    }

    protected JEditObjetoNegocioItemIf getItemSelecionado() {
        int indice = this.getIndiceSelecionado();
        if (indice != -1) {
            return (JEditObjetoNegocioItemIf)this.colecao.recuperarLista().get(indice);
        }
        return null;
    }

    @Override
    protected void desfazModificacao() {
        int indice = this.getIndiceSelecionado();
        this.combo.setSelectedIndex(indice);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JEditObjetoNegocio.this.combo.grabFocus();
            }
        });
    }

    protected int getTotalColunas() {
        if (this.colecao.getTipoItens() == null) {
            return 0;
        }
        if (this.colecao.recuperarLista().isEmpty()) {
            return ((JEditObjetoNegocioItemIf)this.colecao.instanciaNovoObjeto()).getTotalAtributos();
        }
        return ((JEditObjetoNegocioItemIf)this.colecao.recuperarLista().get(0)).getTotalAtributos();
    }

    protected int getColunaFiltro() {
        if (this.colecao.getTipoItens() == null) {
            return 0;
        }
        if (this.colecao.recuperarLista().isEmpty()) {
            return ((JEditObjetoNegocioItemIf)this.colecao.instanciaNovoObjeto()).getColunaFiltro();
        }
        return ((JEditObjetoNegocioItemIf)this.colecao.recuperarLista().get(0)).getColunaFiltro();
    }

    private void inicio() {
        this.setInformacao(this.getInformacao());
        this.combo.setKeySelectionManager(new KeySelectionCustomizadoObjNegocio(this.getColunaFiltro()));
        this.combo.addActionListener(this);
        this.combo.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (e.getOppositeComponent() == null || !JEditObjetoNegocio.this.isFocusLostAtivo()) {
                    return;
                }
                JEditObjetoNegocio.this.setIdentificacaoFoco(false);
                if (!JEditObjetoNegocio.this.getInformacao().getListaValidadoresImpeditivos().isEmpty()) {
                    JEditObjetoNegocioItemIf elemento = JEditObjetoNegocio.this.getItemSelecionado();
                    if (!JEditObjetoNegocio.this.verificaValidacoesImpeditivas(elemento)) {
                        return;
                    }
                    JEditObjetoNegocio.this.setaCampo();
                }
                JEditObjetoNegocio.this.chamaValidacao();
            }
        });
    }

    protected void initColsVisiveis() {
        this.colsVisiveis = new boolean[30];
        this.colsVisiveisExpandidas = new boolean[30];
        int i = 0;
        while (i < this.colsVisiveis.length) {
            this.colsVisiveisExpandidas[i] = false;
            this.colsVisiveis[i] = false;
            ++i;
        }
        this.exibeColunaNaoExpandida(1);
        this.exibeColunaExpandida(1);
    }

    public void exibeColunaNaoExpandida(int aCol) {
        this.colsVisiveis[aCol] = true;
    }

    public void escondeColunaNaoExpandida(int aCol) {
        this.colsVisiveis[aCol] = false;
    }

    public void exibeColunaExpandida(int aCol) {
        this.colsVisiveisExpandidas[aCol] = true;
    }

    public void escondeColunaExpandida(int aCol) {
        this.colsVisiveisExpandidas[aCol] = false;
    }

    public Colecao getColecao() {
        return this.colecao;
    }

    public void setColecao(Colecao colecao) {
        this.colecao = colecao;
        this.aplicaItens(colecao.recuperarLista());
    }

    private void aplicaItens(List<ObjetoNegocio> elems) {
        if (elems != null) {
            this.calculaTamanhoMaxCols();
            this.combo.setModel(new DefaultComboBoxModel<Object>(elems.toArray()));
            this.combo.setSelectedItem(this.getItemSelecionado());
        }
    }

    @Override
    protected void buildComponente() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        if (this.combo == null) {
            this.colecao = new Colecao(){};
            this.combo = new CustomComboBoxObjNegocio(this);
            this.combo.setRenderer(new MyCustomRendererObjNegocio(this));
        }
        if (this.colsVisiveis == null || this.colsVisiveisExpandidas == null) {
            this.initColsVisiveis();
        }
        this.add((Component)this.combo, "Center");
        JButtonMensagem btnMsg = this.getButtonMensagem();
        if (btnMsg != null) {
            this.add((Component)new PainelBotao(btnMsg), "East");
        }
    }

    @Override
    protected void informacaoModificada() {
        this.aplicaItens(this.colecao.recuperarLista());
        ((PPGDComboBox)this.combo).setInformacao(this.campo);
    }

    @Override
    public void implementacaoPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() != null && evt.getPropertyName().equals(this.getInformacao().getNomeCampo())) {
            this.combo.setSelectedIndex(this.getIndiceSelecionado());
        }
    }

    @Override
    public JComponent getComponenteEditor() {
        return this.combo;
    }

    @Override
    public JComponent getComponenteFoco() {
        return this.combo;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.getInformacao().getListaValidadoresImpeditivos().isEmpty()) {
            return;
        }
        this.setaCampo();
    }

    public void setaCampo() {
        JEditObjetoNegocioItemIf elem = (JEditObjetoNegocioItemIf)this.combo.getSelectedItem();
        if (elem != null) {
            this.campo.setConteudo(elem.getConteudo(0));
        }
    }

    private void calculaTamanhoMaxCols() {
        Dimension tam;
        int i;
        JEditObjetoNegocioItemIf elem;
        Iterator it = this.colecao.recuperarLista().iterator();
        if (it.hasNext()) {
            elem = (JEditObjetoNegocioItemIf)it.next();
            this.tamCols = new Dimension[elem.getTotalAtributos()];
            i = 0;
            while (i < this.tamCols.length) {
                tam = new JLabel(elem.getConteudo(i)).getPreferredSize();
                if (this.tamCols[i] == null || this.tamCols[i].width < tam.width) {
                    this.tamCols[i] = tam;
                    this.tamCols[i].width += 5;
                }
                ++i;
            }
        }
        while (it.hasNext()) {
            elem = (JEditObjetoNegocioItemIf)it.next();
            i = 0;
            while (i < this.tamCols.length) {
                tam = new JLabel(elem.getConteudo(i)).getPreferredSize();
                if (this.tamCols[i] == null || this.tamCols[i].width < tam.width) {
                    this.tamCols[i] = tam;
                    this.tamCols[i].width += 5;
                }
                ++i;
            }
        }
    }

    @Override
    protected void readOnlyPropertyChange(boolean readOnly) {
        this.combo.setEnabled(!readOnly);
    }

    @Override
    protected void habilitadoPropertyChange(boolean habilitado) {
        this.combo.setEnabled(habilitado);
    }

    public Border getBordaColunas() {
        Border borda = null;
        int qtdColsVisiveis = 0;
        int i = 0;
        while (i < this.colsVisiveis.length) {
            if (this.colsVisiveis[i]) {
                ++qtdColsVisiveis;
            }
            ++i;
        }
        borda = qtdColsVisiveis > 1 ? this.bordaColunas : this.bordaVazia;
        return borda;
    }

    public void setBordaColunas(Border bordaColunas) {
        this.bordaColunas = bordaColunas;
    }

    @Override
    public void setEstiloFonte(int estilo) {
        Font f = this.combo.getFont();
        f = f.deriveFont(estilo);
        this.combo.setFont(f);
    }

    @Override
    public void setIncrementoTamanhoFonte(int incremento) {
        this.incrementoTamanhoFonte = incremento;
        Font f = this.combo.getFont();
        if (this.tamanhoOriginal == -1.0f) {
            this.tamanhoOriginal = f.getSize2D();
        }
        f = f.deriveFont(this.tamanhoOriginal + (float)incremento);
        this.combo.setFont(f);
    }

    @Override
    public int getIncrementoTamanhoFonte() {
        return this.incrementoTamanhoFonte;
    }
}

