/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.infraestrutura.acoes;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import serpro.ppgd.gui.FabricaGUI;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.treeview.NoGenerico;
import serpro.ppgd.infraestrutura.util.PainelCacher;
import serpro.ppgd.negocio.util.LogPPGD;

public class AcaoMudaPainel
extends AbstractAction {
    protected JPanel painelAcionado;
    protected String painelStr = null;

    public AcaoMudaPainel() {
    }

    public AcaoMudaPainel(String aPainelStr) {
        this.setPainelStr(aPainelStr);
    }

    protected void acionaPainel(String pRotuloNodo) {
        try {
            this.painelAcionado = PainelCacher.getInstance().obtemUrgentemente(this.painelStr);
            PlataformaPPGD.getPlataforma().mudaPainelExibido(this.painelAcionado);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setPainelStr(String painelStr) {
        this.painelStr = painelStr;
        PainelCacher.getInstance().fazCacheDe(this.painelStr);
    }

    public String getPainelStr() {
        return this.painelStr;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FabricaGUI.esconderPainelDicas();
        if (e != null && e.getActionCommand() != null && e.getActionCommand().length() > 0 && this.getPainelStr() == null) {
            this.setPainelStr(e.getActionCommand());
        }
        if (this.painelStr != null && this.painelStr.trim().length() > 0) {
            if (e.getSource() instanceof NoGenerico) {
                NoGenerico nodoSource = (NoGenerico)e.getSource();
                this.acionaPainel(nodoSource.getNome());
            } else {
                this.acionaPainel(e.getActionCommand());
            }
        } else {
            LogPPGD.debug((String)("Erro: " + this.getClass().getName() + ": faltou especificar o painel a ser acionado!"));
        }
    }
}

