/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.infraestrutura.treeview;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import serpro.ppgd.gui.ConstantesGlobaisGUI;
import serpro.ppgd.infraestrutura.treeview.NoGenerico;
import serpro.ppgd.negocio.util.UtilitariosString;

public class RenderizadorNodos
extends DefaultTreeCellRenderer {
    protected final ImageIcon ICO_INDICADOR = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("imagens/ico_indicador.gif"));
    protected JTree tree;
    protected Object ultimoNodo;

    public RenderizadorNodos(JTree ptree) {
        this.tree = ptree;
        this.setLeafIcon(null);
        this.setFocusable(false);
        this.setBackgroundSelectionColor(this.getBackgroundNonSelectionColor());
        this.tree.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent me) {
                TreePath treePath = RenderizadorNodos.this.tree.getPathForLocation(me.getX(), me.getY());
                Object obj = treePath != null ? treePath.getLastPathComponent() : null;
                if (obj != RenderizadorNodos.this.ultimoNodo) {
                    RenderizadorNodos.this.ultimoNodo = obj;
                    RenderizadorNodos.this.tree.repaint();
                }
            }
        });
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        tree.setRowHeight(0);
        this.setTextSelectionColor(this.getTextNonSelectionColor());
        NoGenerico nodo = (NoGenerico)value;
        if (nodo.isRoot()) {
            NoGenerico no = (NoGenerico)value;
            this.setOpenIcon(no.getIconeExpandido());
            this.setClosedIcon(no.getIconeContraido());
            this.setVerticalTextPosition(1);
        } else if (nodo != null) {
            this.setOpenIcon(nodo.getIconeExpandido());
            this.setClosedIcon(nodo.getIconeContraido());
            this.setLeafIcon(nodo.getIconeContraido());
            this.setToolTipText(nodo.getTooltip());
        }
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (!nodo.isRoot()) {
            if (!((NoGenerico)value).isActionHabilitado()) {
                this.setForeground(ConstantesGlobaisGUI.COR_CINZA_CLARO);
                this.setEnabled(false);
            } else {
                this.setForeground(ConstantesGlobaisGUI.COR_PRETO);
                this.setEnabled(true);
            }
            if (value == this.ultimoNodo && nodo.isActionHabilitado()) {
                this.setText("<HTML><U>" + this.getText() + "</U></HTML>");
            }
        }
        this.setOpenIcon(null);
        this.setClosedIcon(null);
        if (sel && nodo.isActionHabilitado()) {
            this.setText(UtilitariosString.expandeStringHTML((String)(this.getText() + '^'), (String)"<FONT COLOR=#336699><u>", (int)0));
            this.setText("<HTML><U>" + this.getText() + "</U></HTML>");
        }
        return this;
    }
}

