/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.infraestrutura.util;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;

public class PainelCacher
extends Thread {
    private List<ItemCache> listaNomeProximos = new ArrayList<ItemCache>();
    private List<ItemCache> listaNomeTodos = new ArrayList<ItemCache>();
    private Map<String, JPanel> cache = new Hashtable<String, JPanel>();
    private Integer lockLista = 0;
    private static PainelCacher instance = new PainelCacher();
    public static final int INICIADO = 0;
    public static final int PAUSADO = 1;
    public static final int FINALIZADO = 2;
    private boolean fazCacheAoObter = false;
    private long cacherSleep = Long.parseLong(FabricaUtilitarios.getProperties().getProperty("aplicacao.infraestrutura.painelcacher.intervalo", "3000"));
    private transient int estado = 2;

    public static PainelCacher getInstance() {
        if (!instance.isAlive()) {
            instance.start();
            instance.setPriority(1);
        }
        return instance;
    }

    public static PainelCacher getInstancia() {
        if (!instance.isAlive()) {
            instance.start();
            instance.setPriority(1);
        }
        return instance;
    }

    private PainelCacher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    if (this.estado == 0) {
                        Integer n = this.lockLista;
                        synchronized (n) {
                            if (this.listaNomeProximos.size() > 0) {
                                ItemCache item = this.listaNomeProximos.remove(0);
                                String painelStr = item.getNomeClasse();
                                JPanel painelInstanciado = this.cache.get(painelStr);
                                if (painelInstanciado == null) {
                                    painelInstanciado = PlataformaPPGD.getPlataforma().instanciaPainel(painelStr);
                                }
                                if (painelInstanciado != null) {
                                    this.aplicaIdentificacao(painelStr, painelInstanciado);
                                    this.cache.put(painelStr, painelInstanciado);
                                }
                            }
                        }
                    }
                    PainelCacher.sleep(this.cacherSleep);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void inicia() {
        LogPPGD.debug((String)"############ Iniciando PainelCacher ##############");
        this.estado = 0;
    }

    public void pausa() {
        this.estado = 1;
    }

    public void encerra() {
        LogPPGD.debug((String)"############ Encerrando PainelCacher ##############");
        this.estado = 2;
        this.reiniciaCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void esvaziaCache() {
        LogPPGD.debug((String)"############ Esvaziando PainelCacher ##############");
        this.estado = 2;
        Integer n = this.lockLista;
        synchronized (n) {
            this.cache.clear();
            this.listaNomeProximos.clear();
            this.listaNomeTodos.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reiniciaCache() {
        Integer n = this.lockLista;
        synchronized (n) {
            this.cache.clear();
            this.listaNomeProximos.clear();
            this.listaNomeProximos.addAll(this.listaNomeTodos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fazCacheDe(String aPainelStr) {
        Integer n = this.lockLista;
        synchronized (n) {
            ItemCache item = new ItemCache(aPainelStr);
            this.listaNomeProximos.add(item);
            this.listaNomeTodos.add(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fazCacheDe(String aPainelStr, Object aParam) {
        Integer n = this.lockLista;
        synchronized (n) {
            ItemCache item = new ItemCache(aPainelStr, aParam);
            this.listaNomeProximos.add(item);
            this.listaNomeTodos.add(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPanel obtemUrgentemente(String aPainelStr) {
        JPanel painel = this.cache.get(aPainelStr);
        int estadoAnterior = this.estado;
        if (!this.isFazCacheAoObter()) {
            try {
                painel = PlataformaPPGD.getPlataforma().instanciaPainel(aPainelStr);
            }
            catch (Exception e) {
                LogPPGD.erro((String)("O PainelCacher n\u00e3o conseguiu instanciar a classe " + aPainelStr + "!!"));
                e.printStackTrace();
            }
        }
        if (painel == null) {
            Integer n = this.lockLista;
            synchronized (n) {
                JPanel painelInstanciado = null;
                try {
                    painelInstanciado = PlataformaPPGD.getPlataforma().instanciaPainel(aPainelStr);
                    this.aplicaIdentificacao(aPainelStr, painelInstanciado);
                    this.cache.put(aPainelStr, painelInstanciado);
                    this.listaNomeProximos.remove(aPainelStr);
                }
                catch (Exception e) {
                    LogPPGD.erro((String)("O PainelCacher n\u00e3o conseguiu instanciar a classe " + aPainelStr + "!!"));
                    e.printStackTrace();
                }
                painel = painelInstanciado;
            }
        }
        this.estado = estadoAnterior;
        return painel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPanel obtemUrgentemente(String aChave, String aPainelStr) {
        JPanel painel = this.cache.get(aChave);
        int estadoAnterior = this.estado;
        if (!this.isFazCacheAoObter()) {
            try {
                painel = PlataformaPPGD.getPlataforma().instanciaPainel(aPainelStr);
            }
            catch (Exception e) {
                LogPPGD.erro((String)("O PainelCacher n\u00e3o conseguiu instanciar a classe " + aPainelStr + "!!"));
                e.printStackTrace();
            }
        }
        if (painel == null) {
            Integer n = this.lockLista;
            synchronized (n) {
                JPanel painelInstanciado = null;
                try {
                    painelInstanciado = PlataformaPPGD.getPlataforma().instanciaPainel(aPainelStr);
                    this.aplicaIdentificacao(aChave, painelInstanciado);
                    this.cache.put(aChave, painelInstanciado);
                    this.listaNomeProximos.remove(aPainelStr);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                painel = painelInstanciado;
            }
        }
        this.estado = estadoAnterior;
        return painel;
    }

    public boolean isEmCache(String aPainelStr) {
        return this.cache.get(aPainelStr) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instanciaTodosUrgenteMente() {
        try {
            int estadoAnterior = this.estado;
            this.pausa();
            Integer n = this.lockLista;
            synchronized (n) {
                for (ItemCache item : this.listaNomeProximos) {
                    String proximo = item.getNomeClasse();
                    JPanel painelInstanciado = this.obtemUrgentemente(proximo);
                }
                this.listaNomeProximos.clear();
            }
            this.estado = estadoAnterior;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void aplicaIdentificacao(String proximo, JPanel painelInstanciado) {
    }

    public void setFazCacheAoObter(boolean fazCacheAoObter) {
        this.fazCacheAoObter = fazCacheAoObter;
    }

    public boolean isFazCacheAoObter() {
        return this.fazCacheAoObter;
    }

    private class ItemCache {
        private String nomeClasse;
        private Object param;

        public ItemCache(String nomeClasse) {
            this.setNomeClasse(nomeClasse);
        }

        public ItemCache(String nomeClasse, Object param) {
            this.setNomeClasse(nomeClasse);
            this.setParam(param);
        }

        public void setNomeClasse(String nomeClasse) {
            this.nomeClasse = nomeClasse;
        }

        public String getNomeClasse() {
            return this.nomeClasse;
        }

        public void setParam(Object param) {
            this.param = param;
        }

        public Object getParam() {
            return this.param;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ItemCache) {
                ItemCache outroItem = (ItemCache)obj;
                return this.getNomeClasse().equals(outroItem.getNomeClasse());
            }
            return false;
        }
    }
}

