/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.alimentandos;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import serpro.ppgd.gui.xbeans.JEditObjetoNegocioItemIf;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.alimentandos.a;
import serpro.ppgd.irpf.alimentandos.b;
import serpro.ppgd.irpf.alimentandos.c;
import serpro.ppgd.irpf.alimentandos.d;
import serpro.ppgd.irpf.alimentandos.e;
import serpro.ppgd.irpf.alimentandos.f;
import serpro.ppgd.irpf.alimentandos.g;
import serpro.ppgd.irpf.contribuinte.j;
import serpro.ppgd.irpf.gui.alimentandos.PainelAlimentandos;
import serpro.ppgd.irpf.o;
import serpro.ppgd.irpf.pagamentos.Pagamento;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class Alimentando
extends ObjetoNegocio
implements JEditObjetoNegocioItemIf,
ObjetoFicha {
    public static final String PROP_CAMPO_NOME = "Nome do alimentando";
    public static final String PROP_CAMPO_CPF = "CPF";
    public static final String RESIDENTE_BRASIL = "0";
    public static final String RESIDENTE_EXTERIOR = "1";
    public static final String RESIDENTE_VAZIO = "2";
    private String chave = "";
    private Alfa nome = new Alfa((ObjetoNegocio)this, "Nome do alimentando", 60);
    private Alfa residente = new Alfa((ObjetoNegocio)this, "Residente", 1);
    private CPF cpf = new CPF((ObjetoNegocio)this, "CPF");
    private Data dtNascimento = new Data((ObjetoNegocio)this, "Data de nascimento");
    private WeakReference refDeclaracao;

    public Alimentando(DeclaracaoIRPF declaracaoIRPF) {
        this.refDeclaracao = new WeakReference<DeclaracaoIRPF>(declaracaoIRPF);
        this.getNome().addValidador((ValidadorIf)new a(3, this.getDtNascimento(), this.tab.msg("alimentandos_nome_branco")));
        this.getNome().addObservador((Observador)new o());
        this.getNome().addValidador((ValidadorIf)new ValidadorNaoNulo(3));
        this.getNome().addValidador((ValidadorIf)new g(this, 3));
        this.getCpf().addValidador((ValidadorIf)new f(this, 3));
        this.getCpf().addValidador((ValidadorIf)new serpro.ppgd.irpf.b(3, this.tab.msg("cpf_alimentando_tit_igual"), declaracaoIRPF.getIdentificadorDeclaracao().getCpf()));
        this.getCpf().addValidador((ValidadorIf)new c(this.getResidente(), this.getDtNascimento()));
        this.getCpf().addValidador((ValidadorIf)new e(declaracaoIRPF.getAlimentandos()));
        this.getCpf().addValidador((ValidadorIf)new b(declaracaoIRPF.getDependentes()));
        this.getResidente().addValidador((ValidadorIf)new d(3, this.tab.msg("alimentando_residencia_branco")));
        this.getDtNascimento().addValidador((ValidadorIf)new ValidadorNaoNulo(3));
        this.getDtNascimento().addValidador((ValidadorIf)new j(3));
    }

    public Alfa getNome() {
        return this.nome;
    }

    public String toString() {
        return this.nome.asString();
    }

    public String getConteudo(int n2) {
        return this.getNome().getConteudoFormatado();
    }

    public int getTotalAtributos() {
        return 1;
    }

    public int getColunaFiltro() {
        return 0;
    }

    public String getChave() {
        return this.chave;
    }

    public void setChave(String string) {
        this.chave = string;
    }

    public String getClasseFicha() {
        return PainelAlimentandos.class.getName();
    }

    public CPF getCpf() {
        return this.cpf;
    }

    public Data getDtNascimento() {
        return this.dtNascimento;
    }

    public Alfa getResidente() {
        return this.residente;
    }

    public boolean isVazio() {
        for (Informacao informacao : this.recuperarCamposInformacao()) {
            if (informacao.isVazio() || informacao.getNomeCampo().equals("Residente")) continue;
            return false;
        }
        return true;
    }

    protected List recuperarListaCamposPendencia() {
        List list = super.recuperarListaCamposPendencia();
        list.add(this.getResidente());
        list.add(this.getNome());
        list.add(this.getCpf());
        list.add(this.getDtNascimento());
        return list;
    }

    public List verificarPendencias(int n2) {
        List list = super.verificarPendencias(n2);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("");
        arrayList.add("01");
        arrayList.add("02");
        arrayList.add("10");
        arrayList.add("11");
        arrayList.add("20");
        arrayList.add("21");
        arrayList.add("26");
        arrayList.add("30");
        arrayList.add("31");
        arrayList.add("33");
        arrayList.add("34");
        if (!this.getCpf().isVazio()) {
            Object object = (DeclaracaoIRPF)((Object)this.refDeclaracao.get());
            object = ((DeclaracaoIRPF)((Object)object)).getPagamentos().recuperarLista();
            boolean bl2 = false;
            if (!object.isEmpty()) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (!Pagamento.TIPO_ALIMENTANDO.equals(((Pagamento)(object = (Pagamento)object)).getTipo().asString()) || !arrayList.contains(((Pagamento)object).getCodigo().asString()) || this.getNome().asString().isEmpty() || !this.getNome().asString().equals(((Pagamento)object).getDependenteOuAlimentando().asString())) continue;
                    bl2 = true;
                }
            }
            if (!bl2) {
                object = new Pendencia(2, (Informacao)this.getCpf(), this.getCpf().getNomeCampo(), this.tab.msg("alimentando_nao_dedutivel"), n2);
                object.setClassePainel(this.getClasseFicha());
                list.add(object);
            }
        }
        return list;
    }
}

