/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.bens;

import serpro.ppgd.irpf.bens.Bem;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;

public class Bens
extends Colecao {
    private static final String VALOR_ALTO = "500.000,00";
    private Valor totalExercicioAnterior = new Valor((ObjetoNegocio)this, "Total exercicio Anterior");
    private Valor totalExercicioAtual = new Valor((ObjetoNegocio)this, "Total exercicio Atual");
    private Alfa ultimoIndiceGerado = new Alfa();
    private static long geradorIndices;

    public Bens() {
        super(Bem.class.getName());
        this.setFicha("Bens e Direitos");
        this.totalExercicioAnterior.setReadOnly(true);
        this.totalExercicioAtual.setReadOnly(true);
    }

    public void inicializaGeradorIndices() {
        if (this.ultimoIndiceGerado.asString().trim().equals("")) {
            geradorIndices = 0L;
            return;
        }
        geradorIndices = Long.parseLong(this.ultimoIndiceGerado.asString());
    }

    private String proximoIndice() {
        this.ultimoIndiceGerado.setConteudo("" + geradorIndices++);
        return this.ultimoIndiceGerado.asString();
    }

    public ObjetoNegocio instanciaNovoObjeto() {
        Bem bem = (Bem)super.instanciaNovoObjeto();
        bem.getIndice().setConteudo(this.proximoIndice());
        return bem;
    }

    public void objetoInserido(Object object) {
        this.setFicha(this.getFicha());
    }

    public Valor getTotalExercicioAnterior() {
        return this.totalExercicioAnterior;
    }

    public Valor getTotalExercicioAtual() {
        return this.totalExercicioAtual;
    }

    public boolean existeValorAlto() {
        for (Bem bem : this.recuperarLista()) {
            if (!bem.getValorExercicioAtual().comparacao(">", VALOR_ALTO)) continue;
            return true;
        }
        return false;
    }
}

