/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.ganhosdecapital;

import java.util.ArrayList;
import java.util.Iterator;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ganhosdecapital.ColecaoIdentificacaoDeclaranteGCAP;
import serpro.ppgd.irpf.ganhosdecapital.IdentificacaoDeclaranteGCAP;
import serpro.ppgd.irpf.ganhosdecapital.bensimoveis.ColecaoBensImoveis;
import serpro.ppgd.irpf.ganhosdecapital.bensimoveis.ItemDadosBemImovel;
import serpro.ppgd.irpf.ganhosdecapital.bensmoveis.ColecaoBensMoveis;
import serpro.ppgd.irpf.ganhosdecapital.bensmoveis.ItemDadosBemMovel;
import serpro.ppgd.irpf.ganhosdecapital.psocietarias.ColecaoPSocietarias;
import serpro.ppgd.irpf.ganhosdecapital.psocietarias.ItemDadosPSocietarias;
import serpro.ppgd.irpf.gui.ganhosdecapital.bensimoveis.PainelGCapBensImoveisLista;
import serpro.ppgd.irpf.p;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;

public class GanhosDeCapital
extends ObjetoNegocio
implements ObjetoFicha {
    private ColecaoBensImoveis bensImoveis;
    private ColecaoBensMoveis bensMoveis;
    private ColecaoPSocietarias participacoesSocietarias;
    private ColecaoIdentificacaoDeclaranteGCAP declarantes;
    private p totalImpostoPagoSobreGanhosCapital = new p(this, "");
    private p totalImpostoRetidoFonteSobreGanhosCapital = new p(this, "");

    public GanhosDeCapital(DeclaracaoIRPF declaracaoIRPF) {
        this.setFicha("Ganho de Capital");
        this.bensImoveis = new ColecaoBensImoveis(declaracaoIRPF);
        this.bensMoveis = new ColecaoBensMoveis(declaracaoIRPF);
        this.participacoesSocietarias = new ColecaoPSocietarias(declaracaoIRPF);
        this.declarantes = new ColecaoIdentificacaoDeclaranteGCAP();
    }

    public ColecaoBensImoveis getBensImoveis() {
        return this.bensImoveis;
    }

    public ColecaoBensMoveis getBensMoveis() {
        return this.bensMoveis;
    }

    public ColecaoPSocietarias getParticipacoesSocietarias() {
        return this.participacoesSocietarias;
    }

    public p getTotalImpostoPagoSobreGanhosCapital() {
        return this.totalImpostoPagoSobreGanhosCapital;
    }

    public void setBensImoveis(ColecaoBensImoveis colecaoBensImoveis) {
        this.bensImoveis = colecaoBensImoveis;
    }

    public void setBensMoveis(ColecaoBensMoveis colecaoBensMoveis) {
        this.bensMoveis = colecaoBensMoveis;
    }

    public void setParticipacoesSocietarias(ColecaoPSocietarias colecaoPSocietarias) {
        this.participacoesSocietarias = colecaoPSocietarias;
    }

    public ColecaoIdentificacaoDeclaranteGCAP getDeclarantes() {
        return this.declarantes;
    }

    public void setDeclarantes(ColecaoIdentificacaoDeclaranteGCAP colecaoIdentificacaoDeclaranteGCAP) {
        this.declarantes = colecaoIdentificacaoDeclaranteGCAP;
    }

    public void setTotalImpostoPagoSobreGanhosCapital(p p2) {
        this.totalImpostoPagoSobreGanhosCapital = p2;
    }

    public p getTotalImpostoRetidoFonteSobreGanhosCapital() {
        return this.totalImpostoRetidoFonteSobreGanhosCapital;
    }

    public void setTotalImpostoRetidoFonteSobreGanhosCapital(p p2) {
        this.totalImpostoRetidoFonteSobreGanhosCapital = p2;
    }

    public void excluirItemPorCPF(String string) {
        ArrayList<ItemDadosBemImovel> arrayList = new ArrayList<ItemDadosBemImovel>();
        ArrayList<ObjetoNegocio> arrayList2 = new ArrayList<ObjetoNegocio>();
        ArrayList<ObjetoNegocio> arrayList3 = new ArrayList<ObjetoNegocio>();
        ArrayList<ObjetoNegocio> arrayList4 = new ArrayList<ObjetoNegocio>();
        for (ObjetoNegocio objetoNegocio : this.getBensImoveis().recuperarLista()) {
            if (!string.equals(objetoNegocio.getCpf().asString())) continue;
            arrayList.add((ItemDadosBemImovel)objetoNegocio);
        }
        for (ObjetoNegocio objetoNegocio : this.getBensMoveis().recuperarLista()) {
            if (!string.equals(objetoNegocio.getCpf().asString())) continue;
            arrayList2.add(objetoNegocio);
        }
        for (ObjetoNegocio objetoNegocio : this.getParticipacoesSocietarias().recuperarLista()) {
            if (!string.equals(objetoNegocio.getCpf().asString())) continue;
            arrayList3.add(objetoNegocio);
        }
        Iterator iterator = this.getDeclarantes().recuperarLista().iterator();
        while (iterator.hasNext()) {
            ObjetoNegocio objetoNegocio;
            objetoNegocio = (IdentificacaoDeclaranteGCAP)((Object)iterator.next());
            if (!string.equals(objetoNegocio.getCpf().asString())) continue;
            arrayList4.add(objetoNegocio);
            this.getDeclarantes().recuperarLista().remove(objetoNegocio);
            iterator = this.getDeclarantes().recuperarLista().iterator();
        }
        for (ObjetoNegocio objetoNegocio : arrayList3) {
            this.getParticipacoesSocietarias().recuperarLista().remove(objetoNegocio);
        }
        for (ObjetoNegocio objetoNegocio : arrayList4) {
            this.getDeclarantes().recuperarLista().remove(objetoNegocio);
        }
        this.getBensMoveis().recuperarLista().removeAll(arrayList2);
        this.getBensImoveis().recuperarLista().removeAll(arrayList);
    }

    public boolean existeItemPorCPF(String string) {
        if ("".equals(string.trim())) {
            return false;
        }
        for (ObjetoNegocio objetoNegocio : this.getBensImoveis().recuperarLista()) {
            if (!string.equals(objetoNegocio.getCpf().asString())) continue;
            return true;
        }
        for (ObjetoNegocio objetoNegocio : this.getBensMoveis().recuperarLista()) {
            if (!string.equals(objetoNegocio.getCpf().asString())) continue;
            return true;
        }
        for (ObjetoNegocio objetoNegocio : this.getParticipacoesSocietarias().recuperarLista()) {
            if (!string.equals(objetoNegocio.getCpf().asString())) continue;
            return true;
        }
        return false;
    }

    public ItemDadosBemImovel getBemImovelPorCodItem(String string) {
        for (ItemDadosBemImovel itemDadosBemImovel : this.getBensImoveis().recuperarLista()) {
            if (!itemDadosBemImovel.getNumeroItem().asString().equals(string)) continue;
            return itemDadosBemImovel;
        }
        return null;
    }

    public ItemDadosBemMovel getBemMovelPorCodItem(String string) {
        for (ItemDadosBemMovel itemDadosBemMovel : this.getBensMoveis().recuperarLista()) {
            if (!itemDadosBemMovel.getNumeroItem().asString().equals(string)) continue;
            return itemDadosBemMovel;
        }
        return null;
    }

    public ItemDadosPSocietarias getPartSocPorCodItem(String string) {
        for (ItemDadosPSocietarias itemDadosPSocietarias : this.getParticipacoesSocietarias().recuperarLista()) {
            if (!itemDadosPSocietarias.getNumeroItem().asString().equals(string)) continue;
            return itemDadosPSocietarias;
        }
        return null;
    }

    public void clear() {
        this.getBensImoveis().recuperarLista().clear();
        this.getBensMoveis().recuperarLista().clear();
        this.getParticipacoesSocietarias().recuperarLista().clear();
        this.getDeclarantes().recuperarLista().clear();
        this.getTotalImpostoPagoSobreGanhosCapital().clear();
        this.getTotalImpostoRetidoFonteSobreGanhosCapital().clear();
    }

    public String getClasseFicha() {
        return PainelGCapBensImoveisLista.class.getName();
    }
}

