/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import serpro.ppgd.gui.BlinkLabel;
import serpro.ppgd.gui.ConstantesGlobaisGUI;
import serpro.ppgd.gui.FabricaGUI;
import serpro.ppgd.gui.PainelDicasModal;
import serpro.ppgd.gui.UtilitariosGUI;
import serpro.ppgd.gui.pendencia.MapeamentoInformacaoEditCampo;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.RetornosValidacoes;
import serpro.ppgd.negocio.ValidadorImpeditivoDefault;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;

public abstract class EditCampo
implements PropertyChangeListener {
    protected Informacao campo = null;
    protected JLabel labelCampo = null;
    protected JLabel simbolo = new JLabel("");
    private BlinkLabel bLabel;
    protected Dimension[] d;
    private boolean observadorAtivo = true;
    private JButton buttonMensagem;
    private boolean validar = true;
    private String idAjuda;
    private String identificacaoPainelAssociado = "";
    private MostrarDicas mostraDicas = null;
    private static boolean validandoImpeditivo;
    private ActionListener preActionOkSomente;
    private ActionListener preActionOk;
    private ActionListener preActionCancel;
    private static int CONST_CALC_TAMX_PAINELDICAS;
    private boolean focusLostAtivo = true;
    private Color corComponenteReadOnly = null;
    private Color corBackgroundComponenteReadOnly = null;
    private Color corComponenteNormal = null;
    private Color corBackgroundComponenteNormal = null;
    private boolean disableButtonMensagem = false;
    protected boolean isPerdeFocoComEnter = editCampoTransfereFocoEnter;
    private static boolean prevalidacaoAtiva;
    private static boolean escondeErroAoEditar;
    private static boolean validaNaoNuloAposEdicao;
    private static boolean validaAposAcoplarInformacao;
    private static boolean editCampoTransfereFocoEnter;
    private boolean readOnlyFocusAble = true;
    protected boolean selecionaTextoOnFocusGained = true;

    static {
        CONST_CALC_TAMX_PAINELDICAS = 7;
        prevalidacaoAtiva = false;
        escondeErroAoEditar = false;
        validaNaoNuloAposEdicao = true;
        validaAposAcoplarInformacao = false;
        editCampoTransfereFocoEnter = false;
        try {
            prevalidacaoAtiva = Boolean.valueOf(FabricaUtilitarios.getProperties().getProperty("aplicacao.gui.prevalidacaoAtiva", "false"));
            escondeErroAoEditar = Boolean.valueOf(FabricaUtilitarios.getProperties().getProperty("aplicacao.gui.escondeErroAoEditar", "false"));
            validaNaoNuloAposEdicao = Boolean.valueOf(FabricaUtilitarios.getProperties().getProperty("aplicacao.gui.validaNaoNuloAposEdicao", "true"));
            validaAposAcoplarInformacao = Boolean.valueOf(FabricaUtilitarios.getProperties().getProperty("aplicacao.gui.validaAposAcoplarInformacao", "false"));
            editCampoTransfereFocoEnter = Boolean.valueOf(FabricaUtilitarios.getProperties().getProperty("editCampo.transfereFocoEnter", "false"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public EditCampo() {
    }

    public EditCampo(Informacao campo, Dimension[] arDim) {
        this(campo, arDim, null);
    }

    public EditCampo(Informacao campo, Dimension[] arDim, String idAjuda) {
        this.init(campo, arDim, idAjuda);
    }

    public EditCampo(Informacao campo, Dimension d) {
        this(campo, d, null);
    }

    public EditCampo(Informacao campo, Dimension d, String idAjuda) {
        Dimension[] arDim = new Dimension[]{d};
        this.init(campo, arDim, idAjuda);
    }

    public EditCampo(Informacao campo, int tamanho) {
        this(campo, tamanho, null);
    }

    public EditCampo(Informacao campo, int tamanho, String idAjuda) {
        Dimension[] arDim = new Dimension[]{new Dimension(tamanho, 0)};
        this.init(campo, arDim, idAjuda);
    }

    public EditCampo(Informacao campo) {
        this(campo, 0, null);
    }

    public EditCampo(Informacao campo, String idAjuda) {
        this(campo, 0, idAjuda);
    }

    public boolean isSelecionaTextoOnFocusGained() {
        return this.selecionaTextoOnFocusGained;
    }

    public void setSelecionaTextoOnFocusGained(boolean selecionaTextoOnFocusGained) {
        this.selecionaTextoOnFocusGained = selecionaTextoOnFocusGained;
    }

    protected void desfazModificacao() {
        this.getInformacao().disparaObservadores();
        this.getComponenteFoco().grabFocus();
    }

    protected boolean continuaValidacaoImpeditiva(Object proxConteudo) {
        return proxConteudo == null || !proxConteudo.equals(this.getInformacao().getConteudoFormatado()) || this.getInformacao().isVazio();
    }

    protected boolean verificaValidacoesImpeditivas(Object proxConteudo) {
        if (!this.continuaValidacaoImpeditiva(proxConteudo)) {
            return true;
        }
        this.setObservadorAtivo(false);
        this.getInformacao().ordenaListaValidadoreImpeditivos();
        for (ValidadorImpeditivoDefault validador : this.getInformacao().getListaValidadoresImpeditivos()) {
            validador.setProximoConteudo(proxConteudo);
            RetornoValidacao retornoValidacao = validador.validarImplementado();
            if (retornoValidacao == null) continue;
            if (validador.getTipoExibicao() == 0) {
                Object[] options;
                String stringOkCustom = validador.getStringOkCustomizada();
                String stringCancelCustom = validador.getStringCancelarCustomizada();
                if (stringOkCustom == null) {
                    stringOkCustom = "Ok";
                }
                if (stringCancelCustom == null) {
                    stringCancelCustom = "Cancelar";
                }
                int tipoMensagem = validador.getTipoMensagem();
                if (validador.getSeveridade() == 5) {
                    options = new Object[]{stringOkCustom};
                    JOptionPane.showOptionDialog(UtilitariosGUI.tentaObterJanelaPrincipal(), retornoValidacao.getMensagemValidacaoExtendida(), validador.getTituloPopup(), 0, tipoMensagem != -1 ? tipoMensagem : 1, null, options, options[0]);
                    validador.acaoCancelar();
                    this.setObservadorAtivo(true);
                    if (validador.isDesfazModificacaoAoCancelar()) {
                        this.desfazModificacao();
                    }
                    return false;
                }
                options = new Object[]{stringOkCustom, stringCancelCustom};
                int opt = JOptionPane.showOptionDialog(UtilitariosGUI.tentaObterJanelaPrincipal(), retornoValidacao.getMensagemValidacaoExtendida(), validador.getTituloPopup(), 2, tipoMensagem != -1 ? tipoMensagem : 3, null, options, options[0]);
                if (opt == 0) {
                    validador.acaoOk();
                    this.setObservadorAtivo(true);
                    continue;
                }
                validador.acaoCancelar();
                this.setObservadorAtivo(true);
                if (validador.isDesfazModificacaoAoCancelar()) {
                    this.desfazModificacao();
                }
                return false;
            }
            if (validador.getTipoExibicao() != 1) continue;
            this.setValidandoImpeditivo(true);
            Window parent = SwingUtilities.getWindowAncestor(this.getButtonMensagem());
            if (validador.getSeveridade() == 5) {
                this.getButtonMensagem().setIcon(ConstantesGlobaisGUI.ICO_ERRO);
            } else {
                this.getButtonMensagem().setIcon(ConstantesGlobaisGUI.ICO_AVISO);
            }
            this.getButtonMensagem().setVisible(true);
            this.mostraDicas = new MostrarDicas(parent, validador.getSeveridade(), this.campo.getNomeCampoCurto(), retornoValidacao.getMensagemValidacaoExtendida());
            this.mostraDicas.disparaValidacaoImpeditiva();
            if (PainelDicasModal.getOpcaoSelecionada() == 1 && validador.getSeveridade() == 4) {
                validador.acaoOk();
                this.setObservadorAtivo(true);
                continue;
            }
            validador.acaoCancelar();
            this.setObservadorAtivo(true);
            if (validador.isDesfazModificacaoAoCancelar()) {
                this.desfazModificacao();
            }
            return false;
        }
        this.setObservadorAtivo(true);
        return true;
    }

    private void init(Informacao campo, Dimension[] arDim, String idAjuda) {
        this.setIdAjuda(idAjuda);
        this.d = arDim;
        int i = 0;
        while (i < this.d.length) {
            if (this.d[i].width < 2) {
                this.d[i].width = 1;
            }
            if (this.d[i].height < 2) {
                this.d[i].height = 1;
            }
            ++i;
        }
        if (campo != null) {
            this.setAssociaInformacao(campo);
            this.getComponenteEditor().setPreferredSize(new Dimension(this.d[0].width * 10, 20));
            if (escondeErroAoEditar) {
                this.getComponenteEditor().addFocusListener(new FocusAdapter(){

                    public void focusGained(FocusEvent e) {
                        if (EditCampo.this.getButtonMensagem().isVisible()) {
                            EditCampo.this.getButtonMensagem().setVisible(false);
                            FabricaGUI.esconderPainelDicas();
                        }
                    }
                });
            }
            if (prevalidacaoAtiva) {
                this.getComponenteEditor().addHierarchyListener(new HierarchyListener(){

                    public void hierarchyChanged(HierarchyEvent e) {
                        if (EditCampo.this.getInformacao().asString() != null && !EditCampo.this.getInformacao().asString().trim().equals("")) {
                            EditCampo.this.chamaValidacao();
                        }
                    }
                });
            }
            LogPPGD.debug((String)this.getComponenteEditor().getPreferredSize().toString());
            LogPPGD.debug((String)this.getComponenteEditor().getMaximumSize().toString());
        }
        this.setPreActionOkSomente(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Informacao info = EditCampo.this.getInformacao();
                info.setConteudo(info.getUltimoConteudoValido());
                EditCampo.this.getComponenteEditor().grabFocus();
            }
        });
        this.setPreActionOk(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Informacao info = EditCampo.this.getInformacao();
                info.setUltimoConteudoValido(info.asString());
            }
        });
        this.setPreActionCancel(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Informacao info = EditCampo.this.getInformacao();
                String conteudoAtual = info.asString();
                info.setConteudo(info.getUltimoConteudoValido());
                EditCampo.this.getComponenteEditor().grabFocus();
            }
        });
    }

    public void setDim(Dimension[] d) {
        this.d = d;
        this.getComponenteEditor().setPreferredSize(new Dimension(d[0].width * 10, 20));
        LogPPGD.debug((String)this.getComponenteEditor().getPreferredSize().toString());
        LogPPGD.debug((String)this.getComponenteEditor().getMaximumSize().toString());
    }

    public final void setAssociaInformacao(Informacao novoCampo) {
        if (this.labelCampo == null) {
            this.labelCampo = new JLabel(novoCampo.getNomeCampo());
        } else {
            this.labelCampo.setText(novoCampo.getNomeCampo());
        }
        if (this.buttonMensagem == null) {
            this.buttonMensagem = new JButton();
        }
        this.buttonMensagem.setVisible(false);
        this.buttonMensagem.setContentAreaFilled(false);
        this.buttonMensagem.setFocusable(false);
        this.buttonMensagem.setSize(20, 20);
        this.buttonMensagem.setMaximumSize(this.buttonMensagem.getSize());
        this.buttonMensagem.setBorder(null);
        if (this.campo != null) {
            this.campo.getObservadores().removePropertyChangeListener(this);
        }
        this.campo = novoCampo;
        if (novoCampo != null) {
            novoCampo.getObservadores().addPropertyChangeListener(this);
        }
        this.setInformacao(novoCampo);
        this.setPerdeFocoComEnter(this.isPerdeFocoComEnter);
        MapeamentoInformacaoEditCampo.associaInformacao((Object)this, (Informacao)novoCampo);
        this.readOnlyPropertyChange(novoCampo.isReadOnly());
        if (!novoCampo.isHabilitado()) {
            this.habilitadoPropertyChange(novoCampo.isHabilitado());
        }
        if (validaAposAcoplarInformacao) {
            this.campo.validar();
        }
        if (!this.campo.isValido()) {
            this.chamaValidacao();
        }
    }

    public abstract void setInformacao(Informacao var1);

    public Informacao getInformacao() {
        return this.campo;
    }

    public JLabel getRotulo() {
        return this.labelCampo;
    }

    public void setRotulo(JLabel jlabel) {
        jlabel.setEnabled(this.labelCampo.isEnabled());
        this.labelCampo = jlabel;
    }

    public JButton getButtonMensagem() {
        return this.buttonMensagem;
    }

    public String getIdAjuda() {
        return this.idAjuda;
    }

    public void setIdAjuda(String string) {
        this.idAjuda = string;
    }

    public boolean isValidar() {
        return this.validar;
    }

    public boolean isValidarHabilitado() {
        return this.validar;
    }

    public void setValidar(boolean b) {
        this.validar = b;
    }

    public void setValidarHabilitado(boolean b) {
        this.validar = b;
    }

    public synchronized boolean chamaValidacao() {
        if (this.isValidandoImpeditivo()) {
            return false;
        }
        if (!this.validar && !this.getInformacao().isValidadoresAtivos()) {
            this.getButtonMensagem().setVisible(false);
            return true;
        }
        if (!validaNaoNuloAposEdicao && this.getInformacao().isVazio()) {
            this.getButtonMensagem().setVisible(false);
            return true;
        }
        Informacao campo = this.getInformacao();
        RetornosValidacoes retornosValidacoes = campo.validar();
        RetornoValidacao ret = retornosValidacoes.getPrimeiroRetornoValidacaoMaisSevero();
        if (ret.getSeveridade() > 0) {
            String mensagem = ret.getMensagemValidacaoExtendida();
            if (this.mostraDicas != null) {
                this.getButtonMensagem().removeActionListener(this.mostraDicas);
            }
            if (ret.getSeveridade() == 1) {
                this.getButtonMensagem().setIcon(ConstantesGlobaisGUI.ICO_ATENCAO);
                this.mostraDicas = new MostrarDicas(ret.getSeveridade(), campo.getNomeCampoCurto(), mensagem);
                this.getButtonMensagem().addActionListener(this.mostraDicas);
            } else if (ret.getSeveridade() == 3) {
                this.getButtonMensagem().setIcon(ConstantesGlobaisGUI.ICO_ERRO);
                this.mostraDicas = new MostrarDicas(ret.getSeveridade(), campo.getNomeCampoCurto(), mensagem);
                this.getButtonMensagem().addActionListener(this.mostraDicas);
            } else if (ret.getSeveridade() == 5) {
                this.setValidandoImpeditivo(true);
                Window parent = SwingUtilities.getWindowAncestor(this.getButtonMensagem());
                this.getButtonMensagem().setIcon(ConstantesGlobaisGUI.ICO_ERRO);
                this.mostraDicas = new MostrarDicas(parent, ret.getSeveridade(), campo.getNomeCampoCurto(), mensagem);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        EditCampo.this.mostraDicas.dispara();
                    }
                });
            } else if (ret.getSeveridade() == 4) {
                this.setValidandoImpeditivo(true);
                Window parent = SwingUtilities.getWindowAncestor(this.getButtonMensagem());
                this.getButtonMensagem().setIcon(ConstantesGlobaisGUI.ICO_ATENCAO);
                this.mostraDicas = new MostrarDicas(parent, ret.getSeveridade(), campo.getNomeCampoCurto(), mensagem);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        EditCampo.this.mostraDicas.dispara();
                    }
                });
            } else {
                this.getButtonMensagem().setIcon(ConstantesGlobaisGUI.ICO_AVISO);
                this.mostraDicas = new MostrarDicas(ret.getSeveridade(), campo.getNomeCampoCurto(), mensagem);
                this.getButtonMensagem().addActionListener(this.mostraDicas);
                this.getButtonMensagem().setVisible(!this.isDisableButtonMensagem());
            }
            this.getButtonMensagem().setVisible(!this.isDisableButtonMensagem());
            return false;
        }
        this.getButtonMensagem().setVisible(false);
        FabricaGUI.esconderPainelDicas();
        return true;
    }

    public final void propertyChange(PropertyChangeEvent evt) {
        if (this.isObservadorAtivo()) {
            LogPPGD.debug((String)("Disparando observador EditCampo de " + this.getInformacao().getNomeCampo() + "."));
            if (evt.getPropertyName() != null) {
                if (evt.getPropertyName().equals("ReadOnly")) {
                    if (!this.isReadOnlyFocusAble()) {
                        if (this.getInformacao().isReadOnly()) {
                            this.getComponenteFoco().setFocusable(false);
                        } else {
                            this.getComponenteFoco().setFocusable(true);
                        }
                    } else {
                        this.getComponenteFoco().setFocusable(true);
                    }
                    if (this.getInformacao().isReadOnly()) {
                        this.setDisableButtonMensagem(true);
                        this.getComponenteFoco().setForeground(this.getCorComponenteReadOnly());
                        this.getComponenteFoco().setBackground(this.getCorBackgroundComponenteReadOnly());
                    } else {
                        this.setDisableButtonMensagem(false);
                        this.getComponenteFoco().setForeground(this.getCorComponenteNormal());
                        this.getComponenteFoco().setBackground(this.getCorBackgroundComponenteNormal());
                    }
                    if (this.getInformacao().isTransportado()) {
                        this.getSimbolo().setText(">>");
                    } else {
                        this.getSimbolo().setText("=");
                    }
                    this.getSimbolo().setVisible(this.getInformacao().isReadOnly());
                    this.readOnlyPropertyChange(this.getInformacao().isReadOnly());
                } else if (evt.getPropertyName().equals("habilitado")) {
                    if (this.getInformacao().isHabilitado()) {
                        this.setDisableButtonMensagem(false);
                    } else {
                        this.setDisableButtonMensagem(true);
                    }
                    this.habilitadoPropertyChange(this.getInformacao().isHabilitado());
                } else if (evt.getPropertyName().equals("Label_Modificado")) {
                    this.getRotulo().setText(this.getInformacao().getNomeCampo());
                }
            }
            this.implementacaoPropertyChange(evt);
            this.chamaValidacao();
        }
    }

    protected abstract void readOnlyPropertyChange(boolean var1);

    protected abstract void habilitadoPropertyChange(boolean var1);

    public boolean isObservadorAtivo() {
        return this.observadorAtivo;
    }

    public void setObservadorAtivo(boolean b) {
        this.observadorAtivo = b;
    }

    public abstract void implementacaoPropertyChange(PropertyChangeEvent var1);

    public abstract JComponent getComponenteEditor();

    public abstract JComponent getComponenteFoco();

    public void setIdentificacaoFoco(boolean status) {
        if (status) {
            this.bLabel = new BlinkLabel(this.labelCampo);
            this.bLabel.start();
        } else if (this.bLabel != null) {
            this.bLabel.parar();
            this.bLabel = null;
        }
    }

    public void setaFoco(boolean status) {
        SwingUtilities.invokeLater(new Run(status));
    }

    public void setaVisivel(boolean pOpt) {
        this.getComponenteEditor().setVisible(pOpt);
        this.getRotulo().setVisible(pOpt);
    }

    public String getIdentificacaoPainelAssociado() {
        return this.identificacaoPainelAssociado;
    }

    public void setIdentificacaoPainelAssociado(String aIdentificacao) {
        this.identificacaoPainelAssociado = aIdentificacao;
    }

    public JLabel getSimbolo() {
        return this.simbolo;
    }

    public void setSimbolo(JLabel simbolo) {
        this.simbolo = simbolo;
    }

    public void setPreActionOkSomente(ActionListener preActionOkSomente) {
        this.preActionOkSomente = preActionOkSomente;
    }

    public ActionListener getPreActionOkSomente() {
        return this.preActionOkSomente;
    }

    public void setPreActionOk(ActionListener preActionOk) {
        this.preActionOk = preActionOk;
    }

    public ActionListener getPreActionOk() {
        return this.preActionOk;
    }

    public void setPreActionCancel(ActionListener preActionCancel) {
        this.preActionCancel = preActionCancel;
    }

    public ActionListener getPreActionCancel() {
        return this.preActionCancel;
    }

    protected synchronized void setValidandoImpeditivo(boolean pValidandoImpeditivo) {
        validandoImpeditivo = pValidandoImpeditivo;
    }

    protected boolean isValidandoImpeditivo() {
        return validandoImpeditivo;
    }

    public Dimension[] getD() {
        return this.d;
    }

    public void setTamanho(int tamanho) {
        this.d[0].width = tamanho;
        this.getComponenteEditor().setPreferredSize(new Dimension(this.d[0].width * 10, 20));
        LogPPGD.debug((String)this.getComponenteEditor().getPreferredSize().toString());
        LogPPGD.debug((String)this.getComponenteEditor().getMaximumSize().toString());
    }

    public void disparaPainelDicasModal() {
        this.getButtonMensagem().setVisible(true);
        RetornosValidacoes validacoes = this.getInformacao().validar();
        RetornoValidacao ret = validacoes.getPrimeiroRetornoValidacaoMaisSevero();
        Window parent = SwingUtilities.getWindowAncestor(this.getButtonMensagem());
        this.getButtonMensagem().setIcon(ConstantesGlobaisGUI.ICO_ERRO);
        this.mostraDicas = new MostrarDicas(parent, ret.getSeveridade(), this.campo.getNomeCampoCurto(), ret.getMensagemValidacaoExtendida());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EditCampo.this.mostraDicas.dispara();
            }
        });
    }

    public void disparaOptionPaneValidacaoImpeditiva(String tit, int tipo) {
        RetornosValidacoes validacoes = this.getInformacao().validar();
        RetornoValidacao ret = validacoes.getPrimeiroRetornoValidacaoMaisSevero();
        JOptionPane.showMessageDialog(UtilitariosGUI.tentaObterJanelaPrincipal(), ret.getMensagemValidacaoExtendida(), tit, tipo);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EditCampo.this.getComponenteFoco().grabFocus();
            }
        });
    }

    public boolean isFocusLostAtivo() {
        return this.focusLostAtivo;
    }

    public void setFocusLostAtivo(boolean focusListenersAtivos) {
        this.focusLostAtivo = focusListenersAtivos;
    }

    public Color getCorComponenteReadOnly() {
        if (this.corComponenteReadOnly == null) {
            this.corComponenteReadOnly = this.getComponenteFoco().getForeground();
        }
        return this.corComponenteReadOnly;
    }

    public void setCorComponenteReadOnly(Color corComponenteReadOnly) {
        this.corComponenteReadOnly = corComponenteReadOnly;
    }

    public Color getCorComponenteNormal() {
        if (this.corComponenteNormal == null) {
            this.corComponenteNormal = this.getComponenteFoco().getForeground();
        }
        return this.corComponenteNormal;
    }

    public void setCorComponenteNormal(Color corComponenteNormal) {
        this.corComponenteNormal = corComponenteNormal;
    }

    public Color getCorBackgroundComponenteNormal() {
        if (this.corBackgroundComponenteNormal == null) {
            this.corBackgroundComponenteNormal = this.getComponenteFoco().getBackground();
        }
        return this.corBackgroundComponenteNormal;
    }

    public void setCorBackgroundComponenteNormal(Color corBackgroundComponenteNormal) {
        this.corBackgroundComponenteNormal = corBackgroundComponenteNormal;
    }

    public Color getCorBackgroundComponenteReadOnly() {
        if (this.corBackgroundComponenteReadOnly == null) {
            this.corBackgroundComponenteReadOnly = this.getComponenteFoco().getBackground();
        }
        return this.corBackgroundComponenteReadOnly;
    }

    public void setCorBackgroundComponenteReadOnly(Color corBackgroundComponenteReadOnly) {
        this.corBackgroundComponenteReadOnly = corBackgroundComponenteReadOnly;
    }

    public boolean isReadOnlyFocusAble() {
        return this.readOnlyFocusAble;
    }

    public void setReadOnlyFocusAble(boolean isReadOnlyFocusAble) {
        this.readOnlyFocusAble = isReadOnlyFocusAble;
    }

    public boolean isDisableButtonMensagem() {
        return this.disableButtonMensagem;
    }

    public void setDisableButtonMensagem(boolean disableButtonMensagem) {
        this.disableButtonMensagem = disableButtonMensagem;
    }

    public abstract void setPerdeFocoComEnter(boolean var1);

    public boolean isPerdeFocoComEnter() {
        return this.isPerdeFocoComEnter;
    }

    protected void aplicaTransfereFocoEnter() {
        this.getComponenteFoco().getInputMap().put(KeyStroke.getKeyStroke(10, 0, true), "Focus.nextComponent");
        this.getComponenteFoco().getActionMap().put("Focus.nextComponent", FabricaGUI.criaActionTransfereFoco());
    }

    protected void removeTransfereFocoEnter() {
        this.getComponenteFoco().getInputMap().put(KeyStroke.getKeyStroke(10, 0, true), "Focus.nextComponent");
        this.getComponenteFoco().getActionMap().put("Focus.nextComponent", null);
    }

    class Run
    implements Runnable {
        private boolean foco;

        public Run(boolean mudarIdentificacaoFoco) {
            this.foco = mudarIdentificacaoFoco;
        }

        public void run() {
            EditCampo.this.setIdentificacaoFoco(this.foco);
            EditCampo.this.getComponenteFoco().requestFocusInWindow();
        }
    }

    class MostrarDicas
    implements ActionListener {
        private String msg;
        private String titulo;
        private int tipo;
        private Window parent = null;

        public MostrarDicas(int tipo, String titulo, String msg) {
            this.msg = msg;
            this.titulo = titulo;
            this.tipo = tipo;
        }

        public MostrarDicas(Window parent, byte severidade, String nomeCampoCurto, String mensagem) {
            this(severidade, nomeCampoCurto, mensagem);
            this.parent = parent;
        }

        public void disparaValidacaoImpeditiva() {
            int tamMax = EditCampo.this.getInformacao().getNomeCampoCurto().length() * CONST_CALC_TAMX_PAINELDICAS;
            int n = tamMax = tamMax > 90 ? tamMax : 90;
            if (this.tipo == 5) {
                FabricaGUI.exibirPainelDicasModal(this.parent, this.tipo, this.titulo, this.msg, EditCampo.this.getComponenteEditor(), tamMax);
                EditCampo.this.setValidandoImpeditivo(false);
                EditCampo.this.getButtonMensagem().setVisible(false);
            } else if (this.tipo == 4) {
                FabricaGUI.exibirPainelDicasModal(this.parent, this.tipo, this.titulo, this.msg, EditCampo.this.getComponenteEditor(), tamMax);
                EditCampo.this.setValidandoImpeditivo(false);
                EditCampo.this.getButtonMensagem().setVisible(false);
            }
        }

        public void dispara() {
            int tamMax = EditCampo.this.getInformacao().getNomeCampoCurto().length() * CONST_CALC_TAMX_PAINELDICAS;
            int n = tamMax = tamMax > 90 ? tamMax : 90;
            if (this.tipo == 5) {
                FabricaGUI.exibirPainelDicasModal(this.parent, this.tipo, this.titulo, this.msg, EditCampo.this.getComponenteEditor(), tamMax, EditCampo.this.getPreActionOkSomente());
                EditCampo.this.setValidandoImpeditivo(false);
                EditCampo.this.getButtonMensagem().setVisible(false);
            } else if (this.tipo == 4) {
                FabricaGUI.exibirPainelDicasModal(this.parent, this.tipo, this.titulo, this.msg, EditCampo.this.getComponenteEditor(), tamMax, EditCampo.this.getPreActionOk(), EditCampo.this.getPreActionCancel());
                EditCampo.this.setValidandoImpeditivo(false);
                EditCampo.this.getButtonMensagem().setVisible(false);
            } else if (SwingUtilities.getRoot(EditCampo.this.getButtonMensagem()) instanceof JDialog) {
                FabricaGUI.exibirPainelDicas((Window)SwingUtilities.getRoot(EditCampo.this.getButtonMensagem()), this.tipo, this.titulo, this.msg, EditCampo.this.getButtonMensagem(), tamMax);
            } else {
                FabricaGUI.exibirPainelDicas(this.tipo, this.titulo, this.msg, EditCampo.this.getButtonMensagem(), tamMax);
            }
        }

        public void actionPerformed(ActionEvent e) {
            this.dispara();
        }
    }
}

