/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import serpro.ppgd.gui.CustomComboBox;
import serpro.ppgd.gui.EditCampo;
import serpro.ppgd.gui.KeySelectionCustomizado;
import serpro.ppgd.gui.MyCustomRenderer;
import serpro.ppgd.gui.editors.PPGDComboBox;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Informacao;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditCodigo
extends EditCampo
implements ActionListener {
    private static Codigo vazio = new Codigo("C\u00f3digo");
    JComboBox combo;
    Dimension[] tamCols;
    boolean[] colsVisiveisExpandidas;
    boolean[] colsVisiveis;
    private Border bordaColunas = BorderFactory.createMatteBorder(0, 0, 1, 1, Color.GRAY);
    private Border bordaVazia = BorderFactory.createEmptyBorder();
    private KeySelectionCustomizado keySelectionCustomizado;

    public EditCodigo() {
        super((Informacao)vazio);
        this.aplicaItens(((Codigo)this.campo).getColecaoElementoTabela());
        this.inicio();
    }

    public EditCodigo(Informacao aCampo) {
        super(aCampo);
        this.inicio();
    }

    public EditCodigo(Informacao aCampo, Dimension[] d, String idAjuda) {
        super(aCampo, d, idAjuda);
        this.inicio();
    }

    @Override
    protected boolean continuaValidacaoImpeditiva(Object proxConteudo) {
        return proxConteudo == null || !proxConteudo.equals(((Codigo)this.getInformacao()).getElementoTabela());
    }

    @Override
    protected void desfazModificacao() {
        int indice = ((Codigo)this.getInformacao()).getIndiceElementoTabela();
        this.combo.setSelectedIndex(indice);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EditCodigo.this.combo.grabFocus();
            }
        });
    }

    private void inicio() {
        this.setInformacao(this.getInformacao());
        this.combo.setKeySelectionManager(this.keySelectionCustomizado);
        this.combo.addActionListener(this);
        this.combo.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (e.getOppositeComponent() == null || !EditCodigo.this.isFocusLostAtivo()) {
                    return;
                }
                EditCodigo.this.setIdentificacaoFoco(false);
                if (!EditCodigo.this.getInformacao().getListaValidadoresImpeditivos().isEmpty()) {
                    ElementoTabela elemento = ((Codigo)EditCodigo.this.getInformacao()).getElementoTabela(EditCodigo.this.combo.getSelectedIndex());
                    if (!EditCodigo.this.verificaValidacoesImpeditivas(elemento)) {
                        return;
                    }
                    EditCodigo.this.setaCampo();
                }
                EditCodigo.this.chamaValidacao();
            }
        });
        this.getInformacao().getObservadores().addPropertyChangeListener("ComboReiniciado", this);
    }

    private void initColsVisiveis() {
        this.colsVisiveis = new boolean[30];
        this.colsVisiveisExpandidas = new boolean[30];
        int i = 0;
        while (i < this.colsVisiveis.length) {
            this.colsVisiveisExpandidas[i] = false;
            this.colsVisiveis[i] = false;
            ++i;
        }
        this.exibeColunaNaoExpandida(1);
        this.exibeColunaExpandida(1);
    }

    public void exibeColunaNaoExpandida(int aCol) {
        this.colsVisiveis[aCol] = true;
    }

    public void escondeColunaNaoExpandida(int aCol) {
        this.colsVisiveis[aCol] = false;
    }

    public void exibeColunaExpandida(int aCol) {
        this.colsVisiveisExpandidas[aCol] = true;
    }

    public void escondeColunaExpandida(int aCol) {
        this.colsVisiveisExpandidas[aCol] = false;
    }

    private void aplicaItens(List<ElementoTabela> elems) {
        if (this.combo == null) {
            this.combo = new CustomComboBox(this);
        }
        if (this.colsVisiveis == null || this.colsVisiveisExpandidas == null) {
            this.initColsVisiveis();
        }
        this.combo.setRenderer(new MyCustomRenderer(this));
        if (elems != null) {
            this.calculaTamanhoMaxCols();
            this.combo.setModel(new DefaultComboBoxModel<Object>(elems.toArray()));
            this.combo.setSelectedItem(((Codigo)this.campo).getElementoTabela());
        }
    }

    @Override
    public void setInformacao(Informacao campo) {
        if (campo != null) {
            this.campo = campo;
            this.aplicaItens(((Codigo)campo).getColecaoElementoTabela());
            ((PPGDComboBox)this.combo).setInformacao(campo);
            if (this.keySelectionCustomizado == null) {
                this.keySelectionCustomizado = new KeySelectionCustomizado(((Codigo)campo).getColunaFiltro());
            } else {
                this.keySelectionCustomizado.setColunaFiltro(((Codigo)campo).getColunaFiltro());
            }
        }
    }

    @Override
    public void implementacaoPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() != null && evt.getPropertyName().equals("ComboReiniciado")) {
            this.setInformacao(this.getInformacao());
        }
        if (evt.getPropertyName() != null && evt.getPropertyName().equals(this.getInformacao().getNomeCampo())) {
            this.combo.setSelectedIndex(((Codigo)this.getInformacao()).getIndiceElementoTabela());
        }
    }

    @Override
    public JComponent getComponenteEditor() {
        return this.combo;
    }

    @Override
    public JComponent getComponenteFoco() {
        return this.combo;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.getInformacao().getListaValidadoresImpeditivos().isEmpty()) {
            return;
        }
        this.setaCampo();
    }

    public void setaCampo() {
        ElementoTabela elem = (ElementoTabela)this.combo.getSelectedItem();
        if (elem != null) {
            this.campo.setConteudo(elem.getConteudo(0));
        }
    }

    private void calculaTamanhoMaxCols() {
        Dimension tam;
        int i;
        ElementoTabela elem;
        Iterator it = ((Codigo)this.campo).getColecaoElementoTabela().iterator();
        if (it.hasNext()) {
            elem = (ElementoTabela)it.next();
            this.tamCols = new Dimension[elem.size()];
            i = 0;
            while (i < this.tamCols.length) {
                tam = new JLabel(elem.getConteudo(i)).getPreferredSize();
                if (this.tamCols[i] == null || this.tamCols[i].width < tam.width) {
                    this.tamCols[i] = tam;
                    this.tamCols[i].width += 5;
                }
                ++i;
            }
        }
        while (it.hasNext()) {
            elem = (ElementoTabela)it.next();
            i = 0;
            while (i < this.tamCols.length) {
                tam = new JLabel(elem.getConteudo(i)).getPreferredSize();
                if (this.tamCols[i] == null || this.tamCols[i].width < tam.width) {
                    this.tamCols[i] = tam;
                    this.tamCols[i].width += 5;
                }
                ++i;
            }
        }
    }

    @Override
    protected void readOnlyPropertyChange(boolean readOnly) {
        this.combo.setEnabled(!readOnly);
    }

    @Override
    protected void habilitadoPropertyChange(boolean habilitado) {
        this.combo.setEnabled(habilitado);
        this.labelCampo.setEnabled(habilitado);
    }

    public void setMaximoCaracteresNaColuna(int col, int qtd) {
        String s = "";
        int i = 0;
        while (i < qtd) {
            s = String.valueOf(s) + " ";
            ++i;
        }
        this.tamCols[col] = new JLabel(s).getPreferredSize();
    }

    public Border getBordaColunas() {
        Border borda = null;
        int qtdColsVisiveis = 0;
        int i = 0;
        while (i < this.colsVisiveis.length) {
            if (this.colsVisiveis[i]) {
                ++qtdColsVisiveis;
            }
            ++i;
        }
        borda = qtdColsVisiveis > 1 ? this.bordaColunas : this.bordaVazia;
        return borda;
    }

    public void setBordaColunas(Border bordaColunas) {
        this.bordaColunas = bordaColunas;
    }

    @Override
    public void setPerdeFocoComEnter(boolean aPerdeFocoComEnter) {
        this.isPerdeFocoComEnter = aPerdeFocoComEnter;
        if (this.isPerdeFocoComEnter()) {
            this.aplicaTransfereFocoEnter();
        } else {
            this.removeTransfereFocoEnter();
        }
    }
}

