/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import serpro.ppgd.gui.EditCampo;
import serpro.ppgd.gui.editors.PPGDSpinner;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Inteiro;

public class EditInteiro
extends EditCampo {
    private static Inteiro vazio = new Inteiro("EditInteiro");
    private JSpinner componente;
    private SpinnerNumberModel model;
    int valorInicial;
    int valorMinimo;
    int valorMaximo;
    int valorStep;

    public EditInteiro() {
        super((Informacao)vazio);
    }

    public EditInteiro(Informacao campo) {
        super(campo);
    }

    public void setInformacao(Informacao campo) {
        if (this.componente == null) {
            this.model = new SpinnerNumberModel(0, 0, 10000, 1);
            this.componente = new PPGDSpinner(this.model);
            this.model.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent event) {
                    EditInteiro.this.setIdentificacaoFoco(false);
                    Integer value = (Integer)EditInteiro.this.componente.getValue();
                    EditInteiro.this.getInformacao().setConteudo(value.toString());
                }
            });
            ((JSpinner.DefaultEditor)this.componente.getEditor()).getTextField().addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    EditInteiro.this.setIdentificacaoFoco(false);
                    String val = ((JSpinner.DefaultEditor)EditInteiro.this.componente.getEditor()).getTextField().getText();
                    EditInteiro.this.getInformacao().setConteudo(val);
                }
            });
        }
        Inteiro inteiro = (Inteiro)this.getInformacao();
        int valor = inteiro.asInteger();
        this.componente.setValue(valor);
        ((PPGDSpinner)this.componente).setInformacao(campo);
    }

    public void implementacaoPropertyChange(PropertyChangeEvent evt) {
        this.getInformacao().setObservadoresAtivos(false);
        this.setObservadorAtivo(false);
        this.componente.setValue(((Inteiro)this.getInformacao()).asInteger());
        this.getInformacao().setObservadoresAtivos(true);
        this.setObservadorAtivo(true);
    }

    protected void readOnlyPropertyChange(boolean readOnly) {
        if (readOnly) {
            this.componente.setEnabled(false);
        } else {
            this.componente.setEnabled(true);
        }
    }

    protected void habilitadoPropertyChange(boolean habilitado) {
        this.componente.setEnabled(habilitado);
        this.labelCampo.setEnabled(habilitado);
    }

    public JComponent getComponenteEditor() {
        return this.componente;
    }

    public void configurarLimites(int valorMinimo, int valorMaximo, int valorStep) {
        this.model.setMaximum(Integer.valueOf(valorMaximo));
        this.model.setMinimum(Integer.valueOf(valorMinimo));
        this.model.setStepSize(valorStep);
    }

    public JComponent getComponenteFoco() {
        return this.componente;
    }

    public void setPerdeFocoComEnter(boolean aPerdeFocoComEnter) {
        this.isPerdeFocoComEnter = aPerdeFocoComEnter;
        if (this.isPerdeFocoComEnter()) {
            this.aplicaTransfereFocoEnter();
        } else {
            this.removeTransfereFocoEnter();
        }
    }
}

