/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import serpro.ppgd.gui.BlinkBorder;
import serpro.ppgd.gui.ConstantesGlobaisGUI;
import serpro.ppgd.gui.EditCampo;
import serpro.ppgd.gui.editors.PPGDRadioButton;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.OpcaoLogico;
import serpro.ppgd.negocio.ValidadorImpeditivoDefault;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditLogico
extends EditCampo {
    private static Logico vazio = new Logico();
    private Box box;
    private ButtonGroup group;
    private int orientacaoTexto = 0;
    private static final Color DEFAULT_FOREGROUND = new JRadioButton().getForeground();
    private static final Color DISABLED_FOREGROUND = ConstantesGlobaisGUI.COR_CINZA_CLARO;
    private boolean bloqueiaItemListener = false;
    private Map<String, JRadioButton> radios;
    private LinkedList<JRadioButton> listaOrdenada = new LinkedList();
    private BlinkBorder borda;

    public EditLogico() {
        super((Informacao)vazio);
    }

    public EditLogico(Informacao campo, int tamanho) {
        super(campo, tamanho);
    }

    public EditLogico(Informacao campo, int tamanho, int orientacao) {
        super(campo, tamanho);
        this.setOrientacaoTexto(orientacao);
    }

    public void setFont(Font pFont) {
        for (JRadioButton radio : this.radios.values()) {
            radio.setFont(pFont);
        }
    }

    public void setForeground(Color pCor) {
        for (JRadioButton radio : this.radios.values()) {
            radio.setForeground(pCor);
        }
    }

    public void setFont(String pValOpcao, Color pCor) {
        String lblOpcao = ((Logico)this.getInformacao()).getLabelOpcao(pValOpcao);
        if (this.radios.containsKey(lblOpcao)) {
            JRadioButton radio = this.radios.get(lblOpcao);
            radio.setForeground(pCor);
        }
    }

    public void setFont(String pValOpcao, Font pFont) {
        String lblOpcao = ((Logico)this.getInformacao()).getLabelOpcao(pValOpcao);
        if (this.radios.containsKey(lblOpcao)) {
            JRadioButton radio = this.radios.get(lblOpcao);
            radio.setFont(pFont);
        }
    }

    public void addListener(String pValOpcao, EventListener listener) {
        String lblOpcao = ((Logico)this.getInformacao()).getLabelOpcao(pValOpcao);
        if (this.radios.containsKey(lblOpcao)) {
            JRadioButton radio = this.radios.get(lblOpcao);
            this.adicionaListener(radio, listener);
        }
    }

    private void adicionaListener(JRadioButton radio, EventListener listener) {
        if (listener instanceof ActionListener) {
            radio.addActionListener((ActionListener)listener);
        } else if (listener instanceof ItemListener) {
            radio.addItemListener((ItemListener)listener);
        } else if (listener instanceof KeyListener) {
            radio.addKeyListener((KeyListener)listener);
        } else if (listener instanceof FocusListener) {
            radio.addFocusListener((FocusListener)listener);
        } else if (listener instanceof MouseListener) {
            radio.addMouseListener((MouseListener)listener);
        } else if (listener instanceof MouseMotionListener) {
            radio.addMouseMotionListener((MouseMotionListener)listener);
        }
    }

    public void addListener(EventListener listener) {
        for (JRadioButton radio : this.radios.values()) {
            this.adicionaListener(radio, listener);
        }
    }

    public void addValidador(ValidadorImpeditivoDefault validador, String valOpcao) {
    }

    public int getOrientacaoTexto() {
        return this.orientacaoTexto;
    }

    public void setOrientacaoTexto(int orientacaoTexto) {
        this.orientacaoTexto = orientacaoTexto;
        this.box = new Box(orientacaoTexto);
        this.setInformacao(this.getInformacao());
    }

    public void setOpcaoHabilitada(String pValOpcao, boolean pOpt) {
        String lblOpcao = ((Logico)this.getInformacao()).getLabelOpcao(pValOpcao);
        if (this.radios.containsKey(lblOpcao)) {
            JRadioButton radio = this.radios.get(lblOpcao);
            radio.setEnabled(pOpt);
            if (!pOpt) {
                radio.setForeground(DISABLED_FOREGROUND);
            } else {
                radio.setForeground(DEFAULT_FOREGROUND);
            }
        }
    }

    @Override
    public void setInformacao(Informacao campo) {
        this.rebuildComponente(campo);
        this.setObservadorAtivo(false);
        PropertyChangeEvent evt = new PropertyChangeEvent(this, null, null, this.getInformacao().asString());
        this.implementacaoPropertyChange(evt);
        this.setObservadorAtivo(true);
    }

    private void rebuildComponente(Informacao campo) {
        this.radios = new Hashtable<String, JRadioButton>();
        this.listaOrdenada = new LinkedList();
        if (this.box == null) {
            this.box = new Box(this.getOrientacaoTexto());
        } else {
            this.box.removeAll();
        }
        Logico logico = (Logico)campo;
        this.group = new ButtonGroup();
        for (OpcaoLogico opt : logico.getListaOrdenada()) {
            PPGDRadioButton rb = new PPGDRadioButton(opt.labelOpcao, opt.selecionado);
            rb.setInformacao(campo);
            rb.setVisible(true);
            this.radios.put(rb.getText(), rb);
            this.listaOrdenada.addLast(rb);
            rb.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    if (e.getOppositeComponent() == null) {
                        return;
                    }
                    EditLogico.this.setIdentificacaoFoco(false);
                    EditLogico.this.chamaValidacao();
                }
            });
            rb.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1 && !EditLogico.this.isBloqueiaItemListener()) {
                        JRadioButton r = (JRadioButton)e.getSource();
                        String labelOpcao = r.getText().trim();
                        String valorOpcao = ((Logico)EditLogico.this.getInformacao()).getValorOpcao(labelOpcao);
                        ((Logico)EditLogico.this.getInformacao()).atualizaListaValidadoresImpeditivos(valorOpcao);
                        if (!EditLogico.this.getInformacao().getListaValidadoresImpeditivos().isEmpty() && !EditLogico.this.verificaValidacoesImpeditivas(valorOpcao)) {
                            return;
                        }
                        ((Logico)EditLogico.this.getInformacao()).setConteudo(valorOpcao);
                        EditLogico.this.chamaValidacao();
                    }
                }
            });
            if (this.getOrientacaoTexto() == 0) {
                this.box.add(new JLabel(" "));
            }
            this.box.add(rb);
            if (((Logico)campo).isSelecaoMultipla()) continue;
            this.group.add(rb);
        }
        this.box.validate();
    }

    @Override
    public JComponent getComponenteEditor() {
        return this.box;
    }

    @Override
    public void setIdentificacaoFoco(boolean status) {
        if (this.getComponenteEditor().getBorder() != null) {
            if (status) {
                this.borda = new BlinkBorder(this.getComponenteEditor());
                this.borda.start();
            } else if (this.borda != null) {
                this.borda.parar();
                this.borda = null;
            }
        } else {
            super.setIdentificacaoFoco(status);
        }
    }

    @Override
    public void implementacaoPropertyChange(PropertyChangeEvent evt) {
        this.setObservadorAtivo(false);
        if (evt == null) {
            System.out.println("Evento nulo no metodo implementacaoPropertyChange da classe " + this.getClass());
        }
        if ((evt.getPropertyName() == null || !evt.getPropertyName().equals("ReadOnly")) && evt.getNewValue() instanceof String) {
            String novoValor = (String)evt.getNewValue();
            if (novoValor == null) {
                novoValor = "";
            }
            if (novoValor.equals("")) {
                this.rebuildComponente(this.getInformacao());
            } else {
                String labelNovoValor = ((Logico)this.getInformacao()).getLabelOpcao(novoValor);
                for (final JRadioButton rb : this.radios.values()) {
                    ButtonModel model = rb.getModel();
                    if (rb.getText().equals(labelNovoValor)) {
                        this.setBloqueiaItemListener(true);
                        rb.setSelected(true);
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                rb.requestFocusInWindow();
                            }
                        });
                        this.setBloqueiaItemListener(false);
                        continue;
                    }
                    this.setBloqueiaItemListener(true);
                    rb.setSelected(false);
                    this.setBloqueiaItemListener(false);
                }
            }
        }
        this.setObservadorAtivo(true);
    }

    @Override
    protected void readOnlyPropertyChange(boolean readOnly) {
        for (JRadioButton rb : this.radios.values()) {
            rb.setEnabled(!readOnly);
        }
    }

    @Override
    protected void habilitadoPropertyChange(boolean habilitado) {
        for (JRadioButton rb : this.radios.values()) {
            rb.setEnabled(habilitado);
            rb.setForeground(ConstantesGlobaisGUI.COR_CINZA_CLARO);
        }
        this.labelCampo.setEnabled(habilitado);
    }

    @Override
    public JComponent getComponenteFoco() {
        int qtdRadios = this.radios.values().size();
        int posicaoPrimeiroAtivo = 0;
        if (qtdRadios > 0) {
            int i = 0;
            while (i < qtdRadios) {
                if (((JRadioButton)this.radios.values().toArray()[i]).isEnabled()) {
                    posicaoPrimeiroAtivo = i;
                    break;
                }
                ++i;
            }
            return (JRadioButton)this.radios.values().toArray()[posicaoPrimeiroAtivo];
        }
        return null;
    }

    public Map<String, JRadioButton> getRadios() {
        return this.radios;
    }

    public void setRadios(Map<String, JRadioButton> radios) {
        this.radios = radios;
    }

    public LinkedList<JRadioButton> getListaRadiosOrdenada() {
        return this.listaOrdenada;
    }

    public boolean isBloqueiaItemListener() {
        return this.bloqueiaItemListener;
    }

    public void setBloqueiaItemListener(boolean bloqueiaItemListener) {
        this.bloqueiaItemListener = bloqueiaItemListener;
    }

    @Override
    public void setPerdeFocoComEnter(boolean isPerdeFocoComEnter) {
    }
}

