/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui;

import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import serpro.ppgd.gui.EditCampo;
import serpro.ppgd.gui.editors.PPGDTextArea;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Informacao;

public class EditMemo
extends EditCampo {
    private static Alfa vazio = new Alfa("EditMemo");
    private JTextArea componente;
    private JScrollPane sp;
    private int nrMaxCaracteres;

    public EditMemo() {
        super((Informacao)vazio);
    }

    public EditMemo(Informacao campo, Dimension d, int nrMaxCaracteres) {
        super(campo, d);
        this.nrMaxCaracteres = nrMaxCaracteres;
    }

    public void setInformacao(Informacao campo) {
        if (this.componente == null) {
            this.componente = new PPGDTextArea(this.d[0].height, this.d[0].width);
            this.sp = new JScrollPane(this.componente);
            this.componente.setLineWrap(true);
            this.componente.setWrapStyleWord(true);
            this.componente.setTabSize(1);
            this.componente.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    if (e.getOppositeComponent() == null) {
                        return;
                    }
                    EditMemo.this.setIdentificacaoFoco(false);
                    if (!EditMemo.this.getInformacao().getListaValidadoresImpeditivos().isEmpty() && !EditMemo.this.verificaValidacoesImpeditivas(EditMemo.this.componente.getText())) {
                        return;
                    }
                    EditMemo.this.setObservadorAtivo(false);
                    String s = EditMemo.this.componente.getText();
                    if (s.length() > EditMemo.this.nrMaxCaracteres) {
                        s = s.substring(0, EditMemo.this.nrMaxCaracteres);
                    }
                    EditMemo.this.getInformacao().setConteudo(s);
                    EditMemo.this.chamaValidacao();
                    EditMemo.this.setObservadorAtivo(true);
                }
            });
            this.componente.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    char ch = e.getKeyChar();
                    boolean eventosEhInclusao = ch != '\uffff' && ch != '\b' && ch != '\u007f' && ch != '%' && ch != '\'' || ch == '\u0011';
                    int tamanhoTextoAtual = EditMemo.this.componente.getText().length();
                    if (tamanhoTextoAtual >= EditMemo.this.nrMaxCaracteres && eventosEhInclusao && EditMemo.this.componente.getSelectedText() == null) {
                        e.setKeyChar('\uffff');
                        e.consume();
                        UIManager.getLookAndFeel().provideErrorFeedback(EditMemo.this.componente);
                    }
                }

                public void keyTyped(KeyEvent e) {
                    char ch = e.getKeyChar();
                    boolean eventosEhInclusao = ch != '\t' && ch != '\n' && ch != '\b' && ch != '\u007f' && ch != '%' && ch != '\'';
                    int tamanhoTextoAtual = EditMemo.this.componente.getText().length();
                    if (tamanhoTextoAtual >= EditMemo.this.nrMaxCaracteres && eventosEhInclusao && EditMemo.this.componente.getSelectedText() == null) {
                        e.setKeyChar('\uffff');
                        e.consume();
                        UIManager.getLookAndFeel().provideErrorFeedback(EditMemo.this.componente);
                    }
                }
            });
        }
        ((PPGDTextArea)this.componente).setInformacao(this.getInformacao());
        this.setMaxCaracteres(((Alfa)campo).getMaximoCaracteres());
        this.implementacaoPropertyChange(null);
    }

    public JComponent getComponenteEditor() {
        return this.sp;
    }

    public void implementacaoPropertyChange(PropertyChangeEvent evt) {
        this.componente.setText(this.getInformacao().getConteudoFormatado());
    }

    protected void readOnlyPropertyChange(boolean readOnly) {
        if (readOnly) {
            this.componente.setEditable(false);
        } else {
            this.componente.setEditable(true);
        }
    }

    protected void habilitadoPropertyChange(boolean habilitado) {
        this.componente.setEnabled(habilitado);
        this.labelCampo.setEnabled(habilitado);
    }

    public JComponent getComponenteFoco() {
        return this.componente;
    }

    public void setMaxCaracteres(int nrMaxCaracteres) {
        this.nrMaxCaracteres = nrMaxCaracteres;
    }

    public void setPerdeFocoComEnter(boolean isPerdeFocoComEnter) {
    }
}

