/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import serpro.ppgd.gui.ConstantesGlobaisGUI;
import serpro.ppgd.gui.EditCampo;
import serpro.ppgd.gui.editors.PPGDFormattedTextField;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.UtilitariosString;

public class EditValor
extends EditCampo {
    private static Valor vazio = new Valor(null, "EditValor");
    private static String maskara = "###.###.##0,00";
    protected JFormattedTextField componente;
    protected boolean aceitaNumerosNegativos = false;

    public EditValor() {
        this((Informacao)vazio);
    }

    public EditValor(Informacao campo) {
        super(campo, maskara.length());
    }

    protected EditValor(Informacao pInfo, int pLength) {
        super(pInfo, pLength);
    }

    public boolean isAceitaNumerosNegativos() {
        return this.aceitaNumerosNegativos;
    }

    public void setAceitaNumerosNegativos(boolean aceitaNumerosNegativos) {
        this.aceitaNumerosNegativos = aceitaNumerosNegativos;
    }

    public void setInformacao(Informacao campo) {
        if (this.componente == null) {
            this.componente = new PPGDFormattedTextField();
            this.componente.setHorizontalAlignment(11);
            this.componente.setFont(ConstantesGlobaisGUI.FONTE_9_NORMAL);
            this.componente.setHorizontalAlignment(4);
            this.componente.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    if (EditValor.this.isSelecionaTextoOnFocusGained()) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                1.access$0(this.this$1).componente.selectAll();
                            }
                        });
                    }
                }

                public void focusLost(FocusEvent e) {
                    if (e.getOppositeComponent() == null) {
                        return;
                    }
                    EditValor.this.setIdentificacaoFoco(false);
                    if (!EditValor.this.getInformacao().getListaValidadoresImpeditivos().isEmpty() && !EditValor.this.verificaValidacoesImpeditivas(EditValor.this.componente.getText())) {
                        return;
                    }
                    EditValor.this.getInformacao().setConteudo(EditValor.this.componente.getText());
                    EditValor.this.componente.setText(EditValor.this.getInformacao().getConteudoFormatado());
                    EditValor.this.chamaValidacao();
                }

                static /* synthetic */ EditValor access$0(1 var0) {
                    return var0.EditValor.this;
                }
            });
            this.componente.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent ev) {
                    EditValor.this.trataEventoKeyTyped(ev);
                }
            });
        }
        ((PPGDFormattedTextField)this.componente).setInformacao(this.getInformacao());
        this.implementacaoPropertyChange(null);
    }

    protected void trataEventoKeyTyped(KeyEvent e) {
        boolean naoEhDigitoVirgulaPontoOuSinalNegativo;
        char ch;
        int tamanhoMaximo;
        boolean manipulacaoCursor;
        boolean bl = manipulacaoCursor = (e.getKeyChar() == '\t' || e.getKeyChar() == '\n' || e.getKeyChar() == '\b' || e.getKeyChar() == '\u007f' || e.getKeyChar() == '%' || e.getKeyChar() == '\'') && !String.valueOf(e.getKeyChar()).equals("%") && !String.valueOf(e.getKeyChar()).equals("'");
        if (manipulacaoCursor) {
            return;
        }
        String text = this.componente.getText();
        int tamanhoTextoAtual = UtilitariosString.retiraMascara((String)text).length();
        boolean fracaoGrande = false;
        Valor info = (Valor)this.getInformacao();
        int pos = text.indexOf(44);
        if (pos != -1) {
            tamanhoMaximo = info.getMaximoDigitosParteInteira() + info.getCasasDecimais();
            String s = text.substring(pos + 1);
            if (s.length() == info.getCasasDecimais() && this.componente.getCaretPosition() > pos && this.componente.getSelectedText() == null) {
                fracaoGrande = true;
            }
        } else {
            tamanhoMaximo = info.getMaximoDigitosParteInteira();
        }
        if (e.getKeyChar() == ',') {
            tamanhoMaximo = info.getMaximoDigitosParteInteira() + info.getCasasDecimais();
        }
        boolean eventosEhInclusao = (ch = e.getKeyChar()) != '\t' && ch != '\n' && ch != '\b' && ch != '\u007f' && ch != '%' && ch != '\'';
        boolean jaExisteUmSinalNeg = false;
        if (this.componente.getText().trim().indexOf("-") != -1) {
            jaExisteUmSinalNeg = true;
        }
        boolean jaExisteVirgula = false;
        if (this.componente.getText().trim().indexOf(",") != -1) {
            jaExisteVirgula = true;
        }
        boolean bl2 = naoEhDigitoVirgulaPontoOuSinalNegativo = !Character.isDigit(e.getKeyChar()) && e.getKeyChar() != '-' && e.getKeyChar() != '.' && e.getKeyChar() != ',' && e.getKeyChar() != ' ';
        if (tamanhoTextoAtual >= tamanhoMaximo && eventosEhInclusao && this.componente.getSelectedText() == null || e.getKeyChar() == '-' && !this.aceitaNumerosNegativos || Character.isLetter(e.getKeyChar()) || fracaoGrande || e.getKeyChar() == '-' && jaExisteUmSinalNeg || jaExisteUmSinalNeg && tamanhoTextoAtual + 1 >= tamanhoMaximo || e.getKeyChar() == '\'' || e.getKeyChar() == '\"' || String.valueOf(e.getKeyChar()).equals("\u00b4") || String.valueOf(e.getKeyChar()).equals("`") || String.valueOf(e.getKeyChar()).equals("^") || String.valueOf(e.getKeyChar()).equals("@") || String.valueOf(e.getKeyChar()).equals("~") || String.valueOf(e.getKeyChar()).equals("'") || String.valueOf(e.getKeyChar()).equals("%") || e.getKeyChar() == ',' && jaExisteVirgula || e.getKeyChar() == ',' && info.getCasasDecimais() == 0 || naoEhDigitoVirgulaPontoOuSinalNegativo) {
            e.setKeyChar('\uffff');
            e.consume();
            UIManager.getLookAndFeel().provideErrorFeedback(this.componente);
        }
    }

    public void implementacaoPropertyChange(PropertyChangeEvent evt) {
        this.componente.setText(this.getInformacao().getConteudoFormatado());
    }

    public JComponent getComponenteEditor() {
        return this.componente;
    }

    protected void readOnlyPropertyChange(boolean readOnly) {
        if (readOnly) {
            this.componente.setEditable(false);
        } else {
            this.componente.setEditable(true);
        }
    }

    protected void habilitadoPropertyChange(boolean habilitado) {
        this.componente.setEnabled(habilitado);
        this.labelCampo.setEnabled(habilitado);
    }

    public JComponent getComponenteFoco() {
        return this.componente;
    }

    public void setPerdeFocoComEnter(boolean aPerdeFocoComEnter) {
        this.isPerdeFocoComEnter = aPerdeFocoComEnter;
        if (this.isPerdeFocoComEnter()) {
            this.aplicaTransfereFocoEnter();
        } else {
            this.removeTransfereFocoEnter();
        }
    }
}

