/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.tree;

import java.io.File;
import javax.swing.tree.DefaultMutableTreeNode;

public class PPGDFileTreeNode
extends DefaultMutableTreeNode {
    private boolean explored = false;

    public PPGDFileTreeNode(File file) {
        if (file != null) {
            this.setUserObject(file);
        }
    }

    public boolean getAllowsChildren() {
        if (this.getUserObject() == null) {
            return true;
        }
        return this.isDirectory();
    }

    public boolean isLeaf() {
        if (this.getUserObject() == null) {
            return false;
        }
        return !this.isDirectory();
    }

    public File getFile() {
        return (File)this.getUserObject();
    }

    public boolean isExplored() {
        if (this.getUserObject() == null) {
            return true;
        }
        return this.explored;
    }

    public boolean isDirectory() {
        if (this.getUserObject() == null) {
            return true;
        }
        File file = this.getFile();
        return file.isDirectory();
    }

    public String toString() {
        if (this.getUserObject() == null) {
            return "Raiz";
        }
        File file = (File)this.getUserObject();
        String filename = file.toString();
        int index = filename.lastIndexOf(File.separator);
        return index != -1 && index != filename.length() - 1 ? filename.substring(index + 1) : filename;
    }

    public void explore(boolean showFiles, boolean showHiddenFiles) {
        if (this.getUserObject() == null) {
            this.explored = true;
            int i = 0;
            while (i < File.listRoots().length) {
                this.add(new PPGDFileTreeNode(File.listRoots()[i]));
                ++i;
            }
            return;
        }
        if (!this.isDirectory()) {
            return;
        }
        if (!this.isExplored()) {
            File file = this.getFile();
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                if ((showFiles || !showFiles && children[i].isDirectory()) && (showHiddenFiles || !children[i].isHidden())) {
                    this.add(new PPGDFileTreeNode(children[i]));
                }
                ++i;
            }
            this.explored = true;
        }
    }

    public void setExplored(boolean explored) {
        this.explored = explored;
    }
}

