/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.repositorio.embeddedDB;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.IdDeclaracao;
import serpro.ppgd.negocio.IdUsuario;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.impl.IdDeclaracaoImpl;
import serpro.ppgd.negocio.impl.IdUsuarioImpl;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.repositorio.RepositorioException;
import serpro.ppgd.repositorio.embeddedDB.util.UtilDB;

public class RepositorioIdDeclaracaoDAO {
    public static final String NOME_TABELA_ID_DECLARACAO = "IdDeclaracao";
    private Class<?> classeIdDec = IdDeclaracaoImpl.class;

    public RepositorioIdDeclaracaoDAO(String pNomeCompletoClasseDoIdDeclaracao) {
        if (pNomeCompletoClasseDoIdDeclaracao != null) {
            try {
                this.classeIdDec = Class.forName(pNomeCompletoClasseDoIdDeclaracao);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("O nome da classe de IdDeclaracao passada como par\u00e2metro \u00e9 inv\u00e1lido!!");
            }
        }
    }

    private RepositorioIdDeclaracaoDAO() {
    }

    public static String preparaSQLCriacaoTabelaIdDeclaracao(IdUsuario pId, Class<?> pClasseIdDeclaracao) {
        StringBuilder strBuff = new StringBuilder();
        if (pId == null) {
            pId = new IdUsuarioImpl();
        }
        strBuff.append("CREATE TABLE ");
        strBuff.append(NOME_TABELA_ID_DECLARACAO);
        strBuff.append(" ( ");
        Iterator itCamposId = FabricaUtilitarios.getFieldsCamposInformacao(pClasseIdDeclaracao).iterator();
        while (itCamposId.hasNext()) {
            Field field = (Field)itCamposId.next();
            strBuff.append(field.getName() + " Varchar ");
            if (!itCamposId.hasNext()) continue;
            strBuff.append(" , ");
        }
        Iterator itAtributos = pId.getListaAtributosPK().iterator();
        if (itAtributos.hasNext()) {
            strBuff.append(" , ");
        }
        while (itAtributos.hasNext()) {
            Field field = FabricaUtilitarios.getField((Object)pId, itAtributos.next());
            strBuff.append(field.getName() + " Varchar ");
            if (!itAtributos.hasNext()) continue;
            strBuff.append(" , ");
        }
        strBuff.append(" ); ");
        return strBuff.toString();
    }

    public IdDeclaracao criaInstanciaIdDeclaracaoConcreto(IdUsuario pId) {
        try {
            Class[] argumentosFormais = new Class[]{IdUsuario.class};
            Object[] argumentosReais = new Object[]{pId};
            Constructor<?> construtor = this.classeIdDec.getConstructor(argumentosFormais);
            Object retorno = construtor.newInstance(argumentosReais);
            return (IdDeclaracao)retorno;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Erro na instancia\u00e7\u00e3o do IdDeclaracao Concreto :" + e.getMessage());
        }
    }

    public IdDeclaracao criarIdDeclaracaoNaoPersistido(IdUsuario id) {
        IdDeclaracao idDeclaracao = this.criaInstanciaIdDeclaracaoConcreto(id);
        idDeclaracao.getExercicio().setConteudo(ConstantesGlobais.EXERCICIO);
        idDeclaracao.getTipo().setConteudo("DECLARA\u00c7\u00c3O DE AJUSTE ANUAL");
        return idDeclaracao;
    }

    public void inserir(IdDeclaracao pObj) throws RepositorioException {
        try {
            Statement statement = UtilDB.getConexao().createStatement();
            StringBuilder strBuff = new StringBuilder();
            strBuff.append("INSERT INTO ");
            strBuff.append(NOME_TABELA_ID_DECLARACAO);
            strBuff.append(" VALUES ( ");
            Iterator itCamposId = FabricaUtilitarios.getFieldsCamposInformacao(pObj.getClass()).iterator();
            while (itCamposId.hasNext()) {
                Field field = (Field)itCamposId.next();
                strBuff.append("'");
                Object valorAtributo = FabricaUtilitarios.getValorField((Field)field, (Object)pObj);
                if (valorAtributo != null) {
                    strBuff.append(((Informacao)valorAtributo).asString());
                }
                strBuff.append("'");
                if (!itCamposId.hasNext()) continue;
                strBuff.append(" , ");
            }
            Iterator itAtributos = pObj.getId().getListaAtributosPK().iterator();
            if (itAtributos.hasNext()) {
                strBuff.append(" , ");
            }
            while (itAtributos.hasNext()) {
                Field field = FabricaUtilitarios.getField((Object)pObj.getId(), itAtributos.next());
                strBuff.append("'");
                Object valorAtributo = FabricaUtilitarios.getValorField((Field)field, (Object)pObj.getId());
                if (valorAtributo != null) {
                    strBuff.append(((Informacao)valorAtributo).asString());
                }
                strBuff.append("'");
                if (!itAtributos.hasNext()) continue;
                strBuff.append(" , ");
            }
            strBuff.append(" ); ");
            statement.execute(strBuff.toString());
            statement.close();
        }
        catch (SQLException e) {
            throw new RepositorioException("Erro na inser\u00e7\u00e3o do IdDeclaracao:" + e.getMessage());
        }
    }

    public void alterar(IdDeclaracao pObj) throws RepositorioException {
        try {
            Statement statement = UtilDB.getConexao().createStatement();
            StringBuilder strBuff = new StringBuilder();
            strBuff.append("UPDATE ");
            strBuff.append(NOME_TABELA_ID_DECLARACAO);
            strBuff.append(" SET ");
            Iterator itCamposId = FabricaUtilitarios.getFieldsCamposInformacao(pObj.getClass()).iterator();
            while (itCamposId.hasNext()) {
                Field field = (Field)itCamposId.next();
                strBuff.append(field.getName());
                strBuff.append(" = ");
                strBuff.append("'");
                Object valorAtributo = FabricaUtilitarios.getValorField((Field)field, (Object)pObj);
                if (valorAtributo != null) {
                    strBuff.append(((Informacao)valorAtributo).asString());
                }
                strBuff.append("'");
                if (!itCamposId.hasNext()) continue;
                strBuff.append(" , ");
            }
            this.adicionarClausulaSQL_WHERE(pObj, strBuff);
            strBuff.append(" ; ");
            statement.executeUpdate(strBuff.toString());
            statement.close();
        }
        catch (SQLException e) {
            throw new RepositorioException("Erro na atualiza\u00e7\u00e3o do IdDeclaracao:" + e.getMessage());
        }
    }

    public void deletar(IdDeclaracao pObj) throws RepositorioException {
        try {
            Statement statement = UtilDB.getConexao().createStatement();
            StringBuilder strBuff = new StringBuilder();
            strBuff.append("DELETE FROM ");
            strBuff.append(NOME_TABELA_ID_DECLARACAO);
            this.adicionarClausulaSQL_WHERE(pObj, strBuff);
            strBuff.append(" ; ");
            int i = statement.executeUpdate(strBuff.toString());
            LogPPGD.debug((String)("i->" + i));
            statement.close();
        }
        catch (SQLException e) {
            throw new RepositorioException("Erro na exclus\u00e3o do IdDeclaracao:" + e.getMessage());
        }
    }

    public List<IdDeclaracao> recuperarIdDeclaracoes(List<IdUsuario> listIds) throws RepositorioException {
        ArrayList<IdDeclaracao> retorno = new ArrayList<IdDeclaracao>();
        for (IdUsuario idAtual : listIds) {
            try {
                IdDeclaracao idDecl = null;
                Statement statement = UtilDB.getConexao().createStatement();
                StringBuilder strBuff = new StringBuilder();
                strBuff.append("SELECT * FROM ");
                strBuff.append(NOME_TABELA_ID_DECLARACAO);
                strBuff.append(",");
                strBuff.append("ID");
                strBuff.append(" WHERE  ");
                Iterator itPk = idAtual.getListaAtributosPK().iterator();
                while (itPk.hasNext()) {
                    Field field = FabricaUtilitarios.getField((Object)idAtual, itPk.next());
                    Informacao info = (Informacao)FabricaUtilitarios.getValorField((Field)field, (Object)idAtual);
                    strBuff.append("IdDeclaracao." + field.getName());
                    strBuff.append(" = ");
                    strBuff.append("ID." + field.getName());
                    strBuff.append(" AND ");
                    strBuff.append(field.getName());
                    strBuff.append(" = ");
                    strBuff.append(info.asString());
                    if (!itPk.hasNext()) continue;
                    strBuff.append(" AND ");
                }
                strBuff.append(" ; ");
                ResultSet rs = statement.executeQuery(strBuff.toString());
                while (rs.next()) {
                    idDecl = this.criaInstanciaIdDeclaracaoConcreto(idAtual);
                    UtilDB.preencheObjeto(rs, idDecl);
                    retorno.add(idDecl);
                }
                rs.close();
                statement.close();
            }
            catch (SQLException e) {
                throw new RepositorioException("Erro recupera\u00e7\u00e3o de IdDeclaracao:" + e.getMessage());
            }
        }
        return retorno;
    }

    public IdDeclaracao recuperarIdDeclaracao(IdDeclaracao pObj) throws RepositorioException {
        try {
            IdDeclaracao retorno = null;
            Statement statement = UtilDB.getConexao().createStatement();
            StringBuilder strBuff = new StringBuilder();
            strBuff.append("SELECT * FROM ");
            strBuff.append(NOME_TABELA_ID_DECLARACAO);
            this.adicionarClausulaSQL_WHERE(pObj, strBuff);
            strBuff.append(" ; ");
            ResultSet rs = statement.executeQuery(strBuff.toString());
            while (rs.next()) {
                retorno = this.criaInstanciaIdDeclaracaoConcreto(pObj.getId());
                UtilDB.preencheObjeto(rs, retorno);
                UtilDB.preencheObjeto(rs, retorno.getId());
            }
            rs.close();
            statement.close();
            return retorno;
        }
        catch (SQLException e) {
            throw new RepositorioException("Erro recupera\u00e7\u00e3o de IdUsuario:" + e.getMessage());
        }
    }

    private void adicionarClausulaSQL_WHERE(IdDeclaracao pObj, StringBuilder strBuff) {
        Iterator itPk = pObj.getListaAtributosPK().iterator();
        if (itPk.hasNext()) {
            strBuff.append(" WHERE ");
            while (itPk.hasNext()) {
                Informacao atributoAtual = (Informacao)itPk.next();
                boolean ehCampoDoId = false;
                Field field = FabricaUtilitarios.getField((Object)pObj, (Object)atributoAtual);
                if (field == null) {
                    field = FabricaUtilitarios.getField((Object)pObj.getId(), (Object)atributoAtual);
                    ehCampoDoId = true;
                }
                strBuff.append(field.getName());
                strBuff.append(" = ");
                if (atributoAtual != null && atributoAtual.asString().trim().length() > 0) {
                    strBuff.append("'");
                    strBuff.append(atributoAtual.asString());
                    strBuff.append("'");
                } else {
                    strBuff.append(field.getName());
                }
                if (!itPk.hasNext()) continue;
                strBuff.append(" AND ");
            }
        }
    }
}

