/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.repositorio.embeddedDB;

import java.util.Map;
import serpro.ppgd.negocio.IdDeclaracao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.repositorio.RepositorioException;
import serpro.ppgd.repositorio.RepositorioObjetoNegocioIf;
import serpro.ppgd.repositorio.embeddedDB.ObjetoPersistente;
import serpro.ppgd.repositorio.embeddedDB.RepositorioObjetoNegocioDAO;
import serpro.ppgd.repositorio.repositorioXML.HashtableIdDeclaracao;

public class RepositorioObjetoNegocioDB
implements RepositorioObjetoNegocioIf {
    private RepositorioObjetoNegocioDAO repositorioObjetoNegocioDAO = null;
    private Map<IdDeclaracao, ObjetoPersistente> objetosAbertos;

    public RepositorioObjetoNegocioDB(String pNomeCompletoClasseDaDeclaracao, String pNomeTabela) {
        this.repositorioObjetoNegocioDAO = new RepositorioObjetoNegocioDAO(pNomeCompletoClasseDaDeclaracao, pNomeTabela);
    }

    public RepositorioObjetoNegocioDB(String pNomeCompletoClasseDaDeclaracao) {
        this.repositorioObjetoNegocioDAO = new RepositorioObjetoNegocioDAO(pNomeCompletoClasseDaDeclaracao, null);
    }

    @Override
    public void descarregar(IdDeclaracao id) throws RepositorioException {
        if (this.getObjetosAbertos().containsKey(id)) {
            this.getObjetosAbertos().remove(id);
        }
    }

    @Override
    public ObjetoNegocio recuperar(IdDeclaracao idDec) throws RepositorioException {
        if (this.getObjetosAbertos().containsKey(idDec)) {
            return (ObjetoNegocio)this.getObjetosAbertos().get((Object)idDec).instancia;
        }
        ObjetoNegocio resultado = this.repositorioObjetoNegocioDAO.recuperar(idDec);
        this.getObjetosAbertos().put(idDec, new ObjetoPersistente(resultado, true));
        return resultado;
    }

    @Override
    public ObjetoNegocio criar(IdDeclaracao idDec) throws RepositorioException {
        ObjetoNegocio resultado = null;
        if (idDec == null) {
            throw new IllegalArgumentException("RepositorioObjetoNegocioDB: argumento \u00e9 nulo.");
        }
        if (this.getObjetosAbertos().containsKey(idDec)) {
            throw new IllegalArgumentException("RepositorioObjetoNegocioDB: ObjetoNegocio solicitado j\u00e1 existe.");
        }
        resultado = this.repositorioObjetoNegocioDAO.criarNaoPersistido(idDec);
        this.getObjetosAbertos().put(idDec, new ObjetoPersistente(resultado, false));
        return resultado;
    }

    @Override
    public void salvar(IdDeclaracao idDec) throws RepositorioException {
        if (this.getObjetosAbertos().containsKey(idDec)) {
            ObjetoPersistente objetoPersistente = this.getObjetosAbertos().get(idDec);
            if (objetoPersistente.persistido) {
                this.repositorioObjetoNegocioDAO.alterar((ObjetoNegocio)objetoPersistente.instancia);
            } else {
                this.repositorioObjetoNegocioDAO.inserir((ObjetoNegocio)objetoPersistente.instancia);
                objetoPersistente.persistido = true;
            }
        } else {
            throw new IllegalArgumentException("N\u00e3o h\u00e1 ObjetoNegocio correspondente a esse IdDeclaracao: " + idDec.getNiContribuinte());
        }
    }

    @Override
    public void deletar(IdDeclaracao idDec) throws RepositorioException {
        ObjetoNegocio obj = this.repositorioObjetoNegocioDAO.criarNaoPersistido(idDec);
        this.repositorioObjetoNegocioDAO.excluir(obj);
        this.getObjetosAbertos().remove(idDec);
    }

    public Map<IdDeclaracao, ObjetoPersistente> getObjetosAbertos() {
        if (this.objetosAbertos == null) {
            this.objetosAbertos = new HashtableIdDeclaracao<IdDeclaracao, ObjetoPersistente>();
        }
        return this.objetosAbertos;
    }
}

