/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.repositorio.embeddedDB.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.IdDeclaracao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.repositorio.RepositorioException;

public abstract class UtilDB {
    static Connection conexao = null;

    public static Connection getConexao() throws RepositorioException {
        String pDriver = FabricaUtilitarios.getProperties().getProperty("aplicacao.persistencia.conexaoDB.driver");
        String pUrlConexao = FabricaUtilitarios.getProperties().getProperty("aplicacao.persistencia.conexaoDB.url");
        String pUsuario = FabricaUtilitarios.getProperties().getProperty("aplicacao.persistencia.conexaoDB.usuario");
        String pSenha = FabricaUtilitarios.getProperties().getProperty("aplicacao.persistencia.conexaoDB.senha");
        if (pDriver == null) {
            throw new RepositorioException("Est\u00e1 faltando a chave \"aplicacao.persistencia.conexaoDB.driver\" no arquivo de propriedades da aplica\u00e7\u00e3o");
        }
        if (pUrlConexao == null) {
            throw new RepositorioException("Est\u00e1 faltando a chave \"aplicacao.persistencia.conexaoDB.url\" no arquivo de propriedades da aplica\u00e7\u00e3o");
        }
        if (pUsuario == null) {
            throw new RepositorioException("Est\u00e1 faltando a chave \"aplicacao.persistencia.conexaoDB.usuario\" no arquivo de propriedades da aplica\u00e7\u00e3o");
        }
        if (conexao == null) {
            try {
                Class.forName(pDriver);
                conexao = DriverManager.getConnection(pUrlConexao, pUsuario, pSenha);
            }
            catch (Exception e) {
                throw new RepositorioException("Erro ao criar conex\u00e3o com BD :" + e.getMessage());
            }
        }
        return conexao;
    }

    public static void preencheObjeto(ResultSet resultSet, Object pObj) throws RepositorioException {
        for (Field field : FabricaUtilitarios.getFieldsCamposInformacao(pObj.getClass())) {
            LogPPGD.debug((String)("field->" + field.getName()));
            Informacao valorAtributo = (Informacao)FabricaUtilitarios.getValorField((Field)field, (Object)pObj);
            if (valorAtributo instanceof Valor && ((Valor)valorAtributo).isCampoCalculado()) continue;
            try {
                valorAtributo.setConteudo(resultSet.getString(field.getName()));
                LogPPGD.debug((String)("preencheu Atributo:" + resultSet.getString(field.getName())));
            }
            catch (Exception e) {}
        }
    }

    public static void finalizaConexao() {
        if (conexao != null) {
            try {
                conexao.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static int executarDDL(String comando) throws RepositorioException {
        try {
            Statement statement = UtilDB.getConexao().createStatement();
            int retorno = statement.executeUpdate(comando);
            statement.close();
            return retorno;
        }
        catch (SQLException e) {
            throw new RepositorioException("Erro na execu\u00e7\u00e3o do comando DDL :" + e.getMessage());
        }
    }

    public static String preparaSqlCreateTableObjetoNegocio(ObjetoNegocio pObj, String pNomeTabela) throws RepositorioException {
        try {
            StringBuilder strBuff = new StringBuilder();
            strBuff.append("CREATE TABLE ");
            strBuff.append(pNomeTabela);
            strBuff.append(" ( ");
            Iterator itCamposId = FabricaUtilitarios.getFieldsCamposInformacao(pObj.getClass()).iterator();
            boolean semNenhumcampoInformacao = true;
            if (itCamposId.hasNext()) {
                semNenhumcampoInformacao = false;
            }
            while (itCamposId.hasNext()) {
                Field field = (Field)itCamposId.next();
                strBuff.append(field.getName() + " Varchar ");
                if (!itCamposId.hasNext()) continue;
                strBuff.append(" , ");
            }
            Iterator itAtributos = pObj.getIdDeclaracao().getListaAtributosPK().iterator();
            if (itAtributos.hasNext() && !semNenhumcampoInformacao) {
                strBuff.append(" , ");
            }
            while (itAtributos.hasNext()) {
                Object campoAtual = itAtributos.next();
                Field field = FabricaUtilitarios.getField((Object)pObj.getIdDeclaracao(), campoAtual);
                if (field == null) {
                    field = FabricaUtilitarios.getField((Object)pObj.getIdDeclaracao().getId(), campoAtual);
                }
                strBuff.append(field.getName() + " Varchar ");
                if (!itAtributos.hasNext()) continue;
                strBuff.append(" , ");
            }
            strBuff.append(" ); ");
            return strBuff.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositorioException("Erro na cria\u00e7\u00e3o das tabelas do objeto de neg\u00f3cio:", e);
        }
    }

    public static List<String> preparaSqlCriacaoTabelasObjetoNegocio(ObjetoNegocio pObj, String pNomeTabela) throws RepositorioException {
        try {
            ArrayList<String> retorno = new ArrayList<String>();
            String sqltabela = UtilDB.preparaSqlCreateTableObjetoNegocio(pObj, pNomeTabela);
            if (sqltabela != null) {
                retorno.add(sqltabela);
            }
            Field[] fields = pObj.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!ObjetoNegocio.class.isAssignableFrom(fields[i].getType())) continue;
                ObjetoNegocio valor = (ObjetoNegocio)FabricaUtilitarios.getValorField((Field)fields[i], (Object)pObj);
                if (Colecao.class.isAssignableFrom(fields[i].getType()) && ((Colecao)valor).getTipoItens() != null) {
                    Class[] argumentosFormais = new Class[]{IdDeclaracao.class};
                    Object[] argumentosReais = new Object[]{pObj.getIdDeclaracao()};
                    Constructor construtor = ((Colecao)valor).getTipoItens().getConstructor(argumentosFormais);
                    ObjetoNegocio itemColecao = (ObjetoNegocio)construtor.newInstance(argumentosReais);
                    String nomeTabela = ((Colecao)valor).getTipoItens().getName();
                    nomeTabela = nomeTabela.substring(nomeTabela.lastIndexOf(46) + 1);
                    retorno.addAll(UtilDB.preparaSqlCriacaoTabelasObjetoNegocio(itemColecao, fields[i].getName() + "_" + nomeTabela));
                }
                retorno.addAll(UtilDB.preparaSqlCriacaoTabelasObjetoNegocio(valor, fields[i].getName()));
            }
            return retorno;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositorioException("Erro na gera\u00e7\u00e3o da lista de Sql de cria\u00e7\u00e3o de tabelas:", e);
        }
    }

    public static List<String> preparaSqlRemocaoTabelasObjetoNegocio(ObjetoNegocio pObj, String pNomeTabela) throws RepositorioException {
        try {
            ArrayList<String> retorno = new ArrayList<String>();
            retorno.add("DROP TABLE " + pNomeTabela);
            Field[] fields = pObj.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!ObjetoNegocio.class.isAssignableFrom(fields[i].getType())) continue;
                ObjetoNegocio valor = (ObjetoNegocio)FabricaUtilitarios.getValorField((Field)fields[i], (Object)pObj);
                if (Colecao.class.isAssignableFrom(fields[i].getType()) && ((Colecao)valor).getTipoItens() != null) {
                    Class[] argumentosFormais = new Class[]{IdDeclaracao.class};
                    Object[] argumentosReais = new Object[]{pObj.getIdDeclaracao()};
                    Constructor construtor = ((Colecao)valor).getTipoItens().getConstructor(argumentosFormais);
                    ObjetoNegocio itemColecao = (ObjetoNegocio)construtor.newInstance(argumentosReais);
                    String nomeTabela = ((Colecao)valor).getTipoItens().getName();
                    nomeTabela = nomeTabela.substring(nomeTabela.lastIndexOf(46) + 1);
                    retorno.addAll(UtilDB.preparaSqlRemocaoTabelasObjetoNegocio(itemColecao, fields[i].getName() + "_" + nomeTabela));
                }
                retorno.addAll(UtilDB.preparaSqlRemocaoTabelasObjetoNegocio(valor, fields[i].getName()));
            }
            return retorno;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositorioException("Erro na gera\u00e7\u00e3o da lista de Sql de cria\u00e7\u00e3o de tabelas:", e);
        }
    }

    private static String preparaSQLInsertObjetoNegocio(ObjetoNegocio pObj, String pNomeTabela) throws RepositorioException {
        try {
            StringBuilder strBuff = new StringBuilder();
            StringBuilder strBuffCampos = new StringBuilder();
            StringBuilder strBuffValues = new StringBuilder();
            strBuff.append("INSERT INTO ");
            strBuff.append(pNomeTabela);
            strBuffCampos.append(" ( ");
            strBuffValues.append(" VALUES ( ");
            Iterator itCamposId = FabricaUtilitarios.getFieldsCamposInformacao(pObj.getClass()).iterator();
            boolean semNenhumcampoInformacao = true;
            if (itCamposId.hasNext()) {
                semNenhumcampoInformacao = false;
            }
            while (itCamposId.hasNext()) {
                Field field = (Field)itCamposId.next();
                strBuffCampos.append(field.getName());
                strBuffValues.append("'");
                Object valorAtributo = FabricaUtilitarios.getValorField((Field)field, (Object)pObj);
                if (valorAtributo != null) {
                    strBuffValues.append(((Informacao)valorAtributo).asString());
                }
                strBuffValues.append("' ");
                if (!itCamposId.hasNext()) continue;
                strBuffCampos.append(" , ");
                strBuffValues.append(" , ");
            }
            Iterator itAtributos = pObj.getIdDeclaracao().getListaAtributosPK().iterator();
            if (itAtributos.hasNext() && !semNenhumcampoInformacao) {
                strBuffCampos.append(" , ");
                strBuffValues.append(" , ");
            }
            while (itAtributos.hasNext()) {
                Object campoAtual = itAtributos.next();
                Field field = FabricaUtilitarios.getField((Object)pObj.getIdDeclaracao(), campoAtual);
                if (field == null) {
                    field = FabricaUtilitarios.getField((Object)pObj.getIdDeclaracao().getId(), campoAtual);
                }
                strBuffCampos.append(field.getName());
                strBuffValues.append("'");
                Object valorAtributo = null;
                try {
                    valorAtributo = FabricaUtilitarios.getValorField((Field)field, (Object)pObj.getIdDeclaracao());
                }
                catch (IllegalArgumentException e) {
                    valorAtributo = FabricaUtilitarios.getValorField((Field)field, (Object)pObj.getIdDeclaracao().getId());
                }
                if (valorAtributo != null) {
                    strBuffValues.append(((Informacao)valorAtributo).asString());
                }
                strBuffValues.append("' ");
                if (!itAtributos.hasNext()) continue;
                strBuffCampos.append(" , ");
                strBuffValues.append(" , ");
            }
            strBuffCampos.append(" ) ");
            strBuffValues.append(" ) ");
            strBuff.append(" " + strBuffCampos.toString());
            strBuff.append(" " + strBuffValues.toString());
            return strBuff.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositorioException("Erro na cria\u00e7\u00e3o do SQL Insert do objeto de neg\u00f3cio:" + pObj.getClass().getName(), e);
        }
    }

    public static List<String> preparaSqlInsertTabelasObjetoNegocio(ObjetoNegocio pObj, String pNomeTabela) throws RepositorioException {
        try {
            ArrayList<String> retorno = new ArrayList<String>();
            String sqltabela = UtilDB.preparaSQLInsertObjetoNegocio(pObj, pNomeTabela);
            if (sqltabela != null) {
                retorno.add(sqltabela);
            }
            Field[] fields = pObj.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!ObjetoNegocio.class.isAssignableFrom(fields[i].getType())) continue;
                ObjetoNegocio valor = (ObjetoNegocio)FabricaUtilitarios.getValorField((Field)fields[i], (Object)pObj);
                if (Colecao.class.isAssignableFrom(fields[i].getType()) && ((Colecao)valor).getTipoItens() != null) {
                    Iterator itItensColecao = ((Colecao)valor).recuperarLista().iterator();
                    String nomeTabela = ((Colecao)valor).getTipoItens().getName();
                    nomeTabela = nomeTabela.substring(nomeTabela.lastIndexOf(46) + 1);
                    while (itItensColecao.hasNext()) {
                        ObjetoNegocio itemColecao = (ObjetoNegocio)itItensColecao.next();
                        retorno.addAll(UtilDB.preparaSqlInsertTabelasObjetoNegocio(itemColecao, fields[i].getName() + "_" + nomeTabela));
                    }
                }
                retorno.addAll(UtilDB.preparaSqlInsertTabelasObjetoNegocio(valor, fields[i].getName()));
            }
            return retorno;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositorioException("Erro na gera\u00e7\u00e3o do SQL de Insert:", e);
        }
    }

    private static String preparaSQLUpdateObjetoNegocio(ObjetoNegocio pObj, String pNomeTabela) throws RepositorioException {
        try {
            StringBuilder strBuff = new StringBuilder();
            strBuff.append("UPDATE ");
            strBuff.append(pNomeTabela);
            strBuff.append(" SET ");
            Iterator itCamposId = FabricaUtilitarios.getFieldsCamposInformacao(pObj.getClass()).iterator();
            if (!itCamposId.hasNext()) {
                return null;
            }
            while (itCamposId.hasNext()) {
                Field field = (Field)itCamposId.next();
                strBuff.append(field.getName());
                strBuff.append("=");
                strBuff.append("'");
                Object valorAtributo = FabricaUtilitarios.getValorField((Field)field, (Object)pObj);
                if (valorAtributo != null) {
                    strBuff.append(((Informacao)valorAtributo).asString());
                }
                strBuff.append("' ");
                if (!itCamposId.hasNext()) continue;
                strBuff.append(" , ");
            }
            UtilDB.montaClausulaSQLWhere(strBuff, pObj);
            strBuff.append(" ; ");
            return strBuff.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositorioException("Erro na cria\u00e7\u00e3o do SQL de Update do objeto de neg\u00f3cio:" + pObj.getClass().getName(), e);
        }
    }

    private static void montaClausulaSQLWhere(StringBuilder strBuff, ObjetoNegocio pObj) throws RepositorioException {
        strBuff.append(" WHERE ");
        Iterator itCamposId = pObj.getIdDeclaracao().getListaAtributosPK().iterator();
        while (itCamposId.hasNext()) {
            Object campoAtual = itCamposId.next();
            Field field = FabricaUtilitarios.getField((Object)pObj.getIdDeclaracao(), campoAtual);
            if (field == null) {
                field = FabricaUtilitarios.getField((Object)pObj.getIdDeclaracao().getId(), campoAtual);
            }
            Object valorAtributo = null;
            try {
                valorAtributo = FabricaUtilitarios.getValorField((Field)field, (Object)pObj.getIdDeclaracao());
            }
            catch (IllegalArgumentException e) {
                valorAtributo = FabricaUtilitarios.getValorField((Field)field, (Object)pObj.getIdDeclaracao().getId());
            }
            strBuff.append(field.getName());
            strBuff.append("=");
            if (valorAtributo != null && ((Informacao)valorAtributo).asString().trim().length() != 0) {
                strBuff.append("'");
                strBuff.append(((Informacao)valorAtributo).asString());
                strBuff.append("' ");
            } else {
                strBuff.append(field.getName());
            }
            if (!itCamposId.hasNext()) continue;
            strBuff.append(" AND ");
        }
    }

    public static List<String> preparaSqlUpdateTabelasObjetoNegocio(ObjetoNegocio pObj, String pNomeTabela) throws RepositorioException {
        try {
            ArrayList<String> retorno = new ArrayList<String>();
            String sqltabela = UtilDB.preparaSQLUpdateObjetoNegocio(pObj, pNomeTabela);
            if (sqltabela != null) {
                retorno.add(sqltabela);
            }
            Field[] fields = pObj.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!ObjetoNegocio.class.isAssignableFrom(fields[i].getType())) continue;
                ObjetoNegocio valor = (ObjetoNegocio)FabricaUtilitarios.getValorField((Field)fields[i], (Object)pObj);
                if (Colecao.class.isAssignableFrom(fields[i].getType()) && ((Colecao)valor).getTipoItens() != null) {
                    Iterator itItensColecao = ((Colecao)valor).recuperarLista().iterator();
                    String nomeTabela = ((Colecao)valor).getTipoItens().getName();
                    nomeTabela = nomeTabela.substring(nomeTabela.lastIndexOf(46) + 1);
                    retorno.add(" DELETE FROM " + fields[i].getName() + "_" + nomeTabela + " ; ");
                    while (itItensColecao.hasNext()) {
                        ObjetoNegocio itemColecao = (ObjetoNegocio)itItensColecao.next();
                        retorno.addAll(UtilDB.preparaSqlInsertTabelasObjetoNegocio(itemColecao, fields[i].getName() + "_" + nomeTabela));
                    }
                }
                retorno.addAll(UtilDB.preparaSqlUpdateTabelasObjetoNegocio(valor, fields[i].getName()));
            }
            return retorno;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositorioException("Erro na gera\u00e7\u00e3o da lista de Sql de update das tabelas:", e);
        }
    }

    private static String preparaSQLDeleteObjetoNegocio(ObjetoNegocio pObj, String pNomeTabela) throws RepositorioException {
        try {
            StringBuilder strBuff = new StringBuilder();
            strBuff.append("DELETE FROM ");
            strBuff.append(pNomeTabela);
            UtilDB.montaClausulaSQLWhere(strBuff, pObj);
            strBuff.append(" ; ");
            return strBuff.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositorioException("Erro no preparo no SQL de remo\u00e7\u00e3o do objeto de neg\u00f3cio:", e);
        }
    }

    public static List<String> preparaSqlDeleteTabelasObjetoNegocio(ObjetoNegocio pObj, String pNomeTabela) throws RepositorioException {
        try {
            ArrayList<String> retorno = new ArrayList<String>();
            String sqltabela = UtilDB.preparaSQLDeleteObjetoNegocio(pObj, pNomeTabela);
            if (sqltabela != null) {
                retorno.add(sqltabela);
            }
            Field[] fields = pObj.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!ObjetoNegocio.class.isAssignableFrom(fields[i].getType())) continue;
                ObjetoNegocio valor = (ObjetoNegocio)FabricaUtilitarios.getValorField((Field)fields[i], (Object)pObj);
                if (Colecao.class.isAssignableFrom(fields[i].getType()) && ((Colecao)valor).getTipoItens() != null) {
                    Class[] argumentosFormais = new Class[]{IdDeclaracao.class};
                    Object[] argumentosReais = new Object[]{pObj.getIdDeclaracao()};
                    Constructor construtor = ((Colecao)valor).getTipoItens().getConstructor(argumentosFormais);
                    ObjetoNegocio itemColecao = (ObjetoNegocio)construtor.newInstance(argumentosReais);
                    String nomeTabela = ((Colecao)valor).getTipoItens().getName();
                    nomeTabela = nomeTabela.substring(nomeTabela.lastIndexOf(46) + 1);
                    retorno.addAll(UtilDB.preparaSqlDeleteTabelasObjetoNegocio(itemColecao, fields[i].getName() + "_" + nomeTabela));
                }
                retorno.addAll(UtilDB.preparaSqlDeleteTabelasObjetoNegocio(valor, fields[i].getName()));
            }
            return retorno;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositorioException("Erro na gera\u00e7\u00e3o da lista de Sql de Delete das tabelas:", e);
        }
    }

    public static String preparaSQLSelectObjetoNegocio(ObjetoNegocio pObj, String pNomeTabela) throws RepositorioException {
        try {
            StringBuilder strBuff = new StringBuilder();
            strBuff.append("SELECT * FROM ");
            strBuff.append(pNomeTabela);
            UtilDB.montaClausulaSQLWhere(strBuff, pObj);
            strBuff.append(" ; ");
            return strBuff.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositorioException("Erro no preparo no SQL de select do objeto de neg\u00f3cio:", e);
        }
    }
}

