/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.calendario;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;
import serpro.ppgd.gui.calendario.CalendarioEvent;
import serpro.ppgd.gui.calendario.CalendarioListener;
import serpro.ppgd.negocio.util.LogPPGD;

public class Calendario
extends JPanel
implements ItemListener,
MouseListener,
FocusListener,
KeyListener,
ActionListener {
    private static final String[] MONTHS = new String[]{"Janeiro", "Fevereiro", "Mar\u00e7o", "Abril", "Maio", "Junho", "Julho", "Agosto", "Setembro", "Outubro", "Novembro", "Dezembro"};
    private static final String[] DAYS = new String[]{"Dom", "Seg", "Ter", "Qua", "Qui", "Sex", "Sab"};
    private static Color WEEK_DAYS_FOREGROUND = UIManager.getColor("TextArea.selectionForeground");
    private static Color WEEK_DAYS_BACKGROUND = Color.lightGray;
    private static Color ENDWEEK_DAYS_FOREGROUND = UIManager.getColor("TextArea.foreground");
    private static Color ENDWEEK_DAYS_BACKGROUND = UIManager.getColor("TextArea.background");
    private static Color DAYS_FOREGROUND = UIManager.getColor("TextArea.foreground");
    private Color corTextoSelecao = UIManager.getColor("TextArea.selectionForeground");
    private Color corSelecao = UIManager.getColor("TextArea.selectionBackground");
    private Color corDiaDesabilitado = UIManager.getColor("Menu.disabledForeground");
    private static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    private static final Border FOCUSED_BORDER = BorderFactory.createLineBorder(Color.black, 1);
    private static final int FIRST_YEAR = 1900;
    private static final int LAST_YEAR = 2100;
    private GregorianCalendar calendar;
    private LabelDia[][] days;
    private FocusablePanel daysGrid;
    private JComboBox month;
    private JComboBox year;
    private JButton ok;
    private JButton cancel;
    private int offset;
    private int lastDay;
    private ArrayList selectedDays = new ArrayList();
    private boolean okClicked;
    private JLabel monthAndYearTitle = new JLabel();
    private JPanel monthYear;
    private JPanel daysPanel;
    private JPanel buttons;
    private boolean dataFixa = false;
    private boolean selecaoMultipla = false;
    private EventListenerList listenersCalendario = new EventListenerList();
    private boolean anoFixo = false;
    private boolean selecaoHabilitada = true;
    private boolean eventosDesabilitados = false;
    static /* synthetic */ Class class$0;

    private void constructWithStaticLabel() {
        this.setLayout(new BorderLayout());
        this.calendar = new GregorianCalendar();
        this.month = new JComboBox<String>(MONTHS);
        this.month.addItemListener(this);
        this.year = new JComboBox();
        int i = 1900;
        while (i <= 2100) {
            this.year.addItem(Integer.toString(i));
            ++i;
        }
        this.year.addItemListener(this);
        this.days = new LabelDia[7][7];
        this.days[0][0] = new LabelDia(DAYS[0], 0);
        this.days[0][0].setForeground(WEEK_DAYS_FOREGROUND);
        this.days[0][0].setBackground(WEEK_DAYS_BACKGROUND);
        this.days[0][0].setOpaque(true);
        i = 1;
        while (i < 6) {
            this.days[0][i] = new LabelDia(DAYS[i], 0);
            this.days[0][i].setForeground(WEEK_DAYS_FOREGROUND);
            this.days[0][i].setBackground(WEEK_DAYS_BACKGROUND);
            this.days[0][i].setOpaque(true);
            ++i;
        }
        this.days[0][6] = new LabelDia(DAYS[6], 0);
        this.days[0][6].setForeground(WEEK_DAYS_FOREGROUND);
        this.days[0][6].setBackground(WEEK_DAYS_BACKGROUND);
        this.days[0][6].setOpaque(true);
        i = 1;
        while (i < 7) {
            int j = 0;
            while (j < 7) {
                this.days[i][j] = new LabelDia(" ", 0);
                this.aplicaVisualLabelDias(i, j);
                this.days[i][j].addMouseListener(this);
                ++j;
            }
            ++i;
        }
        this.ok = new JButton("Ok");
        this.ok.addActionListener(this);
        this.cancel = new JButton("Cancelar");
        this.cancel.addActionListener(this);
        this.buildMonthYearStatic();
        this.controiDaysPanel();
        this.buttons = new JPanel();
        this.buttons.add(this.ok);
        this.buttons.add(this.cancel);
        this.addComponents(this.monthYear, this.daysPanel, this.buttons);
        this.update();
    }

    private void aplicaVisualLabelDias(int i, int j) {
        this.days[i][j].setForeground(DAYS_FOREGROUND);
        this.days[i][j].setBackground(this.getCorSelecao());
        this.days[i][j].setBorder(EMPTY_BORDER);
    }

    private void buildMonthYearStatic() {
        this.monthYear = new JPanel();
        this.monthYear.setLayout((LayoutManager)new FormLayout("5dlu:grow,F:P,3dlu:grow,F:P:grow,3dlu", "P"));
        CellConstraints cc = new CellConstraints();
        this.monthYear.add((Component)this.monthAndYearTitle, cc.xywh(2, 1, 3, 1));
    }

    public void addCalendarioListener(CalendarioListener listener) {
        this.listenersCalendario.add(CalendarioListener.class, listener);
    }

    public void removeCalendarioListener(CalendarioListener listener) {
        this.listenersCalendario.remove(CalendarioListener.class, listener);
    }

    private void construct() {
        this.setLayout(new BorderLayout());
        this.calendar = new GregorianCalendar();
        this.month = new JComboBox<String>(MONTHS);
        this.month.addItemListener(this);
        this.year = new JComboBox();
        int i = 1900;
        while (i <= 2100) {
            this.year.addItem(Integer.toString(i));
            ++i;
        }
        this.year.addItemListener(this);
        this.days = new LabelDia[7][7];
        this.days[0][0] = new LabelDia(DAYS[0], 0);
        this.days[0][0].setForeground(WEEK_DAYS_FOREGROUND);
        this.days[0][0].setBackground(WEEK_DAYS_BACKGROUND);
        this.days[0][0].setOpaque(true);
        i = 1;
        while (i < 6) {
            this.days[0][i] = new LabelDia(DAYS[i], 0);
            this.days[0][i].setForeground(WEEK_DAYS_FOREGROUND);
            this.days[0][i].setBackground(WEEK_DAYS_BACKGROUND);
            this.days[0][i].setOpaque(true);
            ++i;
        }
        this.days[0][6] = new LabelDia(DAYS[6], 0);
        this.days[0][6].setForeground(WEEK_DAYS_FOREGROUND);
        this.days[0][6].setBackground(WEEK_DAYS_BACKGROUND);
        this.days[0][6].setOpaque(true);
        i = 1;
        while (i < 7) {
            int j = 0;
            while (j < 7) {
                this.days[i][j] = new LabelDia(" ", 0);
                this.aplicaVisualLabelDias(i, j);
                this.days[i][j].addMouseListener(this);
                ++j;
            }
            ++i;
        }
        this.ok = new JButton("Ok");
        this.ok.addActionListener(this);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        this.buildMonthYearDynamic();
        this.controiDaysPanel();
        this.buttons = new JPanel();
        this.buttons.add(this.ok);
        this.buttons.add(this.cancel);
        this.addComponents(this.monthYear, this.daysPanel, this.buttons);
        this.update();
    }

    private void controiDaysPanel() {
        JPanel daysTitles = new JPanel(new GridLayout(1, 7, 0, 0));
        daysTitles.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, WEEK_DAYS_BACKGROUND));
        int i = 0;
        while (i < 7) {
            daysTitles.add(this.days[0][i]);
            ++i;
        }
        this.daysGrid = new FocusablePanel(new GridLayout(6, 7, 0, 0));
        this.daysGrid.addFocusListener(this);
        this.daysGrid.addKeyListener(this);
        i = 1;
        while (i < 7) {
            int j = 0;
            while (j < 7) {
                this.daysGrid.add(this.days[i][j]);
                ++j;
            }
            ++i;
        }
        this.daysGrid.setBackground(Color.white);
        this.daysPanel = new JPanel(new BorderLayout());
        this.daysPanel.add((Component)daysTitles, "North");
        this.daysPanel.add((Component)this.daysGrid, "Center");
        this.daysPanel.setBorder(BorderFactory.createLoweredBevelBorder());
    }

    private void buildMonthYearDynamic() {
        this.monthYear = new JPanel();
        this.monthYear.setLayout((LayoutManager)new FormLayout("F:P:grow,3dlu,F:P:grow", "P"));
        CellConstraints cc = new CellConstraints();
        this.monthYear.add((Component)this.month, cc.xywh(1, 1, 1, 1));
        this.monthYear.add((Component)this.year, cc.xywh(3, 1, 1, 1));
    }

    private void addComponents(JPanel monthYear, JPanel daysPanel, JPanel buttons) {
        this.add((Component)monthYear, "North");
        this.add((Component)daysPanel, "Center");
    }

    private void readdComponents() {
        this.removeAll();
        this.addComponents(this.monthYear, this.daysPanel, this.buttons);
    }

    private int getSelectedDay() {
        if (this.selectedDays.isEmpty()) {
            return -1;
        }
        try {
            return Integer.parseInt(((JLabel)this.selectedDays.get(0)).getText());
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private int[] getSelectedDays() {
        if (this.selectedDays.isEmpty()) {
            return null;
        }
        try {
            int[] intDays = new int[this.selectedDays.size()];
            Iterator it = this.selectedDays.iterator();
            int i = 0;
            while (it.hasNext()) {
                intDays[i] = Integer.parseInt(((JLabel)it.next()).getText());
                ++i;
            }
            return intDays;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void setSelected(JLabel newDay) {
        newDay.setForeground(this.getCorTextoSelecao());
        newDay.setOpaque(true);
        if (this.daysGrid.hasFocus()) {
            newDay.setBorder(FOCUSED_BORDER);
        }
    }

    private void setSelected(int newDay) {
        this.setSelected(this.getJLabelForDay(newDay));
    }

    private JLabel getJLabelForDay(int newDay) {
        return this.days[(newDay + this.offset - 1) / 7 + 1][(newDay + this.offset - 1) % 7];
    }

    private void update() {
        int iday = this.getSelectedDay();
        int i = 0;
        while (i < 7) {
            this.days[1][i].setText(" ");
            this.days[5][i].setText(" ");
            this.days[6][i].setText(" ");
            ++i;
        }
        this.calendar.set(5, 1);
        this.calendar.set(2, this.month.getSelectedIndex() + 0);
        this.calendar.set(1, this.year.getSelectedIndex() + 1900);
        this.offset = this.calendar.get(7) - 1;
        this.lastDay = this.calendar.getActualMaximum(5);
        i = 0;
        while (i < this.lastDay) {
            this.days[(i + this.offset) / 7 + 1][(i + this.offset) % 7].setText(String.valueOf(i + 1));
            ++i;
        }
        this.monthAndYearTitle.setText(this.month.getSelectedItem() + ", " + this.year.getSelectedItem().toString());
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ok) {
            this.okClicked = true;
        }
    }

    public void focusGained(FocusEvent e) {
        Iterator it = this.selectedDays.iterator();
        while (it.hasNext()) {
            this.setSelected((JLabel)it.next());
        }
    }

    public void focusLost(FocusEvent e) {
        Iterator it = this.selectedDays.iterator();
        while (it.hasNext()) {
            this.setSelected((JLabel)it.next());
        }
    }

    public void itemStateChanged(ItemEvent e) {
        this.deselecionaTodos();
        this.update();
        CalendarioEvent event = new CalendarioEvent(e.getSource());
        event.setMes(this.month.getSelectedIndex());
        event.setAno(this.year.getSelectedIndex() + 1900);
        this.fireMudouMesAno(event);
    }

    public void keyPressed(KeyEvent e) {
        int iday = this.getSelectedDay();
        switch (e.getKeyCode()) {
            case 37: {
                if (iday <= 1) break;
                this.setSelected(iday - 1);
                break;
            }
            case 39: {
                if (iday >= this.lastDay) break;
                this.setSelected(iday + 1);
                break;
            }
            case 38: {
                if (iday <= 7) break;
                this.setSelected(iday - 7);
                break;
            }
            case 40: {
                if (iday > this.lastDay - 7) break;
                this.setSelected(iday + 7);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (this.isSelecaoHabilitada()) {
            JLabel day = (JLabel)e.getSource();
            this.processaSelecao(day);
            CalendarioEvent event = new CalendarioEvent(e.getSource());
            event.setLabelDia(day);
            if (this.selectedDays.contains(day)) {
                this.fireSelecionouDia(event);
            } else {
                this.fireDeselecionouDia(event);
            }
        }
    }

    public void desabilitaDia(int aDia) {
        LabelDia label = (LabelDia)this.getJLabelForDay(aDia);
        this.unselectDay(label);
        this.selectedDays.remove(label);
        label.setHabilitado(false);
        label.setForeground(this.getCorDiaDesabilitado());
    }

    public void desabilitaDia(int aDia, Color background, Color foreground) {
        LabelDia label = (LabelDia)this.getJLabelForDay(aDia);
        this.unselectDay(label);
        this.selectedDays.remove(label);
        label.setHabilitado(false);
        label.setOpaque(true);
        label.setBackground(background);
        label.setForeground(foreground);
    }

    public void habilitaDia(int aDia) {
        LabelDia label = (LabelDia)this.getJLabelForDay(aDia);
        label.setHabilitado(true);
        label.setForeground(DAYS_FOREGROUND);
        label.setBackground(this.getCorSelecao());
        label.setOpaque(false);
    }

    private void processaSelecao(JLabel day) {
        LabelDia lblDia = (LabelDia)day;
        if (!day.getText().equals(" ") && lblDia.isHabilitado()) {
            if (!this.isSelecaoMultipla()) {
                if (!this.selectedDays.isEmpty()) {
                    JLabel oldDay = (JLabel)this.selectedDays.get(0);
                    this.selectedDays.remove(oldDay);
                    this.unselectDay(oldDay);
                }
                this.selectedDays.add(day);
                this.setSelected(day);
            } else if (this.selectedDays.contains(day)) {
                this.selectedDays.remove(day);
                this.unselectDay(day);
            } else {
                LogPPGD.debug((String)("adicionando dia:" + day));
                this.selectedDays.add(day);
                this.setSelected(day);
            }
        }
        this.daysGrid.requestFocus();
    }

    private void unselectDay(JLabel day) {
        day.setForeground(DAYS_FOREGROUND);
        day.setOpaque(false);
        day.setBorder(EMPTY_BORDER);
    }

    public void deselecionaTodos() {
        Iterator it = this.selectedDays.iterator();
        while (it.hasNext()) {
            this.unselectDay((JLabel)it.next());
        }
        this.selectedDays.clear();
        int i = 1;
        while (i < 7) {
            int j = 0;
            while (j < 7) {
                if (!this.days[i][j].isHabilitado()) {
                    this.unselectDay(this.days[i][j]);
                    this.days[i][j].setHabilitado(true);
                }
                ++j;
            }
            ++i;
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public Calendario() {
        this.construct();
    }

    public Date select(Date date) {
        this.calendar.setTime(date);
        int _day = this.calendar.get(5);
        int _month = this.calendar.get(2);
        int _year = this.calendar.get(1);
        this.setAno(_year);
        this.setMes(_month);
        this.setSelected(_day);
        this.okClicked = false;
        this.setVisible(true);
        if (!this.okClicked) {
            return null;
        }
        this.calendar.set(5, this.getSelectedDay());
        this.calendar.set(2, this.month.getSelectedIndex() + 0);
        this.calendar.set(1, this.year.getSelectedIndex() + 1900);
        return this.calendar.getTime();
    }

    public Collection getDatasSelecionadas() {
        ArrayList<Date> lista = new ArrayList<Date>();
        int[] selDays = this.getSelectedDays();
        if (selDays != null) {
            int i = 0;
            while (i < selDays.length) {
                this.calendar.set(5, selDays[i]);
                this.calendar.set(2, this.month.getSelectedIndex() + 0);
                this.calendar.set(1, this.year.getSelectedIndex() + 1900);
                lista.add(this.calendar.getTime());
                ++i;
            }
        }
        return lista;
    }

    public void setDatasSelecionadas(Collection datas) {
        Iterator it = datas.iterator();
        while (it.hasNext()) {
            this.setData((Date)it.next());
        }
    }

    public void setData(Date aDate) {
        this.eventosDesabilitados = true;
        this.calendar.setTime(aDate);
        int _day = this.calendar.get(5);
        int _month = this.calendar.get(2);
        int _year = this.calendar.get(1);
        this.setAno(_year);
        this.setMes(_month);
        this.processaSelecao(this.getJLabelForDay(_day));
        this.eventosDesabilitados = false;
    }

    public void setMes(int aMes) {
        this.eventosDesabilitados = true;
        if (aMes < 0 || aMes > 11) {
            throw new IllegalArgumentException("M\u00eas s\u00f3 vai de 0 a 11");
        }
        this.month.setSelectedIndex(aMes - 0);
        this.eventosDesabilitados = false;
    }

    public int getMes() {
        return this.month.getSelectedIndex() + 0;
    }

    public void setAno(int aAno) {
        this.eventosDesabilitados = true;
        this.year.setSelectedIndex(aAno - 1900);
        this.eventosDesabilitados = false;
    }

    public int getAno() {
        return this.year.getSelectedIndex() + 1900;
    }

    public Date getData() {
        return this.calendar.getTime();
    }

    public Date select(Date date, int pMonth, String pYear) {
        if (date != null) {
            this.calendar.setTime(date);
        } else {
            this.calendar.set(5, 1);
            this.calendar.set(2, pMonth != -1 ? pMonth - 1 : 0);
            this.calendar.set(1, Integer.parseInt(pYear));
        }
        int _day = this.calendar.get(5);
        int _month = this.calendar.get(2);
        int _year = this.calendar.get(1);
        if (pYear != null && pYear.trim().length() > 0) {
            this.year.setSelectedItem(pYear);
            this.year.setEnabled(false);
        } else {
            this.setAno(_year);
            this.year.setEnabled(true);
        }
        if (pMonth != -1) {
            this.month.setSelectedIndex(pMonth);
            this.month.setEnabled(false);
        } else {
            this.setMes(_month);
            this.month.setEnabled(true);
        }
        this.setSelected(_day);
        this.okClicked = false;
        this.setVisible(true);
        if (!this.okClicked) {
            return null;
        }
        this.calendar.set(5, this.getSelectedDay());
        this.calendar.set(2, this.month.getSelectedIndex() + 0);
        this.calendar.set(1, this.year.getSelectedIndex() + 1900);
        return this.calendar.getTime();
    }

    public Date select() {
        return this.select(new Date());
    }

    public JComboBox getSeletorMes() {
        return this.month;
    }

    public JComboBox getSeletorAno() {
        return this.year;
    }

    public JLabel getLabelMesAno() {
        return this.monthAndYearTitle;
    }

    public void setDataFixa(boolean staticView) {
        this.dataFixa = staticView;
        if (this.isDataFixa()) {
            this.buildMonthYearStatic();
            this.readdComponents();
        } else {
            this.buildMonthYearDynamic();
            this.readdComponents();
        }
    }

    public void setAnoFixo(boolean staticView) {
        this.anoFixo = staticView;
        if (this.isDataFixa()) {
            this.buildMonthYearStatic();
            this.readdComponents();
        } else {
            this.buildMonthYearDynamic();
            this.readdComponents();
        }
    }

    public boolean isDataFixa() {
        return this.dataFixa;
    }

    public void setSelecaoMultipla(boolean multiSelection) {
        this.selecaoMultipla = multiSelection;
        this.deselecionaTodos();
    }

    public boolean isSelecaoMultipla() {
        return this.selecaoMultipla;
    }

    public void setCorSelecao(Color corSelecao) {
        this.corSelecao = corSelecao;
        this.deselecionaTodos();
        int i = 1;
        while (i < 7) {
            int j = 0;
            while (j < 7) {
                this.aplicaVisualLabelDias(i, j);
                ++j;
            }
            ++i;
        }
    }

    public Color getCorSelecao() {
        return this.corSelecao;
    }

    private void fireSelecionouDia(CalendarioEvent evt) {
        if (!this.eventosDesabilitados) {
            Object[] listeners = this.listenersCalendario.getListenerList();
            int i = 0;
            while (i < listeners.length) {
                if (listeners[i] == CalendarioListener.class) {
                    ((CalendarioListener)listeners[i + 1]).marcouDia(evt);
                }
                i += 2;
            }
        }
    }

    private void fireDeselecionouDia(CalendarioEvent evt) {
        if (!this.eventosDesabilitados) {
            Object[] listeners = this.listenersCalendario.getListenerList();
            int i = 0;
            while (i < listeners.length) {
                if (listeners[i] == CalendarioListener.class) {
                    ((CalendarioListener)listeners[i + 1]).desmarcouDia(evt);
                }
                i += 2;
            }
        }
    }

    private void fireMudouMesAno(CalendarioEvent event) {
        if (!this.eventosDesabilitados) {
            Object[] listeners = this.listenersCalendario.getListenerList();
            int i = 0;
            while (i < listeners.length) {
                if (listeners[i] == CalendarioListener.class) {
                    ((CalendarioListener)listeners[i + 1]).mudouMesAno(event);
                }
                i += 2;
            }
        }
    }

    public static void main(String[] args) {
        UIDefaults uiDefaults = UIManager.getDefaults();
        Enumeration enum2 = uiDefaults.keys();
        while (enum2.hasMoreElements()) {
            Object key = enum2.nextElement();
            Object val = uiDefaults.get(key);
            System.out.println(key.toString());
        }
    }

    public void setCorDiaDesabilitado(Color corDiaDesabilitado) {
        this.corDiaDesabilitado = corDiaDesabilitado;
    }

    public Color getCorDiaDesabilitado() {
        return this.corDiaDesabilitado;
    }

    public void setCorTextoSelecao(Color corTextoSelecao) {
        this.corTextoSelecao = corTextoSelecao;
        this.deselecionaTodos();
        int i = 1;
        while (i < 7) {
            int j = 0;
            while (j < 7) {
                this.aplicaVisualLabelDias(i, j);
                ++j;
            }
            ++i;
        }
    }

    public Color getCorTextoSelecao() {
        return this.corTextoSelecao;
    }

    public void setSelecaoHabilitada(boolean selecaoHabilitada) {
        this.selecaoHabilitada = selecaoHabilitada;
    }

    public boolean isSelecaoHabilitada() {
        return this.selecaoHabilitada;
    }

    private static class FocusablePanel
    extends JPanel {
        public FocusablePanel(LayoutManager layout) {
            super(layout);
        }

        public boolean isFocusTraversable() {
            return true;
        }
    }

    private class LabelDia
    extends JLabel {
        private boolean habilitado;

        public LabelDia() {
            this.habilitado = true;
        }

        public LabelDia(String desc, int align) {
            super(desc, align);
            this.habilitado = true;
        }

        public void setHabilitado(boolean habilitado) {
            this.habilitado = habilitado;
        }

        public boolean isHabilitado() {
            return this.habilitado;
        }
    }
}

