/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ItemOpcao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.ValidadorImpeditivoDefault;
import serpro.ppgd.negocio.ValidadorImpeditivoOpcao;
import serpro.ppgd.negocio.util.LogPPGD;

public class Opcao
extends Informacao {
    private String conteudo = "";
    private String C_DELIMITADOR_OPCOES = ";";
    public static String SIM = "1";
    public static String NAO = "0";
    public static String LABEL_SIM = "Sim";
    public static String LABEL_NAO = "N\u00e3o";
    public boolean selecaoMultipla = true;
    private Map<String, ItemOpcao> opcoes;
    private LinkedList<ItemOpcao> listaOrdenada;
    private List<ValidadorIf> listaValidadoresImpeditivosTemporaria;

    public Opcao() {
        super("");
    }

    @Override
    public void addValidador(ValidadorIf validador) {
        if (validador instanceof ValidadorImpeditivoDefault && !(validador instanceof ValidadorImpeditivoOpcao)) {
            throw new IllegalArgumentException("O Validador adicionado n\u00e3o \u00e9 do tipo ValidadorImpeditivoOpcao.\n Fa\u00e7a com que esse herde de ValidadorImpeditivoOpcao.");
        }
        super.addValidador(validador);
    }

    public void atualizaListaValidadoresImpeditivos(String proximaOpcao) {
        ArrayList<ValidadorImpeditivoOpcao> lista = new ArrayList<ValidadorImpeditivoOpcao>(super.getListaValidadoresImpeditivos().size());
        for (ValidadorImpeditivoOpcao validadorImpeditivoOpcao : super.getListaValidadoresImpeditivos()) {
            if (validadorImpeditivoOpcao.getValorCodigoOpcao().trim().equals("") || !this.getOpcoes().containsKey(validadorImpeditivoOpcao.getValorCodigoOpcao().trim()) || !proximaOpcao.equals(validadorImpeditivoOpcao.getValorCodigoOpcao())) continue;
            lista.add(validadorImpeditivoOpcao);
        }
        this.getListaValidadoresImpeditivos().clear();
        this.getListaValidadoresImpeditivos().addAll(lista);
    }

    @Override
    public void ordenaListaValidadoreImpeditivos() {
        LinkedList<ValidadorImpeditivoDefault> retorno = new LinkedList<ValidadorImpeditivoDefault>();
        for (ValidadorImpeditivoDefault validadorImpeditivoDefault : this.getListaValidadoresImpeditivos()) {
            if (validadorImpeditivoDefault.getSeveridade() == 5) {
                retorno.addFirst(validadorImpeditivoDefault);
                continue;
            }
            if (validadorImpeditivoDefault.getSeveridade() != 4) continue;
            retorno.addLast(validadorImpeditivoDefault);
        }
        this.getListaValidadoresImpeditivos().clear();
        this.getListaValidadoresImpeditivos().addAll(retorno);
    }

    @Override
    public List<ValidadorIf> getListaValidadoresImpeditivos() {
        if (this.listaValidadoresImpeditivosTemporaria == null) {
            this.listaValidadoresImpeditivosTemporaria = new ArrayList<ValidadorIf>(5);
        }
        return this.listaValidadoresImpeditivosTemporaria;
    }

    public void adicionaOpcao(String codigo, String descricao) {
        if (this.getOpcoes().containsKey(codigo)) {
            this.getListaOrdenada().remove(this.getOpcoes().get(codigo));
        }
        ItemOpcao o = new ItemOpcao(codigo, descricao);
        this.getOpcoes().put(codigo, o);
        this.getListaOrdenada().addLast(o);
    }

    public void adicionaOpcao(String codigo, String descricao, boolean selecionado) {
        if (this.getOpcoes().containsKey(codigo)) {
            this.getListaOrdenada().remove(this.getOpcoes().get(codigo));
        }
        ItemOpcao o = new ItemOpcao(codigo, descricao, selecionado);
        this.getOpcoes().put(codigo, o);
        this.getListaOrdenada().addLast(o);
    }

    public void addOpcao(String codigo, String descricao, boolean selecionado) {
        if (this.getOpcoes().containsKey(codigo)) {
            this.getListaOrdenada().remove(this.getOpcoes().get(codigo));
        }
        ItemOpcao o = new ItemOpcao(codigo, descricao, selecionado);
        this.getOpcoes().put(codigo, o);
        this.getListaOrdenada().addLast(o);
    }

    public String getDescricaoOpcao(String valor) {
        if (this.getOpcoes().containsKey(valor)) {
            return this.getOpcoes().get(valor).getDescricao();
        }
        return "";
    }

    public String getCodigoOpcao(String descricao) {
        String retorno = "";
        for (ItemOpcao o : this.getOpcoes().values()) {
            if (!o.getDescricao().trim().equals(descricao.trim())) continue;
            return o.getCodigo();
        }
        return retorno;
    }

    public String getDescricaoOpcoes() {
        Iterator<ItemOpcao> it = this.getOpcoes().values().iterator();
        String result = "";
        while (it.hasNext()) {
            ItemOpcao o = it.next();
            if (!o.isSelecionado()) continue;
            if (result.equals("")) {
                result = result + o.getDescricao();
                continue;
            }
            result = result + this.C_DELIMITADOR_OPCOES + o.getDescricao();
        }
        return result;
    }

    public String getCodigoOpcoes() {
        Iterator<ItemOpcao> it = this.getOpcoes().values().iterator();
        String result = "";
        while (it.hasNext()) {
            ItemOpcao o = it.next();
            if (!o.isSelecionado()) continue;
            if (result.equals("")) {
                result = result + o.getCodigo();
                continue;
            }
            result = result + this.C_DELIMITADOR_OPCOES + o.getCodigo();
        }
        return result;
    }

    public Opcao(ObjetoNegocio owner, String nomeCampo) {
        super(owner, nomeCampo);
    }

    public Opcao(ObjetoNegocio owner, String nomeCampo, List<ElementoTabela> listaOpcoes) {
        super(owner, nomeCampo);
        for (int i = 0; i < listaOpcoes.size(); ++i) {
            this.adicionaOpcao(listaOpcoes.get(i).getConteudo(0), listaOpcoes.get(i).getConteudo(1));
        }
    }

    public void converteEmTipoSimNao(String descricao, boolean selecionado, String valorInicial) {
        this.adicionaOpcao(LABEL_SIM, descricao, selecionado);
        this.setConteudo(valorInicial);
    }

    @Override
    public void clear() {
        this.setConteudo("");
    }

    @Override
    public String asString() {
        Iterator<ItemOpcao> it = this.getOpcoes().values().iterator();
        String result = "";
        while (it.hasNext()) {
            ItemOpcao o = it.next();
            if (!o.isSelecionado()) continue;
            if (result.equals("")) {
                result = result + o.getCodigo();
                continue;
            }
            result = result + this.C_DELIMITADOR_OPCOES + o.getCodigo();
        }
        return result;
    }

    @Override
    public String getConteudoFormatado() {
        return this.asString();
    }

    public String getConteudo() {
        return this.asString();
    }

    @Override
    public void setConteudo(String codigos) {
        LogPPGD.debug("Atribui\u00e7\u00e3o: " + this.getNomeCampo() + " = " + String.valueOf(this.conteudo));
        String antigo = this.conteudo;
        this.clearRetornosValidacoes();
        List<String> listCodigos = Opcao.getListByString(codigos, this.C_DELIMITADOR_OPCOES);
        this.conteudo = codigos;
        for (ItemOpcao o : this.getOpcoes().values()) {
            o.setSelecionado(listCodigos.contains(o.getCodigo().trim()));
        }
        if (this.isVazio()) {
            this.getObservadores().firePropertyChange(this.getNomeCampo(), "_", "");
        } else {
            this.disparaObservadores(antigo);
        }
    }

    public void addSelectedItem(String codigo) {
        LogPPGD.debug("Atribui\u00e7\u00e3o: " + this.getNomeCampo() + " = " + String.valueOf(this.conteudo));
        if (!this.isSelecaoMultipla()) {
            this.setConteudo("");
        }
        ItemOpcao item = this.getOpcoes().get(codigo);
        item.setSelecionado(true);
        this.setConteudo(this.getCodigoOpcoes());
    }

    public void delSelectedItem(String codigo) {
        LogPPGD.debug("Atribui\u00e7\u00e3o: " + this.getNomeCampo() + " = " + String.valueOf(this.conteudo));
        ItemOpcao item = this.getOpcoes().get(codigo);
        item.setSelecionado(false);
        this.setConteudo(this.getCodigoOpcoes());
    }

    @Override
    public boolean isVazio() {
        return this.asString() == null || this.asString().trim().length() == 0;
    }

    public Map<String, ItemOpcao> getOpcoes() {
        if (this.opcoes == null) {
            this.opcoes = new Hashtable<String, ItemOpcao>();
        }
        return this.opcoes;
    }

    public void setOpcoes(Map<String, ItemOpcao> opcoes) {
        this.opcoes = opcoes;
    }

    public LinkedList<ItemOpcao> getListaOrdenada() {
        if (this.listaOrdenada == null) {
            this.listaOrdenada = new LinkedList();
        }
        return this.listaOrdenada;
    }

    public boolean isSelecaoMultipla() {
        return this.selecaoMultipla;
    }

    public void setSelecaoMultipla(boolean selecaoMultipla) {
        this.selecaoMultipla = selecaoMultipla;
    }

    public static List<String> getListByString(String valor, String delimitador) {
        int v_idx = 1;
        String valorFragmentado = null;
        String valorTemporario = null;
        ArrayList<String> result = new ArrayList<String>(5);
        valorTemporario = valor;
        while (v_idx > 0) {
            v_idx = valorTemporario.indexOf(delimitador);
            valorFragmentado = v_idx >= 0 ? valorTemporario.substring(0, v_idx) : valorTemporario;
            result.add(valorFragmentado);
            valorTemporario = valorTemporario.substring(v_idx + delimitador.length(), valorTemporario.length());
        }
        return result;
    }
}

