/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.RetornosValidacoes;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.util.TabelaMensagens;

public abstract class ValidadorDefault
implements ValidadorIf {
    private Informacao informacao;
    private Object parValidacao;
    private RetornosValidacoes retornosValidacoes;
    private byte severidade;
    private boolean verificaVazio = false;
    private boolean validadorAtivo = true;
    private String mensagemValidacao = "";
    private boolean exibePopup = false;
    protected static TabelaMensagens tab = TabelaMensagens.getTabelaMensagens();

    public ValidadorDefault(byte severidade) {
        this.severidade = severidade;
    }

    @Override
    public void setInformacao(Informacao informacao) {
        if (informacao == null) {
            throw new IllegalArgumentException("Informacao \u00e9 null");
        }
        this.informacao = informacao;
    }

    protected Informacao getInformacao() {
        return this.informacao;
    }

    @Override
    public void setParValidacao(Object parValidacao) {
        this.parValidacao = parValidacao;
    }

    protected Object getParValidacao() {
        return this.parValidacao;
    }

    @Override
    public void setRetornosValidacoes(RetornosValidacoes lista) {
        if (lista == null) {
            throw new IllegalArgumentException("RetornosValidacoes \u00e9 null");
        }
        this.retornosValidacoes = lista;
    }

    protected RetornosValidacoes getRetornosValidacoes() {
        return this.retornosValidacoes;
    }

    public void setSeveridade(byte severidade) {
        this.severidade = severidade;
    }

    public byte getSeveridade() {
        return this.severidade;
    }

    public abstract RetornoValidacao validarImplementado();

    @Override
    public void validar() {
        if (!this.isValidadorAtivo()) {
            return;
        }
        if (!this.isVerificaVazio() && this.getInformacao().isVazio()) {
            return;
        }
        RetornoValidacao ret = this.validarImplementado();
        if (ret != null) {
            if (ret.getSeveridade() > 0) {
                ret.setSeveridade(this.getSeveridade());
            }
            if (!this.getMensagemValidacao().trim().equals("")) {
                ret.setMensagemValidacao(this.getMensagemValidacao());
            }
            ret.setExibePopup(this.isExibePopup());
            this.getRetornosValidacoes().add(ret);
        } else {
            this.getRetornosValidacoes().add(new RetornoValidacao(0));
        }
    }

    public void setVerificaVazio(boolean b) {
        this.verificaVazio = b;
    }

    public boolean isVerificaVazio() {
        return this.verificaVazio;
    }

    @Override
    public boolean isValidadorAtivo() {
        return this.validadorAtivo;
    }

    @Override
    public void setValidadorAtivo(boolean validadorAtivo) {
        this.validadorAtivo = validadorAtivo;
    }

    public String getMensagemValidacao() {
        return this.mensagemValidacao;
    }

    public void setMensagemValidacao(String string) {
        this.mensagemValidacao = string;
    }

    public boolean isExibePopup() {
        return this.exibePopup;
    }

    public void setExibePopup(boolean exibePopup) {
        this.exibePopup = exibePopup;
    }
}

