/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio.interpretador;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.interpretador.InstanciadorOperacoes;
import serpro.ppgd.negocio.interpretador.OperadorMatematico;
import serpro.ppgd.negocio.util.FabricaUtilitarios;

public class InterpretadorOperacoes {
    private Map<String, ObservadorGeral> observadores;
    private List<OperadorMatematico> operacoes;
    private String xmlOperacoes;
    private ObjetoNegocio instanciaObjetoNegocio;
    private Integer bitObservadorAtivo;
    private static Map<String, Document> xmlsCarregados;

    public InterpretadorOperacoes(ObjetoNegocio pObj, String pXmlOperacoes) {
        this.xmlOperacoes = pXmlOperacoes;
        this.instanciaObjetoNegocio = pObj;
        InstanciadorOperacoes.getInstance().instanciaOperacao(this);
    }

    private synchronized Document obtemDocumento(String xmlOperacoes) {
        Document definicoes = null;
        if (!InterpretadorOperacoes.getXmlsCarregados().containsKey(xmlOperacoes)) {
            definicoes = FabricaUtilitarios.carregarDOM(xmlOperacoes);
            InterpretadorOperacoes.getXmlsCarregados().put(xmlOperacoes, definicoes);
        } else {
            definicoes = InterpretadorOperacoes.getXmlsCarregados().get(xmlOperacoes);
        }
        return definicoes;
    }

    public void traduzXML() {
        Document definicoes = this.obtemDocumento(this.xmlOperacoes);
        Element raiz = definicoes.getDocumentElement();
        if (raiz.hasChildNodes()) {
            NodeList filhos = raiz.getChildNodes();
            for (int i = 0; i < filhos.getLength(); ++i) {
                Element elementFilho;
                if (filhos.item(i).getNodeType() != 1 || !(elementFilho = (Element)filhos.item(i)).getNodeName().trim().equalsIgnoreCase("operacao")) continue;
                this.carregaOperacao(elementFilho);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void carregaOperacao(Element nodoOperacao) {
        Map<String, String> atributos = this.carregaIdApelidos(nodoOperacao);
        String identificador = nodoOperacao.getAttribute("identificador");
        String receptor = nodoOperacao.getAttribute("receptor");
        String strOperacao = null;
        for (int n = 0; n < nodoOperacao.getChildNodes().getLength() - 1; ++n) {
            if (nodoOperacao.getChildNodes().item(n).getNodeType() != 4) continue;
            strOperacao = nodoOperacao.getChildNodes().item(n).getNodeValue();
            n = nodoOperacao.getChildNodes().getLength() + 1;
        }
        strOperacao = strOperacao.replaceAll("\n", " ");
        strOperacao = strOperacao.replaceAll("\t", " ");
        if (identificador == null || identificador.trim().length() == 0) {
            identificador = "todos";
        }
        OperadorMatematico operacao = new OperadorMatematico(strOperacao, this.instanciaObjetoNegocio, atributos, receptor, identificador, this.getObservador(identificador));
        Integer n = this.bitObservadorAtivo;
        synchronized (n) {
            this.getOperacoes().add(operacao);
        }
        operacao.atualiza();
    }

    private PropertyChangeListener getObservador(String nome) {
        if (!this.getObservadores().containsKey(nome)) {
            this.getObservadores().put(nome, new ObservadorGeral(nome));
        }
        return this.getObservadores().get(nome);
    }

    private Map<String, String> carregaIdApelidos(Element nodoOperacao) {
        Hashtable<String, String> atributos = new Hashtable<String, String>();
        if (nodoOperacao.hasChildNodes()) {
            NodeList filhos = nodoOperacao.getChildNodes();
            for (int i = 0; i < filhos.getLength(); ++i) {
                Element elementFilho;
                if (filhos.item(i).getNodeType() != 1 || !(elementFilho = (Element)filhos.item(i)).getNodeName().trim().equalsIgnoreCase("atributo")) continue;
                String acesso = elementFilho.getAttribute("conteudo");
                String apelido = elementFilho.getAttribute("id");
                if (apelido == null || apelido.trim().length() == 0) {
                    apelido = acesso;
                }
                atributos.put(apelido, acesso);
            }
        }
        return atributos;
    }

    private Map insereObservadoresOutrosAtributos(Element nodoOperacao) {
        Hashtable atributos = new Hashtable();
        if (nodoOperacao.hasChildNodes()) {
            NodeList filhos = nodoOperacao.getChildNodes();
            for (int i = 0; i < filhos.getLength(); ++i) {
                String atributo;
                Element elementFilho;
                if (filhos.item(i).getNodeType() != 1 || !(elementFilho = (Element)filhos.item(i)).getNodeName().trim().equalsIgnoreCase("observador") || (atributo = elementFilho.getAttribute("atributo")) == null || atributo.trim().length() == 0) continue;
                Informacao info = (Informacao)FabricaUtilitarios.obtemAtributo(this.instanciaObjetoNegocio, atributo);
                String identificador = nodoOperacao.getAttribute("identificador");
                if (identificador == null || identificador.trim().length() == 0) {
                    identificador = "todos";
                }
                info.getObservadores().addPropertyChangeListener(this.getObservador(identificador));
            }
        }
        return atributos;
    }

    private List<OperadorMatematico> getOperacoes() {
        if (this.operacoes == null) {
            this.operacoes = new ArrayList<OperadorMatematico>(5);
        }
        return this.operacoes;
    }

    public Map<String, ObservadorGeral> getObservadores() {
        if (this.observadores == null) {
            this.observadores = new Hashtable<String, ObservadorGeral>();
        }
        return this.observadores;
    }

    public static Map<String, Document> getXmlsCarregados() {
        if (xmlsCarregados == null) {
            xmlsCarregados = new Hashtable<String, Document>();
        }
        return xmlsCarregados;
    }

    class ObservadorGeral
    implements PropertyChangeListener {
        private String identificador = null;
        private boolean ativo = true;

        public ObservadorGeral(String pIdentificador) {
            this.identificador = pIdentificador;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.atualizacao();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void atualizacao() {
            if (!this.ativo) {
                return;
            }
            Integer n = InterpretadorOperacoes.this.bitObservadorAtivo;
            synchronized (n) {
                this.ativo = false;
                for (OperadorMatematico op : InterpretadorOperacoes.this.getOperacoes()) {
                    if (!op.getIdentificador().equals("todos") && !op.getIdentificador().equals(this.identificador)) continue;
                    op.atualiza();
                }
                this.ativo = true;
            }
        }

        public boolean equals(Object o) {
            if (o instanceof ObservadorGeral) {
                ObservadorGeral outro = (ObservadorGeral)o;
                return outro.getIdentificador().equals(this.getIdentificador());
            }
            return super.equals(o);
        }

        public String getIdentificador() {
            return this.identificador;
        }
    }
}

