/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.draw;

import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.export.draw.ElementDrawer;

public class EllipseDrawer
extends ElementDrawer {
    public void draw(Graphics2D grx, JRPrintElement element, int offsetX, int offsetY) {
        JRPrintEllipse ellipse = (JRPrintEllipse)element;
        if (ellipse.getMode() == 1) {
            grx.setColor(ellipse.getBackcolor());
            grx.fillOval(ellipse.getX() + offsetX, ellipse.getY() + offsetY, ellipse.getWidth(), ellipse.getHeight());
        }
        grx.setColor(ellipse.getLinePen().getLineColor());
        Stroke stroke = EllipseDrawer.getStroke(ellipse.getLinePen());
        if (stroke != null) {
            AffineTransform transform = grx.getTransform();
            grx.translate(ellipse.getX() + offsetX, ellipse.getY() + offsetY);
            grx.setStroke(stroke);
            grx.drawOval(0, 0, ellipse.getWidth(), ellipse.getHeight());
            grx.setTransform(transform);
        }
    }
}

