// n-gram memory pool 
// by M. Federico
// Copyright Marcello Federico, ITC-irst, 2004


#ifndef MF_NGRAMPOOL_H
#define MF_NGRAMPOOL_H

#define NGPOOL_MAXNGRAM   4  // 4-grams
#define NGPOOL_HEADERSIZE 1  // 1 byte

#define NGPOOL_MAXSIZE NGPOOL_MAXNGRAM * CODESIZE+NGPOOL_HEADERSIZE


//! Memory structure to store n-grams
/*! which can be access by an address
*/

class ngrampool{

  storage*         mem; //!< memory storage class
  dictionary*     dict; //!< private dictionary
  htable*           ht; //!< private hash table

 public:

  ngrampool(dictionary* d);
  
  char* put(ngram);
  
  int get(char* address,ngram &ng);

  void stat(){
    mem->stat();
  };

  ~ngrampool(){
    delete mem;
    delete dict;
    delete ht;
  };
};

#endif
