/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.jalbum.editor.JFindDialog;
import net.jalbum.editor.JTextPadDocument;
import net.jalbum.editor.Main;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.DefaultCompletionProvider;
import org.fife.ui.autocomplete.MarkupTagCompletion;
import org.fife.ui.autocomplete.VariableCompletion;
import org.fife.ui.rtextarea.SearchEngine;
import se.datadosen.component.JStackLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTextPad
extends JFrame {
    public static final String APP_NAME = "jAlbum Textpad";
    public static final String VERSION = "2.2";
    static final int menuShortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private static JTextPad instance;
    static LinkedList<JTextPad> editors;
    private List<JTextPadDocument> documents = new ArrayList<JTextPadDocument>();
    private JTabbedPane tabs = new JTabbedPane();
    private DefaultCompletionProvider provider = new DefaultCompletionProvider(){

        protected boolean isValidChar(char ch) {
            if (ch == ':') {
                return true;
            }
            return super.isValidChar(ch);
        }
    };
    public static Map<String, String> fileTypes;
    static KeyStroke ctrlPgUp;
    static KeyStroke ctrlPgDown;
    Action previousDocumentAction = new AbstractAction("Previous document"){
        {
            this.putValue("AcceleratorKey", ctrlPgUp);
        }

        public void actionPerformed(ActionEvent e) {
            int index = JTextPad.this.tabs.getSelectedIndex();
            if (index > 0) {
                JTextPad.this.tabs.setSelectedIndex(index - 1);
            }
        }
    };
    Action nextDocumentAction = new AbstractAction("Next document"){
        {
            this.putValue("AcceleratorKey", ctrlPgDown);
        }

        public void actionPerformed(ActionEvent e) {
            int index = JTextPad.this.tabs.getSelectedIndex();
            if (index < JTextPad.this.tabs.getTabCount() - 1) {
                JTextPad.this.tabs.setSelectedIndex(index + 1);
            }
        }
    };
    Action saveAllAction = new AbstractAction("Save All"){
        {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, menuShortcutKeyMask | 0x200));
        }

        public void actionPerformed(ActionEvent e) {
            for (JTextPadDocument document : JTextPad.this.documents) {
                document.saveAction.actionPerformed(null);
            }
        }
    };
    Action findAction = new AbstractAction("Find..."){
        {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, menuShortcutKeyMask));
        }

        public void actionPerformed(ActionEvent e) {
            JTextPad.this.findDialog.setMode(JFindDialog.Mode.find);
            JTextPad.this.findDialog.setVisible(true);
        }
    };
    Action replaceAction = new AbstractAction("Replace..."){
        {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, menuShortcutKeyMask));
        }

        public void actionPerformed(ActionEvent e) {
            JTextPad.this.findDialog.setMode(JFindDialog.Mode.replace);
            JTextPad.this.findDialog.setVisible(true);
        }
    };
    Action findNextAction = new AbstractAction("Find Next"){
        {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(114, 0));
        }

        public void actionPerformed(ActionEvent e) {
            if (((JTextPad)JTextPad.this).findDialog.toFind.getText().length() == 0) {
                JTextPad.this.findAction.actionPerformed(e);
            } else {
                boolean found = false;
                boolean up = ((JTextPad)JTextPad.this).findDialog.up.isSelected();
                JTextPadDocument document = JTextPad.this.getCurrentDocument();
                do {
                    int oldCaretPosition = document.getTextArea().getCaretPosition();
                    if (document != JTextPad.this.getCurrentDocument()) {
                        document.getTextArea().setCaretPosition(up ? document.getTextArea().getDocument().getLength() : 0);
                    }
                    if (found = SearchEngine.find(document.getTextArea(), ((JTextPad)JTextPad.this).findDialog.toFind.getText(), ((JTextPad)JTextPad.this).findDialog.down.isSelected(), ((JTextPad)JTextPad.this).findDialog.matchCase.isSelected(), ((JTextPad)JTextPad.this).findDialog.wholeWords.isSelected(), ((JTextPad)JTextPad.this).findDialog.regExp.isSelected())) {
                        if (document != JTextPad.this.getCurrentDocument()) {
                            JTextPad.this.setCurrentDocument(document);
                        }
                        return;
                    }
                    document.getTextArea().setCaretPosition(oldCaretPosition);
                } while (((JTextPad)JTextPad.this).findDialog.allDocuments.isSelected() && (document = JTextPad.this.getAdjacentDocument(document, up)) != null);
                if (!found) {
                    JTextPad.this.getStatusBar().setText("Search passed the end of file");
                }
            }
        }
    };
    Action replaceNextAction = new AbstractAction("Replace Next"){

        public void actionPerformed(ActionEvent e) {
            if (((JTextPad)JTextPad.this).findDialog.toFind.getText().length() == 0) {
                JTextPad.this.findAction.actionPerformed(e);
            } else {
                boolean found = false;
                boolean up = ((JTextPad)JTextPad.this).findDialog.up.isSelected();
                JTextPadDocument document = JTextPad.this.getCurrentDocument();
                do {
                    int oldCaretPosition = document.getTextArea().getCaretPosition();
                    if (document != JTextPad.this.getCurrentDocument()) {
                        document.getTextArea().setCaretPosition(up ? document.getTextArea().getDocument().getLength() : 0);
                    }
                    if (found = SearchEngine.replace(document.getTextArea(), ((JTextPad)JTextPad.this).findDialog.toFind.getText(), ((JTextPad)JTextPad.this).findDialog.replaceWith.getText(), ((JTextPad)JTextPad.this).findDialog.down.isSelected(), ((JTextPad)JTextPad.this).findDialog.matchCase.isSelected(), ((JTextPad)JTextPad.this).findDialog.wholeWords.isSelected(), ((JTextPad)JTextPad.this).findDialog.regExp.isSelected())) {
                        if (document != JTextPad.this.getCurrentDocument()) {
                            JTextPad.this.setCurrentDocument(document);
                        }
                        return;
                    }
                    document.getTextArea().setCaretPosition(oldCaretPosition);
                } while (((JTextPad)JTextPad.this).findDialog.allDocuments.isSelected() && (document = JTextPad.this.getAdjacentDocument(document, up)) != null);
                if (!found) {
                    JTextPad.this.getStatusBar().setText("Search passed the end of file");
                }
            }
        }
    };
    Action replaceAllAction = new AbstractAction("Replace All"){

        public void actionPerformed(ActionEvent e) {
            if (((JTextPad)JTextPad.this).findDialog.toFind.getText().length() == 0) {
                return;
            }
            LinkedList<JTextPadDocument> docs = new LinkedList<JTextPadDocument>();
            if (((JTextPad)JTextPad.this).findDialog.allDocuments.isSelected()) {
                docs.addAll(JTextPad.this.documents);
            } else {
                docs.add(JTextPad.this.getCurrentDocument());
            }
            int total = 0;
            int nDocs = 0;
            for (JTextPadDocument document : docs) {
                int count = SearchEngine.replaceAll(document.getTextArea(), ((JTextPad)JTextPad.this).findDialog.toFind.getText(), ((JTextPad)JTextPad.this).findDialog.replaceWith.getText(), ((JTextPad)JTextPad.this).findDialog.matchCase.isSelected(), ((JTextPad)JTextPad.this).findDialog.wholeWords.isSelected(), ((JTextPad)JTextPad.this).findDialog.regExp.isSelected());
                total += count;
                if (count <= 0) continue;
                ++nDocs;
            }
            JTextPad.this.getStatusBar().setText("" + total + " occurences of " + ((JTextPad)JTextPad.this).findDialog.toFind.getText() + " in " + nDocs + " documents replaced");
        }
    };
    Action exitAction = new AbstractAction("Exit"){
        {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(81, menuShortcutKeyMask));
        }

        public void actionPerformed(ActionEvent e) {
            JTextPad.this.saveWindowLocation();
            JTextPad.this.setVisible(false);
            ArrayList docsClone = new ArrayList(JTextPad.this.documents);
            for (JTextPadDocument document : docsClone) {
                JTextPad.this.closeDocument(document, true);
            }
            editors.remove(JTextPad.this);
            if (Main.runsStandalone && editors.size() == 0) {
                System.exit(0);
            } else {
                JTextPad.this.setVisible(false);
            }
        }
    };
    private JFindDialog findDialog = new JFindDialog(this);

    CompletionProvider getCompletionProvider() {
        return this.provider;
    }

    public static JTextPad getInstance() {
        if (instance == null) {
            instance = new JTextPad();
        }
        return instance;
    }

    public static JTextPad getLastUsedInstance() {
        if (editors.size() == 0) {
            return JTextPad.getInstance();
        }
        return editors.getFirst();
    }

    public JTextPad() {
        this.init();
    }

    public JTextPad(File workingFile) {
        this.init();
        this.openDocument(workingFile);
    }

    public File getCurrentFile() {
        JTextPadDocument doc = this.getCurrentDocument();
        return doc != null ? doc.getFile() : null;
    }

    public JTextPadDocument getCurrentDocument() {
        return (JTextPadDocument)this.tabs.getSelectedComponent();
    }

    List<JTextPadDocument> getDocuments() {
        return this.documents;
    }

    public void setCurrentDocument(JTextPadDocument document) {
        this.tabs.setSelectedComponent(document);
        document.getTextArea().requestFocusInWindow();
    }

    public JTextPadDocument getOpenDocumentFor(File f) {
        for (JTextPadDocument d : this.documents) {
            if (!f.equals(d.getFile())) continue;
            return d;
        }
        return null;
    }

    public JTextPadDocument openDocument(File f) {
        JTextPadDocument document;
        if (f != null && (document = this.getOpenDocumentFor(f)) != null) {
            return document;
        }
        document = new JTextPadDocument(this, f);
        this.tabs.addTab(null, document);
        this.tabs.setTabComponentAt(this.tabs.getTabCount() - 1, document.getTabComponent());
        if (document.getFile() != null) {
            this.tabs.setToolTipTextAt(this.tabs.getTabCount() - 1, document.getFile().getAbsolutePath());
        }
        this.documents.add(document);
        if (this.documents.size() == 1) {
            this.setVisible(true);
            document.getTextArea().requestFocusInWindow();
        } else {
            this.toFront();
        }
        return document;
    }

    public void closeDocument(JTextPadDocument document) {
        this.closeDocument(document, false);
    }

    private void saveWindowLocation() {
        Preferences prefs = Preferences.userNodeForPackage(JTextPad.class);
        Rectangle bounds = this.getBounds();
        prefs.putInt("windowX", bounds.x);
        prefs.putInt("windowY", bounds.y);
        prefs.putInt("windowWidth", bounds.width);
        prefs.putInt("windowHeight", bounds.height);
    }

    private void loadWindowLocation() {
        Preferences prefs = Preferences.userNodeForPackage(JTextPad.class);
        Dimension size = new Dimension(prefs.getInt("windowWidth", 800), prefs.getInt("windowHeight", 600));
        this.setSize(size);
        Point location = new Point(prefs.getInt("windowX", -1), prefs.getInt("windowY", -1));
        if (location.x > 0) {
            this.setLocation(location);
        } else {
            this.setLocationRelativeTo(null);
        }
    }

    private JTextPadDocument getAdjacentDocument(JTextPadDocument document, boolean previous) {
        int index = this.tabs.indexOfComponent(document);
        if (previous) {
            if (index > 0) {
                return (JTextPadDocument)this.tabs.getComponentAt(index - 1);
            }
        } else if (index < this.tabs.getTabCount() - 1) {
            return (JTextPadDocument)this.tabs.getComponentAt(index + 1);
        }
        return null;
    }

    void closeDocument(JTextPadDocument document, boolean inExit) {
        document.ensureNoLoss();
        this.tabs.removeTabAt(this.tabs.indexOfComponent(document));
        this.documents.remove(document);
        if (this.documents.size() == 0 && !inExit) {
            this.exitAction.actionPerformed(null);
        }
    }

    private JStackLabel getStatusBar() {
        return this.getCurrentDocument().getStatusBar();
    }

    private void init() {
        JTextPad.setApplicationModalExclusion(this);
        try {
            this.setDropTarget(new DropTarget(this, new DropTargetListener(){

                public void dragEnter(DropTargetDragEvent e) {
                    e.acceptDrag(1);
                }

                public void dragOver(DropTargetDragEvent e) {
                    e.acceptDrag(1);
                }

                public void dragExit(DropTargetEvent e) {
                }

                public void drop(DropTargetDropEvent e) {
                    if ((e.getSourceActions() & 1) == 0) {
                        e.rejectDrop();
                        return;
                    }
                    e.acceptDrop(1);
                    try {
                        List files = (List)e.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                        e.dropComplete(true);
                        boolean first = true;
                        for (File f : files) {
                            JTextPadDocument document = JTextPad.this.openDocument(f);
                            if (!first) continue;
                            JTextPad.this.setCurrentDocument(document);
                            first = false;
                        }
                        return;
                    }
                    catch (IOException ex) {
                        System.err.println(ex);
                    }
                    catch (UnsupportedFlavorException ex) {
                        System.err.println(ex);
                    }
                    e.dropComplete(false);
                }

                public void dropActionChanged(DropTargetDragEvent e) {
                }
            }));
        }
        catch (RuntimeException ex) {
            ex.printStackTrace(System.err);
        }
        try {
            this.provider.loadFromXML(JTextPad.class.getResourceAsStream("jalbum.xml"));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.provider.setListCellRenderer(new DefaultListCellRenderer(){
            private final Color darkGreen = new Color(50, 140, 50);

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (!isSelected) {
                    if (value instanceof MarkupTagCompletion) {
                        comp.setForeground(Color.blue);
                    } else if (value instanceof VariableCompletion) {
                        comp.setForeground(this.darkGreen);
                    }
                }
                return comp;
            }
        });
        this.addWindowFocusListener(new WindowFocusListener(){

            public void windowGainedFocus(WindowEvent e) {
                if (JTextPad.this.isVisible()) {
                    editors.remove(JTextPad.this);
                    editors.addFirst(JTextPad.this);
                }
            }

            public void windowLostFocus(WindowEvent e) {
            }
        });
        this.setTitle(APP_NAME);
        this.tabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JTextPadDocument document = JTextPad.this.getCurrentDocument();
                if (document != null) {
                    JTextPad.this.setJMenuBar(document.getMenuBar());
                    JTextPad.this.getRootPane().putClientProperty("Window.documentFile", document.getFile());
                    JTextPad.this.updateTitle();
                }
            }
        });
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        c.add((Component)this.tabs, "Center");
        this.pack();
        this.loadWindowLocation();
        this.findDialog.setLocationRelativeTo(this);
    }

    private static boolean setApplicationModalExclusion(JFrame frmMain) {
        try {
            Class<?> exclusionType = Class.forName("java.awt.Dialog$ModalExclusionType");
            Field field = exclusionType.getField("APPLICATION_EXCLUDE");
            Object value = field.get(exclusionType);
            Method meth = JFrame.class.getMethod("setModalExclusionType", exclusionType);
            meth.invoke((Object)frmMain, value);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.exitAction.actionPerformed(null);
        } else {
            super.processWindowEvent(e);
        }
    }

    void updateTitle() {
        File wf;
        String name = "";
        JTextPadDocument document = this.getCurrentDocument();
        if (document != null && (wf = document.getFile()) != null) {
            File parent = wf.getParentFile();
            if (parent != null) {
                name = parent.getName() + File.separatorChar;
            }
            name = name + wf.getName();
        }
        this.setTitle(APP_NAME + ("".equals(name) ? "" : " [" + name + "]"));
    }

    public void actionPerformed(ActionEvent e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        editors = new LinkedList();
        fileTypes = new HashMap<String, String>();
        fileTypes.put("txt", "text/plain");
        fileTypes.put("jsp", "text/jsp");
        fileTypes.put("htt", "text/jsp");
        fileTypes.put("inc", "text/jsp");
        fileTypes.put("java", "text/java");
        fileTypes.put("bsh", "text/java");
        fileTypes.put("css", "text/css");
        fileTypes.put("xml", "text/xml");
        fileTypes.put("info", "text/xml");
        fileTypes.put("rss", "text/xml");
        fileTypes.put("html", "text/html");
        fileTypes.put("htm", "text/html");
        fileTypes.put("xhtml", "text/html");
        fileTypes.put("properties", "text/properties");
        fileTypes.put("jap", "text/properties");
        fileTypes.put("js", "text/javascript");
        ctrlPgUp = KeyStroke.getKeyStroke(33, menuShortcutKeyMask);
        ctrlPgDown = KeyStroke.getKeyStroke(34, menuShortcutKeyMask);
    }
}

