/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.jalbum.filterManager.FilterProperties;
import net.jalbum.filters.BasicFilter;
import net.jalbum.filters.PixelateControl;
import se.datadosen.jalbum.Msg;

public class PixelateFilterPlugin
extends BasicFilter {
    private static final long serialVersionUID = 6592860195353596506L;
    protected int pixelSize = 5;
    protected PixelateControl pixelateControl;

    public PixelateFilterPlugin() {
        this.name = Msg.getString((Object)this, (String)"filters.pixelate.name");
        this.shortName = Msg.getString((Object)this, (String)"filters.pixelate.shortName");
        this.icon = new ImageIcon(this.getClass().getResource("res/pixelate.png"));
        this.author = "David Fichtmueller";
        this.version = "1.0";
        this.description = Msg.getString((Object)this, (String)"filters.pixelate.description");
        this.category = FilterProperties.FilterCategory.FUN;
        this.prescale = false;
        this.postscale = true;
        this.pixelateControl = new PixelateControl(this);
    }

    public JPanel getControls() {
        return this.pixelateControl;
    }

    protected BufferedImage cloneBufferedImage(BufferedImage bi) {
        return bi;
    }

    public BufferedImage renderImage(BufferedImage bi) {
        return this.pixelateImage(bi, this.pixelSize);
    }

    public BufferedImage pixelateImage(BufferedImage bi, int pixelSize) {
        if (pixelSize == 0) {
            pixelSize = 1;
        }
        int width = bi.getWidth();
        int height = bi.getHeight();
        BufferedImage out = new BufferedImage(width, height, bi.getType());
        int rasterWidth = width / pixelSize;
        if (width % pixelSize > 0) {
            ++rasterWidth;
        }
        int rasterHeight = height / pixelSize;
        if (height % pixelSize > 0) {
            ++rasterHeight;
        }
        for (int x = 0; x < rasterWidth; ++x) {
            for (int y = 0; y < rasterHeight; ++y) {
                int rgb;
                int posY;
                int posX;
                int alpha = 0;
                int r = 0;
                int g = 0;
                int b = 0;
                int nextX = Math.min(pixelSize, width - x * pixelSize);
                int nextY = Math.min(pixelSize, height - y * pixelSize);
                for (posX = x * pixelSize; posX < x * pixelSize + nextX; ++posX) {
                    for (posY = y * pixelSize; posY < y * pixelSize + nextY; ++posY) {
                        try {
                            rgb = bi.getRGB(posX, posY);
                        }
                        catch (RasterFormatException e) {
                            rgb = 0;
                        }
                        alpha += (rgb & 0xFF000000) >> 24;
                        r += (rgb & 0xFF0000) >> 16;
                        g += (rgb & 0xFF00) >> 8;
                        b += rgb & 0xFF;
                    }
                }
                rgb = ((alpha /= nextX * nextY) & 0xFF) << 24 | ((r /= nextX * nextY) & 0xFF) << 16 | ((g /= nextX * nextY) & 0xFF) << 8 | (b /= nextX * nextY) & 0xFF;
                for (posX = x * pixelSize; posX < x * pixelSize + nextX; ++posX) {
                    for (posY = y * pixelSize; posY < y * pixelSize + nextY; ++posY) {
                        try {
                            out.setRGB(posX, posY, rgb);
                            continue;
                        }
                        catch (RasterFormatException e) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return out;
    }

    public void paint(Graphics g) {
        super.paint(g);
    }

    public int getPixelSize() {
        return this.pixelSize;
    }

    public void setPixelSize(int pixelSize) {
        this.pixelSize = pixelSize;
    }
}

