/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.player.advanced.AdvancedPlayer;
import javazoom.jl.player.advanced.PlaybackEvent;
import javazoom.jl.player.advanced.PlaybackListener;
import se.datadosen.util.Item;
import se.datadosen.util.PersistentList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPlaylist
extends JPanel
implements PersistentList {
    private Class cl = this.getClass();
    private ImageIcon addIcon = new ImageIcon(this.cl.getResource("images/add2.png"));
    private ImageIcon deleteIcon = new ImageIcon(this.cl.getResource("images/delete2.png"));
    private ImageIcon upIcon = new ImageIcon(this.cl.getResource("images/arrow_up_blue.png"));
    private ImageIcon downIcon = new ImageIcon(this.cl.getResource("images/arrow_down_blue.png"));
    private ImageIcon playIcon = new ImageIcon(this.cl.getResource("images/media_play_green.png"));
    private ImageIcon previousIcon = new ImageIcon(this.cl.getResource("images/media_step_back.png"));
    private ImageIcon nextIcon = new ImageIcon(this.cl.getResource("images/media_step_forward.png"));
    private ImageIcon pauseIcon = new ImageIcon(this.cl.getResource("images/media_pause.png"));
    private ImageIcon stopIcon = new ImageIcon(this.cl.getResource("images/media_stop.png"));
    private JFileChooser fileChooser = new JFileChooser();
    private DefaultListModel filesModel = new DefaultListModel();
    private AdvancedPlayer player;
    private boolean playing = false;
    private FileFilter fileFilter = new FileFilter(){

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(".mp3");
        }

        public String getDescription() {
            return "mp3 music files";
        }
    };
    BorderLayout borderLayout1 = new BorderLayout();
    JScrollPane scroller = new JScrollPane();
    String[] data = new String[]{"one", "two", "three", "four"};
    JList fileList = new JList(this.filesModel);
    JButton addButton = new JButton();
    JButton deleteButton = new JButton();
    JButton upButton = new JButton();
    JButton downButton = new JButton();
    JButton playButton = new JButton();
    JButton previousButton = new JButton();
    JButton nextButton = new JButton();
    JButton pauseButton = new JButton();
    JButton stopButton = new JButton();
    JToolBar buttonBar = new JToolBar();

    private void initFileChooser() {
        this.fileChooser.setFileFilter(this.fileFilter);
        this.fileChooser.setMultiSelectionEnabled(true);
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(FileFilter ff) {
        this.fileFilter = ff;
        this.initFileChooser();
    }

    public void setCurrentDirectory(File dir) {
        this.fileChooser.setCurrentDirectory(dir);
    }

    public File getSelectedFile() {
        Item item = (Item)this.fileList.getSelectedValue();
        if (item != null) {
            return (File)item.value;
        }
        return (File)((Item)this.filesModel.get((int)0)).value;
    }

    public File[] getFileList() {
        File[] files = new File[this.filesModel.size()];
        Enumeration en = this.filesModel.elements();
        int i = 0;
        while (en.hasMoreElements()) {
            Item item = (Item)en.nextElement();
            files[i] = (File)item.value;
            ++i;
        }
        return files;
    }

    public void clearFileList() {
        this.filesModel.removeAllElements();
    }

    public void addFileList(File[] newFiles) {
        for (int i = 0; i < newFiles.length; ++i) {
            Item item = new Item(newFiles[i], newFiles[i].getName());
            this.filesModel.addElement(item);
        }
        if (this.fileList.getSelectedIndex() == -1) {
            this.fileList.setSelectedIndex(0);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.fileList.setEnabled(enabled);
        this.addButton.setEnabled(enabled);
        this.deleteButton.setEnabled(enabled);
        this.upButton.setEnabled(enabled);
        this.downButton.setEnabled(enabled);
        this.previousButton.setEnabled(enabled);
        this.nextButton.setEnabled(enabled);
        this.playButton.setEnabled(enabled);
        this.stopButton.setEnabled(enabled);
        this.pauseButton.setEnabled(enabled);
    }

    public JPlaylist() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public JPlaylist(File[] files) {
        this();
        this.addFileList(files);
    }

    public void addButton(JButton toolbarButton) {
        this.buttonBar.add(toolbarButton);
    }

    private void jbInit() throws Exception {
        this.initFileChooser();
        this.fileList.setCellRenderer(new SmartListCellRenderer());
        this.fileList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    JPlaylist.this.playButton_actionPerformed(null);
                }
            }
        });
        this.fileList.setSelectionMode(0);
        this.setLayout(this.borderLayout1);
        this.addButton.setIcon(this.addIcon);
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JPlaylist.this.addButton_actionPerformed(e);
            }
        });
        this.deleteButton.setIcon(this.deleteIcon);
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JPlaylist.this.deleteButton_actionPerformed(e);
            }
        });
        this.upButton.setIcon(this.upIcon);
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JPlaylist.this.upButton_actionPerformed(e);
            }
        });
        this.downButton.setIcon(this.downIcon);
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JPlaylist.this.downButton_actionPerformed(e);
            }
        });
        this.playButton.setIcon(this.playIcon);
        this.playButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JPlaylist.this.playButton_actionPerformed(e);
            }
        });
        this.stopButton.setIcon(this.stopIcon);
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JPlaylist.this.stopButton_actionPerformed(e);
            }
        });
        this.previousButton.setIcon(this.previousIcon);
        this.previousButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JPlaylist.this.previousButton_actionPerformed(e);
            }
        });
        this.nextButton.setIcon(this.nextIcon);
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JPlaylist.this.nextButton_actionPerformed(e);
            }
        });
        this.buttonBar.setFloatable(false);
        this.buttonBar.setOpaque(false);
        this.buttonBar.setBorderPainted(false);
        this.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent e) {
                JPlaylist.this.this_componentHidden(e);
            }
        });
        this.add((Component)this.scroller, "Center");
        this.add((Component)this.buttonBar, "North");
        this.buttonBar.add(this.addButton);
        this.buttonBar.add(this.deleteButton);
        this.buttonBar.addSeparator();
        this.buttonBar.add(this.upButton);
        this.buttonBar.add(this.downButton);
        this.buttonBar.addSeparator();
        this.buttonBar.add(this.previousButton);
        this.buttonBar.add(this.playButton);
        this.buttonBar.add(this.stopButton);
        this.buttonBar.add(this.nextButton);
        this.scroller.getViewport().add(this.fileList);
    }

    private void addButton_actionPerformed(ActionEvent e) {
        int result = this.fileChooser.showOpenDialog(this);
        if (result == 0) {
            File[] newFiles = this.fileChooser.getSelectedFiles();
            this.addFileList(newFiles);
        }
    }

    private void deleteButton_actionPerformed(ActionEvent e) {
        int selIndex = this.fileList.getSelectedIndex();
        Item toRemove = (Item)this.fileList.getSelectedValue();
        if (toRemove != null) {
            this.filesModel.removeElement(toRemove);
            if (selIndex == 0) {
                selIndex = 1;
            }
            this.fileList.setSelectedIndex(selIndex - 1);
        }
    }

    private void upButton_actionPerformed(ActionEvent e) {
        int selectedIndex = this.fileList.getSelectedIndex();
        if (selectedIndex != -1 && selectedIndex > 0) {
            Item item = (Item)this.filesModel.getElementAt(selectedIndex);
            this.filesModel.removeElement(item);
            this.filesModel.insertElementAt(item, selectedIndex - 1);
            this.fileList.setSelectedIndex(selectedIndex - 1);
        }
    }

    private void downButton_actionPerformed(ActionEvent e) {
        int selectedIndex = this.fileList.getSelectedIndex();
        if (selectedIndex != -1 && selectedIndex < this.filesModel.getSize() - 1) {
            Item item = (Item)this.filesModel.getElementAt(selectedIndex);
            this.filesModel.removeElement(item);
            this.filesModel.insertElementAt(item, selectedIndex + 1);
            this.fileList.setSelectedIndex(selectedIndex + 1);
        }
    }

    private void playButton_actionPerformed(ActionEvent e) {
        this.playing = false;
        final File f = this.getSelectedFile();
        if (f != null) {
            if (this.player != null) {
                this.player.stop();
            }
            this.playing = true;
            Thread t = new Thread("PlayerThread"){

                public void run() {
                    try {
                        JPlaylist.this.player = new AdvancedPlayer((InputStream)new FileInputStream(f));
                        JPlaylist.this.player.setPlayBackListener(new PlaybackListener(){

                            public void playbackFinished(PlaybackEvent evt) {
                                JPlaylist.this.player = null;
                                if (JPlaylist.this.playing) {
                                    JPlaylist.this.nextButton_actionPerformed(null);
                                }
                            }
                        });
                        JPlaylist.this.player.play();
                    }
                    catch (FileNotFoundException ex1) {
                        ex1.printStackTrace();
                    }
                    catch (JavaLayerException ex1) {
                        ex1.printStackTrace();
                    }
                }
            };
            t.setDaemon(true);
            t.setPriority(10);
            t.start();
        }
    }

    private void stopButton_actionPerformed(ActionEvent e) {
        this.playing = false;
        if (this.player != null) {
            this.player.stop();
            this.player = null;
        }
    }

    private void previousButton_actionPerformed(ActionEvent e) {
        int index = this.fileList.getSelectedIndex();
        if (index != -1) {
            if (index > 0) {
                this.fileList.setSelectedIndex(index - 1);
            } else {
                this.fileList.setSelectedIndex(this.fileList.getModel().getSize() - 1);
            }
        }
        if (this.playing) {
            this.play();
        }
    }

    private void nextButton_actionPerformed(ActionEvent e) {
        int index = this.fileList.getSelectedIndex();
        if (index != -1) {
            if (index < this.fileList.getModel().getSize() - 1) {
                this.fileList.setSelectedIndex(index + 1);
            } else {
                this.fileList.setSelectedIndex(0);
            }
        }
        if (this.playing) {
            this.play();
        }
    }

    public void play() {
        this.playButton_actionPerformed(null);
    }

    public void stop() {
        this.stopButton_actionPerformed(null);
    }

    private ListModel DefaultListModel() {
        return null;
    }

    @Override
    public List<String> getContent() {
        LinkedList<String> content = new LinkedList<String>();
        Enumeration en = this.filesModel.elements();
        int i = 0;
        while (en.hasMoreElements()) {
            Item item = (Item)en.nextElement();
            content.add(((File)item.value).getAbsolutePath());
            ++i;
        }
        return content;
    }

    @Override
    public void setContent(List<String> content) {
        this.clearFileList();
        File[] files = new File[content.size()];
        for (int i = 0; i < content.size(); ++i) {
            files[i] = new File(content.get(i));
        }
        this.addFileList(files);
    }

    protected void finalize() throws Throwable {
        this.stopButton_actionPerformed(null);
    }

    public void this_componentHidden(ComponentEvent e) {
        this.stopButton_actionPerformed(null);
    }

    class SmartListCellRenderer
    extends DefaultListCellRenderer {
        SmartListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setComponentOrientation(list.getComponentOrientation());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value instanceof Icon) {
                this.setIcon((Icon)value);
                this.setText("");
            } else {
                this.setIcon(null);
                this.setText(value == null ? "" : value.toString());
            }
            if (value instanceof Item) {
                this.setToolTipText(((Item)value).value.toString());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setBorder(cellHasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
            return this;
        }
    }
}

