/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.dnd;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import se.datadosen.dnd.FileDropEvent;
import se.datadosen.dnd.FileDropListener;

public class JFileDropPanel
extends JPanel
implements DropTargetListener {
    private Component component;
    private transient Vector fileDropListeners;

    public JFileDropPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public JFileDropPanel(LayoutManager layout) {
        super(layout);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
    }

    public void addComponent(Component newComponent) {
        Component oldComponent = this.component;
        this.component = newComponent;
        this.component.setDropTarget(new DropTarget(this.component, this));
        this.firePropertyChange("component", oldComponent, newComponent);
    }

    public Component getComponent() {
        return this.component;
    }

    public void dragEnter(DropTargetDragEvent e) {
        e.acceptDrag(1);
    }

    public void dragOver(DropTargetDragEvent e) {
        e.acceptDrag(1);
    }

    public void dragExit(DropTargetEvent e) {
    }

    public void drop(DropTargetDropEvent e) {
        if ((e.getSourceActions() & 1) == 0) {
            e.rejectDrop();
            return;
        }
        e.acceptDrop(1);
        try {
            List files = (List)e.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
            e.dropComplete(true);
            this.fireFilesDropped(new FileDropEvent(this, files));
            return;
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
        catch (UnsupportedFlavorException ex) {
            System.err.println(ex);
        }
        e.dropComplete(false);
    }

    public void dragScroll(DropTargetDragEvent e) {
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    public synchronized void removeFileDropListener(FileDropListener l) {
        if (this.fileDropListeners != null && this.fileDropListeners.contains(l)) {
            Vector v = (Vector)this.fileDropListeners.clone();
            v.removeElement(l);
            this.fileDropListeners = v;
        }
    }

    public synchronized void addFileDropListener(FileDropListener l) {
        Vector v;
        if (this.component == null) {
            this.addComponent(this);
        }
        Vector vector = v = this.fileDropListeners == null ? new Vector(2) : (Vector)this.fileDropListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.fileDropListeners = v;
        }
    }

    protected void fireFilesDropped(FileDropEvent e) {
        if (this.fileDropListeners != null) {
            Vector listeners = this.fileDropListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((FileDropListener)listeners.elementAt(i)).filesDropped(e);
            }
        }
    }
}

