/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import se.datadosen.jalbum.AccountProfile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AuthenticationException;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.SignInManager;
import se.datadosen.jalbum.event.AccountManagerListener;
import se.datadosen.tags.Element;
import se.datadosen.tags.ElementException;
import se.datadosen.tags.Elements;
import se.datadosen.tags.XMLDocument;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.IO;
import se.datadosen.util.StringUtil;
import se.datadosen.util.httpClient.HttpConnection;
import se.datadosen.util.httpClient.HttpResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccountManager {
    private static final File ACCOUNTS_FILE = Config.getConfigFile("accounts.xml", ".jalbum-ftp-accounts.xml");
    private static AccountManager instance;
    private DefaultListModel accounts = new DefaultListModel();
    private transient Vector<AccountManagerListener> accountManagerListeners;

    private AccountManager() {
        try {
            this.loadAccounts();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static AccountManager getInstance() {
        if (instance == null) {
            instance = new AccountManager();
        }
        return instance;
    }

    public void addAccount(AccountProfile newAccount) {
        Vector<String> names = new Vector<String>();
        Enumeration e = this.accounts.elements();
        while (e.hasMoreElements()) {
            AccountProfile account = (AccountProfile)e.nextElement();
            names.add(account.getName());
        }
        newAccount.setName(this.uniqueName(newAccount.getName(), names));
        this.accounts.addElement(newAccount);
        try {
            this.saveAccounts();
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.fireAccountListUpdated();
    }

    public void removeAccount(AccountProfile oldAccount) {
        this.accounts.removeElement(oldAccount);
        try {
            this.saveAccounts();
            this.fireAccountListUpdated();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void removeAccountManagerListener(AccountManagerListener l) {
        if (this.accountManagerListeners != null && this.accountManagerListeners.contains(l)) {
            Vector v = (Vector)this.accountManagerListeners.clone();
            v.removeElement(l);
            this.accountManagerListeners = v;
        }
    }

    public synchronized void addAccountManagerListener(AccountManagerListener l) {
        Vector v;
        Vector vector = v = this.accountManagerListeners == null ? new Vector(2) : (Vector)this.accountManagerListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.accountManagerListeners = v;
        }
    }

    protected void fireAccountListUpdated() {
        if (this.accountManagerListeners != null) {
            Vector<AccountManagerListener> listeners = this.accountManagerListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).accountListUpdated();
            }
        }
    }

    public boolean hasAccounts() {
        return !this.accounts.isEmpty();
    }

    public void resetAccounts() {
        this.accounts.removeAllElements();
        this.fireAccountListUpdated();
        try {
            this.saveAccounts();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadAccounts() throws ElementException, IOException {
        Element ae;
        String doc;
        if (!ACCOUNTS_FILE.exists()) {
            return;
        }
        String rest = doc = IO.readTextFile(ACCOUNTS_FILE);
        this.accounts.removeAllElements();
        while ((ae = Elements.getElementByName("account", rest, false)) != null) {
            AccountProfile a = new AccountProfile();
            BeanBinder.setProperties((Object)a, ae.getAttributes());
            this.accounts.addElement(a);
            rest = ae.getPostElement();
        }
        this.fireAccountListUpdated();
    }

    public AccountProfile getFirstMyjalbumAccount() {
        Enumeration e = this.accounts.elements();
        while (e.hasMoreElements()) {
            AccountProfile account = (AccountProfile)e.nextElement();
            if (!account.isMyjalbum()) continue;
            return account;
        }
        return null;
    }

    public AccountProfile findJAlbumAccountByUserName(String userName) {
        Enumeration e = this.accounts.elements();
        while (e.hasMoreElements()) {
            AccountProfile account = (AccountProfile)e.nextElement();
            if (!account.isMyjalbum() || !account.getFtpUser().toLowerCase().equals(userName.toLowerCase())) continue;
            return account;
        }
        return null;
    }

    public AccountProfile findAccountByName(String name) {
        Enumeration e = this.accounts.elements();
        while (e.hasMoreElements()) {
            AccountProfile account = (AccountProfile)e.nextElement();
            if (!account.getName().equals(name)) continue;
            return account;
        }
        return null;
    }

    public AccountProfile findCurrentAccount(AlbumBean engine) {
        String name = engine.getAccountProfileName();
        AccountProfile account = this.findAccountByName(name);
        if (account == null) {
            SignInManager mgr = SignInManager.getInstance();
            if (mgr.isSignedIn()) {
                return this.findJAlbumAccountByUserName(mgr.getUserName());
            }
            return null;
        }
        return account;
    }

    public static String getCid(String userName, String password) {
        return StringUtil.toHexString(userName + ":" + password);
    }

    public static String getCid(AccountProfile account) {
        return AccountManager.getCid(account.getFtpUser(), account.getFtpPassword());
    }

    public static String resolveCid(AccountProfile account) {
        if (account.isMyjalbum()) {
            return AccountManager.getCid(account.getFtpUser(), account.getFtpPassword());
        }
        SignInManager mgr = SignInManager.getInstance();
        if (mgr.isSignedIn()) {
            return AccountManager.getCid(mgr.getUserName(), mgr.getPassword());
        }
        return null;
    }

    public static AccountStatus getJalbumAccountQuota(String username, String password) throws IOException {
        try {
            HashMap<String, String> data = new HashMap<String, String>();
            URL url = new URL(JAlbumSite.getInstance().getMyJAlbumQuotaUrl());
            data.put("userName", username);
            data.put("cid", AccountManager.getCid(username, password));
            HttpConnection conn = new HttpConnection(url);
            HttpResponse resp = conn.Post(data);
            if (resp.getStatusCode() != 200) {
                throw new IOException(Msg.get("wiz.httpError") + " " + resp.getStatusCode() + ": " + resp.getReasonLine());
            }
            String doc = resp.getContentAsString();
            Element resultElement = Elements.getElementByName("result", doc, false);
            if (resultElement == null) {
                throw new RuntimeException("Script error. Please contact hosting@jalbum.net:\n" + doc);
            }
            AccountStatus accountStatus = new AccountStatus();
            Set entries = resultElement.getAttributes().entrySet();
            for (Map.Entry e : entries) {
                accountStatus.put(e.getKey().toString(), e.getValue().toString());
            }
            return accountStatus;
        }
        catch (ElementException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static AccountStatus getJalbumAccountStatus(AccountProfile profile) throws IOException, AuthenticationException {
        return AccountManager.getJalbumAccountStatus(profile.getFtpUser(), profile.getFtpPassword());
    }

    public static AccountStatus getJalbumAccountStatus(String username, String password) throws IOException, AuthenticationException {
        try {
            HashMap<String, String> data = new HashMap<String, String>();
            URL url = new URL(JAlbumSite.getInstance().getVerifyCidUrl());
            data.put("cid", AccountManager.getCid(username, password));
            data.put("language", Config.getConfig().getInterpretedLanguage());
            data.put("internalVersion", AlbumBean.getInternalVersion());
            HttpConnection conn = new HttpConnection(url);
            HttpResponse resp = conn.Post(data);
            if (resp.getStatusCode() != 200) {
                throw new IOException(Msg.get("wiz.httpError") + " " + resp.getStatusCode() + ": " + resp.getReasonLine());
            }
            String doc = resp.getContentAsString();
            if (Config.getConfig().isDebugMode()) {
                System.out.println("Response from getJalbumAccountStatus: " + doc);
            }
            Element resultElement = Elements.getElementByName("result", doc, false);
            String errorCode = Elements.contentOfElement("errorCode", doc);
            if (resultElement == null) {
                throw new RuntimeException("Script error. Please contact hosting@jalbum.net:\n" + doc);
            }
            if ("ok".equals(resultElement.getContent())) {
                AccountStatus accountStatus = new AccountStatus();
                Set entries = resultElement.getAttributes().entrySet();
                for (Map.Entry e : entries) {
                    accountStatus.put(e.getKey().toString(), e.getValue().toString());
                }
                return accountStatus;
            }
            throw new AuthenticationException(errorCode);
        }
        catch (ElementException ex) {
            throw new RuntimeException(ex);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    static Set<String> getProtectedPaths(AccountProfile profile) throws IOException {
        TreeSet<String> paths = new TreeSet<String>();
        if (!profile.isMyjalbum()) {
            return paths;
        }
        String username = profile.getFtpUser();
        String password = profile.getFtpPassword();
        try {
            HashMap<String, String> data = new HashMap<String, String>();
            String s = JAlbumSite.getInstance().getProtectedPathsUrl();
            if (s == null) {
                return paths;
            }
            URL url = new URL(JAlbumSite.getInstance().getProtectedPathsUrl());
            data.put("cid", AccountManager.getCid(username, password));
            HttpConnection conn = new HttpConnection(url);
            HttpResponse resp = conn.Post(data);
            if (resp.getStatusCode() != 200) {
                throw new IOException(Msg.get("wiz.httpError") + " " + resp.getStatusCode() + ": " + resp.getReasonLine());
            }
            String doc = resp.getContentAsString();
            InputSource input = new InputSource(new StringReader(doc));
            String expression = "//protected-paths/path";
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList nodes = (NodeList)xpath.evaluate(expression, input, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                paths.add(IO.combinePaths("/", nodes.item(i).getTextContent()));
            }
            return paths;
        }
        catch (XPathExpressionException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String uniqueName(String name, AbstractCollection names) {
        if (names.contains(name)) {
            int i;
            for (i = name.length() - 1; i >= 0 && Character.isDigit(name.charAt(i)); --i) {
            }
            String base = name.substring(0, i + 1);
            i = 1;
            while (names.contains(name = base + i)) {
                ++i;
            }
        }
        return name;
    }

    public void saveAccounts() throws IOException, Exception {
        FileWriter out = new FileWriter(ACCOUNTS_FILE);
        Element ftpAccounts = new Element("ftp-accounts");
        Enumeration e = this.accounts.elements();
        while (e.hasMoreElements()) {
            AccountProfile account = (AccountProfile)e.nextElement();
            Element el = new Element("account");
            Properties props = BeanBinder.getProperties(account);
            el.setAttributes(props);
            ftpAccounts.addContentElement(el);
        }
        XMLDocument doc = new XMLDocument(ftpAccounts);
        out.write(doc.toString());
        out.close();
    }

    public DefaultListModel getAccounts() {
        return this.accounts;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AccountStatus
    extends HashMap<String, String> {
        public static final String quota = "quota";
        public static final String limit = "limit";
        public static final String usage = "usage";
        public static final String accountType = "accountType";
        public static final String accountExpires = "accountExpires";
        public static final String validLicense = "validLicense";
        public static final String username = "username";
        public static final String email = "email";
        public static final String name = "name";
        public static final String donor = "donor";

        public String get(String key, String defaultValue) {
            if (!this.containsKey(key)) {
                return defaultValue;
            }
            return ((String)this.get(key)).toString();
        }

        public boolean isFree() {
            return "FREE".equals(this.get(accountType));
        }

        public boolean isPaid() {
            String type = (String)this.get(accountType);
            return !"FREE".equals(type) && !"TRIAL".equals(type);
        }

        public boolean isDonor() {
            return "true".equals(this.get(donor));
        }

        public Date getAccountExpires() {
            if (this.containsKey(accountExpires)) {
                SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    return dateFormatter.parse((String)this.get(accountExpires));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return null;
        }

        public String getFormattedAccountExpires() {
            Date d = this.getAccountExpires();
            if (d == null) {
                return "";
            }
            DateFormat formatter = SimpleDateFormat.getDateInstance(3);
            return formatter.format(d);
        }
    }
}

