/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JBackgroundPanel;
import se.datadosen.component.JLinkLabel;
import se.datadosen.component.JMapTable;
import se.datadosen.component.MarginIcon;
import se.datadosen.component.RiverLayout;
import se.datadosen.component.buttonbar.PercentLayout;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.LicenseManager;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.SignInManager;

class JAboutWindow
extends JDialog {
    private final Icon dorImage = new MarginIcon(new Insets(0, 0, 0, 10), new ImageIcon(JAboutWindow.class.getResource("images/make_64.png")));
    private final ImageIcon teamImage = new ImageIcon(JAboutWindow.class.getResource("images/team.png"));
    private final Color lineColor = new Color(0, 0, 0, 70);

    public JAboutWindow(Frame parent) {
        super(parent, "jAlbum");
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setResizable(false);
        this.pack();
    }

    private void init() throws Exception {
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        content.add((Component)this.createTopPanel(), "North");
        content.add((Component)this.createCenterPanel(), "Center");
        content.add((Component)this.createBottomPanel(), "South");
    }

    private JComponent createTopPanel() {
        JPanel p = new JPanel(new BorderLayout()){

            public void paintComponent(Graphics go) {
                Graphics2D g = (Graphics2D)go;
                Point p0 = new Point(80, 0);
                Color c0 = new Color(255, 255, 255, 190);
                Point p1 = new Point(this.getWidth(), 0);
                Color c1 = new Color(140, 140, 140, 50);
                g.setPaint(new GradientPaint(p0, c0, p1, c1));
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(c1);
                g.fillRect(0, 0, this.getWidth(), 1);
                g.fillRect(0, 0, this.getWidth(), 2);
                g.fillRect(0, this.getHeight() - 3, this.getWidth(), this.getHeight());
                g.fillRect(0, this.getHeight() - 2, this.getWidth(), this.getHeight());
            }
        };
        p.setPreferredSize(new Dimension(510, 79));
        MatteBorder lineSouth = BorderFactory.createMatteBorder(0, 0, 1, 0, this.lineColor);
        Border insets = BorderFactory.createEmptyBorder(9, 12, 3, 3);
        p.setBorder(BorderFactory.createCompoundBorder(lineSouth, insets));
        p.setBackground(Color.white);
        JPanel left = new JPanel(new BorderLayout());
        left.setOpaque(false);
        String tab = "&nbsp;&nbsp;&nbsp;&nbsp;";
        String header = "<b>" + Msg.get("about.aboutJAlbum") + "</b>";
        String slogan = Msg.get("about.slogan");
        left.add((Component)JAboutWindow.html(header + "<p>" + tab + slogan), "West");
        p.add((Component)left, "Center");
        p.add((Component)new JLabel(this.dorImage), "East");
        return p;
    }

    private JComponent createCenterPanel() {
        JPanel p = new JPanel(new BorderLayout());
        JTabbedPane tabPane = new JTabbedPane();
        tabPane.setBorder(BorderFactory.createEmptyBorder(9, 9, 0, 9));
        tabPane.addTab(Msg.get("about.application"), this.createApplicationTab());
        JComponent teamTab = this.createTeamTab();
        JComponent systemTab = this.createSystemTab();
        systemTab.setPreferredSize(teamTab.getPreferredSize());
        tabPane.addTab(Msg.get("about.team"), teamTab);
        tabPane.addTab(Msg.get("about.system"), systemTab);
        p.add((Component)tabPane, "Center");
        return p;
    }

    private String attemptSignIn() {
        SignInManager mgr = SignInManager.getInstance();
        if (mgr.isSignedIn()) {
            return "&cid=" + AccountManager.getCid(mgr.getUserName(), mgr.getPassword());
        }
        return "";
    }

    private JComponent createApplicationTab() {
        ControlPanel p = new ControlPanel();
        p.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        p.setLayout(new RiverLayout(6, 6));
        ((Container)p).add("hfill", JAboutWindow.html("<b>jAlbum " + AlbumBean.getInternalVersion() + "</b>"));
        ((Container)p).add("br hfill", JAboutWindow.text("Copyright 2002-2011 jAlbum AB"));
        ((Container)p).add("p hfill", JAboutWindow.text(Msg.get("about.translationInfo")));
        ((Container)p).add("p", JAboutWindow.text(Msg.get("about.freeForNonCommercialUse")));
        LicenseManager mgr = JAlbumContext.getInstance().getLicenseManager();
        ((Container)p).add("p", JAboutWindow.text(mgr.isLicenseValid() ? Msg.get("about.licensedTo", SignInManager.getInstance().getUserName()) : Msg.get("ui.unlicensed")));
        JLinkLabel licenseInfoLink = new JLinkLabel(Msg.get("ui.licenseInfo"));
        licenseInfoLink.setURL(JAlbumSite.getInstance().getJAlbumLicenseUrl() + "/?referrer=jalbumAboutDialog" + this.attemptSignIn());
        ((Container)p).add("br", licenseInfoLink);
        return p;
    }

    private JComponent createTeamTab() {
        JBackgroundPanel p = new JBackgroundPanel();
        p.setBackground(new Color(194, 254, 100));
        p.setBackgroundImage(this.teamImage.getImage());
        p.setLayout(new BorderLayout());
        JPanel bottomPanel = new JPanel(new FlowLayout(2));
        bottomPanel.setOpaque(false);
        bottomPanel.add(new JLinkLabel(JAlbumSite.getInstance().getAboutUsUrl(), Msg.get("about.moreAboutUs")));
        bottomPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        p.add((Component)bottomPanel, "South");
        return p;
    }

    private JComponent createSystemTab() {
        JPanel p = new JPanel(new BorderLayout());
        p.setOpaque(false);
        p.setBorder(BorderFactory.createEmptyBorder(0, 6, 12, 6));
        JMapTable table = new JMapTable("Property", "Value");
        table.putAll(System.getProperties());
        table.setRowHeight(table.getRowHeight() + 2);
        JScrollPane scrollTable = new JScrollPane(table);
        JPanel insetPanel = new JPanel(new BorderLayout());
        insetPanel.setOpaque(false);
        insetPanel.setBorder(BorderFactory.createEmptyBorder(14, 9, 3, 9));
        insetPanel.add((Component)scrollTable, "Center");
        p.add((Component)insetPanel, "Center");
        return p;
    }

    private JComponent createBottomPanel() {
        JPanel p = new JPanel(new PercentLayout());
        p.setBorder(BorderFactory.createEmptyBorder(3, 12, 9, 12));
        AbstractAction closeAction = new AbstractAction(Msg.get("close")){

            public void actionPerformed(ActionEvent e) {
                JAboutWindow.this.dispose();
            }
        };
        p.add(Box.createGlue(), "*");
        p.add(new JButton(closeAction));
        return p;
    }

    private static JLabel text(String text) {
        return new JLabel(text);
    }

    private static JLabel html(String text) {
        return new JLabel("<html>" + text + "</html>");
    }
}

