/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Dialog;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import se.datadosen.component.ComponentUtilities;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JSmartDialog;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.AccountProfile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;
import se.datadosen.util.JComponentHolder;
import se.datadosen.util.Platform;
import se.datadosen.util.PropertyBinder;

public class JPrivacyDialog
extends JSmartDialog
implements JComponentHolder {
    private AlbumBean engine;
    Action okAction = new AbstractAction(Msg.get("ok")){

        public void actionPerformed(ActionEvent ae) {
            Properties props = PropertyBinder.getProperties(JPrivacyDialog.this);
            BeanBinder.setProperties((Object)JPrivacyDialog.this.engine, props);
            JPrivacyDialog.this.setVisible(false);
            JPrivacyDialog.this.dispose();
        }
    };
    Action cancelAction = new AbstractAction(Msg.get("cancel")){

        public void actionPerformed(ActionEvent ae) {
            JPrivacyDialog.this.setVisible(false);
            JPrivacyDialog.this.dispose();
        }
    };
    Action saveAsDefaultAction = new AbstractAction(Msg.get("ui.saveAsDefaultMenu")){
        {
            this.putValue("ShortDescription", Msg.get("ui.saveAsDefaultToolTip"));
        }

        public void actionPerformed(ActionEvent ae) {
            Properties props = PropertyBinder.getProperties(JPrivacyDialog.this.mainPanel);
            try {
                JPrivacyDialog.saveAsDefault(props);
            }
            catch (IOException ex) {
                Debug.showErrorDialog(JPrivacyDialog.this, (Throwable)ex);
            }
        }
    };
    ControlPanel mainPanel = new ControlPanel(Msg.get("ui.shareOnJalbumNet")){
        JCheckBox visibleOnProfilePage;
        JCheckBox notifyFollowers;
        JCheckBox showInRecentAlbumsList;
        JButton saveAsDefaultButton;
        {
            this.visibleOnProfilePage = new JCheckBox(Msg.get("ui.visibleOnProfilePage"));
            this.notifyFollowers = new JCheckBox(Msg.get("ui.notifyFollowers"));
            this.showInRecentAlbumsList = new JCheckBox(Msg.get("ui.showInRecentAlbumsList"));
            this.saveAsDefaultButton = new JButton(JPrivacyDialog.this.saveAsDefaultAction);
            this.saveAsDefaultButton.putClientProperty("JComponent.sizeVariant", "small");
            if (!Platform.isMac()) {
                JPrivacyDialog.setSmallerFont(this.saveAsDefaultButton);
            }
            this.add(this.visibleOnProfilePage);
            this.add("br", this.notifyFollowers);
            this.add("br", this.showInRecentAlbumsList);
            this.add("p right", this.saveAsDefaultButton);
            ComponentUtilities.whenSelectedEnable((AbstractButton)this.visibleOnProfilePage, this.notifyFollowers, this.showInRecentAlbumsList);
        }
    };
    JLabel webPasswordLabel = new JLabel(Msg.get("ui.password"));
    JTextField webPassword = new JTextField();

    public JPrivacyDialog(Dialog d, AlbumBean engine, AccountProfile account) throws HeadlessException {
        super(d, Msg.get("ui.privacy"), true);
        this.init(engine, account);
    }

    private void init(AlbumBean engine, AccountProfile account) {
        this.engine = engine;
        this.webPasswordLabel.setLabelFor(this.webPassword);
        this.webPasswordLabel.setToolTipText(Msg.get("publish.leaveBlankHint"));
        this.webPassword.setToolTipText(Msg.get("publish.leaveBlankHint"));
        this.setLayout(new RiverLayout());
        this.add("hfill", this.mainPanel);
        this.add("p", this.webPasswordLabel);
        this.add("tab hfill", this.webPassword);
        this.registerActions(this.okAction, this.cancelAction);
        try {
            Properties props = BeanBinder.getProperties(engine);
            PropertyBinder.syncUI(props, this);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        if (!account.isMyjalbum()) {
            this.webPasswordLabel.setEnabled(false);
            this.webPassword.setEnabled(false);
            this.webPasswordLabel.setToolTipText(Msg.get("ui.passwordDisabledToolTip"));
            this.webPassword.setToolTipText(Msg.get("ui.passwordDisabledToolTip"));
        }
        this.setResizable(false);
        this.pack();
    }

    private static void setSmallerFont(JComponent comp) {
        Font f = comp.getFont();
        comp.setFont(f.deriveFont(f.getSize2D() - 1.0f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveAsDefault(Properties props) throws IOException {
        FileOutputStream fos = null;
        try {
            Properties defaults = new Properties();
            if (JAlbumFrame.defaultProjectFile.exists()) {
                defaults = IO.readPropertyFile(JAlbumFrame.defaultProjectFile);
            }
            defaults.putAll((Map<?, ?>)props);
            fos = new FileOutputStream(JAlbumFrame.defaultProjectFile);
            defaults.store(fos, "JAlbum Project");
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            IO.close(fos);
            throw throwable;
        }
        IO.close(fos);
    }
}

