/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import java.util.Vector;
import se.datadosen.jalbum.MiniConfig;
import se.datadosen.util.IO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecentProjectFiles {
    private static RecentProjectFiles theInstance;
    private File storeFile;
    private ArrayList<File> files;
    private int maxFiles = 15;
    private transient Vector<Listener> listeners;
    private int loadedHashCode;

    public static RecentProjectFiles getInstance() {
        if (theInstance == null) {
            theInstance = new RecentProjectFiles(RecentProjectFiles.convertConfigFile("recent-projects.txt", ".jalbum-recent-projects.properties"));
        }
        return theInstance;
    }

    private RecentProjectFiles(File storeFile) {
        this.storeFile = storeFile;
        this.init();
    }

    private static File convertConfigFile(String newName, String oldName) {
        File oldFile = new File(System.getProperty("user.home"), oldName);
        File newFile = new File(MiniConfig.getMiniConfig().configDir, newName);
        MiniConfig.getMiniConfig().configDir.mkdir();
        if (!newFile.exists() && oldFile.exists()) {
            try {
                String name;
                ArrayList<File> files = new ArrayList<File>();
                Properties props = new Properties();
                FileInputStream fis = new FileInputStream(oldFile);
                props.load(fis);
                fis.close();
                int i = 1;
                while ((name = props.getProperty("File" + i)) != null) {
                    files.add(new File(name));
                    ++i;
                }
                RecentProjectFiles.save(files, newFile);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return newFile;
    }

    public List<File> getFiles() {
        return this.files;
    }

    private void init() {
        this.files = new ArrayList();
        try {
            Scanner sc = new Scanner(this.storeFile, "UTF-8");
            while (sc.hasNextLine()) {
                this.files.add(new File(sc.nextLine()));
            }
            sc.close();
            this.loadedHashCode = this.files.hashCode();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                RecentProjectFiles.this.save();
            }
        });
    }

    public void replaceFile(File oldFile, File newFile) {
        for (int i = 0; i < this.files.size(); ++i) {
            File f = this.files.get(i);
            if (!f.equals(oldFile)) continue;
            this.files.set(i, newFile);
            break;
        }
        this.fireProjectFileRenamed(oldFile, newFile);
        this.save();
    }

    public boolean save() {
        if (this.files.hashCode() == this.loadedHashCode) {
            return false;
        }
        RecentProjectFiles.save(this.files, this.storeFile);
        return true;
    }

    private static void save(ArrayList<File> files, File dest) {
        StringBuilder buf = new StringBuilder();
        try {
            for (File f : files) {
                buf.append(f.getAbsolutePath());
                buf.append("\r\n");
            }
            IO.writeTextFile(buf.toString(), dest, "UTF-8");
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
    }

    public void addFile(File file) {
        this.files.remove(file);
        this.files.add(0, file);
        if (this.files.size() > this.maxFiles) {
            this.files.remove(this.maxFiles);
        }
        this.fireStructureChanged();
    }

    public void removeFile(File file) {
        this.files.remove(file);
        this.fireStructureChanged();
    }

    public void clear() {
        this.files.clear();
        this.fireStructureChanged();
    }

    public synchronized void removeListener(Listener l) {
        if (this.listeners != null && this.listeners.contains(l)) {
            Vector v = (Vector)this.listeners.clone();
            v.removeElement(l);
            this.listeners = v;
        }
    }

    public synchronized void addListener(Listener l) {
        Vector v;
        Vector vector = v = this.listeners == null ? new Vector(2) : (Vector)this.listeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.listeners = v;
        }
    }

    protected void fireStructureChanged() {
        if (this.listeners != null) {
            for (Listener l : this.listeners) {
                l.structureChanged(this);
            }
        }
    }

    protected void fireProjectFileRenamed(File oldName, File newName) {
        if (this.listeners != null) {
            for (Listener l : this.listeners) {
                l.projectFileRenamed(this, oldName, newName);
            }
        }
    }

    public static interface Listener {
        public void projectFileRenamed(RecentProjectFiles var1, File var2, File var3);

        public void structureChanged(RecentProjectFiles var1);
    }
}

