/*
 * Decompiled with CFR 0.152.
 */
package info.cqs.remotefs;

import info.cqs.remotefs.DiskSpaceEvent;
import info.cqs.remotefs.DiskSpaceListener;
import info.cqs.remotefs.RemoteFS;
import info.cqs.remotefs.RemoteFSDelegate;
import info.cqs.remotefs.RemoteFSException;
import info.cqs.remotefs.RemoteFSFactory;
import info.cqs.remotefs.RemoteFSProgressMonitor;
import info.cqs.remotefs.RemoteFile;
import info.cqs.remotefs.RemoteFileFilter;
import info.cqs.remotefs.annotations.AffectsDiskSpace;
import info.cqs.remotefs.annotations.RecoverFromIOException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.TransferProtocol;
import se.datadosen.util.IO;
import se.datadosen.util.Stopwatch;

public class RemoteFSBean
implements RemoteFSDelegate {
    private RemoteFS remoteFS = null;
    private TransferProtocol protocol = TransferProtocol.ftp;
    private String currentDirectory = "";
    private String server;
    private String user;
    private String password;
    private final transient List<DiskSpaceListener> diskSpaceListeners = new ArrayList<DiskSpaceListener>();
    public static RemoteFileFilter noDotDotDotFileFilter = new RemoteFileFilter(){

        public boolean accept(RemoteFile rf) {
            String name = rf.getName();
            return !name.equals(".") && !name.equals("..");
        }
    };
    private DiskSpaceWatcher diskSpaceWatcher;

    private RemoteFSBean() {
    }

    public static RemoteFSDelegate createInstance() {
        RemoteFSBean target = new RemoteFSBean();
        return (RemoteFSDelegate)Proxy.newProxyInstance(target.getClass().getClassLoader(), target.getClass().getInterfaces(), (InvocationHandler)new RemoteFSHandler(target));
    }

    public TransferProtocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(TransferProtocol protocol) {
        if (protocol != this.protocol) {
            this.remoteFS = null;
        }
        this.protocol = protocol;
    }

    private RemoteFS getRemoteFS() {
        if (this.remoteFS == null) {
            this.remoteFS = RemoteFSFactory.getRemoteFS(this.protocol);
        }
        return this.remoteFS;
    }

    public void testConnection(String server, String user, String password) throws IOException, RemoteFSException {
        this.connect(server, user, password);
        if (!this.isConnected()) {
            throw new RemoteFSException("Not connected to server");
        }
        this.disconnect();
        if (this.isConnected()) {
            throw new RemoteFSException("Still connected to server");
        }
    }

    public void setPort(int port) throws RemoteFSException {
        this.getRemoteFS().setPort(port);
    }

    public int getPort() throws RemoteFSException {
        return this.getRemoteFS().getPort();
    }

    public void setForceUTF8(boolean force) throws RemoteFSException {
        this.getRemoteFS().setForceUTF8(force);
    }

    public boolean isForceUTF8() throws RemoteFSException {
        return this.getRemoteFS().isForceUTF8();
    }

    public void setPassiveMode(boolean mode) throws RemoteFSException {
        this.getRemoteFS().setPassiveMode(mode);
    }

    public boolean isPassiveMode() throws RemoteFSException {
        return this.getRemoteFS().isPassiveMode();
    }

    @RecoverFromIOException
    public String getDirectory() throws IOException, RemoteFSException {
        return this.getRemoteFS().getDirectory();
    }

    @RecoverFromIOException
    public void setDirectory(String directory) throws IOException, RemoteFSException {
        if (directory.length() == 0) {
            return;
        }
        this.getRemoteFS().setDirectory(directory);
        this.currentDirectory = directory.startsWith("/") ? directory : IO.combinePaths(this.currentDirectory, directory);
    }

    @RecoverFromIOException
    public void toParentDirectory() throws RemoteFSException, IOException {
        this.getRemoteFS().toParentDirectory();
        int lastSlashIndex = this.currentDirectory.lastIndexOf(47);
        this.currentDirectory = lastSlashIndex == -1 ? "" : this.currentDirectory.substring(0, lastSlashIndex);
    }

    @RecoverFromIOException
    @AffectsDiskSpace
    public void createDirectory(String name) throws IOException, RemoteFSException {
        this.getRemoteFS().createDirectory(name);
    }

    @RecoverFromIOException
    @AffectsDiskSpace
    public void removeDirectory(String name) throws IOException, RemoteFSException {
        this.getRemoteFS().removeDirectory(name);
    }

    public void connect(String server, String user, String password) throws IOException, RemoteFSException {
        this.getRemoteFS().connect(server, user, password);
        this.server = server;
        this.user = user;
        this.password = password;
        this.currentDirectory = "";
    }

    public void abortConnect() throws RemoteFSException, IOException {
        this.getRemoteFS().abortConnect();
    }

    public void reconnect() throws RemoteFSException, IOException {
        this.getRemoteFS().connect(this.server, this.user, this.password);
        if (!"".equals(this.currentDirectory)) {
            this.getRemoteFS().setDirectory(this.currentDirectory);
        }
    }

    public void disconnect() throws IOException, RemoteFSException {
        this.getRemoteFS().disconnect();
        this.remoteFS = null;
    }

    public boolean isConnected() throws RemoteFSException {
        return this.getRemoteFS().isConnected();
    }

    @RecoverFromIOException
    public RemoteFile[] getFiles() throws IOException, RemoteFSException {
        return this.getRemoteFS().getFiles();
    }

    @RecoverFromIOException
    public RemoteFile[] getFiles(String dir) throws IOException, RemoteFSException {
        return this.getRemoteFS().getFiles(dir);
    }

    @RecoverFromIOException
    public RemoteFile[] getFiles(RemoteFileFilter filter) throws IOException, RemoteFSException {
        return this.getFiles("", filter);
    }

    @RecoverFromIOException
    public RemoteFile[] getFiles(String dir, RemoteFileFilter filter) throws IOException, RemoteFSException {
        RemoteFile[] allFiles = this.getFiles(dir);
        LinkedList<RemoteFile> list = new LinkedList<RemoteFile>();
        for (int i = 0; i < allFiles.length; ++i) {
            if (!filter.accept(allFiles[i])) continue;
            list.addLast(allFiles[i]);
        }
        return list.toArray(new RemoteFile[list.size()]);
    }

    @RecoverFromIOException
    @AffectsDiskSpace
    public void putFile(File file) throws IOException, RemoteFSException {
        this.getRemoteFS().putFile(file);
    }

    @RecoverFromIOException
    @AffectsDiskSpace
    public void putFile(File file, String path) throws IOException, RemoteFSException {
        this.getRemoteFS().putFile(file, path);
    }

    @AffectsDiskSpace
    public void put(InputStream in, String path) throws IOException, RemoteFSException {
        this.getRemoteFS().put(in, path);
    }

    @RecoverFromIOException
    public void get(String path, OutputStream out) throws IOException, RemoteFSException {
        this.getRemoteFS().get(path, out);
    }

    @RecoverFromIOException
    public void getUnmonitored(String path, OutputStream out) throws IOException, RemoteFSException {
        this.getRemoteFS().getUnmonitored(path, out);
    }

    @RecoverFromIOException
    @AffectsDiskSpace
    public void removeFile(String filename) throws IOException, RemoteFSException {
        this.getRemoteFS().removeFile(filename);
    }

    public void setProgressMonitor(RemoteFSProgressMonitor monitor) {
        this.getRemoteFS().setProgressMonitor(monitor);
    }

    @RecoverFromIOException
    public void rename(String from, String to) throws IOException, RemoteFSException {
        this.getRemoteFS().rename(from, to);
    }

    @RecoverFromIOException
    public boolean exists(String path) throws IOException, RemoteFSException {
        return this.getRemoteFS().exists(path);
    }

    @RecoverFromIOException
    public boolean existsDirectory(String path) throws IOException, RemoteFSException {
        return this.getRemoteFS().existsDirectory(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDiskSpaceListener(DiskSpaceListener listener) {
        List<DiskSpaceListener> list = this.diskSpaceListeners;
        synchronized (list) {
            this.diskSpaceListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDiskSpaceListener(DiskSpaceListener listener) {
        List<DiskSpaceListener> list = this.diskSpaceListeners;
        synchronized (list) {
            this.diskSpaceListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDiskSpaceAffected(DiskSpaceEvent e) {
        List<DiskSpaceListener> list = this.diskSpaceListeners;
        synchronized (list) {
            for (DiskSpaceListener listener : this.diskSpaceListeners) {
                listener.diskSpaceAffected(e);
            }
        }
    }

    private static class DiskSpaceWatcher
    extends Thread {
        private final RemoteFSBean bean;
        State state = State.PAUSING;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DiskSpaceWatcher(RemoteFSBean bean) {
            super("Disk space watcher thread");
            this.bean = bean;
            DiskSpaceWatcher diskSpaceWatcher = this;
            synchronized (diskSpaceWatcher) {
                this.start();
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }

        public synchronized void countdown() {
            if (this.state != State.PAUSING) {
                new IllegalStateException("Not in pause state").printStackTrace(System.err);
            } else {
                this.notify();
            }
        }

        public synchronized void pause() {
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DiskSpaceWatcher diskSpaceWatcher = this;
            synchronized (diskSpaceWatcher) {
                this.notify();
                while (true) {
                    try {
                        this.state = State.PAUSING;
                        this.wait();
                        this.state = State.COUNTDOWN;
                        this.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
            this.bean.fireDiskSpaceAffected(new DiskSpaceEvent(this.bean, this.bean.server, this.bean.user, this.bean.password));
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum State {
            PAUSING,
            COUNTDOWN;

        }
    }

    static class RemoteFSHandler
    implements InvocationHandler {
        RemoteFSBean bean;
        Stopwatch stopwatch = new Stopwatch("Time between calls");

        public RemoteFSHandler(RemoteFSBean bean) {
            this.bean = bean;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object first2;
            method = this.bean.getClass().getMethod(method.getName(), method.getParameterTypes());
            boolean autoRecover = method.isAnnotationPresent(RecoverFromIOException.class);
            boolean affectsDiskSpace = method.isAnnotationPresent(AffectsDiskSpace.class);
            DiskSpaceWatcher watcher = this.bean.diskSpaceWatcher;
            if (affectsDiskSpace && watcher != null) {
                this.bean.diskSpaceWatcher.pause();
            }
            Stopwatch sw = new Stopwatch();
            sw.start();
            try {
                try {
                    if (Config.getConfig().isDebugMode()) {
                        System.out.print("RemoteFSHandler: " + method.getName() + " ");
                        if (args != null) {
                            boolean first2 = true;
                            for (Object arg : args) {
                                System.out.print((first2 ? "" : ", ") + arg);
                                first2 = false;
                            }
                        }
                    }
                    first2 = method.invoke((Object)this.bean, args);
                    Object var14_22 = null;
                    if (Config.getConfig().isDebugMode()) {
                        System.out.println("\t[" + sw + "]");
                    }
                    if (!affectsDiskSpace) return first2;
                }
                catch (InvocationTargetException e) {
                    Throwable cause = this.getEmbeddedIOException(e.getTargetException());
                    if (!autoRecover) throw e.getTargetException();
                    if (!(cause instanceof IOException)) throw e.getTargetException();
                    this.log("Caught " + cause + " when calling " + method.getName() + ". Reconnecting");
                    try {
                        if (this.bean.isConnected()) {
                            try {
                                this.bean.abortConnect();
                            }
                            catch (IOException ex) {
                                // empty catch block
                            }
                        }
                        this.bean.reconnect();
                        Object ex = method.invoke((Object)this.bean, args);
                    }
                    catch (IOException ex) {
                        throw ex;
                    }
                    catch (RemoteFSException ex) {
                        throw ex;
                    }
                    catch (InvocationTargetException ex) {
                        throw ex.getTargetException();
                    }
                    Object var14_23 = null;
                    if (Config.getConfig().isDebugMode()) {
                        System.out.println("\t[" + sw + "]");
                    }
                    if (!affectsDiskSpace) return ex;
                    if (this.bean.diskSpaceWatcher == null || !this.bean.diskSpaceWatcher.isAlive()) {
                        this.bean.diskSpaceWatcher = new DiskSpaceWatcher(this.bean);
                    }
                    this.bean.diskSpaceWatcher.countdown();
                    this.stopwatch.reset();
                    this.stopwatch.start();
                    return ex;
                }
                catch (Exception e) {
                    throw new RuntimeException("unexpected invocation exception: " + e.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var14_24 = null;
                if (Config.getConfig().isDebugMode()) {
                    System.out.println("\t[" + sw + "]");
                }
                if (!affectsDiskSpace) throw throwable;
                if (this.bean.diskSpaceWatcher == null || !this.bean.diskSpaceWatcher.isAlive()) {
                    this.bean.diskSpaceWatcher = new DiskSpaceWatcher(this.bean);
                }
                this.bean.diskSpaceWatcher.countdown();
                this.stopwatch.reset();
                this.stopwatch.start();
                throw throwable;
            }
            if (this.bean.diskSpaceWatcher == null || !this.bean.diskSpaceWatcher.isAlive()) {
                this.bean.diskSpaceWatcher = new DiskSpaceWatcher(this.bean);
            }
            this.bean.diskSpaceWatcher.countdown();
            this.stopwatch.reset();
            this.stopwatch.start();
            return first2;
        }

        private Throwable getEmbeddedIOException(Throwable ex) {
            Throwable original = ex;
            do {
                if (!(ex instanceof IOException)) continue;
                return ex;
            } while ((ex = ex.getCause()) != null);
            return original;
        }

        void log(String s) {
            System.out.println("RemoteFSHandler: " + s);
        }

        void debug(String s) {
            if (Config.getConfig().isDebugMode()) {
                System.out.println("RemoteFSHandler: " + s);
            }
        }
    }
}

