/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import se.datadosen.component.FileChooser;

public class MacAWTFileChooser
implements FileChooser {
    private FileDialog dialog;
    private ActionListener listener;

    public MacAWTFileChooser(Frame parent) {
        this.dialog = new FileDialog(parent);
    }

    public MacAWTFileChooser(Dialog parent) {
        this.dialog = new FileDialog(parent);
    }

    public void setCurrentDirectory(File dir) {
        this.dialog.setDirectory(dir.getAbsolutePath());
    }

    public File getCurrentDirectory() {
        return new File(this.dialog.getDirectory());
    }

    public void setSelectedFile(File file) {
        if (file != null) {
            this.setCurrentDirectory(file.getParentFile());
            this.dialog.setFile(file.getName());
        } else {
            this.dialog.setFile(null);
        }
    }

    public File getSelectedFile() {
        if (this.dialog.getFile() == null) {
            return null;
        }
        return new File(this.dialog.getDirectory(), this.dialog.getFile());
    }

    public void setDialogTitle(String title) {
        this.dialog.setTitle(title);
    }

    private int showDialog(Component parent) {
        File selected = this.getSelectedFile();
        if (selected != null) {
            this.setCurrentDirectory(selected);
        }
        String def = System.getProperty("apple.awt.fileDialogForDirectories", "false");
        System.setProperty("apple.awt.fileDialogForDirectories", "false");
        this.dialog.setVisible(true);
        System.setProperty("apple.awt.fileDialogForDirectories", def);
        if (this.dialog.getFile() != null && this.listener != null) {
            this.listener.actionPerformed(new ActionEvent(this, 0, "ApproveSelection"));
        }
        return this.dialog.getFile() != null ? 0 : 1;
    }

    public int showOpenDialog(Component parent) {
        this.dialog.setMode(0);
        return this.showDialog(parent);
    }

    public int showSaveDialog(Component parent) {
        this.dialog.setMode(1);
        return this.showDialog(parent);
    }

    public void setDialogType(int dialogType) {
        switch (dialogType) {
            case 0: {
                this.dialog.setMode(0);
                break;
            }
            case 1: {
                this.dialog.setMode(1);
                break;
            }
            case 2: {
                this.dialog.setMode(0);
            }
        }
    }

    public void setMultiSelectionEnabled(boolean b) {
        try {
            FileDialog.class.getMethod("setMultipleMode", Boolean.TYPE).invoke((Object)this.dialog, b);
            throw new UnsupportedOperationException("Not supported yet.");
        }
        catch (Exception ex) {
            System.err.println(ex);
            return;
        }
    }

    public void setFileSelectionMode(int mode) {
        System.out.println("setFileSelectionMode: " + mode);
    }

    public void addActionListener(ActionListener l) {
        this.listener = l;
    }

    public void setFileView(FileView fileView) {
    }

    public void setFileFilter(final FileFilter filter) {
        this.dialog.setFilenameFilter(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return filter.accept(new File(dir, name));
            }
        });
    }

    public int showDialog(Component parent, String approveButtonText) throws HeadlessException {
        return this.showDialog(parent);
    }

    public File[] getSelectedFiles() {
        try {
            return (File[])FileDialog.class.getMethod("getFiles", new Class[0]).invoke((Object)this.dialog, new Object[0]);
        }
        catch (Exception ex) {
            return new File[]{this.getSelectedFile()};
        }
    }
}

