/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.jalbum.AlbumObject;

public class JAlbumTransferable
implements Transferable {
    private JAlbumExplorer.FolderTreeNode node;
    private JAlbumObject jao;
    public static final DataFlavor folderTreeNodeFlavor = new DataFlavor(JAlbumExplorer.FolderTreeNode.class, "JAlbum folder tree node");
    public static final DataFlavor jalbumObjectFlavor = new DataFlavor(JAlbumObject.class, "JAlbum object");
    public static final DataFlavor albumObjectFlavor = new DataFlavor(AlbumObject.class, "Album object");
    private DataFlavor[] flavors;

    public JAlbumTransferable(JAlbumExplorer.FolderTreeNode node) {
        this.node = node;
        this.flavors = new DataFlavor[]{folderTreeNodeFlavor, DataFlavor.javaFileListFlavor};
    }

    public JAlbumTransferable(JAlbumObject jao) {
        this.jao = jao;
        this.flavors = new DataFlavor[]{jalbumObjectFlavor, DataFlavor.javaFileListFlavor, DataFlavor.stringFlavor};
    }

    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])this.flavors.clone();
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (int i = 0; i < this.flavors.length; ++i) {
            if (!flavor.equals(this.flavors[i])) continue;
            return true;
        }
        return false;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(folderTreeNodeFlavor)) {
            return this.node;
        }
        if (flavor.equals(jalbumObjectFlavor)) {
            return this.jao;
        }
        if (flavor.equals(DataFlavor.javaFileListFlavor)) {
            if (this.node != null) {
                return new File[]{this.node.getAlbumObject().getFile()};
            }
            return new File[]{this.jao.ao.getFile()};
        }
        if (flavor.equals(DataFlavor.stringFlavor)) {
            if (this.node != null) {
                return this.node.getAlbumObject().getFile().getAbsolutePath();
            }
            return this.jao.ao.getFile().getAbsolutePath();
        }
        throw new UnsupportedFlavorException(flavor);
    }
}

